/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.impl.AnnotationData;
import org.jetbrains.kotlin.psi.stubs.impl.EnumData;
import org.jetbrains.kotlin.psi.stubs.impl.KClassData;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueSerializationVisitor;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0002\u001a\u0014\u0010\f\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u001a\u0010\f\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"writeConstantKind", "", "Lcom/intellij/psi/stubs/StubOutputStream;", "kind", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinConstantValueKind;", "readConstantKind", "Lcom/intellij/psi/stubs/StubInputStream;", "deserializeConstantValue", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "dataStream", "serializeConstantValue", "constantValue", "createConstantValue", "value", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "getClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "index", "", "getName", "Lorg/jetbrains/kotlin/name/Name;", "psi-impl"})
@SourceDebugExtension(value={"SMAP\nKotlinConstantValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinConstantValue.kt\norg/jetbrains/kotlin/psi/stubs/impl/KotlinConstantValueKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,258:1\n1585#2:259\n1660#2,3:260\n1204#2,2:263\n1281#2,4:265\n1204#2,2:305\n1281#2,4:307\n1585#2:311\n1660#2,3:312\n11714#3:269\n12062#3,3:270\n11724#3:273\n12073#3,3:274\n11734#3:277\n12084#3,3:278\n11744#3:281\n12095#3,3:282\n11784#3:285\n12139#3,3:286\n11754#3:289\n12106#3,3:290\n11764#3:293\n12117#3,3:294\n11774#3:297\n12128#3,3:298\n11704#3:301\n12051#3,3:302\n*S KotlinDebug\n*F\n+ 1 KotlinConstantValue.kt\norg/jetbrains/kotlin/psi/stubs/impl/KotlinConstantValueKt\n*L\n53#1:259\n53#1:260,3\n64#1:263,2\n64#1:265,4\n242#1:305,2\n242#1:307,4\n246#1:311\n246#1:312,3\n202#1:269\n202#1:270,3\n203#1:273\n203#1:274,3\n204#1:277\n204#1:278,3\n205#1:281\n205#1:282,3\n206#1:285\n206#1:286,3\n207#1:289\n207#1:290,3\n208#1:293\n208#1:294,3\n209#1:297\n209#1:298,3\n210#1:301\n210#1:302,3\n*E\n"})
public final class KotlinConstantValueKt {
    private static final void writeConstantKind(StubOutputStream $this$writeConstantKind, KotlinConstantValueKind kind) {
        KotlinConstantValueKind kotlinConstantValueKind = kind;
        int value2 = kotlinConstantValueKind != null ? kotlinConstantValueKind.ordinal() + 1 : 0;
        $this$writeConstantKind.writeVarInt(value2);
    }

    private static final KotlinConstantValueKind readConstantKind(StubInputStream $this$readConstantKind) {
        int kind = $this$readConstantKind.readVarInt();
        if (kind == 0) {
            return null;
        }
        return (KotlinConstantValueKind)((Object)KotlinConstantValueKind.getEntries().get(kind - 1));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ConstantValue<?> deserializeConstantValue(@NotNull StubInputStream dataStream) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        KotlinConstantValueKind kotlinConstantValueKind = KotlinConstantValueKt.readConstantKind(dataStream);
        switch (kotlinConstantValueKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[kotlinConstantValueKind.ordinal()]) {
            case -1: {
                constantValue = null;
                break;
            }
            case 1: {
                constantValue = NullValue.INSTANCE;
                break;
            }
            case 2: {
                constantValue = new BooleanValue(dataStream.readBoolean());
                break;
            }
            case 3: {
                constantValue = new CharValue(dataStream.readChar());
                break;
            }
            case 4: {
                constantValue = new ByteValue(dataStream.readByte());
                break;
            }
            case 5: {
                constantValue = new ShortValue(dataStream.readShort());
                break;
            }
            case 6: {
                constantValue = new IntValue(dataStream.readVarInt());
                break;
            }
            case 7: {
                constantValue = new LongValue(DataInputOutputUtil.readLONG(dataStream));
                break;
            }
            case 8: {
                constantValue = new DoubleValue(dataStream.readDouble());
                break;
            }
            case 9: {
                constantValue = new FloatValue(dataStream.readFloat());
                break;
            }
            case 10: {
                ClassId classId = StubUtils.deserializeClassId(dataStream);
                Intrinsics.checkNotNull((Object)classId);
                String string = dataStream.readNameString();
                Intrinsics.checkNotNull((Object)string);
                Name name2 = Name.identifier(string);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                constantValue = new EnumValue(classId, name2);
                break;
            }
            case 11: {
                ClassId classId = StubUtils.deserializeClassId(dataStream);
                Intrinsics.checkNotNull((Object)classId);
                constantValue = new KClassValue(classId, dataStream.readVarInt());
                break;
            }
            case 12: {
                String string = dataStream.readNameString();
                Intrinsics.checkNotNull((Object)string);
                constantValue = new StringValue(string);
                break;
            }
            case 13: {
                void $this$mapTo$iv$iv;
                int arraySize = dataStream.readVarInt() - 1;
                Iterable $this$map$iv = (Iterable)new IntRange(0, arraySize);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ConstantValue<?> constantValue2 = KotlinConstantValueKt.deserializeConstantValue(dataStream);
                    Intrinsics.checkNotNull(constantValue2);
                    collection.add(constantValue2);
                }
                List list = (List)destination$iv$iv;
                constantValue = new ArrayValue(list);
                break;
            }
            case 14: {
                constantValue = new UByteValue(dataStream.readByte());
                break;
            }
            case 15: {
                constantValue = new UShortValue(dataStream.readShort());
                break;
            }
            case 16: {
                constantValue = new UIntValue(dataStream.readVarInt());
                break;
            }
            case 17: {
                constantValue = new ULongValue(DataInputOutputUtil.readLONG(dataStream));
                break;
            }
            case 18: {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                ClassId classId = StubUtils.deserializeClassId(dataStream);
                Intrinsics.checkNotNull((Object)classId);
                ClassId classId2 = classId;
                int numberOfArgs = dataStream.readVarInt() - 1;
                Iterable $i$f$map = (Iterable)new IntRange(0, numberOfArgs);
                ClassId classId3 = classId2;
                AnnotationValue.Companion companion = AnnotationValue.Companion;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void $i$f$mapTo = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                Iterator iterator3 = $this$associateTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    int element$iv$iv = ((IntIterator)iterator3).nextInt();
                    Map map = destination$iv$iv;
                    int it = element$iv$iv;
                    boolean bl = false;
                    String string = dataStream.readNameString();
                    Intrinsics.checkNotNull((Object)string);
                    Name name3 = Name.identifier(string);
                    ConstantValue<?> constantValue3 = KotlinConstantValueKt.deserializeConstantValue(dataStream);
                    Intrinsics.checkNotNull(constantValue3);
                    Pair pair = TuplesKt.to((Object)name3, constantValue3);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map map = destination$iv$iv;
                constantValue = companion.create(classId3, map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return constantValue;
    }

    public static final void serializeConstantValue(@Nullable ConstantValue<?> constantValue, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        if (constantValue == null) {
            KotlinConstantValueKt.writeConstantKind(dataStream, null);
            return;
        }
        constantValue.accept(new KotlinConstantValueSerializationVisitor(dataStream), null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConstantValue<?> createConstantValue(@Nullable Object value2) {
        ConstantValue constantValue;
        Object object = value2;
        if (object instanceof Byte) {
            constantValue = new ByteValue(((Number)value2).byteValue());
        } else if (object instanceof Short) {
            constantValue = new ShortValue(((Number)value2).shortValue());
        } else if (object instanceof Integer) {
            constantValue = new IntValue(((Number)value2).intValue());
        } else if (object instanceof Long) {
            constantValue = new LongValue(((Number)value2).longValue());
        } else if (object instanceof Character) {
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (object instanceof Float) {
            constantValue = new FloatValue(((Number)value2).floatValue());
        } else if (object instanceof Double) {
            constantValue = new DoubleValue(((Number)value2).doubleValue());
        } else if (object instanceof Boolean) {
            constantValue = new BooleanValue((Boolean)value2);
        } else if (object instanceof String) {
            constantValue = new StringValue((String)value2);
        } else if (object instanceof byte[]) {
            void $this$mapTo$iv$iv;
            byte[] $this$map$iv = (byte[])value2;
            boolean $i$f$map = false;
            byte[] byArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                void it;
                void item$iv$iv;
                void var10_74 = item$iv$iv = $this$mapTo$iv$iv[i2];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue((byte)it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof short[]) {
            short[] $this$map$iv = (short[])value2;
            boolean $i$f$map = false;
            short[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n3 = $this$mapTo$iv$iv.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                short item$iv$iv;
                short it = item$iv$iv = $this$mapTo$iv$iv[i3];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue(it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof int[]) {
            int[] $this$map$iv = (int[])value2;
            boolean $i$f$map = false;
            int[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n4 = $this$mapTo$iv$iv.length;
            for (int i4 = 0; i4 < n4; ++i4) {
                int item$iv$iv;
                int it = item$iv$iv = $this$mapTo$iv$iv[i4];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue(it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof long[]) {
            long[] $this$map$iv = (long[])value2;
            boolean $i$f$map = false;
            long[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n5 = $this$mapTo$iv$iv.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                void it;
                long item$iv$iv;
                long bl = item$iv$iv = $this$mapTo$iv$iv[i5];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(KotlinConstantValueKt.createConstantValue((long)it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof char[]) {
            char[] $this$map$iv = (char[])value2;
            boolean $i$f$map = false;
            char[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n6 = $this$mapTo$iv$iv.length;
            for (int i6 = 0; i6 < n6; ++i6) {
                char item$iv$iv;
                char it = item$iv$iv = $this$mapTo$iv$iv[i6];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue(Character.valueOf(it)));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof float[]) {
            float[] $this$map$iv = (float[])value2;
            boolean $i$f$map = false;
            float[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n7 = $this$mapTo$iv$iv.length;
            for (int i7 = 0; i7 < n7; ++i7) {
                float item$iv$iv;
                float it = item$iv$iv = $this$mapTo$iv$iv[i7];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue(Float.valueOf(it)));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof double[]) {
            double[] $this$map$iv = (double[])value2;
            boolean $i$f$map = false;
            double[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n8 = $this$mapTo$iv$iv.length;
            for (int i8 = 0; i8 < n8; ++i8) {
                void it;
                double item$iv$iv;
                double bl = item$iv$iv = $this$mapTo$iv$iv[i8];
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(KotlinConstantValueKt.createConstantValue((double)it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof boolean[]) {
            boolean[] $this$map$iv = (boolean[])value2;
            boolean $i$f$map = false;
            boolean[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n9 = $this$mapTo$iv$iv.length;
            for (int i9 = 0; i9 < n9; ++i9) {
                boolean item$iv$iv;
                boolean it = item$iv$iv = $this$mapTo$iv$iv[i9];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue(it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof Object[]) {
            Object[] $this$map$iv = (Object[])value2;
            boolean $i$f$map = false;
            Object[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n10 = $this$mapTo$iv$iv.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                Object item$iv$iv;
                Object it = item$iv$iv = $this$mapTo$iv$iv[i10];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinConstantValueKt.createConstantValue(it));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            constantValue = new ArrayValue(list);
        } else if (object instanceof EnumData) {
            constantValue = new EnumValue(((EnumData)value2).getEnumClassId(), ((EnumData)value2).getEnumEntryName());
        } else if (object instanceof KClassData) {
            constantValue = new KClassValue(((KClassData)value2).getClassId(), ((KClassData)value2).getArrayNestedness());
        } else if (object instanceof AnnotationData) {
            constantValue = AnnotationValue.Companion.create(((AnnotationData)value2).getAnnoClassId(), ((AnnotationData)value2).getArgs());
        } else if (object == null) {
            constantValue = NullValue.INSTANCE;
        } else {
            throw new IllegalStateException(("Unsupported value " + value2).toString());
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConstantValue<?> createConstantValue(@NotNull ProtoBuf.Annotation.Argument.Value value2, @NotNull NameResolver nameResolver) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Boolean bl = Flags.IS_UNSIGNED.get(value2.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean isUnsigned = bl;
        ProtoBuf.Annotation.Argument.Value.Type type = value2.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                constantValue = (ConstantValue)KotlinConstantValueKt.createConstantValue$letIf((byte)value2.getIntValue(), isUnsigned, createConstantValue.10.INSTANCE, createConstantValue.11.INSTANCE);
                break;
            }
            case 2: {
                constantValue = new CharValue((char)value2.getIntValue());
                break;
            }
            case 3: {
                constantValue = (ConstantValue)KotlinConstantValueKt.createConstantValue$letIf((short)value2.getIntValue(), isUnsigned, createConstantValue.12.INSTANCE, createConstantValue.13.INSTANCE);
                break;
            }
            case 4: {
                constantValue = (ConstantValue)KotlinConstantValueKt.createConstantValue$letIf((int)value2.getIntValue(), isUnsigned, createConstantValue.14.INSTANCE, createConstantValue.15.INSTANCE);
                break;
            }
            case 5: {
                constantValue = (ConstantValue)KotlinConstantValueKt.createConstantValue$letIf(value2.getIntValue(), isUnsigned, createConstantValue.16.INSTANCE, createConstantValue.17.INSTANCE);
                break;
            }
            case 6: {
                constantValue = new FloatValue(value2.getFloatValue());
                break;
            }
            case 7: {
                constantValue = new DoubleValue(value2.getDoubleValue());
                break;
            }
            case 8: {
                constantValue = new BooleanValue(value2.getIntValue() != 0L);
                break;
            }
            case 9: {
                constantValue = new StringValue(nameResolver.getString(value2.getStringValue()));
                break;
            }
            case 10: {
                constantValue = new KClassValue(KotlinConstantValueKt.getClassId(nameResolver, value2.getClassId()), value2.getArrayDimensionCount());
                break;
            }
            case 11: {
                constantValue = new EnumValue(KotlinConstantValueKt.getClassId(nameResolver, value2.getClassId()), KotlinConstantValueKt.getName(nameResolver, value2.getEnumValueId()));
                break;
            }
            case 12: {
                void $this$associateTo$iv$iv;
                List<ProtoBuf.Annotation.Argument> list = value2.getAnnotation().getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
                Iterable $this$associate$iv = list;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    boolean bl2 = false;
                    Name name2 = KotlinConstantValueKt.getName(nameResolver, it.getNameId());
                    ProtoBuf.Annotation.Argument.Value value3 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
                    Pair pair = TuplesKt.to((Object)name2, KotlinConstantValueKt.createConstantValue(value3, nameResolver));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map args = destination$iv$iv;
                constantValue = AnnotationValue.Companion.create(KotlinConstantValueKt.getClassId(nameResolver, value2.getAnnotation().getId()), args);
                break;
            }
            case 13: {
                void $this$mapTo$iv$iv;
                List<ProtoBuf.Annotation.Argument.Value> list = value2.getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArrayElementList(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable $i$f$associate = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProtoBuf.Annotation.Argument.Value value4 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(KotlinConstantValueKt.createConstantValue((ProtoBuf.Annotation.Argument.Value)it, nameResolver));
                }
                List list2 = (List)destination$iv$iv;
                constantValue = new ArrayValue(list2);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported annotation argument type: " + value2.getType()).toString());
            }
        }
        return constantValue;
    }

    private static final ClassId getClassId(NameResolver $this$getClassId, int index) {
        return ClassId.Companion.fromString($this$getClassId.getQualifiedClassName(index), $this$getClassId.isLocalClassName(index));
    }

    private static final Name getName(NameResolver $this$getName, int index) {
        Name name2 = Name.guessByFirstCharacter($this$getName.getString(index));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(...)");
        return name2;
    }

    private static final <T, R> R createConstantValue$letIf(T $this$createConstantValue_u24letIf, boolean predicate, Function1<? super T, ? extends R> f2, Function1<? super T, ? extends R> g2) {
        return (R)(predicate ? f2.invoke($this$createConstantValue_u24letIf) : g2.invoke($this$createConstantValue_u24letIf));
    }

    public static final /* synthetic */ void access$writeConstantKind(StubOutputStream $receiver, KotlinConstantValueKind kind) {
        KotlinConstantValueKt.writeConstantKind($receiver, kind);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KotlinConstantValueKind.values().length];
            try {
                nArray[KotlinConstantValueKind.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.CHAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.BYTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.SHORT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.INT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.FLOAT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.ENUM.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.KCLASS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.STRING.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.ARRAY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.UBYTE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.USHORT.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.UINT.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.ULONG.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinConstantValueKind.ANNO.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

