/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantExpressionStubImpl;
import org.jetbrains.kotlin.psi.utils.ConstantExpressionUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0011\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinConstantExpressionStubImpl;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "debugName", "", "<init>", "(Ljava/lang/String;)V", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "Companion", "psi-impl"})
public final class KtConstantExpressionElementType
extends KtStubElementType<KotlinConstantExpressionStubImpl, KtConstantExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KtConstantExpressionElementType(@NonNls @NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(debugName, KtConstantExpression.class, KotlinConstantExpressionStub.class);
    }

    @Override
    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!StubUtils.isDeclaredInsideValueArgument$psi_impl(node)) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStubImpl createStub(@NotNull KtConstantExpression psi, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        IElementType iElementType = psi.getNode().getElementType();
        KtConstantExpressionElementType ktConstantExpressionElementType = iElementType instanceof KtConstantExpressionElementType ? (KtConstantExpressionElementType)iElementType : null;
        if (ktConstantExpressionElementType == null) {
            throw new IllegalStateException("Stub element type is expected for constant");
        }
        KtConstantExpressionElementType elementType = ktConstantExpressionElementType;
        String string = psi.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String value2 = string;
        ConstantValueKind constantValueKind = ConstantExpressionUtils.toConstantValueKind(elementType);
        StringRef stringRef = StringRef.fromString(value2);
        Intrinsics.checkNotNullExpressionValue((Object)stringRef, (String)"fromString(...)");
        return new KotlinConstantExpressionStubImpl(parentStub, constantValueKind, stringRef);
    }

    @Override
    public void serialize(@NotNull KotlinConstantExpressionStubImpl stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeVarInt(stub.getKind().ordinal());
        dataStream.writeName(stub.getValue());
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        int kindOrdinal = dataStream.readVarInt();
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            stringRef = StringRef.fromString("");
        }
        StringRef value2 = stringRef;
        ConstantValueKind valueKind = (ConstantValueKind)((Object)ConstantValueKind.getEntries().get(kindOrdinal));
        Intrinsics.checkNotNull((Object)value2);
        return new KotlinConstantExpressionStubImpl(parentStub, valueKind, value2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0003\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType$Companion;", "", "<init>", "()V", "kindToConstantElementType", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "kind", "Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;", "constantElementTypeToKind", "elementType", "psi-impl"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use ConstantValueKind.toConstantExpressionElementType() instead", replaceWith=@ReplaceWith(expression="kind.toConstantExpressionElementType()", imports={"org.jetbrains.kotlin.psi.utils.toConstantExpressionElementType"}))
        @NotNull
        public final KtConstantExpressionElementType kindToConstantElementType(@NotNull ConstantValueKind kind) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            KtStubElementType<? extends KotlinConstantExpressionStub, KtConstantExpression> ktStubElementType = ConstantExpressionUtils.toConstantExpressionElementType(kind);
            Intrinsics.checkNotNull(ktStubElementType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType");
            return (KtConstantExpressionElementType)ktStubElementType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

