/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithReturnType;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;

public class KtEnumEntry
extends KtClass
implements KtDeclarationWithReturnType {
    public KtEnumEntry(@NotNull ASTNode node) {
        if (node == null) {
            KtEnumEntry.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtEnumEntry(@NotNull KotlinClassStub stub) {
        if (stub == null) {
            KtEnumEntry.$$$reportNull$$$0(1);
        }
        super(stub, (IStubElementType<?, ?>)KtStubBasedElementTypes.ENUM_ENTRY);
    }

    @Override
    @NotNull
    public List<KtSuperTypeListEntry> getSuperTypeListEntries() {
        KtInitializerList initializerList = this.getInitializerList();
        if (initializerList == null) {
            List<KtSuperTypeListEntry> list = Collections.emptyList();
            if (list == null) {
                KtEnumEntry.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<KtSuperTypeListEntry> list = initializerList.getInitializers();
        if (list == null) {
            KtEnumEntry.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean hasInitializer() {
        return !this.getSuperTypeListEntries().isEmpty();
    }

    @Override
    @Nullable
    public ClassId getClassId() {
        return null;
    }

    @Nullable
    public KtInitializerList getInitializerList() {
        return this.getStubOrPsiChild(KtStubBasedElementTypes.INITIALIZER_LIST);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof KtEnumEntry)) {
            return false;
        }
        KtEnumEntry anotherEnumEntry = (KtEnumEntry)another;
        if (!Objects.equals(this.getName(), anotherEnumEntry.getName())) {
            return false;
        }
        KtClassOrObject thisContainingClass = KtPsiUtilKt.getContainingClassOrObject(this);
        if (thisContainingClass == null) {
            return false;
        }
        KtClassOrObject anotherContainingClass = KtPsiUtilKt.getContainingClassOrObject(anotherEnumEntry);
        return thisContainingClass.isEquivalentTo(anotherContainingClass);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtEnumEntry.$$$reportNull$$$0(4);
        }
        return visitor2.visitEnumEntry(this, data);
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtEnumEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtEnumEntry";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypeListEntries";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

