/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.LibraryContainerAwareVirtualFile;
import org.jetbrains.kotlin.load.kotlin.PathHolder;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.PerformanceManagerKt;
import org.jetbrains.kotlin.util.PhaseSideType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0014\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0082\u0004J\n\u0010 \u001a\u00020\u0007H\u0096\u0080\u0004J\n\u0010!\u001a\u00020\u0011H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "className", "Lorg/jetbrains/kotlin/name/ClassId;", "classVersion", "", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "innerClasses", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;ILorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "location", "", "getLocation", "()Ljava/lang/String;", "containingLibrary", "getContainingLibrary", "containingLibraryPath", "Lorg/jetbrains/kotlin/load/kotlin/PathHolder;", "getContainingLibraryPath", "()Lorg/jetbrains/kotlin/load/kotlin/PathHolder;", "getFileContents", "", "equals", "", "other", "", "hashCode", "toString", "Factory", "frontend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nVirtualFileKotlinClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileKotlinClass.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private static final Logger LOG;

    private VirtualFileKotlinClass(VirtualFile file, ClassId className, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
        super(className, classVersion, classHeader, innerClasses);
        this.file = file;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getLocation() {
        String string = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Override
    @Nullable
    public String getContainingLibrary() {
        String string = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{"!/"};
        return (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Override
    @Nullable
    public PathHolder getContainingLibraryPath() {
        PathHolder pathHolder;
        Path containingLibraryPath;
        Path path;
        if (this.file instanceof LibraryContainerAwareVirtualFile) {
            path = ((LibraryContainerAwareVirtualFile)((Object)this.file)).getContainingLibraryPath();
        } else {
            String string = this.getContainingLibrary();
            if (string != null) {
                String it = string;
                boolean bl = false;
                path = Paths.get(it, new String[0]);
            } else {
                path = null;
            }
        }
        Path path2 = containingLibraryPath = path;
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            pathHolder = new PathHolder(containingLibraryPath);
        } else {
            pathHolder = null;
        }
        return pathHolder;
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            return byArray;
        }
        catch (IOException e2) {
            throw VirtualFileKotlinClass.Factory.logFileReadingErrorMessage(e2, this.file);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual((Object)((VirtualFileKotlinClass)other).file, (Object)this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    public /* synthetic */ VirtualFileKotlinClass(VirtualFile file, ClassId className, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses, DefaultConstructorMarker $constructor_marker) {
        this(file, className, classVersion, classHeader, innerClasses);
    }

    static {
        Logger logger = Logger.getInstance(VirtualFileKotlinClass.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "fileContent", "", "perfManager", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "create$frontend_common_jvm", "logFileReadingErrorMessage", "", "e", "renderFileReadingErrorMessage", "", "frontend.common.jvm"})
    @SourceDebugExtension(value={"SMAP\nVirtualFileKotlinClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileKotlinClass.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
    public static final class Factory {
        private Factory() {
        }

        @Nullable
        public final KotlinClassFinder.Result create$frontend_common_jvm(@NotNull VirtualFile file, @NotNull MetadataVersion metadataVersion, @Nullable byte[] fileContent, @Nullable PerformanceManager perfManager) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
            return (KotlinClassFinder.Result)PerformanceManagerKt.tryMeasureSideTime(perfManager, PhaseSideType.BinaryClassFromKotlinFile, () -> Factory.create$lambda$0(file, fileContent, metadataVersion));
        }

        private final Throwable logFileReadingErrorMessage(Throwable e2, VirtualFile file) {
            String errorMessage = this.renderFileReadingErrorMessage(file);
            LOG.warn(errorMessage, e2);
            return new IllegalStateException(errorMessage, e2);
        }

        private final String renderFileReadingErrorMessage(VirtualFile file) {
            return "Could not read file: " + file.getPath() + "; size in bytes: " + file.getLength() + "; file type: " + file.getFileType().getName();
        }

        private static final VirtualFileKotlinClass create$lambda$0$1(VirtualFile $file, ClassId name2, Integer classVersion, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
            Intrinsics.checkNotNull((Object)name2);
            Intrinsics.checkNotNull((Object)classVersion);
            int n2 = classVersion;
            Intrinsics.checkNotNull((Object)header);
            Intrinsics.checkNotNull((Object)innerClasses);
            return new VirtualFileKotlinClass($file, name2, n2, header, innerClasses, null);
        }

        private static final KotlinClassFinder.Result create$lambda$0(VirtualFile $file, byte[] $fileContent, MetadataVersion $metadataVersion) {
            boolean bl;
            boolean bl2 = bl = Intrinsics.areEqual((Object)$file.getExtension(), (Object)JavaClassFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual((Object)$file.getFileType(), (Object)JavaClassFileType.INSTANCE);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22 = false;
                String $i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22 = "Trying to read binary data from a non-class file " + $file;
                throw new AssertionError((Object)$i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22);
            }
            try {
                byte[] byteContent;
                byte[] byArray = $fileContent;
                if ($fileContent == null) {
                    byte[] byArray2 = $file.contentsToByteArray(false);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"contentsToByteArray(...)");
                }
                if (!((byteContent = byArray).length == 0)) {
                    KotlinClassFinder.Result result2;
                    VirtualFileKotlinClass kotlinJvmBinaryClass;
                    VirtualFileKotlinClass virtualFileKotlinClass = kotlinJvmBinaryClass = (VirtualFileKotlinClass)FileBasedKotlinClass.create(byteContent, $metadataVersion, (arg_0, arg_1, arg_2, arg_3) -> Factory.create$lambda$0$1($file, arg_0, arg_1, arg_2, arg_3));
                    if (virtualFileKotlinClass != null) {
                        VirtualFileKotlinClass it = virtualFileKotlinClass;
                        boolean bl3 = false;
                        result2 = new KotlinClassFinder.Result.KotlinClass(it, byteContent);
                    } else {
                        result2 = new KotlinClassFinder.Result.ClassFileContent(byteContent);
                    }
                    return result2;
                }
            }
            catch (FileNotFoundException byteContent) {
            }
            catch (NoSuchFileException byteContent) {
            }
            catch (Throwable e2) {
                if (e2 instanceof ControlFlowException) {
                    throw e2;
                }
                throw Factory.logFileReadingErrorMessage(e2, $file);
            }
            return null;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

