/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.serialization.ConstantsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u001d\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u000b0\"H\u0086\b\u00f8\u0001\u0000J7\u0010#\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\b\u0010$\u001a\u0004\u0018\u0001H\u001e2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u000b0\"H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\"\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0)H\u0086\b\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/serialization/DataWriter;", "", "<init>", "()V", "data", "Ljava/io/ByteArrayOutputStream;", "getData", "()Ljava/io/ByteArrayOutputStream;", "output", "Ljava/io/DataOutputStream;", "saveTo", "", "writeByte", "byte", "", "writeByteArray", "byteArray", "", "writeString", "string", "", "writeBoolean", "boolean", "", "writeInt", "int", "writeDouble", "double", "", "writeCollection", "T", "collection", "", "writeItem", "Lkotlin/Function1;", "ifNotNull", "t", "write", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ifTrue", "condition", "Lkotlin/Function0;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsIrAstSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsIrAstSerializer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/serialization/DataWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,666:1\n1914#2,2:667\n*S KotlinDebug\n*F\n+ 1 JsIrAstSerializer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/serialization/DataWriter\n*L\n63#1:667,2\n*E\n"})
final class DataWriter {
    @NotNull
    private final ByteArrayOutputStream data = new ByteArrayOutputStream();
    @NotNull
    private final DataOutputStream output = new DataOutputStream(this.data);

    @NotNull
    public final ByteArrayOutputStream getData() {
        return this.data;
    }

    public final void saveTo(@NotNull DataOutputStream output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        DataOutputStream it = output2;
        boolean bl = false;
        this.data.writeTo(it);
    }

    public final void writeByte(int n2) {
        if ((n2 & 0xFFFFFF80) != 0) {
            throw new IllegalStateException(("Byte out of bounds: " + n2).toString());
        }
        this.output.writeByte(n2);
    }

    public final void writeByteArray(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.output.writeInt(byteArray.length);
        this.output.write(byteArray);
    }

    public final void writeString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        byte[] byArray = string.getBytes(ConstantsKt.getSerializationCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.writeByteArray(byArray);
    }

    public final void writeBoolean(boolean bl) {
        this.output.writeBoolean(bl);
    }

    public final void writeInt(int n2) {
        this.output.writeInt(n2);
    }

    public final void writeDouble(double d2) {
        this.output.writeDouble(d2);
    }

    public final <T> void writeCollection(@NotNull Collection<? extends T> collection, @NotNull Function1<? super T, Unit> writeItem) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(writeItem, (String)"writeItem");
        boolean $i$f$writeCollection = false;
        this.output.writeInt(collection.size());
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            writeItem.invoke(element$iv);
        }
    }

    @Nullable
    public final <T> T ifNotNull(@Nullable T t2, @NotNull Function1<? super T, Unit> write) {
        Intrinsics.checkNotNullParameter(write, (String)"write");
        boolean $i$f$ifNotNull = false;
        this.output.writeBoolean(t2 != null);
        if (t2 != null) {
            write.invoke(t2);
        }
        return t2;
    }

    public final void ifTrue(boolean condition, @NotNull Function0<Unit> write) {
        Intrinsics.checkNotNullParameter(write, (String)"write");
        boolean $i$f$ifTrue = false;
        this.output.writeBoolean(condition);
        if (condition) {
            write.invoke();
        }
    }
}

