/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u000f*\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "hasThrowableSupertype", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "hasGenericOuterDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirThrowableSubclassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirThrowableSubclassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,70:1\n36#2:71\n1806#3,3:72\n75#4:75\n53#4:76\n*S KotlinDebug\n*F\n+ 1 FirThrowableSubclassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker\n*L\n35#1:71\n49#1:72,3\n63#1:75\n63#1:76\n*E\n"})
public final class FirThrowableSubclassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirThrowableSubclassChecker INSTANCE = new FirThrowableSubclassChecker();

    private FirThrowableSubclassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.hasThrowableSupertype(context2, declaration)) {
            return;
        }
        if (!((Collection)declaration.getTypeParameters()).isEmpty()) {
            boolean bl;
            Object object = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration.getTypeParameters());
            if (object != null && (object = object.getSource()) != null) {
                Object it = object;
                boolean bl2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getGENERIC_THROWABLE_SUBCLASS(), null, 8, null);
            }
            FirClass firClass = declaration;
            if (firClass instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                bl = $this$isInner$iv.getStatus().isInner() || ((FirRegularClass)declaration).isLocal();
            } else if (firClass instanceof FirAnonymousObject) {
                bl = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean shouldReport = bl;
            if (shouldReport) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), null, 8, null);
            }
        } else if (this.hasGenericOuterDeclaration(context2, declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), null, 8, null);
        }
    }

    private final boolean hasThrowableSupertype(CheckerContext context2, FirClass $this$hasThrowableSupertype) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes($this$hasThrowableSupertype);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof ConeErrorType) && FirHelpersKt.isSubtypeOfThrowable(it, context2.getSession()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasGenericOuterDeclaration(CheckerContext context2, FirClass $this$hasGenericOuterDeclaration) {
        if (!$this$hasGenericOuterDeclaration.isLocal()) {
            return false;
        }
        for (FirBasedSymbol containingDeclaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            boolean hasTypeParameters;
            FirBasedSymbol firBasedSymbol = containingDeclaration;
            boolean bl = firBasedSymbol instanceof FirCallableSymbol ? !((Collection)((FirCallableSymbol)containingDeclaration).getTypeParameterSymbols()).isEmpty() : (firBasedSymbol instanceof FirClassLikeSymbol ? !((Collection)((FirClassLikeSymbol)containingDeclaration).getTypeParameterSymbols()).isEmpty() : (hasTypeParameters = false));
            if (hasTypeParameters) {
                return true;
            }
            if (!(containingDeclaration instanceof FirRegularClassSymbol)) continue;
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)containingDeclaration;
            boolean $i$f$isLocal = false;
            if (((FirClassLikeDeclaration)$this$isLocal$iv.getFir()).isLocal()) continue;
            FirClassLikeSymbol $this$isInner$iv = (FirClassLikeSymbol)containingDeclaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getRawStatus().isInner()) continue;
            return false;
        }
        return false;
    }
}

