/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.web;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibSingleFileMetadataSerializer;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.web.AnalyzedFirOutput;
import org.jetbrains.kotlin.cli.pipeline.web.JsFir2IrPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.web.JsSerializedKlibPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.web.WebKlibSerializationPipelinePhaseKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.pipeline.Fir2IrActualizedResult;
import org.jetbrains.kotlin.fir.pipeline.Fir2KlibMetadataSerializer;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;
import org.jetbrains.kotlin.wasm.config.WasmTargetKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016JX\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/web/WebKlibSerializationPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/web/JsFir2IrPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/web/JsSerializedKlibPipelineArtifact;", "<init>", "()V", "executePhase", "input", "serializeFirKlib", "", "moduleStructure", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "firOutputs", "", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "fir2IrActualizedResult", "Lorg/jetbrains/kotlin/fir/pipeline/Fir2IrActualizedResult;", "outputKlibPath", "", "nopack", "", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "jsOutputName", "useWasmPlatform", "wasmTarget", "Lorg/jetbrains/kotlin/platform/wasm/WasmTarget;", "cli-js"})
public final class WebKlibSerializationPipelinePhase
extends PipelinePhase<JsFir2IrPipelineArtifact, JsSerializedKlibPipelineArtifact> {
    @NotNull
    public static final WebKlibSerializationPipelinePhase INSTANCE = new WebKlibSerializationPipelinePhase();

    private WebKlibSerializationPipelinePhase() {
        super("JsKlibSerializationPipelinePhase", null, null, 6, null);
    }

    @Override
    @Nullable
    public JsSerializedKlibPipelineArtifact executePhase(@NotNull JsFir2IrPipelineArtifact input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Fir2IrActualizedResult fir2IrResult = input.component1();
        AnalyzedFirOutput firOutput = input.component2();
        CompilerConfiguration configuration = input.component3();
        BaseDiagnosticsCollector diagnosticCollector = input.component4();
        ModulesStructure moduleStructure = input.component5();
        String outputKlibPath = WebKlibSerializationPipelinePhaseKt.computeOutputKlibPath(configuration);
        this.serializeFirKlib(moduleStructure, firOutput.getOutput(), fir2IrResult, outputKlibPath, JSConfigurationKeysKt.getProduceKlibDir(configuration), diagnosticCollector, JSConfigurationKeysKt.getPerModuleOutputName(configuration), JSConfigurationKeysKt.getWasmCompilation(configuration), WasmTargetKt.getWasmTarget(configuration));
        return new JsSerializedKlibPipelineArtifact(outputKlibPath, diagnosticCollector, configuration);
    }

    public final void serializeFirKlib(@NotNull ModulesStructure moduleStructure, @NotNull List<ModuleCompilerAnalyzedOutput> firOutputs, @NotNull Fir2IrActualizedResult fir2IrActualizedResult, @NotNull String outputKlibPath, boolean nopack, @NotNull BaseDiagnosticsCollector diagnosticsReporter, @Nullable String jsOutputName, boolean useWasmPlatform, @Nullable WasmTarget wasmTarget) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter(firOutputs, (String)"firOutputs");
        Intrinsics.checkNotNullParameter((Object)fir2IrActualizedResult, (String)"fir2IrActualizedResult");
        Intrinsics.checkNotNullParameter((Object)outputKlibPath, (String)"outputKlibPath");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        Fir2KlibMetadataSerializer fir2KlibMetadataSerializer = new Fir2KlibMetadataSerializer(moduleStructure.getCompilerConfiguration(), firOutputs, fir2IrActualizedResult, false, false);
        IncrementalDataProvider incrementalDataProvider = JSConfigurationKeysKt.getIncrementalDataProvider(moduleStructure.getCompilerConfiguration());
        List icData = incrementalDataProvider != null ? KlibKt.getSerializedData(incrementalDataProvider, fir2KlibMetadataSerializer.getSourceFiles()) : null;
        String string = moduleStructure.getCompilerConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string);
        CompilerConfiguration compilerConfiguration = moduleStructure.getCompilerConfiguration();
        DiagnosticReporter diagnosticReporter = diagnosticsReporter;
        KlibSingleFileMetadataSerializer klibSingleFileMetadataSerializer = fir2KlibMetadataSerializer;
        List<KotlinLibrary> list = moduleStructure.getKlibs().getAll();
        IrModuleFragment irModuleFragment = fir2IrActualizedResult.getIrModuleFragment();
        IrBuiltIns irBuiltIns = fir2IrActualizedResult.getIrBuiltIns();
        List list2 = icData;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        KlibKt.serializeModuleIntoKlib(string, compilerConfiguration, diagnosticReporter, klibSingleFileMetadataSerializer, outputKlibPath, list, irModuleFragment, irBuiltIns, list2, nopack, jsOutputName, useWasmPlatform ? BuiltInsPlatform.WASM : BuiltInsPlatform.JS, wasmTarget, CLIConfigurationKeysKt.getPerfManager(moduleStructure.getCompilerConfiguration()));
    }
}

