/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DefaultParameterInjector;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmDefaultArgumentFunctionFactory;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInlineCallableReferenceToLambdaPhase;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@PhaseDescription(name="DefaultParameterInjector", prerequisite={FunctionReferenceLowering.class, JvmInlineCallableReferenceToLambdaPhase.class})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultParameterInjector;", "Lorg/jetbrains/kotlin/backend/common/lower/DefaultParameterInjector;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "nullConst", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "irParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "defaultArgumentStubVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "useConstructorMarker", "", "isStatic", "argumentsForCall", "", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "stubFunction", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmDefaultParameterInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDefaultParameterInjector.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultParameterInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1833#2,4:106\n831#2:110\n861#2,2:111\n*S KotlinDebug\n*F\n+ 1 JvmDefaultParameterInjector.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultParameterInjector\n*L\n63#1:106,4\n94#1:110\n94#1:111,2\n*E\n"})
public final class JvmDefaultParameterInjector
extends DefaultParameterInjector<JvmBackendContext> {
    public JvmDefaultParameterInjector(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, new JvmDefaultArgumentFunctionFactory(context2), false, false, false, 16, null);
    }

    @Override
    @Nullable
    protected IrExpression nullConst(int startOffset, int endOffset, @NotNull IrValueParameter irParameter) {
        Intrinsics.checkNotNullParameter((Object)irParameter, (String)"irParameter");
        return this.nullConst(startOffset, endOffset, irParameter.getType());
    }

    @Override
    @NotNull
    protected IrExpression nullConst(int startOffset, int endOffset, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return JvmIrTypeUtilsKt.defaultValue(type, startOffset, endOffset, (JvmBackendContext)this.getContext());
    }

    @Override
    @NotNull
    protected DescriptorVisibility defaultArgumentStubVisibility(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return JvmIrUtilsKt.getJvmVisibilityOfDefaultArgumentStub(function2);
    }

    @Override
    protected boolean useConstructorMarker(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof IrConstructor || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_CONSTRUCTOR()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_CONSTRUCTOR());
    }

    @Override
    protected boolean isStatic(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_REPLACEMENT()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_REPLACEMENT());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<IrValueParameter, IrExpression> argumentsForCall(@NotNull IrBlockBuilder $this$argumentsForCall, @NotNull IrFunctionAccessExpression expression2, @NotNull IrFunction stubFunction) {
        void $this$filterNotTo$iv$iv;
        Map map;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$argumentsForCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)stubFunction, (String)"stubFunction");
        int startOffset = expression2.getStartOffset();
        int endOffset = expression2.getEndOffset();
        IrFunction declaration = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        Iterable $this$count$iv = declaration.getParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!this.canHaveDefaultValue(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int defaultableParametersSize = n2;
        int[] maskValues = new int[(defaultableParametersSize + 31) / 32];
        Ref.IntRef defaultableParameterIndex = new Ref.IntRef();
        defaultableParameterIndex.element = -1;
        Map<IrValueParameter, IrExpression> mainArguments = ((JvmBackendContext)this.getContext()).getMultiFieldValueClassReplacements().mapFunctionMfvcStructures($this$argumentsForCall, stubFunction, declaration, (Function2<? super IrValueParameter, ? super IrType, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> JvmDefaultParameterInjector.argumentsForCall$lambda$1(this, defaultableParameterIndex, expression2, maskValues, startOffset, endOffset, arg_0, arg_1)));
        int n3 = stubFunction.getParameters().size() - (mainArguments.size() + maskValues.length);
        int n4 = 0 <= n3 ? (n3 < 2 ? 1 : 0) : (n3 = 0);
        if (_Assertions.ENABLED && n3 == 0) {
            boolean $i$a$-assert-JvmDefaultParameterInjector$argumentsForCall$22 = false;
            String $i$a$-assert-JvmDefaultParameterInjector$argumentsForCall$22 = "argument count mismatch: expected " + defaultableParametersSize + " arguments + " + maskValues.length + " masks + optional handler/marker, got " + stubFunction.getParameters().size() + " total in " + RenderIrElementKt.render$default(stubFunction, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-JvmDefaultParameterInjector$argumentsForCall$22);
        }
        Map $this$argumentsForCall_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$argumentsForCall_u24lambda_u243.putAll(mainArguments);
        Iterable $this$filterNot$iv = stubFunction.getParameters();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrValueParameter it = (IrValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (mainArguments.containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List restParameters = (List)destination$iv$iv;
        for (Pair pair : CollectionsKt.zip((Iterable)restParameters, (Iterable)ArraysKt.asList((int[])maskValues))) {
            IrValueParameter maskParameter = (IrValueParameter)pair.component1();
            int maskValue = ((Number)pair.component2()).intValue();
            $this$argumentsForCall_u24lambda_u243.put(maskParameter, IrConstImpl.Companion.int(startOffset, endOffset, maskParameter.getType(), maskValue));
        }
        if (restParameters.size() > maskValues.length) {
            IrValueParameter lastParameter = (IrValueParameter)CollectionsKt.last((List)restParameters);
            $this$argumentsForCall_u24lambda_u243.put(lastParameter, IrConstImpl.Companion.constNull(startOffset, endOffset, lastParameter.getType()));
        }
        return MapsKt.build((Map)map);
    }

    private static final IrExpression argumentsForCall$lambda$1(JvmDefaultParameterInjector this$0, Ref.IntRef $defaultableParameterIndex, IrFunctionAccessExpression $expression, int[] $maskValues, int $startOffset, int $endOffset, IrValueParameter sourceParameter, IrType targetParameterType) {
        IrExpression irExpression;
        IrExpression valueArgument;
        Intrinsics.checkNotNullParameter((Object)sourceParameter, (String)"sourceParameter");
        Intrinsics.checkNotNullParameter((Object)targetParameterType, (String)"targetParameterType");
        if (this$0.canHaveDefaultValue(sourceParameter)) {
            ++$defaultableParameterIndex.element;
            int cfr_ignored_0 = $defaultableParameterIndex.element;
        }
        if ((valueArgument = (IrExpression)$expression.getArguments().get(sourceParameter.getIndexInParameters())) == null) {
            $maskValues[$defaultableParameterIndex.element / 32] = $maskValues[$defaultableParameterIndex.element / 32] | 1 << $defaultableParameterIndex.element % 32;
        }
        if ((irExpression = valueArgument) == null) {
            irExpression = new IrCompositeImpl($expression.getStartOffset(), $expression.getEndOffset(), targetParameterType, IrStatementOrigin.Companion.getDEFAULT_VALUE(), CollectionsKt.listOf((Object)this$0.nullConst($startOffset, $endOffset, targetParameterType)));
        }
        return irExpression;
    }
}

