/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.diagnostics.IdSignatureClashDetector;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "getMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "publicIdSignatureComputer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "getPublicIdSignatureComputer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "clashDetector", "Lorg/jetbrains/kotlin/backend/common/diagnostics/IdSignatureClashDetector;", "getClashDetector$ir_serialization_common", "()Lorg/jetbrains/kotlin/backend/common/diagnostics/IdSignatureClashDetector;", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/Map;", "loadKnownBuiltins", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "computeSignatureByDeclaration", "declaration", "compatibleMode", "", "recordInSignatureClashDetector", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,89:1\n1914#2,2:90\n383#3,7:92\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n*L\n27#1:90,2\n44#1:92,7\n*E\n"})
public abstract class GlobalDeclarationTable {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final PublicIdSignatureComputer publicIdSignatureComputer;
    @NotNull
    private final IdSignatureClashDetector clashDetector;
    @NotNull
    private final Map<IrDeclaration, IdSignature> table;

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
        this.publicIdSignatureComputer = new PublicIdSignatureComputer(this.mangler);
        this.clashDetector = new IdSignatureClashDetector();
        this.table = new Object2ObjectOpenHashMap();
    }

    @NotNull
    public final KotlinMangler.IrMangler getMangler() {
        return this.mangler;
    }

    @NotNull
    public final PublicIdSignatureComputer getPublicIdSignatureComputer() {
        return this.publicIdSignatureComputer;
    }

    @NotNull
    public final IdSignatureClashDetector getClashDetector$ir_serialization_common() {
        return this.clashDetector;
    }

    @NotNull
    protected final Map<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    protected final void loadKnownBuiltins(@NotNull IrBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Iterable $this$forEach$iv = DeclarationTableKt.getKnownBuiltins(builtIns);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            IrSymbol symbol = ((IrSymbolOwner)it).getSymbol();
            IdSignature signature = symbol.getSignature();
            if (signature == null) {
                this.computeSignatureByDeclaration(it, false, true);
                continue;
            }
            this.table.put(it, signature);
            this.clashDetector.trackDeclaration(it, signature);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdSignature computeSignatureByDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode, boolean recordInSignatureClashDetector) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Map<IrDeclaration, IdSignature> map = this.table;
        IrDeclaration key$iv = declaration;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.publicIdSignatureComputer.computePublicIdSignature(declaration, compatibleMode);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map = object;
        IdSignature it = (IdSignature)((Object)map);
        boolean bl = false;
        if (recordInSignatureClashDetector && it.isPubliclyVisible() && !it.isLocal()) {
            this.clashDetector.trackDeclaration(declaration, it);
        }
        return (IdSignature)((Object)map);
    }
}

