/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.IrWhenUtils;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\n\b\u0000\u0010\u0006\u0018\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0086\bJ2\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrWhenUtils;", "", "<init>", "()V", "matchConditions", "", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ororSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "condition", "leafConditionPredicate", "Lkotlin/Function1;", "", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrWhenUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrWhenUtils.kt\norg/jetbrains/kotlin/backend/common/IrWhenUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1585#2:87\n1660#2,3:88\n1#3:91\n*S KotlinDebug\n*F\n+ 1 IrWhenUtils.kt\norg/jetbrains/kotlin/backend/common/IrWhenUtils\n*L\n43#1:87\n43#1:88,3\n*E\n"})
public final class IrWhenUtils {
    @NotNull
    public static final IrWhenUtils INSTANCE = new IrWhenUtils();

    private IrWhenUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends IrExpression> List<T> matchConditions(IrFunctionSymbol ororSymbol, IrExpression condition) {
        List list;
        Intrinsics.checkNotNullParameter((Object)ororSymbol, (String)"ororSymbol");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        boolean $i$f$matchConditions = false;
        Intrinsics.needClassReification();
        List<IrExpression> list2 = this.matchConditions(ororSymbol, condition, (Function1<? super IrExpression, Boolean>)((Function1)matchConditions.1.INSTANCE));
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrExpression irExpression = (IrExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                collection.add((IrExpression)it);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final List<IrExpression> matchConditions(@NotNull IrFunctionSymbol ororSymbol, @NotNull IrExpression condition, @NotNull Function1<? super IrExpression, Boolean> leafConditionPredicate) {
        Intrinsics.checkNotNullParameter((Object)ororSymbol, (String)"ororSymbol");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(leafConditionPredicate, (String)"leafConditionPredicate");
        if (condition instanceof IrWhen && Intrinsics.areEqual((Object)((IrWhen)condition).getOrigin(), (Object)IrStatementOrigin.Companion.getWHEN_COMMA())) {
            Collection collection;
            boolean bl = IrTypePredicatesKt.isBoolean(condition.getType());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "WHEN_COMMA should always be a Boolean: " + DumpIrTreeKt.dump$default(condition, null, 1, null);
                throw new AssertionError((Object)string);
            }
            ArrayList candidates = new ArrayList();
            for (IrBranch branch : ((IrWhen)condition).getBranches()) {
                List<IrExpression> list;
                Collection collection2 = candidates;
                if (IrUtilsKt.isElseBranch(branch)) {
                    boolean bl3 = IrUtilsKt.isTrueConst(branch.getCondition());
                    if (_Assertions.ENABLED && !bl3) {
                        boolean bl4 = false;
                        String string = "IrElseBranch.condition should be const true: " + DumpIrTreeKt.dump$default(branch.getCondition(), null, 1, null);
                        throw new AssertionError((Object)string);
                    }
                    list = this.matchConditions(ororSymbol, branch.getResult(), leafConditionPredicate);
                    if (list == null) {
                        return null;
                    }
                } else {
                    if (!IrUtilsKt.isTrueConst(branch.getResult())) {
                        return null;
                    }
                    list = this.matchConditions(ororSymbol, branch.getCondition(), leafConditionPredicate);
                    if (list == null) {
                        return null;
                    }
                }
                Iterable iterable = list;
                CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
            }
            Collection collection3 = candidates;
            if (collection3.isEmpty()) {
                boolean bl5 = false;
                collection = null;
            } else {
                collection = collection3;
            }
            return (List)collection;
        }
        if (condition instanceof IrCall && Intrinsics.areEqual((Object)((IrCall)condition).getSymbol(), (Object)ororSymbol)) {
            Object object;
            ArrayList candidates = new ArrayList();
            Iterator iterator2 = ((IrCall)condition).getArguments().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Object object2 = iterator2;
            while (object2.hasNext()) {
                IrExpression argument = (IrExpression)object2.next();
                Collection collection = candidates;
                IrExpression irExpression = argument;
                Intrinsics.checkNotNull((Object)irExpression);
                List<IrExpression> list = this.matchConditions(ororSymbol, irExpression, leafConditionPredicate);
                if (list == null) {
                    return null;
                }
                CollectionsKt.addAll((Collection)collection, (Iterable)list);
            }
            object2 = candidates;
            if (object2.isEmpty()) {
                boolean bl = false;
                object = null;
            } else {
                object = object2;
            }
            return (List)object;
        }
        if (((Boolean)leafConditionPredicate.invoke((Object)condition)).booleanValue()) {
            Object[] objectArray = new IrExpression[]{condition};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }
        return null;
    }
}

