/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J5\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirCommaInWhenConditionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "isApplicable", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkPsiOrLightTree", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkCommaInBranchCondition", "branch", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenBranch;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirWhenBranch;)V", "checkers"})
public final class FirCommaInWhenConditionChecker
extends FirExpressionSyntaxChecker<FirWhenExpression, PsiElement> {
    @NotNull
    public static final FirCommaInWhenConditionChecker INSTANCE = new FirCommaInWhenConditionChecker();

    private FirCommaInWhenConditionChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirWhenExpression element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return element.getSubjectVariable() == null;
    }

    @Override
    public void checkPsiOrLightTree(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirWhenExpression element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        for (FirWhenBranch branch : element.getBranches()) {
            if (branch.getCondition() instanceof FirElseIfTrueCondition) continue;
            this.checkCommaInBranchCondition(context2, reporter, branch);
        }
    }

    private final void checkCommaInBranchCondition(CheckerContext context2, DiagnosticReporter reporter, FirWhenBranch branch) {
        KtSourceElement source;
        KtSourceElement ktSourceElement = source = branch.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.WHEN_ENTRY)) {
            KtSourceElement ktSourceElement2;
            KtSourceElement ktSourceElement3 = source;
            if (ktSourceElement3 != null) {
                KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COMMA");
                ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, ktSingleValueToken, 0, 1, false, 10, null);
            } else {
                ktSourceElement2 = null;
            }
            if (ktSourceElement2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT(), null, 8, null);
            }
        }
    }
}

