/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a&\u0010\u000b\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000e\" \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"useSiteTargetsFromMetaAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "findUseSiteTargets", "USE_SITE_TARGET_NAME_MAP", "", "", "DEFAULT_USE_SITE_TARGETS", "forEachAnnotationTarget", "", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "semantics"})
@SourceDebugExtension(value={"SMAP\nAnnotationTargetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationTargetUtils.kt\norg/jetbrains/kotlin/fir/declarations/AnnotationTargetUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n1869#3,2:69\n1869#3,2:71\n1803#3,3:73\n*S KotlinDebug\n*F\n+ 1 AnnotationTargetUtils.kt\norg/jetbrains/kotlin/fir/declarations/AnnotationTargetUtilsKt\n*L\n59#1:69,2\n64#1:71,2\n47#1:73,3\n*E\n"})
public final class AnnotationTargetUtilsKt {
    @NotNull
    private static final Map<String, Set<AnnotationUseSiteTarget>> USE_SITE_TARGET_NAME_MAP;
    @NotNull
    private static final Set<AnnotationUseSiteTarget> DEFAULT_USE_SITE_TARGETS;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Set<AnnotationUseSiteTarget> useSiteTargetsFromMetaAnnotation(@NotNull FirAnnotation $this$useSiteTargetsFromMetaAnnotation, @NotNull FirSession session) {
        Set<AnnotationUseSiteTarget> set;
        List<FirAnnotation> list;
        Intrinsics.checkNotNullParameter((Object)$this$useSiteTargetsFromMetaAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirRegularClass firRegularClass = FirAnnotationUtilsKt.toAnnotationClass($this$useSiteTargetsFromMetaAnnotation, session);
        if (firRegularClass != null && (list = firRegularClass.getAnnotations()) != null) {
            Set<AnnotationUseSiteTarget> set2;
            Object v0;
            block3: {
                Iterable iterable = list;
                for (Object t2 : iterable) {
                    FirAnnotation it = (FirAnnotation)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassIdSafe(it, session), (Object)StandardClassIds.Annotations.INSTANCE.getTarget())) continue;
                    v0 = t2;
                    break block3;
                }
                v0 = null;
            }
            FirAnnotation firAnnotation = v0;
            if (firAnnotation != null && (set2 = AnnotationTargetUtilsKt.findUseSiteTargets(firAnnotation, session)) != null) {
                set = set2;
                return set;
            }
        }
        set = DEFAULT_USE_SITE_TARGETS;
        return set;
    }

    private static final Set<AnnotationUseSiteTarget> findUseSiteTargets(FirAnnotation $this$findUseSiteTargets, FirSession session) {
        Set set;
        Set $this$findUseSiteTargets_u24lambda_u243 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        AnnotationTargetUtilsKt.forEachAnnotationTarget($this$findUseSiteTargets, session, (Function1<? super Name, Unit>)((Function1)arg_0 -> AnnotationTargetUtilsKt.findUseSiteTargets$lambda$3$lambda$2($this$findUseSiteTargets_u24lambda_u243, arg_0)));
        return SetsKt.build((Set)set);
    }

    public static final void forEachAnnotationTarget(@NotNull FirAnnotation $this$forEachAnnotationTarget, @NotNull FirSession session, @NotNull Function1<? super Name, Unit> action) {
        block4: {
            List<FirExpression> list;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$forEachAnnotationTarget, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter(action, (String)"action");
                if (!($this$forEachAnnotationTarget instanceof FirAnnotationCall)) break block3;
                for (FirExpression arg : ((FirAnnotationCall)$this$forEachAnnotationTarget).getArgumentList().getArguments()) {
                    Iterable $this$forEach$iv = FirExpressionUtilKt.unwrapAndFlattenArgument(arg, true);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirExpression p0 = (FirExpression)element$iv;
                        boolean bl = false;
                        AnnotationTargetUtilsKt.forEachAnnotationTarget$take(session, action, p0);
                    }
                }
                break block4;
            }
            FirExpression firExpression = $this$forEachAnnotationTarget.getArgumentMapping().getMapping().get(StandardClassIds.Annotations.ParameterNames.INSTANCE.getTargetAllowedTargets());
            if (firExpression == null || (list = FirExpressionUtilKt.unwrapAndFlattenArgument(firExpression, true)) == null) break block4;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression p0 = (FirExpression)element$iv;
                boolean bl = false;
                AnnotationTargetUtilsKt.forEachAnnotationTarget$take(session, action, p0);
            }
        }
    }

    private static final Unit findUseSiteTargets$lambda$3$lambda$2(Set $this_buildSet, Name it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Set<AnnotationUseSiteTarget> set = USE_SITE_TARGET_NAME_MAP.get(it.getIdentifier());
            if (set == null) break block0;
            Set<AnnotationUseSiteTarget> it2 = set;
            boolean bl = false;
            $this_buildSet.addAll((Collection)it2);
        }
        return Unit.INSTANCE;
    }

    private static final void forEachAnnotationTarget$take(FirSession $session, Function1<? super Name, Unit> $action, FirExpression arg) {
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(arg, $session);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> callableSymbol = firCallableSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(callableSymbol);
        if (Intrinsics.areEqual((Object)(coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null), (Object)StandardClassIds.INSTANCE.getAnnotationTarget())) {
            $action.invoke((Object)callableSymbol.getCallableId().getCallableName());
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$fold$iv;
        Object object = new Pair[6];
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD};
        object[0] = TuplesKt.to((Object)"FIELD", (Object)SetsKt.setOf((Object[])annotationUseSiteTargetArray));
        object[1] = TuplesKt.to((Object)"FILE", (Object)SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.FILE)));
        object[2] = TuplesKt.to((Object)"PROPERTY", (Object)SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY)));
        object[3] = TuplesKt.to((Object)"PROPERTY_GETTER", (Object)SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER)));
        object[4] = TuplesKt.to((Object)"PROPERTY_SETTER", (Object)SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER)));
        annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER, AnnotationUseSiteTarget.RECEIVER, AnnotationUseSiteTarget.SETTER_PARAMETER};
        object[5] = TuplesKt.to((Object)"VALUE_PARAMETER", (Object)SetsKt.setOf((Object[])annotationUseSiteTargetArray));
        USE_SITE_TARGET_NAME_MAP = MapsKt.mapOf((Pair[])object);
        object = USE_SITE_TARGET_NAME_MAP.values();
        Set initial$iv = SetsKt.emptySet();
        boolean $i$f$fold = false;
        Set accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void b2;
            Set set = (Set)element$iv;
            Set a2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = SetsKt.plus((Set)a2, (Iterable)((Iterable)b2));
        }
        DEFAULT_USE_SITE_TARGETS = SetsKt.minus((Set)var3_3, (Iterable)SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.FILE)));
    }
}

