/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0018\u001a\u00020\u0015*\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "checkPsiOrLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkVisibilityModifier", "state", "Lorg/jetbrains/kotlin/config/ExplicitApiMode;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "explicitVisibilityIsNotRequired", "", "checkExplicitReturnType", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "returnTypeCheckIsApplicable", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExplicitApiDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n28#2:155\n28#2:156\n78#2:157\n37#2:158\n1#3:159\n*S KotlinDebug\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n*L\n57#1:155\n59#1:156\n112#1:157\n118#1:158\n*E\n"})
public final class FirExplicitApiDeclarationChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final FirExplicitApiDeclarationChecker INSTANCE = new FirExplicitApiDeclarationChecker();

    private FirExplicitApiDeclarationChecker() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element, @NotNull KtSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        sourceKindIsReal = source.getKind() instanceof KtRealSourceElementKind;
        if (!sourceKindIsReal && !Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) || Intrinsics.areEqual((Object)element.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE) || !(element instanceof FirMemberDeclaration)) {
            return;
        }
        explicitApiState = FirExplicitApiDeclarationChecker.checkPsiOrLightTree$extractState(context, AnalysisFlags.getExplicitApiMode());
        explicitReturnTypesState = FirExplicitApiDeclarationChecker.checkPsiOrLightTree$extractState(context, AnalysisFlags.getExplicitReturnTypes());
        if (explicitApiState == null && explicitReturnTypesState == null) {
            return;
        }
        if (element instanceof FirEnumEntry) {
            return;
        }
        $this$effectiveVisibility$iv = (FirMemberDeclaration)element;
        $i$f$getEffectiveVisibility = false;
        var10_10 = $this$effectiveVisibility$iv.getStatus();
        v0 = var10_10 instanceof FirResolvedDeclarationStatus != false ? (FirResolvedDeclarationStatus)var10_10 : null;
        if (v0 == null || (v0 = v0.getEffectiveVisibility()) == null) {
            v0 = EffectiveVisibility.Local.INSTANCE;
        }
        if (!v0.getPublicApi() && PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility(element) == null) {
            return;
        }
        lastContainingDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context.getContainingDeclarations());
        v1 = lastContainingDeclaration instanceof FirMemberDeclaration != false ? (FirMemberDeclaration)lastContainingDeclaration : null;
        if (v1 == null) ** GOTO lbl-1000
        $this$effectiveVisibility$iv = v1;
        $i$f$getEffectiveVisibility = false;
        var13_13 = $this$effectiveVisibility$iv.getStatus();
        v2 = var13_13 instanceof FirResolvedDeclarationStatus != false ? (FirResolvedDeclarationStatus)var13_13 : null;
        if (v2 == null || (v2 = v2.getEffectiveVisibility()) == null) {
            v2 = v1 = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (v2 != null) {
            v3 = !v1.getPublicApi();
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        if (v3) {
            return;
        }
        if (explicitApiState != null) {
            this.checkVisibilityModifier(explicitApiState, (FirMemberDeclaration)element, source, context, reporter);
        }
        if (sourceKindIsReal && element instanceof FirCallableDeclaration) {
            v4 = explicitApiState;
            if (v4 == null) {
                v5 = explicitReturnTypesState;
                v4 = v5;
                Intrinsics.checkNotNull((Object)v5);
            }
            this.checkExplicitReturnType(v4, (FirCallableDeclaration)element, source, context, reporter);
        }
    }

    private final void checkVisibilityModifier(ExplicitApiMode state, FirMemberDeclaration declaration, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement visibilityModifier;
        KtSourceElement ktSourceElement;
        IElementType iElementType = KtNodeTypes.MODIFIER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MODIFIER_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 != null) {
            TokenSet tokenSet = KtTokens.VISIBILITY_MODIFIERS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VISIBILITY_MODIFIERS");
            ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement2, tokenSet, 0, 0, false, 14, null);
        } else {
            ktSourceElement = visibilityModifier = null;
        }
        if (visibilityModifier != null) {
            return;
        }
        if (this.explicitVisibilityIsNotRequired(declaration, context2)) {
            return;
        }
        KtDiagnosticFactory0 factory = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory, (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean explicitVisibilityIsNotRequired(FirMemberDeclaration declaration, CheckerContext context2) {
        boolean bl;
        FirMemberDeclaration firMemberDeclaration = declaration;
        if (firMemberDeclaration instanceof FirPrimaryConstructor || firMemberDeclaration instanceof FirPropertyAccessor || firMemberDeclaration instanceof FirValueParameter || firMemberDeclaration instanceof FirAnonymousFunction) {
            bl = true;
        } else if (firMemberDeclaration instanceof FirCallableDeclaration) {
            FirRegularClass containingClass;
            Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirRegularClass firRegularClass = containingClass = object instanceof FirRegularClass ? (FirRegularClass)object : null;
            if (declaration instanceof FirProperty && containingClass != null) {
                FirRegularClass $this$isData$iv = containingClass;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
                    return true;
                }
            }
            FirMemberDeclaration $this$isOverride$iv = declaration;
            boolean $i$f$isOverride = false;
            bl = $this$isOverride$iv.getStatus().isOverride() || DeclarationUtilsKt.isLocalMember(declaration);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkExplicitReturnType(ExplicitApiMode state, FirCallableDeclaration declaration, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (!this.returnTypeCheckIsApplicable(declaration)) {
            return;
        }
        KtDiagnosticFactory0 factory = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory, (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean returnTypeCheckIsApplicable(FirCallableDeclaration $this$returnTypeCheckIsApplicable) {
        KtSourceElement ktSourceElement = $this$returnTypeCheckIsApplicable.getReturnTypeRef().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return false;
        }
        return $this$returnTypeCheckIsApplicable instanceof FirProperty || $this$returnTypeCheckIsApplicable instanceof FirFunction && !($this$returnTypeCheckIsApplicable instanceof FirPropertyAccessor) && ((FirFunction)$this$returnTypeCheckIsApplicable).getBody() instanceof FirSingleExpressionBlock;
    }

    private static final ExplicitApiMode checkPsiOrLightTree$extractState(CheckerContext $context, AnalysisFlag<? extends ExplicitApiMode> flag) {
        ExplicitApiMode explicitApiMode;
        ExplicitApiMode it = explicitApiMode = $context.getLanguageVersionSettings().getFlag(flag);
        boolean bl = false;
        return !(it == ExplicitApiMode.DISABLED) ? explicitApiMode : null;
    }
}

