/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.AbiSnapshotDiffService;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.BuildDiffsStorage;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.util.Either;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001at\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0000\u00a8\u0006\u0019"}, d2={"getClasspathChanges", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "classpath", "", "Ljava/io/File;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;", "lastBuildInfo", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "abiSnapshots", "", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "withSnapshot", "", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "scopes", "", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nchangesDetectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 changesDetectionUtils.kt\norg/jetbrains/kotlin/incremental/ChangesDetectionUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,121:1\n547#2,2:122\n865#3,2:124\n865#3,2:126\n3193#3,10:143\n31#4,5:128\n31#4,5:133\n31#4,5:138\n*S KotlinDebug\n*F\n+ 1 changesDetectionUtils.kt\norg/jetbrains/kotlin/incremental/ChangesDetectionUtilsKt\n*L\n31#1:122,2\n35#1:124,2\n36#1:126,2\n95#1:143,10\n65#1:128,5\n75#1:133,5\n117#1:138,5\n*E\n"})
public final class ChangesDetectionUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ChangesEither getClasspathChanges(@NotNull List<? extends File> classpath, @NotNull ChangedFiles.DeterminableFiles.Known changedFiles, @NotNull BuildInfo lastBuildInfo, @NotNull ModulesApiHistory modulesApiHistory, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter, @NotNull Map<String, ? extends AbiSnapshot> abiSnapshots, boolean withSnapshot, @NotNull IncrementalCacheCommon caches, @NotNull Collection<String> scopes) {
        ChangesEither changesEither;
        void $this$measure$iv;
        Either<Set<File>> either;
        void $this$measure$iv2;
        Object element$iv;
        BuildMetricsReporter $this$filterTo$iv;
        boolean bl;
        File it;
        Object element$iv22;
        boolean $i$f$filterTo;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        Intrinsics.checkNotNullParameter((Object)lastBuildInfo, (String)"lastBuildInfo");
        Intrinsics.checkNotNullParameter((Object)modulesApiHistory, (String)"modulesApiHistory");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(abiSnapshots, (String)"abiSnapshots");
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        HashSet<File> classpathSet = new HashSet<File>();
        for (File file2 : classpath) {
            if (file2.isFile()) {
                classpathSet.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            Sequence $this$filterTo$iv2 = (Sequence)FilesKt.walk$default((File)file2, null, (int)1, null);
            $i$f$filterTo = false;
            for (Object element$iv22 : $this$filterTo$iv2) {
                it = (File)element$iv22;
                bl = false;
                if (!it.isFile()) continue;
                ((Collection)classpathSet).add(element$iv22);
            }
        }
        Iterable iterable = changedFiles.getModified();
        Iterable destination$iv = new HashSet();
        $i$f$filterTo = false;
        for (Object element$iv22 : iterable) {
            it = (File)element$iv22;
            bl = false;
            if (!classpathSet.contains(it)) continue;
            destination$iv.add(element$iv22);
        }
        HashSet modifiedClasspath = (HashSet)destination$iv;
        destination$iv = changedFiles.getRemoved();
        Collection destination$iv2 = new HashSet();
        boolean $i$f$filterTo2 = false;
        element$iv22 = $this$filterTo$iv.iterator();
        while (element$iv22.hasNext()) {
            element$iv = element$iv22.next();
            File it2 = (File)element$iv;
            boolean bl2 = false;
            if (!classpathSet.contains(it2)) continue;
            destination$iv2.add(element$iv);
        }
        HashSet hashSet = (HashSet)destination$iv2;
        if (!((Collection)hashSet).isEmpty()) {
            ICReporterKt.info(reporter, (Function0<String>)((Function0)() -> ChangesDetectionUtilsKt.getClasspathChanges$lambda$3(hashSet)));
            return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_REMOVED_ENTRY);
        }
        if (modifiedClasspath.isEmpty()) {
            return new ChangesEither.Known(null, null, 3, null);
        }
        if (withSnapshot) {
            void $this$measure$iv3;
            $this$filterTo$iv = reporter;
            BuildTime time$iv = GradleBuildTime.IC_ANALYZE_JAR_FILES;
            boolean $i$f$measure = false;
            $this$measure$iv3.startMeasure(time$iv);
            try {
                boolean bl3 = false;
                element$iv = ChangesDetectionUtilsKt.getClasspathChanges$analyzeJarFiles(abiSnapshots, lastBuildInfo, reporter, caches, scopes);
            }
            finally {
                $this$measure$iv3.endMeasure(time$iv);
            }
            return element$iv;
        }
        long lastBuildTS = lastBuildInfo.getStartTS();
        HashSet<LookupSymbol> symbols = new HashSet<LookupSymbol>();
        HashSet<FqName> fqNames = new HashSet<FqName>();
        BuildMetricsReporter it2 = reporter;
        Object time$iv = GradleBuildTime.IC_FIND_HISTORY_FILES;
        boolean $i$f$measure = false;
        $this$measure$iv2.startMeasure(time$iv);
        try {
            boolean bl4 = false;
            either = modulesApiHistory.historyFilesForChangedFiles(modifiedClasspath);
        }
        finally {
            $this$measure$iv2.endMeasure(time$iv);
        }
        Either<Set<File>> historyFilesEither = either;
        time$iv = historyFilesEither;
        if (!(time$iv instanceof Either.Success)) {
            if (time$iv instanceof Either.Error) {
                ICReporterKt.info(reporter, (Function0<String>)((Function0)() -> ChangesDetectionUtilsKt.getClasspathChanges$lambda$7(historyFilesEither)));
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_IS_NOT_FOUND);
            }
            throw new NoWhenBranchMatchedException();
        }
        Set historyFiles = (Set)((Either.Success)historyFilesEither).getValue();
        time$iv = reporter;
        BuildTime time$iv2 = GradleBuildTime.IC_ANALYZE_HISTORY_FILES;
        boolean $i$f$measure2 = false;
        $this$measure$iv.startMeasure(time$iv2);
        try {
            boolean bl5 = false;
            changesEither = ChangesDetectionUtilsKt.getClasspathChanges$analyzeHistoryFiles(historyFiles, reporter, symbols, fqNames, lastBuildTS);
        }
        finally {
            $this$measure$iv.endMeasure(time$iv2);
        }
        return changesEither;
    }

    private static final String getClasspathChanges$lambda$3(HashSet $removedClasspath) {
        return "Some files are removed from classpath: " + $removedClasspath;
    }

    private static final String getClasspathChanges$analyzeJarFiles$lambda$4(String $module) {
        return "Some jar are removed from classpath " + $module;
    }

    private static final ChangesEither getClasspathChanges$analyzeJarFiles(Map<String, ? extends AbiSnapshot> $abiSnapshots, BuildInfo $lastBuildInfo, BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> $reporter, IncrementalCacheCommon $caches, Collection<String> $scopes) {
        HashSet<LookupSymbol> symbols = new HashSet<LookupSymbol>();
        HashSet<FqName> fqNames = new HashSet<FqName>();
        for (Map.Entry<String, ? extends AbiSnapshot> entry : $abiSnapshots.entrySet()) {
            String module2 = entry.getKey();
            AbiSnapshot abiSnapshot2 = entry.getValue();
            AbiSnapshot actualAbiSnapshot = $lastBuildInfo.getDependencyToAbiSnapshot().get(module2);
            if (actualAbiSnapshot == null) {
                ICReporterKt.info($reporter, (Function0<String>)((Function0)() -> ChangesDetectionUtilsKt.getClasspathChanges$analyzeJarFiles$lambda$4(module2)));
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_REMOVED_ENTRY);
            }
            DirtyData diffData = AbiSnapshotDiffService.Companion.doCompute(abiSnapshot2, actualAbiSnapshot, $caches, $scopes);
            symbols.addAll(diffData.getDirtyLookupSymbols());
            fqNames.addAll(diffData.getDirtyClassesFqNames());
        }
        return new ChangesEither.Known((Collection<LookupSymbol>)symbols, (Collection<FqName>)fqNames);
    }

    private static final String getClasspathChanges$lambda$7(Either $historyFilesEither) {
        return "Could not find history files: " + ((Either.Error)$historyFilesEither).getReason();
    }

    private static final String getClasspathChanges$analyzeHistoryFiles$lambda$9$lambda$8(File $historyFile) {
        return "Could not read diffs from " + $historyFile;
    }

    private static final String getClasspathChanges$analyzeHistoryFiles$lambda$11(File $historyFile) {
        return "No previously known builds for " + $historyFile;
    }

    private static final String getClasspathChanges$analyzeHistoryFiles$lambda$12(File $historyFile) {
        return "Non-incremental build from dependency " + $historyFile;
    }

    private static final ChangesEither getClasspathChanges$analyzeHistoryFiles(Set<? extends File> historyFiles, BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> $reporter, HashSet<LookupSymbol> symbols, HashSet<FqName> fqNames, long lastBuildTS) {
        for (File file2 : historyFiles) {
            List<BuildDifference> allBuilds;
            if (BuildDiffsStorage.Companion.readDiffsFromFile(file2, $reporter) == null) {
                boolean bl = false;
                ICReporterKt.info($reporter, (Function0<String>)((Function0)() -> ChangesDetectionUtilsKt.getClasspathChanges$analyzeHistoryFiles$lambda$9$lambda$8(file2)));
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_CANNOT_BE_READ);
            }
            Iterable $this$partition$iv = allBuilds;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                BuildDifference it = (BuildDifference)element$iv;
                boolean bl = false;
                boolean bl2 = it.getTs() <= lastBuildTS ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List knownBuilds = (List)pair.component1();
            List newBuilds = (List)pair.component2();
            if (knownBuilds.isEmpty()) {
                ICReporterKt.info($reporter, (Function0<String>)((Function0)() -> ChangesDetectionUtilsKt.getClasspathChanges$analyzeHistoryFiles$lambda$11(file2)));
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_NO_KNOWN_BUILDS);
            }
            for (BuildDifference buildDiff : newBuilds) {
                if (!buildDiff.isIncremental()) {
                    ICReporterKt.info($reporter, (Function0<String>)((Function0)() -> ChangesDetectionUtilsKt.getClasspathChanges$analyzeHistoryFiles$lambda$12(file2)));
                    return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_NON_INCREMENTAL_BUILD_IN_DEP);
                }
                DirtyData dirtyData = buildDiff.getDirtyData();
                symbols.addAll(dirtyData.getDirtyLookupSymbols());
                fqNames.addAll(dirtyData.getDirtyClassesFqNames());
            }
        }
        return new ChangesEither.Known((Collection<LookupSymbol>)symbols, (Collection<FqName>)fqNames);
    }
}

