/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirContextReceiversDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isDelegationOperator", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getContextParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextReceiversDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextReceiversDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,161:1\n1557#2:162\n1628#2,3:163\n1863#2,2:166\n38#3:168\n*S KotlinDebug\n*F\n+ 1 FirContextReceiversDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker\n*L\n55#1:162\n55#1:163,3\n95#1:166,2\n115#1:168\n*E\n"})
public final class FirContextReceiversDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextReceiversDeclarationChecker INSTANCE = new FirContextReceiversDeclarationChecker();

    private FirContextReceiversDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        List<FirValueParameter> contextParameters;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        KtSourceElement ktSourceElement2 = declaration.getSource();
        if (ktSourceElement2 == null || (ktSourceElement2 = SourceHelpersKt.findContextReceiverListSource(ktSourceElement2)) == null) {
            return;
        }
        KtSourceElement source = ktSourceElement2;
        if (declaration instanceof FirTypeAlias) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on type aliases are unsupported.", (DiagnosticContext)context, null, 16, null);
        }
        if ((contextParameters = this.getContextParameters(declaration)).isEmpty()) {
            return;
        }
        boolean contextReceiversEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers);
        boolean contextParametersEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters);
        if (!contextReceiversEnabled && !contextParametersEnabled) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextParameters), (Object)context.getLanguageVersionSettings()), (DiagnosticContext)context, null, 16, null);
            return;
        }
        if (contextReceiversEnabled) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = contextParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()));
            }
            if (FirContextReceiversDeclarationCheckerKt.checkSubTypes((List)destination$iv$iv, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), (DiagnosticContext)context, null, 8, null);
            }
        }
        if (contextParametersEnabled) {
            FirDeclaration firDeclaration = declaration;
            if (firDeclaration instanceof FirClass) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on classes are unsupported.", (DiagnosticContext)context, null, 16, null);
            } else if (firDeclaration instanceof FirConstructor) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on constructors are unsupported.", (DiagnosticContext)context, null, 16, null);
            } else if (firDeclaration instanceof FirCallableDeclaration && this.isDelegationOperator((FirCallableDeclaration)declaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on delegation operators are unsupported.", (DiagnosticContext)context, null, 16, null);
            } else if (firDeclaration instanceof FirProperty && ((FirProperty)declaration).getDelegate() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Context parameters on delegated properties are unsupported.", (DiagnosticContext)context, null, 16, null);
            } else {
                for (FirValueParameter parameter : contextParameters) {
                    List<FirModifier<?>> list;
                    if (FirValueParameterKindKt.isLegacyContextReceiver(parameter)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter.getSource(), FirErrors.INSTANCE.getCONTEXT_PARAMETER_WITHOUT_NAME(), (DiagnosticContext)context, null, 8, null);
                    }
                    if ((list = parameter.getSource()) == null || (list = FirKeywordUtilsKt.getModifierList((KtSourceElement)((Object)list))) == null || (list = ((FirModifierList)((Object)list)).getModifiers()) == null) continue;
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirModifier modifier = (FirModifier)element$iv;
                        boolean bl = false;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifier.getToken(), (Object)"context parameter", (DiagnosticContext)context, null, 32, null);
                    }
                }
            }
        } else {
            for (FirValueParameter parameter : contextParameters) {
                if (FirValueParameterKindKt.isLegacyContextReceiver(parameter)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextParameters), (Object)context.getLanguageVersionSettings()), (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final boolean isDelegationOperator(FirCallableDeclaration $this$isDelegationOperator) {
        FirMemberDeclaration $this$isOperator$iv = $this$isDelegationOperator;
        boolean $i$f$isOperator = false;
        return $this$isOperator$iv.getStatus().isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(FirDeclarationUtilKt.getNameOrSpecialName($this$isDelegationOperator));
    }

    private final List<FirValueParameter> getContextParameters(FirDeclaration $this$getContextParameters) {
        FirDeclaration firDeclaration = $this$getContextParameters;
        return firDeclaration instanceof FirCallableDeclaration ? ((FirCallableDeclaration)$this$getContextParameters).getContextParameters() : (firDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$getContextParameters).getContextParameters() : CollectionsKt.emptyList());
    }
}

