/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.tree.IElementType;
import java.lang.constant.Constable;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapperBase;
import org.jetbrains.kotlin.codegen.state.StaticTypeMapperForOldBackend;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
        v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
        return null;
    }));
    @NotNull
    public final Type type;
    @Nullable
    public final KotlinType kotlinType;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(0);
        }
        this(type2, null, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(1);
        }
        this(type2, null, canHaveSideEffects);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(2);
        }
        this(type2, kotlinType, true);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(3);
        }
        this.type = type2;
        this.kotlinType = kotlinType;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void put(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(4);
        }
        this.put(this.type, null, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(5);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(6);
        }
        this.put(type2, null, v, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(7);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(8);
        }
        this.put(type2, kotlinType, v, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(9);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(10);
        }
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, kotlinType, v);
    }

    public abstract void putSelector(@NotNull Type var1, @Nullable KotlinType var2, @NotNull InstructionAdapter var3);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(11);
        }
    }

    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(12);
        }
        if (!Type.VOID_TYPE.equals(this.type)) {
            AsmUtil.dup(v, this.type);
        }
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(13);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(14);
        }
        this.store(value2, v, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(15);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(16);
        }
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value2.put(value2.type, value2.kotlinType, v);
        this.storeSelector(value2.type, value2.kotlinType, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(17);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(19);
        }
        return new Local(index, type2);
    }

    public static Local local(int index, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(20);
        }
        return new Local(index, type2, kotlinType);
    }

    @NotNull
    public static StackValue local(int index, @NotNull Type type2, @NotNull VariableDescriptor descriptor) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(21);
        }
        if (descriptor == null) {
            StackValue.$$$reportNull$$$0(22);
        }
        return StackValue.local(index, type2, descriptor, null);
    }

    @NotNull
    public static StackValue local(int index, @NotNull Type type2, @NotNull VariableDescriptor descriptor, @Nullable KotlinType delegateKotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(23);
        }
        if (descriptor == null) {
            StackValue.$$$reportNull$$$0(24);
        }
        if (descriptor.isLateInit()) {
            assert (delegateKotlinType == null) : "Delegated property can't be lateinit: " + descriptor + ", delegate type: " + delegateKotlinType;
            return new LateinitLocal(index, type2, descriptor.getType(), descriptor.getName());
        }
        return new Local(index, type2, delegateKotlinType != null ? delegateKotlinType : descriptor.getType());
    }

    @NotNull
    public static StackValue shared(int index, @NotNull Type type2, @NotNull VariableDescriptor descriptor) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(25);
        }
        if (descriptor == null) {
            StackValue.$$$reportNull$$$0(26);
        }
        return StackValue.shared(index, type2, descriptor, null);
    }

    @NotNull
    public static StackValue shared(int index, @NotNull Type type2, @NotNull VariableDescriptor descriptor, @Nullable KotlinType delegateKotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(27);
        }
        if (descriptor == null) {
            StackValue.$$$reportNull$$$0(28);
        }
        return new Shared(index, type2, delegateKotlinType != null ? delegateKotlinType : descriptor.getType(), descriptor.isLateInit(), descriptor.getName());
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(29);
        }
        return StackValue.onStack(type2, null);
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(30);
        }
        return type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2, kotlinType);
    }

    @NotNull
    public static StackValue constant(int value2) {
        return StackValue.constant(value2, Type.INT_TYPE);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(31);
        }
        return StackValue.constant(value2, type2, null);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(32);
        }
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value2 instanceof Boolean) : "Value for boolean constant should have boolean type: " + value2;
            BranchedValue branchedValue = BranchedValue.Companion.booleanConstant((Boolean)value2);
            if (branchedValue == null) {
                StackValue.$$$reportNull$$$0(33);
            }
            return branchedValue;
        }
        return new Constant(value2, type2, kotlinType);
    }

    public static StackValue createDefaultValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(34);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return StackValue.constant(null, type2);
        }
        return StackValue.createDefaultPrimitiveValue(type2);
    }

    private static StackValue createDefaultPrimitiveValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(35);
        }
        assert (1 <= type2.getSort() && type2.getSort() <= 8) : "'createDefaultPrimitiveValue' method should be called only for primitive types, but " + type2;
        Constable value2 = 0;
        if (type2.getSort() == 1) {
            value2 = Boolean.FALSE;
        } else if (type2.getSort() == 6) {
            value2 = new Float(0.0);
        } else if (type2.getSort() == 8) {
            value2 = new Double(0.0);
        } else if (type2.getSort() == 7) {
            value2 = new Long(0L);
        }
        return StackValue.constant(value2, type2);
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        if (opToken == null) {
            StackValue.$$$reportNull$$$0(36);
        }
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(37);
        }
        BranchedValue branchedValue = BranchedValue.Companion.cmp(opToken, type2, left, right);
        if (branchedValue == null) {
            StackValue.$$$reportNull$$$0(38);
        }
        return branchedValue;
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name2, boolean isStatic, @NotNull StackValue receiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(39);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(40);
        }
        if (name2 == null) {
            StackValue.$$$reportNull$$$0(41);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(42);
        }
        return new Field(type2, null, owner, name2, isStatic, receiver, null);
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v);
    }

    private static void unbox(Type methodOwner, Type type2, InstructionAdapter v) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v.invokevirtual(methodOwner.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    public static void boxInlineClass(@NotNull KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(43);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(44);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(45);
        }
        Type boxed = typeMapper2.mapTypeCommon(kotlinType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(kotlinType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.boxInlineClass(unboxed, boxed, isNullable, v);
    }

    public static void boxInlineClass(@NotNull Type unboxed, @NotNull Type boxed, boolean isNullable, @NotNull InstructionAdapter v) {
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(46);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(47);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(48);
        }
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeBoxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeBoxMethod(v, boxed, unboxed);
        }
    }

    private static void invokeBoxMethod(@NotNull InstructionAdapter v, @NotNull Type boxedType, @NotNull Type underlyingType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(49);
        }
        if (boxedType == null) {
            StackValue.$$$reportNull$$$0(50);
        }
        if (underlyingType == null) {
            StackValue.$$$reportNull$$$0(51);
        }
        v.invokestatic(boxedType.getInternalName(), KotlinTypeMapper.BOX_JVM_METHOD_NAME, Type.getMethodDescriptor(boxedType, underlyingType), false);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull KotlinTypeMarker targetInlineClassType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(52);
        }
        if (targetInlineClassType == null) {
            StackValue.$$$reportNull$$$0(53);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(54);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(55);
        }
        Type boxed = typeMapper2.mapTypeCommon(targetInlineClassType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(targetInlineClassType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(targetInlineClassType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.unboxInlineClass(type2, boxed, unboxed, isNullable, v);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull Type boxed, @NotNull Type unboxed, boolean isNullable, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(56);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(57);
        }
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(58);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(59);
        }
        StackValue.coerce(type2, boxed, v);
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeUnboxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeUnboxMethod(v, boxed, unboxed);
        }
    }

    private static void invokeUnboxMethod(@NotNull InstructionAdapter v, @NotNull Type owner, @NotNull Type resultType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(60);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(61);
        }
        if (resultType == null) {
            StackValue.$$$reportNull$$$0(62);
        }
        v.invokevirtual(owner.getInternalName(), KotlinTypeMapper.UNBOX_JVM_METHOD_NAME, "()" + resultType.getDescriptor(), false);
    }

    private static void boxOrUnboxWithNullCheck(@NotNull InstructionAdapter v, @NotNull Consumer<InstructionAdapter> body2) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(63);
        }
        if (body2 == null) {
            StackValue.$$$reportNull$$$0(64);
        }
        Label lNull = new Label();
        Label lDone = new Label();
        v.dup();
        v.ifnull(lNull);
        body2.accept(v);
        v.goTo(lDone);
        v.mark(lNull);
        v.pop();
        v.aconst(null);
        v.mark(lDone);
    }

    protected void coerceTo(@NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (toType == null) {
            StackValue.$$$reportNull$$$0(65);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(66);
        }
        StackValue.coerce(this.type, this.kotlinType, toType, toKotlinType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(67);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(68);
        }
        StackValue.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v);
    }

    public static void coerce(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(69);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(70);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(71);
        }
        if (StackValue.coerceInlineClasses(fromType, fromKotlinType, toType, toKotlinType, v, StaticTypeMapperForOldBackend.INSTANCE)) {
            return;
        }
        StackValue.coerce(fromType, toType, v);
    }

    public static boolean requiresInlineClassBoxingOrUnboxing(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType) {
        boolean isToTypeUnboxed;
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(72);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(73);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        boolean isFromTypeUnboxed = isFromTypeInlineClass && StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
        boolean bl = isToTypeUnboxed = isToTypeInlineClass && StackValue.isUnboxedInlineClass(toKotlinType, toType);
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            return isFromTypeUnboxed != isToTypeUnboxed;
        }
        return isFromTypeInlineClass && isFromTypeUnboxed || isToTypeInlineClass && isToTypeUnboxed;
    }

    private static boolean coerceInlineClasses(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(74);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(75);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(76);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(77);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        if (fromKotlinType.equals(toKotlinType) && fromType.equals(toType)) {
            return true;
        }
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            boolean isFromTypeUnboxed = StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
            boolean isToTypeUnboxed = StackValue.isUnboxedInlineClass(toKotlinType, toType);
            if (isFromTypeUnboxed && !isToTypeUnboxed) {
                StackValue.boxInlineClass(fromKotlinType, v, typeMapper2);
                return true;
            }
            if (!isFromTypeUnboxed && isToTypeUnboxed) {
                StackValue.unboxInlineClass(fromType, toKotlinType, v, typeMapper2);
                return true;
            }
        } else if (isFromTypeInlineClass) {
            if (StackValue.isUnboxedInlineClass(fromKotlinType, fromType)) {
                StackValue.boxInlineClass(fromKotlinType, v, typeMapper2);
                return true;
            }
        } else if (StackValue.isUnboxedInlineClass(toKotlinType, toType)) {
            StackValue.unboxInlineClass(fromType, toKotlinType, v, typeMapper2);
            return true;
        }
        return false;
    }

    public static boolean isUnboxedInlineClass(@NotNull KotlinType kotlinType, @NotNull Type actualType) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(78);
        }
        if (actualType == null) {
            StackValue.$$$reportNull$$$0(79);
        }
        return KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, StaticTypeMapperForOldBackend.INSTANCE).equals(actualType);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(80);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(81);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(82);
        }
        StackValue.coerce(fromType, toType, v, false);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v, boolean forceSelfCast) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(83);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(84);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(85);
        }
        if (toType.equals(fromType) && !forceSelfCast) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else {
                AsmUtil.pushDefaultValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() != 9) {
                v.checkcast(toType);
            } else if (toType.getDimensions() != fromType.getDimensions()) {
                v.checkcast(toType);
            } else if (!toType.getElementType().equals(AsmTypes.OBJECT_TYPE)) {
                v.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10 || fromType.getSort() == 9) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v);
                    v.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(86);
        }
        StackValue.unit().put(AsmTypes.UNIT_TYPE, null, v);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static StackValue operation(Type type2, final Function1<InstructionAdapter, Unit> lambda) {
        return new StackValue(type2, null){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    1.$$$reportNull$$$0(1);
                }
                lambda.invoke((Object)v);
                this.coerceTo(type2, null, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void genNonNullAssertForLateinit(@NotNull InstructionAdapter v, @NotNull String name2) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(87);
        }
        if (name2 == null) {
            StackValue.$$$reportNull$$$0(88);
        }
        v.dup();
        Label ok = new Label();
        v.ifnonnull(ok);
        v.visitLdcInsn(name2);
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwUninitializedPropertyAccessException", "(Ljava/lang/String;)V", false);
        v.mark(ok);
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(89);
        }
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                Type type3 = AsmTypes.OBJECT_REF_TYPE;
                if (type3 == null) {
                    StackValue.$$$reportNull$$$0(90);
                }
                return type3;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        Type type4 = AsmTypes.sharedTypeForPrimitive(primitiveType);
        if (type4 == null) {
            StackValue.$$$reportNull$$$0(91);
        }
        return type4;
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 38: 
            case 90: 
            case 91: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 38: 
            case 90: 
            case 91: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 44: 
            case 48: 
            case 49: 
            case 54: 
            case 59: 
            case 60: 
            case 63: 
            case 66: 
            case 68: 
            case 71: 
            case 76: 
            case 82: 
            case 85: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStackType";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 33: 
            case 38: 
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 40: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 41: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 43: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 45: 
            case 55: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 46: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxed";
                break;
            }
            case 47: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxed";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInlineClassType";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 65: 
            case 70: 
            case 73: 
            case 75: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 69: 
            case 72: 
            case 74: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "constant";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "cmp";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "sharedTypeForType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putReceiver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "storeSelector";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "local";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shared";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "onStack";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
            case 33: 
            case 38: 
            case 90: 
            case 91: {
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultPrimitiveValue";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "cmp";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "field";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "boxInlineClass";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "invokeBoxMethod";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "unboxInlineClass";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "invokeUnboxMethod";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "boxOrUnboxWithNullCheck";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "coerceTo";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "coerceFrom";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "coerce";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "requiresInlineClassBoxingOrUnboxing";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "coerceInlineClasses";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isUnboxedInlineClass";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstance";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "genNonNullAssertForLateinit";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "sharedTypeForType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 33: 
            case 38: 
            case 90: 
            case 91: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            if (type2 == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(0);
            }
            if (receiver == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(1);
            }
            super(type2, kotlinType, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            boolean hasReceiver;
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(2);
            }
            if ((hasReceiver = this.isNonStaticAccess(isRead)) || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, hasReceiver ? this.receiver.kotlinType : null, v);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(3);
            }
            if (!withWriteReceiver) {
                super.dup(v, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v.dup2X1();
                            break;
                        }
                        v.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v.dup2X2();
                            break;
                        }
                        v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(4);
            }
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(5);
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, rightSide.kotlinType, v);
            this.storeSelector(rightSide.type, rightSide.kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putReceiver";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;
        private final boolean isLateinit;
        private final Name name;

        public Shared(int index, Type type2, KotlinType kotlinType, boolean isLateinit, Name name2) {
            super(type2, kotlinType, false, false, Shared.local(index, AsmTypes.OBJECT_TYPE), false);
            this.index = index;
            if (isLateinit && name2 == null) {
                throw new IllegalArgumentException("Lateinit shared local variable should have name: #" + index + " " + type2.getDescriptor());
            }
            this.isLateinit = isLateinit;
            this.name = name2;
        }

        public Shared(int index, Type type2) {
            this(index, type2, null, false, null);
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Shared.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Shared.$$$reportNull$$$0(1);
            }
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v, this.name.asString());
            }
            this.coerceFrom(refType, null, v);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Shared.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Shared.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Shared";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;
        public final DeclarationDescriptor descriptor;

        public Field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name2, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                Field.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                Field.$$$reportNull$$$0(3);
            }
            super(type2, kotlinType, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name2;
            this.descriptor = descriptor;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(4);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(5);
            }
            v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Field.$$$reportNull$$$0(6);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(7);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Field";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value2, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            assert (!Type.BOOLEAN_TYPE.equals(type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Constant.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Constant.$$$reportNull$$$0(1);
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, kotlinType, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Constant";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2, KotlinType kotlinType) {
            super(type2, kotlinType);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(0);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$OnStack";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LateinitLocal
    extends StackValue {
        public final int index;
        private final Name name;

        private LateinitLocal(int index, Type type2, KotlinType kotlinType, Name name2) {
            super(type2, kotlinType, false);
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            if (name2 == null) {
                throw new IllegalArgumentException("Lateinit local variable should have name: #" + index + " " + type2.getDescriptor());
            }
            this.index = index;
            this.name = name2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                LateinitLocal.$$$reportNull$$$0(0);
            }
            if (v == null) {
                LateinitLocal.$$$reportNull$$$0(1);
            }
            v.load(this.index, this.type);
            StackValue.genNonNullAssertForLateinit(v, this.name.asString());
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                LateinitLocal.$$$reportNull$$$0(2);
            }
            if (v == null) {
                LateinitLocal.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.store(this.index, this.type);
            PseudoInsnsKt.storeNotNull(v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$LateinitLocal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            this.index = index;
        }

        private Local(int index, Type type2) {
            this(index, type2, (KotlinType)null);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(1);
            }
            v.load(this.index, this.type);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Local.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.store(this.index, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Local";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                None.$$$reportNull$$$0(0);
            }
            if (v == null) {
                None.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$None";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

