/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "tempIndex", "", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getKPropertyImplConstructor", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "receiverTypes", "returnType", "isLocal", "", "isMutable", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createKProperty", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "createLocalKProperty", "propertyName", "", "propertyType", "isKMutablePropertyType", "type", "Companion", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmPropertyReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmPropertyReferenceLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,305:1\n1#2:306\n350#3,12:307\n1053#4:319\n1557#4:320\n1628#4,3:321\n79#5,6:324\n156#6,6:330\n98#7,2:336\n*S KotlinDebug\n*F\n+ 1 WasmPropertyReferenceLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering\n*L\n83#1:307,12\n169#1:319\n169#1:320\n169#1:321,3\n185#1:324,6\n185#1:330,6\n185#1:336,2\n*E\n"})
public final class WasmPropertyReferenceLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WasmBackendContext context;
    private int tempIndex;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION = new IrDeclarationOriginImpl("KPROPERTIES_FOR_DELEGATION", false, 2, null);

    public WasmPropertyReferenceLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    private final Pair<IrConstructorSymbol, List<IrType>> getKPropertyImplConstructor(List<? extends IrType> receiverTypes, IrType returnType, boolean isLocal, boolean isMutable) {
        IrClassSymbol irClassSymbol;
        if (isLocal) {
            boolean bl = receiverTypes.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Local delegated property cannot have explicit receiver";
                throw new AssertionError((Object)string2);
            }
            irClassSymbol = isMutable ? this.symbols.getKLocalDelegatedMutablePropertyImpl() : this.symbols.getKLocalDelegatedPropertyImpl();
        } else {
            switch (receiverTypes.size()) {
                case 0: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty0Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty0Impl();
                    break;
                }
                case 1: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty1Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty1Impl();
                    break;
                }
                case 2: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty2Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty2Impl();
                    break;
                }
                default: {
                    throw new IllegalStateException("More than 2 receivers is not allowed".toString());
                }
            }
        }
        IrClassSymbol classSymbol = irClassSymbol;
        List arguments = CollectionsKt.plus((Collection)receiverTypes, (Iterable)CollectionsKt.listOf((Object)returnType));
        return TuplesKt.to((Object)SequencesKt.single(IrUtilsKt.getConstructors(classSymbol)), (Object)arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Map kProperties = new LinkedHashMap();
        IrClass arrayClass = (IrClass)this.context.getIrBuiltIns().getArrayClass().getOwner();
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
        boolean $i$f$single = false;
        IrType[] single$iv = null;
        boolean found$iv22 = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("get"))) continue;
            if (found$iv22) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction arrayItemGetter = (IrSimpleFunction)single$iv;
        IrType anyType = this.context.getIrBuiltIns().getAnyType();
        single$iv = new IrType[]{anyType, anyType};
        IrSimpleType kPropertyImplType = IrTypesKt.typeWith((IrClassifierSymbol)this.symbols.getKProperty1Impl(), single$iv);
        IrType[] found$iv22 = new IrType[]{kPropertyImplType};
        IrType kPropertiesFieldType = IrTypesKt.typeWith(arrayClass, found$iv22);
        IrDeclaration irDeclaration2 = (IrDeclaration)CollectionsKt.firstOrNull(irFile.getDeclarations());
        if (irDeclaration2 == null) {
            return;
        }
        IrDeclaration firstFileDeclaration = irDeclaration2;
        IrField kPropertiesField = (IrField)this.context.getIrFactory().getStageController().restrictTo(firstFileDeclaration, () -> WasmPropertyReferenceLowering.lower$lambda$3(this, kPropertiesFieldType, irFile));
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(this, kProperties, arrayItemGetter, kPropertiesField){
            final /* synthetic */ WasmPropertyReferenceLowering this$0;
            final /* synthetic */ Map<IrDeclaration, Pair<IrExpression, Integer>> $kProperties;
            final /* synthetic */ IrSimpleFunction $arrayItemGetter;
            final /* synthetic */ IrField $kPropertiesField;
            {
                this.this$0 = $receiver;
                this.$kProperties = $kProperties;
                this.$arrayItemGetter = $arrayItemGetter;
                this.$kPropertiesField = $kPropertiesField;
            }

            /*
             * WARNING - void declaration
             */
            public IrExpression visitPropertyReference(IrPropertyReference expression2) {
                IrExpression irExpression;
                int n;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                LoweringContext loweringContext = this.this$0.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
                Map<IrDeclaration, Pair<IrExpression, Integer>> map = this.$kProperties;
                IrSimpleFunction irSimpleFunction = this.$arrayItemGetter;
                WasmPropertyReferenceLowering wasmPropertyReferenceLowering = this.this$0;
                IrField irField = this.$kPropertiesField;
                DeclarationIrBuilder $this$visitPropertyReference_u24lambda_u243 = declarationIrBuilder;
                boolean bl = false;
                Object[] objectArray = new IrExpression[]{expression2.getDispatchReceiver(), expression2.getExtensionReceiver()};
                Iterable $this$count$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        IrExpression it = (IrExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it != null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int receiversCount = n;
                switch (receiversCount) {
                    case 0: {
                        IrFunctionAccessExpression irFunctionAccessExpression;
                        Object object;
                        void $this$getOrPut$iv;
                        Map<IrDeclaration, Pair<IrExpression, Integer>> count$iv = map;
                        Owner key$iv = ((IrPropertySymbol)expression2.getSymbol()).getOwner();
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            Pair answer$iv = TuplesKt.to((Object)WasmPropertyReferenceLowering.access$createKProperty(wasmPropertyReferenceLowering, expression2, $this$visitPropertyReference_u24lambda_u243), (Object)map.size());
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        Pair field = (Pair)object;
                        IrFunctionAccessExpression $this$visitPropertyReference_u24lambda_u243_u24lambda_u242 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitPropertyReference_u24lambda_u243, irSimpleFunction);
                        boolean bl4 = false;
                        $this$visitPropertyReference_u24lambda_u243_u24lambda_u242.setDispatchReceiver(ExpressionHelpersKt.irGetField$default($this$visitPropertyReference_u24lambda_u243, null, irField, null, 4, null));
                        $this$visitPropertyReference_u24lambda_u243_u24lambda_u242.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$visitPropertyReference_u24lambda_u243, ((Number)field.getSecond()).intValue(), null, 2, null));
                        irExpression = irFunctionAccessExpression;
                        break;
                    }
                    case 1: {
                        irExpression = WasmPropertyReferenceLowering.access$createKProperty(wasmPropertyReferenceLowering, expression2, $this$visitPropertyReference_u24lambda_u243);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Callable reference to properties with two receivers is not allowed: " + ((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getName()).toString());
                    }
                }
                return irExpression;
            }

            /*
             * WARNING - void declaration
             */
            public IrExpression visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Object object;
                void $this$getOrPut$iv;
                int receiversCount;
                int n;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                LoweringContext loweringContext = this.this$0.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
                Map<IrDeclaration, Pair<IrExpression, Integer>> map = this.$kProperties;
                IrSimpleFunction irSimpleFunction = this.$arrayItemGetter;
                WasmPropertyReferenceLowering wasmPropertyReferenceLowering = this.this$0;
                IrField irField = this.$kPropertiesField;
                DeclarationIrBuilder $this$visitLocalDelegatedPropertyReference_u24lambda_u247 = declarationIrBuilder;
                boolean bl = false;
                Object[] objectArray = new IrExpression[]{expression2.getDispatchReceiver(), expression2.getExtensionReceiver()};
                Iterable $this$count$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$count22 = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        IrExpression it = (IrExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it != null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = receiversCount = count$iv;
                }
                if (receiversCount == 2) {
                    throw new IllegalStateException(("Callable reference to properties with two receivers is not allowed: " + expression2).toString());
                }
                Map<IrDeclaration, Pair<IrExpression, Integer>> $i$f$count22 = map;
                Owner key$iv = ((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner();
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    Pair answer$iv = TuplesKt.to((Object)WasmPropertyReferenceLowering.access$createLocalKProperty(wasmPropertyReferenceLowering, string2, ((IrSimpleFunction)expression2.getGetter().getOwner()).getReturnType(), $this$visitLocalDelegatedPropertyReference_u24lambda_u247), (Object)map.size());
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Pair field = (Pair)object;
                IrFunctionAccessExpression $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitLocalDelegatedPropertyReference_u24lambda_u247, irSimpleFunction);
                boolean bl4 = false;
                $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246.setDispatchReceiver(ExpressionHelpersKt.irGetField$default($this$visitLocalDelegatedPropertyReference_u24lambda_u247, null, irField, null, 4, null));
                $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$visitLocalDelegatedPropertyReference_u24lambda_u247, ((Number)field.getSecond()).intValue(), null, 2, null));
                return irFunctionAccessExpression;
            }
        });
        if (!kProperties.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv = kProperties.values();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
            boolean $i$f$map = false;
            void var13_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrExpression)it.getFirst());
            }
            List initializers = (List)destination$iv$iv;
            kPropertiesField.setInitializer(this.context.getIrFactory().createExpressionBody(-2, -2, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createArrayOfExpression(this.context, -2, -2, kPropertyImplType, initializers)));
            irFile.getDeclarations().add(0, kPropertiesField);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createKProperty(IrPropertyReference expression2, IrBuilderWithScope irBuilder) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        IrFunctionReferenceImpl irFunctionReferenceImpl2;
        Object object;
        IrElementBase getterCallableReference;
        IrElementBase irElementBase;
        IrElementBase irElementBase2;
        Object object2;
        Object returnType;
        Object object3;
        IrVariable extensionReceiver;
        IrVariable irVariable;
        IrVariable irVariable2;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlock$iv$iv;
        int startOffset = expression2.getStartOffset();
        int endOffset = expression2.getEndOffset();
        IrGeneratorWithScope $this$irBlock_u24default$iv = irBuilder;
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = ((IrExpression)expression2).getType();
        boolean $i$f$irBlock = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlock_u24default$iv;
        int n = ((IrExpression)expression2).getStartOffset();
        int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
        boolean $i$f$irBlock2 = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$createKProperty_u24lambda_u2419 = this_$iv$iv$iv;
        boolean bl = false;
        List receiverTypes = new ArrayList();
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl2 = false;
            int n2 = this.tempIndex;
            this.tempIndex = n2 + 1;
            irVariable2 = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$createKProperty_u24lambda_u2419, it, "$dispatchReceiver" + n2, null, false, null, 28, null);
        } else {
            irVariable2 = null;
        }
        IrVariable dispatchReceiver = irVariable2;
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        if (irExpression2 != null) {
            IrExpression it = irExpression2;
            boolean bl3 = false;
            int n3 = this.tempIndex;
            this.tempIndex = n3 + 1;
            irVariable = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$createKProperty_u24lambda_u2419, it, "$extensionReceiver" + n3, null, false, null, 28, null);
        } else {
            irVariable = extensionReceiver = null;
        }
        if ((object3 = expression2.getGetter()) == null || (object3 = (IrSimpleFunction)object3.getOwner()) == null || (object3 = ((IrFunction)object3).getReturnType()) == null) {
            IrFieldSymbol irFieldSymbol = expression2.getField();
            Intrinsics.checkNotNull((Object)irFieldSymbol);
            object3 = returnType = ((IrField)irFieldSymbol.getOwner()).getType();
        }
        if ((object2 = expression2.getGetter()) != null && (object2 = (IrSimpleFunction)object2.getOwner()) != null) {
            IrGetValueImpl irGetValueImpl;
            IrGetValueImpl irGetValueImpl2;
            IrVariable it;
            Object getter2 = object2;
            boolean bl4 = false;
            IrElementBase it2 = ((IrFunction)getter2).getDispatchReceiverParameter();
            boolean bl5 = false;
            if (it2 != null && expression2.getDispatchReceiver() == null) {
                receiverTypes.add(it2.getType());
            }
            it2 = ((IrFunction)getter2).getExtensionReceiverParameter();
            boolean bl6 = false;
            if (it2 != null && expression2.getExtensionReceiver() == null) {
                receiverTypes.add(it2.getType());
            }
            IrSimpleType getterKFunctionType = IrUtilsKt.getKFunctionType(this.context.getIrBuiltIns(), (IrType)returnType, receiverTypes);
            IrType irType = getterKFunctionType;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrFunctionSymbol irFunctionSymbol = irSimpleFunctionSymbol;
            int n4 = getter2.getTypeParameters().size();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol2);
            IrElementBase $this$createKProperty_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412 = it2 = BuildersKt.IrFunctionReferenceImpl$default(startOffset, endOffset, irType, irFunctionSymbol, n4, irSimpleFunctionSymbol2, null, 64, null);
            boolean bl7 = false;
            IrElementBase irElementBase3 = $this$createKProperty_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412;
            IrVariable irVariable3 = dispatchReceiver;
            if (irVariable3 != null) {
                IrVariable irVariable4 = irVariable3;
                irElementBase2 = irElementBase3;
                boolean bl8 = false;
                irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, it);
                irElementBase3 = irElementBase2;
            } else {
                irGetValueImpl2 = null;
            }
            ((IrMemberAccessExpression)irElementBase3).setDispatchReceiver(irGetValueImpl2);
            IrElementBase irElementBase4 = $this$createKProperty_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412;
            IrVariable irVariable5 = extensionReceiver;
            if (irVariable5 != null) {
                it = irVariable5;
                irElementBase2 = irElementBase4;
                boolean bl9 = false;
                irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, it);
                irElementBase4 = irElementBase2;
            } else {
                irGetValueImpl = null;
            }
            ((IrMemberAccessExpression)irElementBase4).setExtensionReceiver(irGetValueImpl);
            int it3 = expression2.getTypeArgumentsCount();
            for (int index = 0; index < it3; ++index) {
                ((IrMemberAccessExpression)$this$createKProperty_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412).putTypeArgument(index, expression2.getTypeArgument(index));
            }
            irElementBase = it2;
        } else {
            irElementBase = getterCallableReference = null;
        }
        if ((object = expression2.getSetter()) != null && (object = (IrSimpleFunction)object.getOwner()) != null) {
            Object setter2 = object;
            boolean bl10 = false;
            if (!this.isKMutablePropertyType(expression2.getType())) {
                irFunctionReferenceImpl2 = null;
            } else {
                IrGetValueImpl irGetValueImpl;
                IrGetValueImpl irGetValueImpl3;
                IrVariable it;
                IrSimpleType setterKFunctionType = IrUtilsKt.getKFunctionType(this.context.getIrBuiltIns(), $this$createKProperty_u24lambda_u2419.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.plus((Collection)receiverTypes, (Object)returnType));
                IrType irType = setterKFunctionType;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
                IrFunctionSymbol irFunctionSymbol = irSimpleFunctionSymbol;
                int n5 = setter2.getTypeParameters().size();
                IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = expression2.getSetter();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol3);
                IrFunctionReferenceImpl $this$createKProperty_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416 = irFunctionReferenceImpl = BuildersKt.IrFunctionReferenceImpl$default(startOffset, endOffset, irType, irFunctionSymbol, n5, irSimpleFunctionSymbol3, null, 64, null);
                boolean bl11 = false;
                IrFunctionReferenceImpl irFunctionReferenceImpl3 = $this$createKProperty_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416;
                IrVariable irVariable6 = dispatchReceiver;
                if (irVariable6 != null) {
                    irElementBase2 = irVariable6;
                    IrFunctionReferenceImpl irFunctionReferenceImpl4 = irFunctionReferenceImpl3;
                    boolean bl12 = false;
                    irGetValueImpl3 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, it);
                    irFunctionReferenceImpl3 = irFunctionReferenceImpl4;
                } else {
                    irGetValueImpl3 = null;
                }
                irFunctionReferenceImpl3.setDispatchReceiver(irGetValueImpl3);
                IrFunctionReferenceImpl irFunctionReferenceImpl5 = $this$createKProperty_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416;
                IrVariable irVariable7 = extensionReceiver;
                if (irVariable7 != null) {
                    it = irVariable7;
                    IrFunctionReferenceImpl irFunctionReferenceImpl6 = irFunctionReferenceImpl5;
                    boolean bl13 = false;
                    irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, it);
                    irFunctionReferenceImpl5 = irFunctionReferenceImpl6;
                } else {
                    irGetValueImpl = null;
                }
                irFunctionReferenceImpl5.setExtensionReceiver(irGetValueImpl);
                int n6 = expression2.getTypeArgumentsCount();
                for (int index = 0; index < n6; ++index) {
                    $this$createKProperty_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416.putTypeArgument(index, expression2.getTypeArgument(index));
                }
                irFunctionReferenceImpl2 = irFunctionReferenceImpl;
            }
        } else {
            irFunctionReferenceImpl2 = null;
        }
        IrFunctionReferenceImpl setterCallableReference = irFunctionReferenceImpl2;
        Pair<IrConstructorSymbol, List<IrType>> pair = this.getKPropertyImplConstructor(receiverTypes, (IrType)returnType, false, setterCallableReference != null);
        IrConstructorSymbol symbol = (IrConstructorSymbol)pair.component1();
        List constructorTypeArguments = (List)pair.component2();
        boolean capturedReceiver = expression2.getDispatchReceiver() != null || expression2.getDispatchReceiver() != null;
        IrSimpleType initializerType = IrTypesKt.typeWith(IrTypesKt.getClassifierOrFail(((IrConstructor)symbol.getOwner()).getReturnType()), (List<? extends IrType>)constructorTypeArguments);
        IrFunctionReferenceImpl $this$createKProperty_u24lambda_u2419_u24lambda_u2418 = irFunctionReferenceImpl = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, (IrFunctionSymbol)symbol, (IrType)initializerType, constructorTypeArguments);
        boolean bl14 = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createKProperty_u24lambda_u2419;
        String string2 = ((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        $this$createKProperty_u24lambda_u2419_u24lambda_u2418.putValueArgument(0, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        $this$createKProperty_u24lambda_u2419_u24lambda_u2418.putValueArgument(1, ExpressionHelpersKt.irString((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, AdditionalIrUtilsKt.getKotlinFqName(((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getParent()).asString()));
        $this$createKProperty_u24lambda_u2419_u24lambda_u2418.putValueArgument(2, ExpressionHelpersKt.irBoolean((IrBuilderWithScope)$this$createKProperty_u24lambda_u2419, capturedReceiver));
        if (getterCallableReference != null) {
            $this$createKProperty_u24lambda_u2419_u24lambda_u2418.putValueArgument(3, (IrExpression)getterCallableReference);
        }
        if (setterCallableReference != null) {
            $this$createKProperty_u24lambda_u2419_u24lambda_u2418.putValueArgument(4, setterCallableReference);
        }
        IrFunctionReferenceImpl initializer = irFunctionReferenceImpl;
        $this$createKProperty_u24lambda_u2419.unaryPlus(initializer);
        return this_$iv$iv$iv.doBuild();
    }

    private final IrExpression createLocalKProperty(String propertyName, IrType propertyType, IrBuilderWithScope irBuilder) {
        IrMemberAccessExpression<?> irMemberAccessExpression;
        IrBuilderWithScope $this$createLocalKProperty_u24lambda_u2421 = irBuilder;
        boolean bl = false;
        Pair<IrConstructorSymbol, List<IrType>> pair = this.getKPropertyImplConstructor(CollectionsKt.emptyList(), propertyType, true, false);
        IrConstructorSymbol symbol = (IrConstructorSymbol)pair.component1();
        List constructorTypeArguments = (List)pair.component2();
        IrSimpleType initializerType = IrTypesKt.typeWith(IrTypesKt.getClassifierOrFail(((IrConstructor)symbol.getOwner()).getReturnType()), (List<? extends IrType>)constructorTypeArguments);
        IrMemberAccessExpression<?> $this$createLocalKProperty_u24lambda_u2421_u24lambda_u2420 = irMemberAccessExpression = ExpressionHelpersKt.irCall($this$createLocalKProperty_u24lambda_u2421, (IrFunctionSymbol)symbol, (IrType)initializerType, constructorTypeArguments);
        boolean bl2 = false;
        $this$createLocalKProperty_u24lambda_u2421_u24lambda_u2420.putValueArgument(0, ExpressionHelpersKt.irString($this$createLocalKProperty_u24lambda_u2421, propertyName));
        IrMemberAccessExpression<?> initializer = irMemberAccessExpression;
        return initializer;
    }

    private final boolean isKMutablePropertyType(IrType type2) {
        IrClassSymbol irClassSymbol;
        if (!(type2 instanceof IrSimpleType)) {
            return false;
        }
        switch (((IrSimpleType)type2).getArguments().size()) {
            case 0: {
                return false;
            }
            case 1: {
                irClassSymbol = this.symbols.getKMutableProperty0();
                break;
            }
            case 2: {
                irClassSymbol = this.symbols.getKMutableProperty1();
                break;
            }
            case 3: {
                irClassSymbol = this.symbols.getKMutableProperty2();
                break;
            }
            default: {
                throw new IllegalStateException("More than 2 receivers is not allowed".toString());
            }
        }
        IrClassSymbol expectedClass = irClassSymbol;
        return Intrinsics.areEqual((Object)((IrSimpleType)type2).getClassifier(), (Object)expectedClass);
    }

    private static final IrField lower$lambda$3(WasmPropertyReferenceLowering this$0, IrType $kPropertiesFieldType, IrFile $irFile) {
        IrField irField;
        IrFactory irFactory = this$0.context.getIrFactory();
        IrDeclarationOrigin irDeclarationOrigin = DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION;
        Name name2 = Name.identifier("$KPROPERTIES");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        IrField $this$lower_u24lambda_u243_u24lambda_u242 = irField = irFactory.createField(-2, -2, irDeclarationOrigin, name2, descriptorVisibility, new IrFieldSymbolImpl(null, null, 3, null), $kPropertiesFieldType, true, true, false);
        boolean bl = false;
        $this$lower_u24lambda_u243_u24lambda_u242.setParent($irFile);
        return irField;
    }

    public static final /* synthetic */ IrExpression access$createKProperty(WasmPropertyReferenceLowering $this, IrPropertyReference expression2, IrBuilderWithScope irBuilder) {
        return $this.createKProperty(expression2, irBuilder);
    }

    public static final /* synthetic */ IrExpression access$createLocalKProperty(WasmPropertyReferenceLowering $this, String propertyName, IrType propertyType, IrBuilderWithScope irBuilder) {
        return $this.createLocalKProperty(propertyName, propertyType, irBuilder);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering$Companion;", "", "<init>", "()V", "DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getDECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "backend.wasm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION() {
            return DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

