/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.UninitializedPropertyAccessExceptionThrower;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="LateinitLowering")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002J\f\u0010!\u001a\u00020\u001f*\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0015H\u0014J\u0018\u0010'\u001a\u00020\r2\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u0010*\u001a\u00020\u0019*\u00020+2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "loweringContext", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "uninitializedPropertyAccessExceptionThrower", "Lorg/jetbrains/kotlin/backend/common/lower/UninitializedPropertyAccessExceptionThrower;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/backend/common/lower/UninitializedPropertyAccessExceptionThrower;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "visitProperty", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "isLateinitBackingField", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isRealLateinit", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "transformLateinitBackingField", "backingField", "property", "transformGetter", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLowering\n+ 2 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n185#2,12:208\n1#3:220\n*S KotlinDebug\n*F\n+ 1 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLowering\n*L\n127#1:208,12\n*E\n"})
public class LateinitLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final LoweringContext loweringContext;
    @NotNull
    private final UninitializedPropertyAccessExceptionThrower uninitializedPropertyAccessExceptionThrower;

    public LateinitLowering(@NotNull LoweringContext loweringContext, @NotNull UninitializedPropertyAccessExceptionThrower uninitializedPropertyAccessExceptionThrower) {
        Intrinsics.checkNotNullParameter((Object)loweringContext, (String)"loweringContext");
        Intrinsics.checkNotNullParameter((Object)uninitializedPropertyAccessExceptionThrower, (String)"uninitializedPropertyAccessExceptionThrower");
        this.loweringContext = loweringContext;
        this.uninitializedPropertyAccessExceptionThrower = uninitializedPropertyAccessExceptionThrower;
    }

    public LateinitLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this(backendContext, new UninitializedPropertyAccessExceptionThrower(backendContext.getIr().getSymbols()));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    public final void lower(@NotNull IrBody irBody) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.isRealLateinit(declaration)) {
            IrField irField = declaration.getBackingField();
            Intrinsics.checkNotNull((Object)irField);
            IrField backingField = irField;
            this.transformLateinitBackingField(backingField, declaration);
            IrSimpleFunction irSimpleFunction = declaration.getGetter();
            if (irSimpleFunction != null) {
                IrSimpleFunction it = irSimpleFunction;
                boolean bl = false;
                this.transformGetter(backingField, it);
            }
        }
        this.transformChildrenVoid(declaration);
        return declaration;
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformChildrenVoid(declaration);
        if (declaration.isLateinit()) {
            declaration.setType(IrTypesKt.makeNullable(declaration.getType()));
            declaration.setVar(true);
            declaration.setInitializer(IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.loweringContext.getIrBuiltIns().getNothingNType()));
        }
        return declaration;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        IrValueDeclaration irValue = expression2.getSymbol().getOwner();
        if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
            return expression2;
        }
        IrDeclarationParent irDeclarationParent = ((IrVariable)irValue).getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
        DeclarationIrBuilder $this$visitGetValue_u24lambda_u241 = LowerUtilsKt.createIrBuilder(this.loweringContext, ((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = $this$visitGetValue_u24lambda_u241;
        IrType irType = expression2.getType();
        IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$visitGetValue_u24lambda_u241, ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue));
        IrBuilderWithScope irBuilderWithScope2 = $this$visitGetValue_u24lambda_u241;
        String string2 = irValue.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression, this.uninitializedPropertyAccessExceptionThrower.build(irBuilderWithScope2, string2), ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue), null, 16, null);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        IrField irField = (IrField)expression2.getSymbol().getOwner();
        if (this.isLateinitBackingField(irField)) {
            expression2.setType(IrTypesKt.makeNullable(expression2.getType()));
        }
        return expression2;
    }

    private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
        IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
        IrProperty property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
        return property2 != null && this.isRealLateinit(property2);
    }

    private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
        return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter(expression2.getSymbol())) {
            return expression2;
        }
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression2);
        IrExpression $this$replaceTailExpression$iv = irExpression2;
        boolean $i$f$replaceTailExpression = false;
        IrExpression current$iv = $this$replaceTailExpression$iv;
        IrContainerExpression block$iv = null;
        while (current$iv instanceof IrContainerExpression) {
            block$iv = (IrContainerExpression)current$iv;
            Object object = CollectionsKt.last(((IrContainerExpression)current$iv).getStatements());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            current$iv = (IrExpression)object;
        }
        IrExpression it = current$iv;
        boolean bl = false;
        IrPropertyReference irPropertyReference = it instanceof IrPropertyReference ? (IrPropertyReference)it : null;
        if (irPropertyReference == null) {
            throw new AssertionError((Object)("Property reference expected: " + RenderIrElementKt.render$default(it, null, 1, null)));
        }
        IrPropertyReference irPropertyRef = irPropertyReference;
        Object object = irPropertyRef.getGetter();
        if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null || (object = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)object, null, 1, null)) == null || (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) == null || (object = (IrProperty)object.getOwner()) == null) {
            throw new AssertionError((Object)("isInitialized cannot be invoked on " + RenderIrElementKt.render$default(it, null, 1, null)));
        }
        Object property2 = object;
        if (!((IrProperty)property2).isLateinit()) {
            boolean bl2 = false;
            String string2 = "isInitialized invoked on non-lateinit property " + RenderIrElementKt.render$default((IrElement)property2, null, 1, null);
            throw new IllegalArgumentException(string2.toString());
        }
        IrField irField = ((IrProperty)property2).getBackingField();
        if (irField == null) {
            throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
        }
        IrField backingField = irField;
        this.transformLateinitBackingField(backingField, (IrProperty)property2);
        DeclarationIrBuilder $this$visitCall_u24lambda_u244_u24lambda_u243 = LowerUtilsKt.createIrBuilder(this.loweringContext, ((IrPropertyReference)it).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl3 = false;
        current$iv = ExpressionHelpersKt.irNotEquals($this$visitCall_u24lambda_u244_u24lambda_u243, ExpressionHelpersKt.irGetField$default($this$visitCall_u24lambda_u244_u24lambda_u243, ((IrPropertyReference)it).getDispatchReceiver(), backingField, null, 4, null), ExpressionHelpersKt.irNull($this$visitCall_u24lambda_u244_u24lambda_u243));
        if (block$iv == null) {
            irExpression = current$iv;
        } else {
            void var2_2;
            block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
            irExpression = var2_2;
        }
        return irExpression;
    }

    protected void transformLateinitBackingField(@NotNull IrField backingField, @NotNull IrProperty property2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)backingField, (String)"backingField");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        boolean bl2 = bl = backingField.getInitializer() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default(property2, null, 1, null);
            throw new AssertionError((Object)string2);
        }
        backingField.setType(IrTypesKt.makeNullable(backingField.getType()));
    }

    private final void transformGetter(IrField backingField, IrFunction getter2) {
        boolean bl;
        IrType type2 = backingField.getType();
        boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LateinitLowering$transformGetter$22 = false;
            String $i$a$-assert-LateinitLowering$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default(backingField, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-LateinitLowering$transformGetter$22);
        }
        int startOffset = getter2.getStartOffset();
        int endOffset = getter2.getEndOffset();
        getter2.setBody(IrFactoryHelpersKt.createBlockBody(this.loweringContext.getIrFactory(), startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> LateinitLowering.transformGetter$lambda$9(this, getter2, startOffset, endOffset, backingField, type2, arg_0))));
    }

    private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name2) {
        return this.uninitializedPropertyAccessExceptionThrower.build($this$throwUninitializedPropertyAccessException, name2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit transformGetter$lambda$9(LateinitLowering this$0, IrFunction $getter, int $startOffset, int $endOffset, IrField $backingField, IrType $type, IrBlockBody $this$createBlockBody) {
        IrGetValueImpl irGetValueImpl;
        DeclarationIrBuilder irBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        DeclarationIrBuilder $this$transformGetter_u24lambda_u249_u24lambda_u248 = irBuilder = LowerUtilsKt.createIrBuilder(this$0.loweringContext, (IrSymbol)$getter.getSymbol(), $startOffset, $endOffset);
        boolean bl = false;
        Scope scope2 = $this$transformGetter_u24lambda_u249_u24lambda_u248.getScope();
        IrBuilderWithScope irBuilderWithScope = $this$transformGetter_u24lambda_u249_u24lambda_u248;
        IrValueParameter irValueParameter = $getter.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            void it;
            IrValueParameter irValueParameter2 = irValueParameter;
            IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
            Scope scope3 = scope2;
            boolean bl2 = false;
            IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u249_u24lambda_u248, (IrValueDeclaration)it);
            scope2 = scope3;
            irBuilderWithScope = irBuilderWithScope2;
            irGetValueImpl = irGetValueImpl2;
        } else {
            irGetValueImpl = null;
        }
        IrVariable resultVar2 = IrBuilderKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, $backingField, $type), null, false, null, null, 30, null);
        resultVar2.setParent($getter);
        $this$createBlockBody.getStatements().add(resultVar2);
        IrBuilderWithScope irBuilderWithScope3 = $this$transformGetter_u24lambda_u249_u24lambda_u248;
        IrType irType = $this$transformGetter_u24lambda_u249_u24lambda_u248.getContext().getIrBuiltIns().getNothingType();
        IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$transformGetter_u24lambda_u249_u24lambda_u248, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u249_u24lambda_u248, resultVar2), ExpressionHelpersKt.irNull($this$transformGetter_u24lambda_u249_u24lambda_u248));
        IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$transformGetter_u24lambda_u249_u24lambda_u248, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u249_u24lambda_u248, resultVar2));
        IrBuilderWithScope irBuilderWithScope4 = $this$transformGetter_u24lambda_u249_u24lambda_u248;
        String string2 = $backingField.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        IrWhenImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, this$0.throwUninitializedPropertyAccessException(irBuilderWithScope4, string2), null, 16, null);
        $this$createBlockBody.getStatements().add(throwIfNull);
        return Unit.INSTANCE;
    }
}

