/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.InlineFunctionUseSiteChecker;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\u001a\u001a\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"validateVararg", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "varargElementType", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "EXCLUDED_MODULE_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "getEXCLUDED_MODULE_NAMES", "()Ljava/util/Set;", "visibilityError", "element", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "isVisibleAsInternal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isVisibleAsPrivate", "checkVisibility", "referencedDeclarationSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "reference", "checkFunctionUseSite", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inlineFunctionUseSiteChecker", "Lorg/jetbrains/kotlin/backend/common/InlineFunctionUseSiteChecker;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCheckerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/backend/common/checkers/CheckerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n1#2:162\n11493#3,3:163\n*S KotlinDebug\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/backend/common/checkers/CheckerUtilsKt\n*L\n73#1:163,3\n*E\n"})
public final class CheckerUtilsKt {
    @NotNull
    private static final Set<Name> EXCLUDED_MODULE_NAMES;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void validateVararg(@NotNull IrElement irElement, @NotNull IrType type2, @NotNull IrType varargElementType, @NotNull CheckerContext context) {
        Boolean isCorrectArrayOfPrimitiveOrUnsigned;
        Boolean bl;
        IrType primitiveOrUnsignedElementType;
        IrType irType;
        boolean isCorrectArrayOf;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)varargElementType, (String)"varargElementType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (IrTypePredicatesKt.isArray(type2) || IrTypePredicatesKt.isNullableArray(type2)) {
            boolean bl2;
            IrTypeArgument it = (IrTypeArgument)CollectionsKt.single(((IrSimpleType)type2).getArguments());
            boolean bl3 = false;
            IrTypeArgument irTypeArgument = it;
            if (irTypeArgument instanceof IrSimpleType) {
                bl2 = Intrinsics.areEqual((Object)it, (Object)varargElementType);
            } else if (irTypeArgument instanceof IrTypeProjection) {
                if (((IrTypeProjection)it).getVariance() == Variance.OUT_VARIANCE && Intrinsics.areEqual((Object)((IrTypeProjection)it).getType(), (Object)varargElementType)) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        boolean bl4 = isCorrectArrayOf = false;
        if (isCorrectArrayOf) {
            return;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(type2);
        if (irClassifierSymbol != null) {
            IrClassifierSymbol classifier = irClassifierSymbol;
            boolean bl5 = false;
            irType = context.getIrBuiltIns().getPrimitiveArrayElementTypes().get(classifier);
            if (irType == null) {
                irType = context.getIrBuiltIns().getUnsignedArraysElementTypes().get(classifier);
            }
        } else {
            irType = null;
        }
        IrType irType2 = primitiveOrUnsignedElementType = irType;
        if (irType2 != null) {
            IrType it = irType2;
            boolean bl6 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)varargElementType);
        } else {
            bl = isCorrectArrayOfPrimitiveOrUnsigned = null;
        }
        if (Intrinsics.areEqual((Object)isCorrectArrayOfPrimitiveOrUnsigned, (Object)true)) {
            return;
        }
        context.error(irElement, "Vararg type=" + RenderIrElementKt.render$default(type2, null, 1, null) + " is expected to be an array of its underlying varargElementType=" + RenderIrElementKt.render$default(varargElementType, null, 1, null));
    }

    @NotNull
    public static final Set<Name> getEXCLUDED_MODULE_NAMES() {
        return EXCLUDED_MODULE_NAMES;
    }

    private static final void visibilityError(IrElement element, Visibility visibility, CheckerContext context) {
        String message = "The following element references " + (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Unknown.INSTANCE) ? "a declaration with unknown visibility:" : '\'' + visibility.getName() + "' declaration that is invisible in the current scope:");
        context.error(element, message);
    }

    private static final boolean isVisibleAsInternal(IrDeclarationWithVisibility $this$isVisibleAsInternal, CheckerContext context) {
        IrPackageFragment referencedDeclarationPackageFragment = IrUtilsKt.getPackageFragment($this$isVisibleAsInternal);
        IrModuleFragment module2 = context.getFile().getModule();
        if (referencedDeclarationPackageFragment.getSymbol() instanceof DescriptorlessExternalPackageFragmentSymbol) {
            return Intrinsics.areEqual((Object)module2.getName().asString(), (Object)"<kotlin>");
        }
        return module2.getDescriptor().shouldSeeInternalsOf(IrPackageFragmentsKt.getModuleDescriptor(referencedDeclarationPackageFragment));
    }

    private static final boolean isVisibleAsPrivate(IrDeclarationWithVisibility $this$isVisibleAsPrivate, CheckerContext context) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$isVisibleAsPrivate);
        return Intrinsics.areEqual((Object)context.getFile().getFileEntry(), (Object)(irFile != null ? irFile.getFileEntry() : null));
    }

    public static final void checkVisibility(@NotNull IrSymbol referencedDeclarationSymbol, @NotNull IrElement reference2, @NotNull CheckerContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)referencedDeclarationSymbol, (String)"referencedDeclarationSymbol");
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrSymbolOwner irSymbolOwner = referencedDeclarationSymbol.getOwner();
        IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
        if (irDeclarationWithVisibility == null) {
            return;
        }
        IrDeclarationWithVisibility referencedDeclaration = irDeclarationWithVisibility;
        IrClass classOfReferenced = IrUtilsKt.getParentClassOrNull(referencedDeclaration);
        Visibility visibility = referencedDeclaration.getVisibility().getDelegate();
        IrClass irClass = classOfReferenced;
        EffectiveVisibility effectiveVisibility = EffectiveVisibilityKt.toEffectiveVisibilityOrNull(visibility, irClass != null ? irClass.getSymbol() : null, true, IrUtilsKt.isPublishedApi(referencedDeclaration));
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility;
        if (effectiveVisibility2 instanceof EffectiveVisibility.Internal || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtected || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtectedBound) {
            bl = CheckerUtilsKt.isVisibleAsInternal(referencedDeclaration, context);
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Local || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInClass || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInFile) {
            bl = CheckerUtilsKt.isVisibleAsPrivate(referencedDeclaration, context);
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.PackagePrivate || effectiveVisibility2 instanceof EffectiveVisibility.Protected || effectiveVisibility2 instanceof EffectiveVisibility.ProtectedBound || effectiveVisibility2 instanceof EffectiveVisibility.Public) {
            bl = true;
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Unknown || effectiveVisibility2 == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVisible = bl;
        if (!isVisible) {
            CheckerUtilsKt.visibilityError(reference2, visibility, context);
        }
    }

    public static final void checkFunctionUseSite(@NotNull IrMemberAccessExpression<IrFunctionSymbol> expression2, @NotNull InlineFunctionUseSiteChecker inlineFunctionUseSiteChecker, @NotNull CheckerContext context) {
        String string2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)inlineFunctionUseSiteChecker, (String)"inlineFunctionUseSiteChecker");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (!function2.isInline() || inlineFunctionUseSiteChecker.isPermitted(expression2)) {
            return;
        }
        StringBuilder $this$checkFunctionUseSite_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$checkFunctionUseSite_u24lambda_u244.append("The following element references ").append(function2.getVisibility()).append(" inline ");
        IrFunction irFunction = function2;
        if (irFunction instanceof IrSimpleFunction) {
            string2 = AdditionalIrUtilsKt.isAccessor(function2) ? "property accessor" : "function";
        } else if (irFunction instanceof IrConstructor) {
            string2 = "constructor";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$checkFunctionUseSite_u24lambda_u244.append(string2);
        $this$checkFunctionUseSite_u24lambda_u244.append(" ").append(function2.getName().asString());
        String message = stringBuilder.toString();
        context.error(expression2, message);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        String[] stringArray = new String[]{"stdlib", "kotlin", "kotlin", "kotlin-test"};
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var6_6 = item$iv = $this$mapTo$iv[i];
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(Name.special('<' + (String)it + '>'));
        }
        EXCLUDED_MODULE_NAMES = (Set)var1_1;
    }
}

