/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstructorAllowedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstructorAllowedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n21#2:61\n11#2:62\n1755#3,3:63\n*S KotlinDebug\n*F\n+ 1 FirConstructorAllowedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker\n*L\n38#1:61\n43#1:62\n45#1:63,3\n*E\n"})
public final class FirConstructorAllowedChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    public static final FirConstructorAllowedChecker INSTANCE = new FirConstructorAllowedChecker();

    private FirConstructorAllowedChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirConstructor declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        IElementType elementType;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        if (!(object instanceof FirClass)) return;
        FirClass firClass = (FirClass)object;
        if (firClass == null) {
            return;
        }
        FirClass containingClass = firClass;
        KtSourceElement ktSourceElement = source = declaration.getSource();
        IElementType iElementType = elementType = ktSourceElement != null ? ktSourceElement.getElementType() : null;
        if (!Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) && !Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[containingClass.getClassKind().ordinal()]) {
            case 1: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            case 2: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_INTERFACE(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            case 4: {
                FirMemberDeclaration $this$visibility$iv = declaration;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) return;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PRIVATE_CONSTRUCTOR_IN_ENUM(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            case 5: {
                FirModifier it;
                KtModifierKeywordToken token;
                FirClass firClass2 = containingClass;
                if (firClass2 instanceof FirAnonymousObject) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
                if (!(firClass2 instanceof FirRegularClass)) throw new NoWhenBranchMatchedException();
                FirMemberDeclaration $this$modality$iv = containingClass;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getStatus().getModality() != Modality.SEALED) return;
                FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
                if (firModifierList == null) {
                    return;
                }
                FirModifierList modifierList2 = firModifierList;
                Iterable $this$any$iv = modifierList2.getModifiers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return;
                    Object element$iv = iterator2.next();
                    it = (FirModifier)element$iv;
                    boolean bl = false;
                } while (!(KtTokens.VISIBILITY_MODIFIERS.contains(token = it.getToken()) && !Intrinsics.areEqual((Object)token, (Object)KtTokens.PROTECTED_KEYWORD) && !Intrinsics.areEqual((Object)token, (Object)KtTokens.PRIVATE_KEYWORD)));
                boolean bl = true;
                boolean hasIllegalModifier = bl;
                if (!hasIllegalModifier) return;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            case 6: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

