/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsComment;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.LocalAlias;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0004J\u0010\u0010 \u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u0010 \u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0004J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0004J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0004J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0004J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0004J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0004J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0004J\u0010\u0010@\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0004J\u0010\u0010@\u001a\u00020G2\u0006\u0010E\u001a\u00020HH\u0004J\u0010\u0010@\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0004J\u0010\u0010@\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0004J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010O\u001a\u00020\u0011H\u0004J\u0010\u0010 \u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0004J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010S\u001a\u00020\u0016H\u0004J\u0010\u0010 \u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0004JG\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020X0\\2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020X0\\2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020X0`H\u0082\bJG\u0010a\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020X0\\2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020X0\\2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020X0`H\u0082\bJ\u0012\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010Y\u001a\u00020ZH&R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000bX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006f"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstSerializerBase;", "", "<init>", "()V", "nameTableBuilder", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$NameTable$Builder;", "kotlin.jvm.PlatformType", "getNameTableBuilder", "()Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$NameTable$Builder;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$NameTable$Builder;", "stringTableBuilder", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$StringTable$Builder;", "getStringTableBuilder", "()Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$StringTable$Builder;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$StringTable$Builder;", "nameMap", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "getNameMap", "()Ljava/util/Map;", "stringMap", "", "getStringMap", "fileStack", "Ljava/util/Deque;", "getFileStack", "()Ljava/util/Deque;", "importedNames", "", "getImportedNames", "()Ljava/util/Set;", "serialize", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Statement;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Expression;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$JsImportedModule;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "serializeParameter", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Parameter;", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "serializeBlock", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$CompositeBlock;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsCompositeBlock;", "serializeFunction", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Function;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "serializeVars", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Vars;", "vars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "serializeUnary", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation;", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperation;", "postfix", "", "map", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Function$Modifier;", "modifier", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction$Modifier;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$BinaryOperation$Type;", "op", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation$Type;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SideEffects;", "sideEffects", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SideEffectKind;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SpecialFunction;", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "name", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$LocalAlias;", "alias", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/LocalAlias;", "string", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Comment;", "comment", "Lorg/jetbrains/kotlin/js/backend/ast/JsComment;", "withLocation", "", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "fileConsumer", "Lkotlin/Function1;", "locationConsumer", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;", "inner", "Lkotlin/Function0;", "withComments", "beforeCommentsConsumer", "afterCommentsConsumer", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "js.serializer"})
@SourceDebugExtension(value={"SMAP\nJsAstSerializerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsAstSerializerBase.kt\norg/jetbrains/kotlin/serialization/js/ast/JsAstSerializerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,606:1\n600#1:607\n601#1,2:610\n571#1,22:612\n603#1:634\n600#1:635\n601#1,2:638\n571#1,22:640\n603#1:662\n571#1,22:668\n1863#2,2:608\n1863#2,2:636\n1863#2,2:664\n1863#2,2:666\n1863#2,2:704\n1863#2,2:706\n1#3:663\n381#4,7:690\n381#4,7:697\n*S KotlinDebug\n*F\n+ 1 JsAstSerializerBase.kt\norg/jetbrains/kotlin/serialization/js/ast/JsAstSerializerBase\n*L\n177#1:607\n177#1:610,2\n178#1:612,22\n177#1:634\n359#1:635\n359#1:638,2\n360#1:640,22\n359#1:662\n421#1:668,22\n177#1:608,2\n359#1:636,2\n403#1:664,2\n404#1:666,2\n600#1:704,2\n601#1:706,2\n522#1:690,7\n552#1:697,7\n*E\n"})
public abstract class JsAstSerializerBase {
    private final JsAstProtoBuf.NameTable.Builder nameTableBuilder = JsAstProtoBuf.NameTable.newBuilder();
    private final JsAstProtoBuf.StringTable.Builder stringTableBuilder = JsAstProtoBuf.StringTable.newBuilder();
    @NotNull
    private final Map<JsName, Integer> nameMap = new LinkedHashMap();
    @NotNull
    private final Map<String, Integer> stringMap = new LinkedHashMap();
    @NotNull
    private final Deque<String> fileStack = new ArrayDeque();
    @NotNull
    private final Set<JsName> importedNames = new LinkedHashSet();

    protected final JsAstProtoBuf.NameTable.Builder getNameTableBuilder() {
        return this.nameTableBuilder;
    }

    protected final JsAstProtoBuf.StringTable.Builder getStringTableBuilder() {
        return this.stringTableBuilder;
    }

    @NotNull
    protected final Map<JsName, Integer> getNameMap() {
        return this.nameMap;
    }

    @NotNull
    protected final Map<String, Integer> getStringMap() {
        return this.stringMap;
    }

    @NotNull
    protected final Deque<String> getFileStack() {
        return this.fileStack;
    }

    @NotNull
    protected final Set<JsName> getImportedNames() {
        return this.importedNames;
    }

    @NotNull
    protected final JsAstProtoBuf.Statement serialize(@NotNull JsStatement statement) {
        JsAstProtoBuf.Comment it;
        JsComment it$iv;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        JsVisitor visitor2 = new JsVisitor(this){
            private final JsAstProtoBuf.Statement.Builder builder;
            final /* synthetic */ JsAstSerializerBase this$0;
            {
                this.this$0 = $receiver;
                this.builder = JsAstProtoBuf.Statement.newBuilder();
            }

            public final JsAstProtoBuf.Statement.Builder getBuilder() {
                return this.builder;
            }

            public void visitReturn(JsReturn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Return.Builder returnBuilder = JsAstProtoBuf.Return.newBuilder();
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2 = jsExpression;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsExpression it = jsExpression2;
                    boolean bl = false;
                    returnBuilder.setValue(jsAstSerializerBase.serialize(it));
                }
                this.builder.setReturnStatement(returnBuilder.build());
            }

            public void visitThrow(JsThrow x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Throw.Builder throwBuilder = JsAstProtoBuf.Throw.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                throwBuilder.setException(this.this$0.serialize(jsExpression));
                this.builder.setThrowStatement(throwBuilder.build());
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Break.Builder breakBuilder = JsAstProtoBuf.Break.newBuilder();
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsNameRef it = jsNameRef2;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    breakBuilder.setLabelId(jsAstSerializerBase.serialize(jsName));
                }
                this.builder.setBreakStatement(breakBuilder.build());
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Continue.Builder continueBuilder = JsAstProtoBuf.Continue.newBuilder();
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsNameRef it = jsNameRef2;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    continueBuilder.setLabelId(jsAstSerializerBase.serialize(jsName));
                }
                this.builder.setContinueStatement(continueBuilder.build());
            }

            public void visitDebugger(JsDebugger x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setDebugger(JsAstProtoBuf.Debugger.newBuilder().build());
            }

            public void visitExpressionStatement(JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ExpressionStatement.Builder statementBuilder = JsAstProtoBuf.ExpressionStatement.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                statementBuilder.setExpression(this.this$0.serialize(jsExpression));
                String tag = MetadataProperties.getExportedTag(x);
                if (tag != null) {
                    statementBuilder.setExportedTagId(this.this$0.serialize(tag));
                }
                this.builder.setExpression(statementBuilder.build());
            }

            public void visitVars(JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setVars(this.this$0.serializeVars(x));
            }

            public void visitBlock(JsBlock x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x instanceof JsCompositeBlock) {
                    this.builder.setCompositeBlock(this.this$0.serializeBlock((JsCompositeBlock)x));
                } else {
                    JsAstProtoBuf.Block.Builder blockBuilder = JsAstProtoBuf.Block.newBuilder();
                    for (JsStatement part : x.getStatements()) {
                        Intrinsics.checkNotNull((Object)part);
                        blockBuilder.addStatement(this.this$0.serialize(part));
                    }
                    this.builder.setBlock(blockBuilder.build());
                }
            }

            public void visitLabel(JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Label.Builder labelBuilder = JsAstProtoBuf.Label.newBuilder();
                JsName jsName = x.getName();
                Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                labelBuilder.setNameId(this.this$0.serialize(jsName));
                JsStatement jsStatement = x.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getStatement(...)");
                labelBuilder.setInnerStatement(this.this$0.serialize(jsStatement));
                this.builder.setLabel(labelBuilder.build());
            }

            public void visitIf(JsIf x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.If.Builder ifBuilder = JsAstProtoBuf.If.newBuilder();
                JsExpression jsExpression = x.getIfExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getIfExpression(...)");
                ifBuilder.setCondition(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getThenStatement(...)");
                ifBuilder.setThenStatement(this.this$0.serialize(jsStatement));
                JsStatement jsStatement2 = x.getElseStatement();
                if (jsStatement2 != null) {
                    JsStatement jsStatement3 = jsStatement2;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsStatement it = jsStatement3;
                    boolean bl = false;
                    ifBuilder.setElseStatement(jsAstSerializerBase.serialize(it));
                }
                this.builder.setIfStatement(ifBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visit(JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Switch.Builder switchBuilder = JsAstProtoBuf.Switch.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                switchBuilder.setExpression(this.this$0.serialize(jsExpression));
                for (JsSwitchMember jsSwitchMember : x.getCases()) {
                    void this_$iv;
                    JsAstProtoBuf.SwitchEntry.Builder entryBuilder = JsAstProtoBuf.SwitchEntry.newBuilder();
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    Intrinsics.checkNotNull((Object)jsSwitchMember);
                    JsNode node$iv = jsSwitchMember;
                    boolean $i$f$withLocation = false;
                    JsLocation location$iv = this_$iv.extractLocation(node$iv);
                    boolean fileChanged$iv = false;
                    if (location$iv != null) {
                        JsAstProtoBuf.Location it;
                        String newFile$iv;
                        String lastFile$iv = this_$iv.getFileStack().peek();
                        boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
                        if (fileChanged$iv) {
                            int it2 = this_$iv.serialize(newFile$iv);
                            boolean bl2 = false;
                            entryBuilder.setFileId(it2);
                            this_$iv.getFileStack().push(location$iv.getFile());
                        }
                        JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
                        locationBuilder$iv.setStartLine(location$iv.getStartLine());
                        locationBuilder$iv.setStartChar(location$iv.getStartChar());
                        Intrinsics.checkNotNullExpressionValue((Object)locationBuilder$iv.build(), (String)"build(...)");
                        boolean bl3 = false;
                        entryBuilder.setLocation(it);
                    }
                    boolean bl = false;
                    if (fileChanged$iv) {
                        this_$iv.getFileStack().pop();
                    }
                    if (jsSwitchMember instanceof JsCase) {
                        JsExpression jsExpression2 = ((JsCase)jsSwitchMember).getCaseExpression();
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getCaseExpression(...)");
                        entryBuilder.setLabel(this.this$0.serialize(jsExpression2));
                    }
                    for (JsStatement part : jsSwitchMember.getStatements()) {
                        Intrinsics.checkNotNull((Object)part);
                        entryBuilder.addStatement(this.this$0.serialize(part));
                    }
                    switchBuilder.addEntry(entryBuilder);
                }
                this.builder.setSwitchStatement(switchBuilder.build());
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.While.Builder whileBuilder = JsAstProtoBuf.While.newBuilder();
                JsExpression jsExpression = x.getCondition();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getCondition(...)");
                whileBuilder.setCondition(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                whileBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setWhileStatement(whileBuilder.build());
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.DoWhile.Builder doWhileBuilder = JsAstProtoBuf.DoWhile.newBuilder();
                JsExpression jsExpression = x.getCondition();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getCondition(...)");
                doWhileBuilder.setCondition(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                doWhileBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setDoWhileStatement(doWhileBuilder.build());
            }

            public void visitFor(JsFor x) {
                JsStatement jsStatement;
                JsExpression it;
                JsAstSerializerBase jsAstSerializerBase;
                JsExpression jsExpression;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.For.Builder forBuilder = JsAstProtoBuf.For.newBuilder();
                if (x.getInitVars() != null) {
                    JsVars jsVars = x.getInitVars();
                    Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"getInitVars(...)");
                    forBuilder.setVariables(this.this$0.serialize(jsVars));
                } else if (x.getInitExpression() != null) {
                    JsExpression jsExpression2 = x.getInitExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getInitExpression(...)");
                    forBuilder.setExpression(this.this$0.serialize(jsExpression2));
                } else {
                    forBuilder.setEmpty(JsAstProtoBuf.EmptyInit.newBuilder().build());
                }
                JsExpression jsExpression3 = x.getCondition();
                if (jsExpression3 != null) {
                    jsExpression = jsExpression3;
                    jsAstSerializerBase = this.this$0;
                    it = jsExpression;
                    boolean bl = false;
                    forBuilder.setCondition(jsAstSerializerBase.serialize(it));
                }
                JsExpression jsExpression4 = x.getIncrementExpression();
                if (jsExpression4 != null) {
                    jsExpression = jsExpression4;
                    jsAstSerializerBase = this.this$0;
                    it = jsExpression;
                    boolean bl = false;
                    forBuilder.setIncrement(jsAstSerializerBase.serialize(it));
                }
                if ((jsStatement = x.getBody()) == null) {
                    jsStatement = JsEmpty.INSTANCE;
                }
                forBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setForStatement(forBuilder.build());
            }

            public void visitForIn(JsForIn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ForIn.Builder forInBuilder = JsAstProtoBuf.ForIn.newBuilder();
                if (x.getIterVarName() != null) {
                    JsName jsName = x.getIterVarName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getIterVarName(...)");
                    forInBuilder.setNameId(this.this$0.serialize(jsName));
                } else if (x.getIterExpression() != null) {
                    JsExpression jsExpression = x.getIterExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getIterExpression(...)");
                    forInBuilder.setExpression(this.this$0.serialize(jsExpression));
                }
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getObjectExpression(...)");
                forInBuilder.setIterable(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                forInBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setForInStatement(forInBuilder.build());
            }

            public void visitTry(JsTry x) {
                JsAstSerializerBase jsAstSerializerBase;
                SourceInfoAwareJsNode sourceInfoAwareJsNode;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Try.Builder tryBuilder = JsAstProtoBuf.Try.newBuilder();
                JsBlock jsBlock = x.getTryBlock();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getTryBlock(...)");
                tryBuilder.setTryBlock(this.this$0.serialize(jsBlock));
                List<JsCatch> list = x.getCatches();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCatches(...)");
                JsCatch jsCatch = (JsCatch)CollectionsKt.firstOrNull(list);
                if (jsCatch != null) {
                    sourceInfoAwareJsNode = jsCatch;
                    jsAstSerializerBase = this.this$0;
                    JsCatch c = sourceInfoAwareJsNode;
                    boolean bl = false;
                    JsAstProtoBuf.Catch.Builder catchBuilder = JsAstProtoBuf.Catch.newBuilder();
                    JsParameter jsParameter = c.getParameter();
                    Intrinsics.checkNotNullExpressionValue((Object)jsParameter, (String)"getParameter(...)");
                    catchBuilder.setParameter(jsAstSerializerBase.serializeParameter(jsParameter));
                    JsBlock jsBlock2 = c.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"getBody(...)");
                    catchBuilder.setBody(jsAstSerializerBase.serialize(jsBlock2));
                    tryBuilder.setCatchBlock(catchBuilder.build());
                }
                JsBlock jsBlock3 = x.getFinallyBlock();
                if (jsBlock3 != null) {
                    sourceInfoAwareJsNode = jsBlock3;
                    jsAstSerializerBase = this.this$0;
                    SourceInfoAwareJsNode it = sourceInfoAwareJsNode;
                    boolean bl = false;
                    tryBuilder.setFinallyBlock(jsAstSerializerBase.serialize((JsStatement)((Object)it)));
                }
                this.builder.setTryStatement(tryBuilder.build());
            }

            public void visitEmpty(JsEmpty x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setEmpty(JsAstProtoBuf.Empty.newBuilder().build());
            }

            public void visitSingleLineComment(JsSingleLineComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                this.builder.setSingleLineComment(JsAstProtoBuf.SingleLineComment.newBuilder().setMessage(comment.getText()).build());
            }

            public void visitMultiLineComment(JsMultiLineComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                this.builder.setMultiLineComment(JsAstProtoBuf.MultiLineComment.newBuilder().setMessage(comment.getText()).build());
            }
        };
        JsAstSerializerBase this_$iv = this;
        boolean $i$f$withComments = false;
        List<JsComment> list = ((JsNode)statement).getCommentsBeforeNode();
        if (list != null) {
            $this$forEach$iv$iv = list;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (JsComment)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it$iv);
                it = this_$iv.serialize(it$iv);
                boolean bl2 = false;
                visitor2.getBuilder().addBeforeComments(it);
            }
        }
        List<JsComment> list2 = ((JsNode)statement).getCommentsAfterNode();
        if (list2 != null) {
            $this$forEach$iv$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (JsComment)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it$iv);
                it = this_$iv.serialize(it$iv);
                boolean bl3 = false;
                visitor2.getBuilder().addAfterComments(it);
            }
        }
        boolean bl = false;
        JsAstSerializerBase this_$iv2 = this;
        boolean $i$f$withLocation = false;
        JsLocation location$iv = this_$iv2.extractLocation(statement);
        boolean fileChanged$iv = false;
        if (location$iv != null) {
            String newFile$iv;
            String lastFile$iv = this_$iv2.getFileStack().peek();
            boolean bl4 = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
            if (fileChanged$iv) {
                int it2 = this_$iv2.serialize(newFile$iv);
                boolean bl5 = false;
                visitor2.getBuilder().setFileId(it2);
                this_$iv2.getFileStack().push(location$iv.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
            locationBuilder$iv.setStartLine(location$iv.getStartLine());
            locationBuilder$iv.setStartChar(location$iv.getStartChar());
            JsAstProtoBuf.Location location = locationBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"build(...)");
            JsAstProtoBuf.Location it3 = location;
            boolean bl6 = false;
            visitor2.getBuilder().setLocation(it3);
        }
        boolean bl7 = false;
        statement.accept(visitor2);
        if (fileChanged$iv) {
            this_$iv2.getFileStack().pop();
        }
        if (statement instanceof HasMetadata && MetadataProperties.getSynthetic((HasMetadata)((Object)statement))) {
            visitor2.getBuilder().setSynthetic(true);
        }
        if (visitor2.getBuilder().getStatementCase() == JsAstProtoBuf.Statement.StatementCase.STATEMENT_NOT_SET) {
            throw new IllegalStateException(("Unknown statement type: " + Reflection.getOrCreateKotlinClass(statement.getClass()).getQualifiedName()).toString());
        }
        JsAstProtoBuf.Statement statement2 = visitor2.getBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"build(...)");
        return statement2;
    }

    @NotNull
    protected final JsAstProtoBuf.Expression serialize(@NotNull JsExpression expression2) {
        JsAstProtoBuf.Comment it;
        JsComment it$iv;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsVisitor visitor2 = new JsVisitor(this){
            private final JsAstProtoBuf.Expression.Builder builder;
            final /* synthetic */ JsAstSerializerBase this$0;
            {
                this.this$0 = $receiver;
                this.builder = JsAstProtoBuf.Expression.newBuilder();
            }

            public final JsAstProtoBuf.Expression.Builder getBuilder() {
                return this.builder;
            }

            public void visitThis(JsThisRef x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setThisLiteral(JsAstProtoBuf.ThisLiteral.newBuilder().build());
            }

            public void visitSuper(JsSuperRef x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setSuperLiteral(JsAstProtoBuf.SuperLiteral.newBuilder().build());
            }

            public void visitNull(JsNullLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setNullLiteral(JsAstProtoBuf.NullLiteral.newBuilder().build());
            }

            public void visitBoolean(JsBooleanLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.getValue()) {
                    this.builder.setTrueLiteral(JsAstProtoBuf.TrueLiteral.newBuilder().build());
                } else {
                    this.builder.setFalseLiteral(JsAstProtoBuf.FalseLiteral.newBuilder().build());
                }
            }

            public void visitString(JsStringLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                String string2 = x.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                this.builder.setStringLiteral(this.this$0.serialize(string2));
            }

            public void visitRegExp(JsRegExp x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.RegExpLiteral.Builder regExpBuilder = JsAstProtoBuf.RegExpLiteral.newBuilder();
                String string2 = x.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPattern(...)");
                regExpBuilder.setPatternStringId(this.this$0.serialize(string2));
                String string3 = x.getFlags();
                if (string3 != null) {
                    String string4 = string3;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    String it = string4;
                    boolean bl = false;
                    regExpBuilder.setFlagsStringId(jsAstSerializerBase.serialize(it));
                }
                this.builder.setRegExpLiteral(regExpBuilder.build());
            }

            public void visitInt(JsIntLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setIntLiteral(x.value);
            }

            public void visitDouble(JsDoubleLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setDoubleLiteral(x.value);
            }

            /*
             * WARNING - void declaration
             */
            public void visitArray(JsArrayLiteral x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ArrayLiteral.Builder arrayBuilder = JsAstProtoBuf.ArrayLiteral.newBuilder();
                List<JsExpression> list = x.getExpressions();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressions(...)");
                Iterable iterable = list;
                JsAstSerializerBase jsAstSerializerBase = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    arrayBuilder.addElement(jsAstSerializerBase.serialize(it));
                }
                this.builder.setArrayLiteral(arrayBuilder.build());
            }

            public void visitObjectLiteral(JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ObjectLiteral.Builder objectBuilder = JsAstProtoBuf.ObjectLiteral.newBuilder();
                for (JsPropertyInitializer initializer : x.getPropertyInitializers()) {
                    JsAstProtoBuf.ObjectLiteralEntry.Builder entryBuilder = JsAstProtoBuf.ObjectLiteralEntry.newBuilder();
                    JsExpression jsExpression = initializer.getLabelExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getLabelExpr(...)");
                    entryBuilder.setKey(this.this$0.serialize(jsExpression));
                    JsExpression jsExpression2 = initializer.getValueExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getValueExpr(...)");
                    entryBuilder.setValue(this.this$0.serialize(jsExpression2));
                    objectBuilder.addEntry(entryBuilder);
                }
                objectBuilder.setMultiline(x.isMultiline());
                this.builder.setObjectLiteral(objectBuilder.build());
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setFunction(this.this$0.serializeFunction(x));
            }

            /*
             * WARNING - void declaration
             */
            public void visitClass(JsClass x) {
                void $this$forEach$iv;
                JsName it;
                JsAstSerializerBase jsAstSerializerBase;
                Object object;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Class.Builder classBuilder = JsAstProtoBuf.Class.newBuilder();
                JsName jsName = x.getName();
                if (jsName != null) {
                    object = jsName;
                    jsAstSerializerBase = this.this$0;
                    it = object;
                    boolean bl = false;
                    classBuilder.setNameId(jsAstSerializerBase.serialize(it));
                }
                JsExpression jsExpression = x.getBaseClass();
                if (jsExpression != null) {
                    object = jsExpression;
                    jsAstSerializerBase = this.this$0;
                    it = object;
                    boolean bl = false;
                    classBuilder.setSuperExpression(jsAstSerializerBase.serialize((JsExpression)((Object)it)));
                }
                JsFunction jsFunction = x.getConstructor();
                if (jsFunction != null) {
                    object = jsFunction;
                    jsAstSerializerBase = this.this$0;
                    it = object;
                    boolean bl = false;
                    classBuilder.setConstructor(jsAstSerializerBase.serializeFunction((JsFunction)((Object)it)));
                }
                Iterable iterable = x.getMembers();
                object = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsFunction it2 = (JsFunction)element$iv;
                    boolean bl = false;
                    classBuilder.addMember(((JsAstSerializerBase)object).serializeFunction(it2));
                }
                this.builder.setClass_(classBuilder.build());
            }

            public void visitDocComment(JsDocComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                JsAstProtoBuf.DocComment.Builder commentBuilder = JsAstProtoBuf.DocComment.newBuilder();
                Map<String, Object> map = comment.getTags();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getTags(...)");
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String name2 = entry.getKey();
                    Object value2 = entry.getValue();
                    JsAstProtoBuf.DocCommentTag.Builder tagBuilder = JsAstProtoBuf.DocCommentTag.newBuilder();
                    Intrinsics.checkNotNull((Object)name2);
                    tagBuilder.setNameId(this.this$0.serialize(name2));
                    Object object = value2;
                    if (object instanceof JsNameRef) {
                        tagBuilder.setExpression(this.this$0.serialize((JsExpression)value2));
                    } else if (object instanceof String) {
                        tagBuilder.setValueStringId(this.this$0.serialize((String)value2));
                    }
                    commentBuilder.addTag(tagBuilder);
                }
                this.builder.setDocComment(commentBuilder.build());
            }

            public void visitBinaryExpression(JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.BinaryOperation.Builder binaryBuilder = JsAstProtoBuf.BinaryOperation.newBuilder();
                JsExpression jsExpression = x.getArg1();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getArg1(...)");
                binaryBuilder.setLeft(this.this$0.serialize(jsExpression));
                JsExpression jsExpression2 = x.getArg2();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getArg2(...)");
                binaryBuilder.setRight(this.this$0.serialize(jsExpression2));
                JsBinaryOperator jsBinaryOperator = x.getOperator();
                Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperator, (String)"getOperator(...)");
                binaryBuilder.setType(this.this$0.map(jsBinaryOperator));
                this.builder.setBinary(binaryBuilder.build());
            }

            public void visitPrefixOperation(JsPrefixOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setUnary(this.this$0.serializeUnary(x, false));
            }

            public void visitPostfixOperation(JsPostfixOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setUnary(this.this$0.serializeUnary(x, true));
            }

            public void visitConditional(JsConditional x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Conditional.Builder conditionalBuilder = JsAstProtoBuf.Conditional.newBuilder();
                JsExpression jsExpression = x.getTestExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getTestExpression(...)");
                conditionalBuilder.setTestExpression(this.this$0.serialize(jsExpression));
                JsExpression jsExpression2 = x.getThenExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getThenExpression(...)");
                conditionalBuilder.setThenExpression(this.this$0.serialize(jsExpression2));
                JsExpression jsExpression3 = x.getElseExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"getElseExpression(...)");
                conditionalBuilder.setElseExpression(this.this$0.serialize(jsExpression3));
                this.builder.setConditional(conditionalBuilder.build());
            }

            public void visitArrayAccess(JsArrayAccess x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ArrayAccess.Builder arrayAccessBuilder = JsAstProtoBuf.ArrayAccess.newBuilder();
                JsExpression jsExpression = x.getArrayExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getArrayExpression(...)");
                arrayAccessBuilder.setArray(this.this$0.serialize(jsExpression));
                JsExpression jsExpression2 = x.getIndexExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getIndexExpression(...)");
                arrayAccessBuilder.setIndex(this.this$0.serialize(jsExpression2));
                this.builder.setArrayAccess(arrayAccessBuilder.build());
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name2 = nameRef.getName();
                JsExpression qualifier = nameRef.getQualifier();
                if (name2 != null) {
                    if (qualifier != null || Intrinsics.areEqual((Object)MetadataProperties.isInline(nameRef), (Object)true)) {
                        JsAstProtoBuf.NameReference.Builder nameRefBuilder = JsAstProtoBuf.NameReference.newBuilder();
                        nameRefBuilder.setNameId(this.this$0.serialize(name2));
                        if (qualifier != null) {
                            nameRefBuilder.setQualifier(this.this$0.serialize(qualifier));
                        }
                        Boolean bl = MetadataProperties.isInline(nameRef);
                        if (bl != null) {
                            boolean it = bl;
                            boolean bl2 = false;
                            nameRefBuilder.setInlineStrategy(it ? JsAstProtoBuf.InlineStrategy.IN_PLACE : JsAstProtoBuf.InlineStrategy.NOT_INLINE);
                        }
                        this.builder.setNameReference(nameRefBuilder.build());
                    } else {
                        this.builder.setSimpleNameReference(this.this$0.serialize(name2));
                    }
                } else {
                    JsAstProtoBuf.PropertyReference.Builder propertyRefBuilder = JsAstProtoBuf.PropertyReference.newBuilder();
                    String string2 = nameRef.getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
                    propertyRefBuilder.setStringId(this.this$0.serialize(string2));
                    JsExpression jsExpression = qualifier;
                    if (jsExpression != null) {
                        JsExpression jsExpression2 = jsExpression;
                        JsAstSerializerBase jsAstSerializerBase = this.this$0;
                        JsExpression it = jsExpression2;
                        boolean bl = false;
                        propertyRefBuilder.setQualifier(jsAstSerializerBase.serialize(it));
                    }
                    Boolean bl = MetadataProperties.isInline(nameRef);
                    if (bl != null) {
                        boolean it = bl;
                        boolean bl3 = false;
                        propertyRefBuilder.setInlineStrategy(it ? JsAstProtoBuf.InlineStrategy.IN_PLACE : JsAstProtoBuf.InlineStrategy.NOT_INLINE);
                    }
                    this.builder.setPropertyReference(propertyRefBuilder.build());
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvocation(JsInvocation invocation) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                JsAstProtoBuf.Invocation.Builder invocationBuilder = JsAstProtoBuf.Invocation.newBuilder();
                JsExpression jsExpression = invocation.getQualifier();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getQualifier(...)");
                invocationBuilder.setQualifier(this.this$0.serialize(jsExpression));
                List<JsExpression> list = invocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                Iterable iterable = list;
                JsAstSerializerBase jsAstSerializerBase = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    invocationBuilder.addArgument(jsAstSerializerBase.serialize(it));
                }
                if (Intrinsics.areEqual((Object)MetadataProperties.isInline(invocation), (Object)true)) {
                    invocationBuilder.setInlineStrategy(JsAstProtoBuf.InlineStrategy.IN_PLACE);
                }
                this.builder.setInvocation(invocationBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visitNew(JsNew x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Instantiation.Builder instantiationBuilder = JsAstProtoBuf.Instantiation.newBuilder();
                JsExpression jsExpression = x.getConstructorExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getConstructorExpression(...)");
                instantiationBuilder.setQualifier(this.this$0.serialize(jsExpression));
                List<JsExpression> list = x.getArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                Iterable iterable = list;
                JsAstSerializerBase jsAstSerializerBase = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    instantiationBuilder.addArgument(jsAstSerializerBase.serialize(it));
                }
                this.builder.setInstantiation(instantiationBuilder.build());
            }
        };
        JsAstSerializerBase this_$iv = this;
        boolean $i$f$withComments = false;
        List<JsComment> list = ((JsNode)expression2).getCommentsBeforeNode();
        if (list != null) {
            $this$forEach$iv$iv = list;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (JsComment)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it$iv);
                it = this_$iv.serialize(it$iv);
                boolean bl2 = false;
                visitor2.getBuilder().addBeforeComments(it);
            }
        }
        List<JsComment> list2 = ((JsNode)expression2).getCommentsAfterNode();
        if (list2 != null) {
            $this$forEach$iv$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (JsComment)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it$iv);
                it = this_$iv.serialize(it$iv);
                boolean bl3 = false;
                visitor2.getBuilder().addAfterComments(it);
            }
        }
        boolean bl = false;
        JsAstSerializerBase this_$iv2 = this;
        boolean $i$f$withLocation = false;
        JsLocation location$iv = this_$iv2.extractLocation(expression2);
        boolean fileChanged$iv = false;
        if (location$iv != null) {
            String newFile$iv;
            String lastFile$iv = this_$iv2.getFileStack().peek();
            boolean bl4 = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
            if (fileChanged$iv) {
                int it2 = this_$iv2.serialize(newFile$iv);
                boolean bl5 = false;
                visitor2.getBuilder().setFileId(it2);
                this_$iv2.getFileStack().push(location$iv.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
            locationBuilder$iv.setStartLine(location$iv.getStartLine());
            locationBuilder$iv.setStartChar(location$iv.getStartChar());
            JsAstProtoBuf.Location location = locationBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"build(...)");
            JsAstProtoBuf.Location it3 = location;
            boolean bl6 = false;
            visitor2.getBuilder().setLocation(it3);
        }
        boolean bl7 = false;
        expression2.accept(visitor2);
        if (fileChanged$iv) {
            this_$iv2.getFileStack().pop();
        }
        JsAstProtoBuf.Expression.Builder $this$serialize_u24lambda_u2413 = visitor2.getBuilder();
        boolean bl8 = false;
        $this$serialize_u24lambda_u2413.setSynthetic(MetadataProperties.getSynthetic(expression2));
        $this$serialize_u24lambda_u2413.setSideEffects(this.map(MetadataProperties.getSideEffects(expression2)));
        JsImportedModule jsImportedModule = MetadataProperties.getLocalAlias(expression2);
        if (jsImportedModule != null) {
            JsImportedModule it4 = jsImportedModule;
            boolean bl9 = false;
            $this$serialize_u24lambda_u2413.setLocalAlias(this.serialize(it4));
        }
        JsAstProtoBuf.Expression expression3 = visitor2.getBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)expression3, (String)"build(...)");
        return expression3;
    }

    @NotNull
    protected final JsAstProtoBuf.JsImportedModule serialize(@NotNull JsImportedModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        JsAstProtoBuf.JsImportedModule.Builder moduleBuilder = JsAstProtoBuf.JsImportedModule.newBuilder();
        moduleBuilder.setExternalName(this.serialize(module2.getExternalName()));
        moduleBuilder.setInternalName(this.serialize(module2.getInternalName()));
        JsExpression jsExpression = module2.getPlainReference();
        if (jsExpression != null) {
            JsExpression it = jsExpression;
            boolean bl = false;
            moduleBuilder.setPlainReference(this.serialize(it));
        }
        JsAstProtoBuf.JsImportedModule jsImportedModule = moduleBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jsImportedModule, (String)"build(...)");
        return jsImportedModule;
    }

    @NotNull
    protected final JsAstProtoBuf.Parameter serializeParameter(@NotNull JsParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        JsAstProtoBuf.Parameter.Builder parameterBuilder = JsAstProtoBuf.Parameter.newBuilder();
        JsName jsName = parameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
        parameterBuilder.setNameId(this.serialize(jsName));
        if (MetadataProperties.getHasDefaultValue(parameter)) {
            parameterBuilder.setHasDefaultValue(true);
        }
        JsAstProtoBuf.Parameter parameter2 = parameterBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"build(...)");
        return parameter2;
    }

    @NotNull
    protected final JsAstProtoBuf.CompositeBlock serializeBlock(@NotNull JsCompositeBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        JsAstProtoBuf.CompositeBlock.Builder blockBuilder = JsAstProtoBuf.CompositeBlock.newBuilder();
        for (JsStatement part : block.getStatements()) {
            Intrinsics.checkNotNull((Object)part);
            blockBuilder.addStatement(this.serialize(part));
        }
        JsAstProtoBuf.CompositeBlock compositeBlock = blockBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"build(...)");
        return compositeBlock;
    }

    @NotNull
    protected final JsAstProtoBuf.Function serializeFunction(@NotNull JsFunction function2) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        JsAstProtoBuf.Function.Builder functionBuilder = JsAstProtoBuf.Function.newBuilder();
        List<JsParameter> list = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JsParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            functionBuilder.addParameter(this.serializeParameter((JsParameter)it));
        }
        Set<JsFunction.Modifier> set = function2.getModifiers();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getModifiers(...)");
        $this$forEach$iv = set;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JsFunction.Modifier)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            functionBuilder.addModifier(this.map((JsFunction.Modifier)((Object)it)));
        }
        JsName jsName = function2.getName();
        if (jsName != null) {
            JsName it2 = jsName;
            boolean bl = false;
            functionBuilder.setNameId(this.serialize(it2));
        }
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        functionBuilder.setBody(this.serialize(jsBlock));
        if (MetadataProperties.isLocal(function2)) {
            functionBuilder.setLocal(true);
        }
        if (function2.isEs6Arrow()) {
            functionBuilder.setIsEs6Arrow(true);
        }
        JsAstProtoBuf.Function function3 = functionBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)function3, (String)"build(...)");
        return function3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final JsAstProtoBuf.Vars serializeVars(@NotNull JsVars vars) {
        Intrinsics.checkNotNullParameter((Object)vars, (String)"vars");
        JsAstProtoBuf.Vars.Builder varsBuilder = JsAstProtoBuf.Vars.newBuilder();
        for (JsVars.JsVar varDecl : vars.getVars()) {
            void this_$iv;
            JsAstProtoBuf.VarDeclaration.Builder declBuilder = JsAstProtoBuf.VarDeclaration.newBuilder();
            JsAstSerializerBase jsAstSerializerBase = this;
            Intrinsics.checkNotNull((Object)varDecl);
            JsNode node$iv = varDecl;
            boolean $i$f$withLocation = false;
            JsLocation location$iv = this_$iv.extractLocation(node$iv);
            boolean fileChanged$iv = false;
            if (location$iv != null) {
                JsAstProtoBuf.Location it;
                String newFile$iv;
                String lastFile$iv = this_$iv.getFileStack().peek();
                boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
                if (fileChanged$iv) {
                    int it2 = this_$iv.serialize(newFile$iv);
                    boolean bl2 = false;
                    declBuilder.setFileId(it2);
                    this_$iv.getFileStack().push(location$iv.getFile());
                }
                JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
                locationBuilder$iv.setStartLine(location$iv.getStartLine());
                locationBuilder$iv.setStartChar(location$iv.getStartChar());
                Intrinsics.checkNotNullExpressionValue((Object)locationBuilder$iv.build(), (String)"build(...)");
                boolean bl3 = false;
                declBuilder.setLocation(it);
            }
            boolean bl = false;
            JsName jsName = varDecl.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            declBuilder.setNameId(this.serialize(jsName));
            if (varDecl.getInitExpression() != null) {
                JsExpression it;
                boolean bl4 = false;
                declBuilder.setInitialValue(this.serialize(it));
            }
            if (fileChanged$iv) {
                this_$iv.getFileStack().pop();
            }
            varsBuilder.addDeclaration(declBuilder);
        }
        if (vars.isMultiline()) {
            varsBuilder.setMultiline(true);
        }
        String string2 = MetadataProperties.getExportedPackage(vars);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            varsBuilder.setExportedPackageId(this.serialize(it));
        }
        JsAstProtoBuf.Vars vars2 = varsBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)vars2, (String)"build(...)");
        return vars2;
    }

    @NotNull
    protected final JsAstProtoBuf.UnaryOperation serializeUnary(@NotNull JsUnaryOperation x, boolean postfix) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsAstProtoBuf.UnaryOperation.Builder unaryBuilder = JsAstProtoBuf.UnaryOperation.newBuilder();
        JsExpression jsExpression = x.getArg();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getArg(...)");
        unaryBuilder.setOperand(this.serialize(jsExpression));
        JsUnaryOperator jsUnaryOperator = x.getOperator();
        Intrinsics.checkNotNullExpressionValue((Object)jsUnaryOperator, (String)"getOperator(...)");
        unaryBuilder.setType(this.map(jsUnaryOperator));
        unaryBuilder.setPostfix(postfix);
        JsAstProtoBuf.UnaryOperation unaryOperation = unaryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)unaryOperation, (String)"build(...)");
        return unaryOperation;
    }

    @NotNull
    protected final JsAstProtoBuf.Function.Modifier map(@NotNull JsFunction.Modifier modifier) {
        JsAstProtoBuf.Function.Modifier modifier2;
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        switch (WhenMappings.$EnumSwitchMapping$0[modifier.ordinal()]) {
            case 1: {
                modifier2 = JsAstProtoBuf.Function.Modifier.STATIC;
                break;
            }
            case 2: {
                modifier2 = JsAstProtoBuf.Function.Modifier.SET;
                break;
            }
            case 3: {
                modifier2 = JsAstProtoBuf.Function.Modifier.GET;
                break;
            }
            case 4: {
                modifier2 = JsAstProtoBuf.Function.Modifier.GENERATOR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return modifier2;
    }

    @NotNull
    protected final JsAstProtoBuf.BinaryOperation.Type map(@NotNull JsBinaryOperator op) {
        JsAstProtoBuf.BinaryOperation.Type type2;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        switch (WhenMappings.$EnumSwitchMapping$1[op.ordinal()]) {
            case 1: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.MUL;
                break;
            }
            case 2: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.DIV;
                break;
            }
            case 3: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.MOD;
                break;
            }
            case 4: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ADD;
                break;
            }
            case 5: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SUB;
                break;
            }
            case 6: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHL;
                break;
            }
            case 7: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHR;
                break;
            }
            case 8: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHRU;
                break;
            }
            case 9: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.LT;
                break;
            }
            case 10: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.LTE;
                break;
            }
            case 11: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.GT;
                break;
            }
            case 12: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.GTE;
                break;
            }
            case 13: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.INSTANCEOF;
                break;
            }
            case 14: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.IN;
                break;
            }
            case 15: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.EQ;
                break;
            }
            case 16: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.NEQ;
                break;
            }
            case 17: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.REF_EQ;
                break;
            }
            case 18: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.REF_NEQ;
                break;
            }
            case 19: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_AND;
                break;
            }
            case 20: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_XOR;
                break;
            }
            case 21: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_OR;
                break;
            }
            case 22: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.AND;
                break;
            }
            case 23: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.OR;
                break;
            }
            case 24: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG;
                break;
            }
            case 25: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_ADD;
                break;
            }
            case 26: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SUB;
                break;
            }
            case 27: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_MUL;
                break;
            }
            case 28: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_DIV;
                break;
            }
            case 29: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_MOD;
                break;
            }
            case 30: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHL;
                break;
            }
            case 31: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHR;
                break;
            }
            case 32: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHRU;
                break;
            }
            case 33: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_AND;
                break;
            }
            case 34: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_OR;
                break;
            }
            case 35: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_XOR;
                break;
            }
            case 36: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.COMMA;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    @NotNull
    protected final JsAstProtoBuf.UnaryOperation.Type map(@NotNull JsUnaryOperator op) {
        JsAstProtoBuf.UnaryOperation.Type type2;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        switch (WhenMappings.$EnumSwitchMapping$2[op.ordinal()]) {
            case 1: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.BIT_NOT;
                break;
            }
            case 2: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.DEC;
                break;
            }
            case 3: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.DELETE;
                break;
            }
            case 4: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.INC;
                break;
            }
            case 5: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.NEG;
                break;
            }
            case 6: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.POS;
                break;
            }
            case 7: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.NOT;
                break;
            }
            case 8: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.TYPEOF;
                break;
            }
            case 9: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.VOID;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    @NotNull
    protected final JsAstProtoBuf.SideEffects map(@NotNull SideEffectKind sideEffects) {
        JsAstProtoBuf.SideEffects sideEffects2;
        Intrinsics.checkNotNullParameter((Object)((Object)sideEffects), (String)"sideEffects");
        switch (WhenMappings.$EnumSwitchMapping$3[sideEffects.ordinal()]) {
            case 1: {
                sideEffects2 = JsAstProtoBuf.SideEffects.AFFECTS_STATE;
                break;
            }
            case 2: {
                sideEffects2 = JsAstProtoBuf.SideEffects.DEPENDS_ON_STATE;
                break;
            }
            case 3: {
                sideEffects2 = JsAstProtoBuf.SideEffects.PURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sideEffects2;
    }

    @NotNull
    protected final JsAstProtoBuf.SpecialFunction map(@NotNull SpecialFunction specialFunction) {
        JsAstProtoBuf.SpecialFunction specialFunction2;
        Intrinsics.checkNotNullParameter((Object)((Object)specialFunction), (String)"specialFunction");
        switch (WhenMappings.$EnumSwitchMapping$4[specialFunction.ordinal()]) {
            case 1: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.DEFINE_INLINE_FUNCTION;
                break;
            }
            case 2: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.WRAP_FUNCTION;
                break;
            }
            case 3: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.TO_BOXED_CHAR;
                break;
            }
            case 4: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.UNBOX_CHAR;
                break;
            }
            case 5: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.SUSPEND_CALL;
                break;
            }
            case 6: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_RESULT;
                break;
            }
            case 7: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_CONTROLLER;
                break;
            }
            case 8: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_RECEIVER;
                break;
            }
            case 9: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.SET_COROUTINE_RESULT;
                break;
            }
            case 10: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.GET_KCLASS;
                break;
            }
            case 11: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return specialFunction2;
    }

    protected final int serialize(@NotNull JsName name2) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Map<JsName, Integer> $this$getOrPut$iv = this.nameMap;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            Object it;
            boolean bl = false;
            JsAstProtoBuf.Name.Builder builder = JsAstProtoBuf.Name.newBuilder();
            String string2 = name2.getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
            builder.setIdentifier(this.serialize(string2));
            builder.setTemporary(name2.isTemporary());
            LocalAlias localAlias = MetadataProperties.getLocalAlias(name2);
            if (localAlias != null) {
                it = localAlias;
                boolean bl2 = false;
                builder.setLocalNameId(this.serialize((LocalAlias)it));
            }
            if (MetadataProperties.getImported(name2) && !this.importedNames.contains(name2)) {
                builder.setImported(true);
            }
            SpecialFunction specialFunction = MetadataProperties.getSpecialFunction(name2);
            if (specialFunction != null) {
                it = specialFunction;
                boolean bl3 = false;
                builder.setSpecialFunction(this.map((SpecialFunction)((Object)it)));
            }
            int result2 = this.nameTableBuilder.getEntryCount();
            this.nameTableBuilder.addEntry(builder);
            Integer answer$iv = result2;
            $this$getOrPut$iv.put(name2, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    @NotNull
    protected final JsAstProtoBuf.LocalAlias serialize(@NotNull LocalAlias alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        JsAstProtoBuf.LocalAlias.Builder builder = JsAstProtoBuf.LocalAlias.newBuilder();
        builder.setLocalNameId(this.serialize(alias.getName()));
        String string2 = alias.getTag();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            builder.setTag(this.serialize(it));
        }
        JsAstProtoBuf.LocalAlias localAlias = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)localAlias, (String)"build(...)");
        return localAlias;
    }

    protected final int serialize(@NotNull String string2) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Map<String, Integer> $this$getOrPut$iv = this.stringMap;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(string2);
        if (value$iv == null) {
            boolean bl = false;
            int result2 = this.stringTableBuilder.getEntryCount();
            this.stringTableBuilder.addEntry(string2);
            Integer answer$iv = result2;
            $this$getOrPut$iv.put(string2, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    @NotNull
    protected final JsAstProtoBuf.Comment serialize(@NotNull JsComment comment) {
        boolean bl;
        JsAstProtoBuf.Comment.Builder builder;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        JsAstProtoBuf.Comment.Builder $this$serialize_u24lambda_u2428 = builder = JsAstProtoBuf.Comment.newBuilder();
        boolean bl2 = false;
        $this$serialize_u24lambda_u2428.setText(comment.getText());
        JsComment jsComment = comment;
        if (jsComment instanceof JsSingleLineComment) {
            bl = false;
        } else if (jsComment instanceof JsMultiLineComment) {
            bl = true;
        } else {
            throw new IllegalStateException(("Unknown type of comment " + comment.getClass().getName()).toString());
        }
        $this$serialize_u24lambda_u2428.setMultiline(bl);
        JsAstProtoBuf.Comment.Builder builder2 = builder;
        JsAstProtoBuf.Comment comment2 = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)comment2, (String)"build(...)");
        return comment2;
    }

    @Nullable
    public abstract JsLocation extractLocation(@NotNull JsNode var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[JsFunction.Modifier.values().length];
            try {
                nArray[JsFunction.Modifier.STATIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsFunction.Modifier.SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsFunction.Modifier.GET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsFunction.Modifier.GENERATOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JsBinaryOperator.values().length];
            try {
                nArray[JsBinaryOperator.MUL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.DIV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.MOD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ADD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.SUB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.SHL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.SHR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.SHRU.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.LT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.LTE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.GT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.GTE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.INSTANCEOF.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.INOP.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.EQ.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.NEQ.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.REF_EQ.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.REF_NEQ.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.BIT_AND.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.BIT_XOR.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.BIT_OR.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.AND.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.OR.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_ADD.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_SUB.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_MUL.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_DIV.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_MOD.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_SHL.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_SHR.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_SHRU.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_BIT_AND.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_BIT_OR.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.ASG_BIT_XOR.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsBinaryOperator.COMMA.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[JsUnaryOperator.values().length];
            try {
                nArray[JsUnaryOperator.BIT_NOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.DEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.INC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.NEG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.POS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.NOT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.TYPEOF.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsUnaryOperator.VOID.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[SideEffectKind.values().length];
            try {
                nArray[SideEffectKind.AFFECTS_STATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SideEffectKind.DEPENDS_ON_STATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SideEffectKind.PURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[SpecialFunction.values().length];
            try {
                nArray[SpecialFunction.DEFINE_INLINE_FUNCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.WRAP_FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.TO_BOXED_CHAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.UNBOX_CHAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.SUSPEND_CALL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.COROUTINE_RESULT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.COROUTINE_CONTROLLER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.COROUTINE_RECEIVER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.SET_COROUTINE_RESULT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.GET_KCLASS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

