/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0002)*B'\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u000b*\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J\u0014\u0010\u001a\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J6\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001cH\u0002J \u0010#\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%H\u0002J4\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050%2\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "removeLastUndefinedArguments", "", "result", "", "hasSpreadElementOrNamedArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "translateUnresolvedArguments", "", "typeToUTypeArray", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "wrapInUArray", "elementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "translateVarargArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "shouldWrapVarargInArray", "varargElementType", "toArray", "elements", "", "prepareConcatArguments", "arguments", "list", "ArgumentsInfo", "Companion", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCallArgumentTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallArgumentTranslator.kt\norg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,381:1\n1755#2,3:382\n1557#2:389\n1628#2,3:390\n1187#2,2:396\n1261#2,4:398\n1187#2,2:402\n1261#2,4:404\n1187#2,2:408\n1261#2,4:410\n1368#2:414\n1454#2,5:415\n1187#2,2:420\n1261#2,4:422\n2632#2,3:426\n1755#2,3:429\n1863#2,2:436\n1#3:385\n77#4:386\n97#4,2:387\n99#4,3:393\n126#4:432\n153#4,3:433\n*S KotlinDebug\n*F\n+ 1 CallArgumentTranslator.kt\norg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator\n*L\n101#1:382,3\n178#1:389\n178#1:390,3\n179#1:396,2\n179#1:398,4\n181#1:402,2\n181#1:404,4\n183#1:408,2\n183#1:410,4\n200#1:414\n200#1:415,5\n202#1:420,2\n202#1:422,4\n203#1:426,3\n205#1:429,3\n212#1:436,2\n178#1:386\n178#1:387,2\n178#1:393,3\n206#1:432\n206#1:433,3\n*E\n"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final TranslationContext context;
    private final boolean isNativeFunctionCall;
    @NotNull
    private final Map<PrimitiveType, ClassDescriptor> typeToUTypeArray;

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall2, JsExpression receiver, TranslationContext context) {
        super(context);
        this.resolvedCall = resolvedCall2;
        this.receiver = receiver;
        this.context = context;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
        this.typeToUTypeArray = new LinkedHashMap();
    }

    private final void removeLastUndefinedArguments(List<JsExpression> result2) {
        int i;
        for (i = CollectionsKt.getLastIndex(result2); i >= 0 && JsAstUtils.isUndefinedExpression(result2.get(i)); --i) {
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private final boolean hasSpreadElementOrNamedArgument(ValueArgument $this$hasSpreadElementOrNamedArgument) {
        return $this$hasSpreadElementOrNamedArgument.getSpreadElement() != null || this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions) && $this$hasSpreadElementOrNamedArgument.isNamed();
    }

    private final ArgumentsInfo translate() {
        List<ValueParameterDescriptor> list = this.resolvedCall.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> valueParameters = list;
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List<JsNameRef> result2 = null;
        result2 = new ArrayList(valueParameters.size());
        List<ResolvedValueArgument> list2 = this.resolvedCall.getValueArgumentsByIndex();
        if (list2 == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        List<ResolvedValueArgument> valueArgumentsByIndex = list2;
        List argsBeforeVararg = null;
        List<JsExpression> concatArguments = null;
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        Map<ValueArgument, JsExpression> argsToJsExpr = this.translateUnresolvedArguments(translationContext, this.resolvedCall);
        KotlinType varargElementType = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                JsExpression it;
                List<ValueArgument> arguments;
                Intrinsics.checkNotNullExpressionValue(((VarargValueArgument)actualArgument).getArguments(), (String)"getArguments(...)");
                if (!hasSpreadOperator) {
                    boolean bl;
                    block20: {
                        Iterable $this$any$iv = arguments;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ValueArgument it2 = (ValueArgument)element$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNull((Object)it2);
                                if (!this.hasSpreadElementOrNamedArgument(it2)) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    hasSpreadOperator = bl;
                }
                Intrinsics.checkNotNull((Object)parameterDescriptor.getOriginal().getVarargElementType());
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result2;
                        result2 = new ArrayList();
                        concatArguments = this.prepareConcatArguments(arguments, CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr), null);
                        continue;
                    }
                    JsExpression jsExpression = this.translateVarargArgument(actualArgument, argsToJsExpr, ((VarargValueArgument)actualArgument).getArguments().size() > 1, varargElementType);
                    if (jsExpression == null) continue;
                    it = jsExpression;
                    boolean bl = false;
                    ((List)result2).add(it);
                    continue;
                }
                if (this.isNativeFunctionCall) {
                    ((List)result2).addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
                    continue;
                }
                if (this.translateVarargArgument(actualArgument, argsToJsExpr, true, varargElementType) == null) continue;
                boolean bl = false;
                ((List)result2).add(it);
                continue;
            }
            List list3 = result2;
            Intrinsics.checkNotNull((Object)actualArgument);
            list3.addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            boolean bl;
            boolean bl3 = bl = argsBeforeVararg != null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallArgumentTranslator$translate$62 = false;
                String $i$a$-assert-CallArgumentTranslator$translate$62 = "argsBeforeVararg should not be null";
                throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$translate$62);
            }
            boolean bl4 = bl = concatArguments != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string2 = "concatArguments should not be null";
                throw new AssertionError((Object)string2);
            }
            if (!((List)result2).isEmpty()) {
                List<JsExpression> list4 = concatArguments;
                Intrinsics.checkNotNull(list4);
                list4.add(this.toArray(null, (List<? extends JsExpression>)result2));
            }
            List list5 = argsBeforeVararg;
            Intrinsics.checkNotNull(list5);
            if (!list5.isEmpty()) {
                List<JsExpression> list6 = concatArguments;
                Intrinsics.checkNotNull(list6);
                list6.add(0, this.toArray(null, argsBeforeVararg));
            }
            Object[] objectArray = new JsExpression[1];
            List<JsExpression> list7 = concatArguments;
            Intrinsics.checkNotNull((Object)list7);
            objectArray[0] = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(list7, varargElementType, true);
            result2 = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                JsNameRef jsNameRef = cachedReceiver.reference();
                Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"reference(...)");
                result2.add(0, jsNameRef);
            } else if (DescriptorUtils.isObject(this.resolvedCall.getResultingDescriptor().getContainingDeclaration())) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(ReferenceTranslator.translateAsValueReference(this.resolvedCall.getResultingDescriptor().getContainingDeclaration(), this.context()));
                JsNameRef jsNameRef = cachedReceiver.reference();
                Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"reference(...)");
                result2.add(0, jsNameRef);
            } else {
                result2.add(0, (JsNameRef)((Object)new JsNullLiteral()));
            }
        }
        Object obj = this.resolvedCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object callableDescriptor = obj;
        if (callableDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)callableDescriptor).isSuspend()) {
            List list8 = result2;
            JsExpression jsExpression = TranslationUtils.translateContinuationArgument(this.context());
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateContinuationArgument(...)");
            list8.add(jsExpression);
        }
        this.removeLastUndefinedArguments((List<JsExpression>)result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ValueArgument, JsExpression> translateUnresolvedArguments(TranslationContext context, ResolvedCall<?> resolvedCall2) {
        boolean bl;
        boolean argumentsAreOrdered;
        Object destination$iv$iv;
        Map result2;
        Map argumentContexts;
        block22: {
            boolean bl2;
            block21: {
                void $this$associate$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                void $this$associateTo$iv$iv2;
                void $this$associateTo$iv$iv3;
                void $this$associateTo$iv$iv4;
                void $this$associate$iv2;
                Object param;
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2;
                Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = map;
                boolean $i$f$flatMap = false;
                void var6_6 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $this$mapTo$iv$iv;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator2.next();
                    boolean bl3 = false;
                    param = (ValueParameterDescriptor)entry2.getKey();
                    ResolvedValueArgument args = (ResolvedValueArgument)entry2.getValue();
                    List<ValueArgument> list = args.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl4 = false;
                        collection.add(TuplesKt.to((Object)param, (Object)it));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv2 = (List)destination$iv$iv2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                destination$iv$iv2 = $this$associate$iv2;
                Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv3 : $this$associateTo$iv$iv4) {
                    Map bl3 = destination$iv$iv4;
                    param = (Pair)element$iv$iv3;
                    boolean bl5 = false;
                    ValueParameterDescriptor param2 = (ValueParameterDescriptor)param.component1();
                    ValueArgument arg = (ValueArgument)param.component2();
                    param = TuplesKt.to((Object)arg, (Object)param2);
                    bl3.put(param.getFirst(), param.getSecond());
                }
                Map argsToParameters = destination$iv$iv4;
                List<? extends ValueArgument> list = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueArguments(...)");
                Iterable $this$associate$iv3 = list;
                boolean $i$f$associate2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv3, (int)10)), (int)16);
                destination$iv$iv4 = $this$associate$iv3;
                Object destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
                boolean bl3 = false;
                for (Object element$iv$iv4 : $this$associateTo$iv$iv3) {
                    param = destination$iv$iv5;
                    ValueArgument it2 = (ValueArgument)element$iv$iv4;
                    boolean bl6 = false;
                    it2 = TuplesKt.to((Object)it2, (Object)context.innerBlock());
                    param.put(it2.getFirst(), it2.getSecond());
                }
                argumentContexts = destination$iv$iv5;
                List<? extends ValueArgument> list2 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueArguments(...)");
                Iterable $this$associate$iv4 = list2;
                boolean $i$f$associate2232 = false;
                int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv4, (int)10)), (int)16);
                destination$iv$iv5 = $this$associate$iv4;
                Map map3 = new LinkedHashMap(capacity$iv3);
                boolean $i$f$associateTo3 = false;
                for (Object element$iv$iv5 : $this$associateTo$iv$iv2) {
                    JsExpression argJs;
                    KotlinType kotlinType;
                    Object it;
                    Map it2 = map3;
                    ValueArgument arg = (ValueArgument)element$iv$iv5;
                    boolean bl7 = false;
                    Object v = argumentContexts.get(arg);
                    Intrinsics.checkNotNull(v);
                    TranslationContext argumentContext = (TranslationContext)v;
                    KtExpression parenthisedArgumentExpression = arg.getArgumentExpression();
                    Object v2 = argsToParameters.get(arg);
                    Intrinsics.checkNotNull(v2);
                    ValueParameterDescriptor param3 = ((ValueParameterDescriptor)v2).getOriginal();
                    Intrinsics.checkNotNullExpressionValue(resolvedCall2.getResultingDescriptor(), (String)"getResultingDescriptor(...)");
                    boolean bl8 = false;
                    boolean isLambda = FunctionTypesKt.getFunctionTypeKind((DeclarationDescriptor)it) != null || it instanceof FunctionInvokeDescriptor;
                    if (!isLambda) {
                        kotlinType = param3.getVarargElementType();
                        if (kotlinType == null) {
                            KotlinType kotlinType2 = param3.getType();
                            kotlinType = kotlinType2;
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                        }
                    } else {
                        SimpleType simpleType = context.getCurrentModule().getBuiltIns().getAnyType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getAnyType(...)");
                        kotlinType = simpleType;
                    }
                    KotlinType parameterType = kotlinType;
                    KtExpression ktExpression = parenthisedArgumentExpression;
                    Intrinsics.checkNotNull((Object)ktExpression);
                    Intrinsics.checkNotNullExpressionValue((Object)Translation.translateAsExpression(ktExpression, argumentContext), (String)"translateAsExpression(...)");
                    if (!ArgumentsUtilsKt.isVararg(param3) || arg.getSpreadElement() == null) {
                        argJs = TranslationUtils.coerce(context, argJs, parameterType);
                    }
                    Pair pair = TuplesKt.to((Object)arg, (Object)argJs);
                    it2.put(pair.getFirst(), pair.getSecond());
                }
                result2 = map3;
                List list3 = resolvedCall2.getValueArgumentsByIndex();
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable $i$f$associate2232 = list3;
                boolean $i$f$flatMap2 = false;
                $this$associateTo$iv$iv2 = $this$flatMap$iv;
                Collection collection = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
                    boolean bl9 = false;
                    List<ValueArgument> list4 = it.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"getArguments(...)");
                    Iterable list$iv$iv = list4;
                    CollectionsKt.addAll((Collection)collection, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = CollectionsKt.withIndex((Iterable)((List)collection));
                boolean $i$f$associate3 = false;
                int capacity$iv4 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var10_26 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap(capacity$iv4);
                boolean $i$f$associateTo422 = false;
                for (Object element$iv$iv6 : var10_26) {
                    Map bl9 = destination$iv$iv;
                    IndexedValue bl7 = (IndexedValue)element$iv$iv6;
                    boolean bl10 = false;
                    int index = bl7.component1();
                    ValueArgument arg = (ValueArgument)bl7.component2();
                    bl7 = TuplesKt.to((Object)arg, (Object)index);
                    bl9.put(bl7.getFirst(), bl7.getSecond());
                }
                Map resolvedOrder = destination$iv$iv;
                List<? extends ValueArgument> list5 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"getValueArguments(...)");
                Iterable $this$none$iv = CollectionsKt.withIndex((Iterable)list5);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IndexedValue $i$f$associateTo422 = (IndexedValue)element$iv;
                        boolean bl11 = false;
                        int index = $i$f$associateTo422.component1();
                        ValueArgument arg = (ValueArgument)$i$f$associateTo422.component2();
                        Integer n = (Integer)resolvedOrder.get(arg);
                        int bl7 = index;
                        if (!(n == null || n != bl7)) continue;
                        bl2 = false;
                        break block21;
                    }
                    bl2 = true;
                }
            }
            argumentsAreOrdered = bl2;
            Iterable $this$any$iv = argumentContexts.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TranslationContext it = (TranslationContext)element$iv;
                    boolean bl12 = false;
                    if (!(!it.currentBlockIsEmpty())) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        if (bl || !argumentsAreOrdered) {
            Map $this$map$iv = result2;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator bl12 = map.entrySet().iterator();
            while (bl12.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = bl12.next();
                Object object = destination$iv$iv;
                boolean bl13 = false;
                ValueArgument arg = (ValueArgument)entry.getKey();
                JsExpression expr = (JsExpression)entry.getValue();
                Object v = argumentContexts.get(arg);
                Intrinsics.checkNotNull(v);
                TranslationContext argumentContext = (TranslationContext)v;
                object.add(TuplesKt.to((Object)arg, (Object)argumentContext.cacheExpressionIfNeeded(expr)));
            }
            result2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        Iterable $this$forEach$iv = argumentContexts.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TranslationContext it = (TranslationContext)element$iv;
            boolean bl14 = false;
            context.moveVarsFrom(it);
            context.addStatementsToCurrentBlockFrom(it);
        }
        return result2;
    }

    private final JsExpression wrapInUArray(JsExpression $this$wrapInUArray, KotlinType elementType) {
        JsExpression jsExpression;
        PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(elementType);
        if (primitiveType != null) {
            PrimitiveType primitiveType2 = primitiveType;
            boolean bl = false;
            MemberScope kotlinMemberScope = this.context.getCurrentModule().getPackage(new FqNameUnsafe("kotlin").toSafe()).getMemberScope();
            ClassDescriptor classDescriptor = this.typeToUTypeArray.computeIfAbsent(primitiveType2, arg_0 -> CallArgumentTranslator.wrapInUArray$lambda$19$lambda$18(arg_0 -> CallArgumentTranslator.wrapInUArray$lambda$19$lambda$17(primitiveType2, kotlinMemberScope, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"computeIfAbsent(...)");
            ClassDescriptor classDescriptor2 = classDescriptor;
            jsExpression = new JsNew(ReferenceTranslator.translateAsTypeReference(classDescriptor2, this.context), CollectionsKt.listOf((Object)$this$wrapInUArray));
        } else {
            jsExpression = $this$wrapInUArray;
        }
        return jsExpression;
    }

    private final JsExpression translateVarargArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs, boolean shouldWrapVarargInArray, KotlinType varargElementType) {
        JsExpression jsExpression;
        List<ValueArgument> list = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        List<ValueArgument> arguments = list;
        if (arguments.isEmpty()) {
            if (shouldWrapVarargInArray) {
                return this.wrapInUArray(this.toArray(varargElementType, new ArrayList()), varargElementType);
            }
            return null;
        }
        List list2 = CallArgumentTranslator.Companion.translateResolvedArgument(resolvedArgument, translatedArgs);
        CallArgumentTranslator callArgumentTranslator = this;
        if (shouldWrapVarargInArray) {
            JsExpression concatExpression;
            List<JsExpression> concatArguments = this.prepareConcatArguments(arguments, list2, varargElementType);
            jsExpression = concatExpression = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments, varargElementType, false);
        } else {
            JsExpression jsExpression2;
            if (ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null) {
                CallArgumentTranslator callArgumentTranslator2 = callArgumentTranslator;
                boolean bl = false;
                callArgumentTranslator = callArgumentTranslator2;
                jsExpression2 = new JsInvocation((JsExpression)new JsNameRef("unbox", (JsExpression)list2.get(0)), new JsExpression[0]);
            } else {
                jsExpression2 = (JsExpression)list2.get(0);
            }
            JsExpression arg = jsExpression2;
            JsInvocation jsInvocation = JsAstUtils.invokeMethod(arg, "slice", new JsExpression[0]);
            Intrinsics.checkNotNull((Object)jsInvocation);
            jsExpression = jsInvocation;
        }
        return callArgumentTranslator.wrapInUArray(jsExpression, varargElementType);
    }

    private final JsExpression toArray(KotlinType varargElementType, List<? extends JsExpression> elements) {
        JsArrayLiteral jsArrayLiteral;
        JsArrayLiteral $this$toArray_u24lambda_u2421 = jsArrayLiteral = new JsArrayLiteral(elements);
        boolean bl = false;
        MetadataProperties.setSideEffects($this$toArray_u24lambda_u2421, SideEffectKind.PURE);
        JsArrayLiteral argument = jsArrayLiteral;
        if (varargElementType == null) {
            return argument;
        }
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        return ArrayFIF.INSTANCE.castOrCreatePrimitiveArray(translationContext, varargElementType, argument);
    }

    private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments, List<? extends JsExpression> list, KotlinType varargElementType) {
        boolean bl;
        boolean bl2 = bl = !((Collection)arguments).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = "arguments.size should not be 0";
            throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32);
        }
        boolean bl3 = bl = arguments.size() == list.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = "arguments.size: " + arguments.size() + " != list.size: " + list.size();
            throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42);
        }
        List concatArguments = new ArrayList();
        List lastArrayContent = new ArrayList();
        int size = arguments.size();
        for (int index = 0; index < size; ++index) {
            boolean bl4;
            ValueArgument valueArgument = arguments.get(index);
            JsExpression expressionArgument = list.get(index);
            if (this.hasSpreadElementOrNamedArgument(valueArgument)) {
                if (lastArrayContent.size() > 0) {
                    concatArguments.add(this.toArray(varargElementType, lastArrayContent));
                    lastArrayContent = new ArrayList();
                }
                JsExpression e = varargElementType != null && ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("unbox", expressionArgument), new JsExpression[0]) : expressionArgument;
                bl4 = concatArguments.add(e);
                continue;
            }
            bl4 = lastArrayContent.add(expressionArgument);
        }
        if (lastArrayContent.size() > 0) {
            concatArguments.add(this.toArray(varargElementType, lastArrayContent));
        }
        return concatArguments;
    }

    private static final ClassDescriptor wrapInUArray$lambda$19$lambda$17(PrimitiveType $primitiveType, MemberScope $kotlinMemberScope, PrimitiveType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Name name2 = Name.identifier("" + 'U' + $primitiveType.getTypeName() + "Array");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name className = name2;
        ClassifierDescriptor classifierDescriptor = $kotlinMemberScope.getContributedClassifier(className, NoLookupLocation.FROM_BACKEND);
        Intrinsics.checkNotNull((Object)classifierDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        return (ClassDescriptor)classifierDescriptor;
    }

    private static final ClassDescriptor wrapInUArray$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        return (ClassDescriptor)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        return Companion.translate(resolvedCall2, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
        return Companion.translate(resolvedCall2, receiver, context, block);
    }

    public /* synthetic */ CallArgumentTranslator(ResolvedCall resolvedCall2, JsExpression receiver, TranslationContext context, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall2, receiver, context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "<init>", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getValueArguments", "()Ljava/util/List;", "getHasSpreadOperator", "()Z", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getReifiedArguments", "translateArguments", "getTranslateArguments", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "js.translator"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
            Intrinsics.checkNotNullParameter(reifiedArguments, (String)"reifiedArguments");
            this.valueArguments = valueArguments;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list, boolean bl, TemporaryConstVariable temporaryConstVariable, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, bl, temporaryConstVariable, list2);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
            Intrinsics.checkNotNullParameter(reifiedArguments, (String)"reifiedArguments");
            return new ArgumentsInfo(valueArguments, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        public static /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list, boolean bl, TemporaryConstVariable temporaryConstVariable, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list2 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list, bl, temporaryConstVariable, list2);
        }

        @NotNull
        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.valueArguments).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasSpreadOperator);
            result2 = result2 * 31 + (this.cachedReceiver == null ? 0 : this.cachedReceiver.hashCode());
            result2 = result2 * 31 + ((Object)this.reifiedArguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentsInfo)) {
                return false;
            }
            ArgumentsInfo argumentsInfo = (ArgumentsInfo)other;
            if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments)) {
                return false;
            }
            if (this.hasSpreadOperator != argumentsInfo.hasSpreadOperator) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cachedReceiver, (Object)argumentsInfo.cachedReceiver)) {
                return false;
            }
            return Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J.\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u0013H\u0002J(\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "<init>", "()V", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateResolvedArgument", "", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "concatArgumentsIfNeeded", "concatArguments", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isMixed", "", "js.translator"})
    @SourceDebugExtension(value={"SMAP\nCallArgumentTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallArgumentTranslator.kt\norg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,381:1\n1557#2:382\n1628#2,3:383\n1#3:386\n37#4:387\n36#4,3:388\n*S KotlinDebug\n*F\n+ 1 CallArgumentTranslator.kt\norg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion\n*L\n337#1:382\n337#1:383,3\n352#1:387\n352#1:388,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsBlock jsBlock = context.dynamicContext().jsBlock();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"jsBlock(...)");
            return this.translate(resolvedCall2, receiver, context, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            TranslationContext translationContext = context.innerBlock(block);
            Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerBlock(...)");
            TranslationContext innerContext = translationContext;
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall2, receiver, innerContext, null);
            ArgumentsInfo result2 = argumentTranslator.translate();
            context.moveVarsFrom(innerContext);
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, (String)"getCandidateDescriptor(...)");
            Object callDescriptor = obj;
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor)) {
                Map<TypeParameterDescriptor, KotlinType> map = resolvedCall2.getTypeArguments();
                Intrinsics.checkNotNullExpressionValue(map, (String)"getTypeArguments(...)");
                Map<TypeParameterDescriptor, KotlinType> typeArgs = map;
                return ArgumentsInfo.copy$default(result2, null, false, null, CallArgumentTranslatorKt.buildReifiedTypeArgs(typeArgs, context), 7, null);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> translateResolvedArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs) {
            void $this$mapTo$iv$iv;
            if (resolvedArgument instanceof DefaultValueArgument) {
                return CollectionsKt.listOf((Object)Namer.getUndefinedExpression());
            }
            List<ValueArgument> list = resolvedArgument.getArguments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsExpression jsExpression = translatedArgs.get(it);
                Intrinsics.checkNotNull((Object)jsExpression);
                collection.add(jsExpression);
            }
            return (List)destination$iv$iv;
        }

        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments, KotlinType varargElementType, boolean isMixed) {
            JsExpression jsExpression;
            boolean bl;
            boolean bl2 = bl = !((Collection)concatArguments).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22 = false;
                String $i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22 = "concatArguments.size should not be 0";
                throw new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22);
            }
            if (concatArguments.size() > 1) {
                JsInvocation jsInvocation;
                if (varargElementType != null && (TypeUtilsKt.isPrimitiveNumberType(varargElementType) || ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null)) {
                    String method = isMixed ? "arrayConcat" : "primitiveArrayConcat";
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)concatArguments.get(0));
                    Collection $this$toTypedArray$iv = concatArguments.subList(1, concatArguments.size());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new JsExpression[0]));
                    jsInvocation = JsAstUtils.invokeKotlinFunction(method, (JsExpression[])spreadBuilder.toArray((Object[])new JsExpression[spreadBuilder.size()]));
                } else {
                    jsInvocation = new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
                }
                JsInvocation jsInvocation2 = jsInvocation;
                Intrinsics.checkNotNull((Object)jsInvocation2);
                jsExpression = jsInvocation2;
            } else {
                jsExpression = concatArguments.get(0);
            }
            return jsExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

