/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isMalformed", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "containsMalformedArgument", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeAliasExpandsToArrayOfNothingsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeAliasExpandsToArrayOfNothingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,40:1\n12567#2,2:41\n*S KotlinDebug\n*F\n+ 1 FirTypeAliasExpandsToArrayOfNothingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker\n*L\n37#1:41,2\n*E\n"})
public final class FirTypeAliasExpandsToArrayOfNothingsChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirTypeAliasExpandsToArrayOfNothingsChecker INSTANCE = new FirTypeAliasExpandsToArrayOfNothingsChecker();

    private FirTypeAliasExpandsToArrayOfNothingsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeClassLikeType coneClassLikeType = FirDeclarationUtilKt.getExpandedConeType(declaration);
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        if (this.isMalformed(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(type2), context)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), (Object)type2, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isMalformed(ConeKotlinType $this$isMalformed, CheckerContext context) {
        ConeTypeProjection coneTypeProjection;
        return Intrinsics.areEqual((Object)FirHelpersKt.fullyExpandedClassId($this$isMalformed, context.getSession()), (Object)StandardClassIds.INSTANCE.getArray()) && Intrinsics.areEqual((coneTypeProjection = (ConeTypeProjection)ArraysKt.singleOrNull((Object[])ConeTypeUtilsKt.getTypeArgumentsOfLowerBoundIfFlexible($this$isMalformed))) != null && (coneTypeProjection = ConeTypeProjectionKt.getType(coneTypeProjection)) != null ? FirHelpersKt.fullyExpandedClassId((ConeKotlinType)coneTypeProjection, context.getSession()) : null, (Object)StandardClassIds.INSTANCE.getNothing()) || this.containsMalformedArgument($this$isMalformed, context);
    }

    private final boolean containsMalformedArgument(ConeKotlinType $this$containsMalformedArgument, CheckerContext context) {
        boolean bl;
        block1: {
            ConeTypeProjection[] $this$any$iv = ConeTypeUtilsKt.getTypeArgumentsOfLowerBoundIfFlexible($this$containsMalformedArgument);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
                boolean bl3 = coneKotlinType != null ? INSTANCE.isMalformed(coneKotlinType, context) : false;
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

