/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"toVisibilityOrNull", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "findContextReceiverListSource", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "Lorg/jetbrains/kotlin/KtSourceElement;", "delegatedPropertySourceOrThis", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkers"})
@SourceDebugExtension(value={"SMAP\nSourceHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/SourceHelpersKt\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n803#2,7:54\n803#2,7:61\n57#3,11:68\n21#3,2:79\n1#4:81\n*S KotlinDebug\n*F\n+ 1 SourceHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/SourceHelpersKt\n*L\n37#1:54,7\n43#1:61,7\n48#1:68,11\n48#1:79,2\n*E\n"})
public final class SourceHelpersKt {
    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toVisibilityOrNull, (String)"<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtLightSourceElement findContextReceiverListSource(@NotNull KtSourceElement $this$findContextReceiverListSource) {
        KtLightSourceElement ktLightSourceElement;
        Intrinsics.checkNotNullParameter((Object)$this$findContextReceiverListSource, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$findContextReceiverListSource.getLighterASTNode().getTokenType(), (Object)KtNodeTypes.CONTEXT_RECEIVER_LIST)) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv = $this$findContextReceiverListSource.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv);
        }
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$findContextReceiverListSource.getTreeStructure();
        LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
        IElementType iElementType = KtNodeTypes.CONTEXT_RECEIVER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CONTEXT_RECEIVER_LIST");
        LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findDescendantByType(flyweightCapableTreeStructure, lighterASTNode, iElementType, false);
        if (lighterASTNode2 != null) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode tree$iv = lighterASTNode2;
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv2 = $this$findContextReceiverListSource.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv2, kind$iv);
        } else {
            ktLightSourceElement = null;
        }
        return ktLightSourceElement;
    }

    @NotNull
    public static final KtSourceElement delegatedPropertySourceOrThis(@NotNull KtSourceElement $this$delegatedPropertySourceOrThis, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$delegatedPropertySourceOrThis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)$this$delegatedPropertySourceOrThis.getKind(), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            KtSourceElement ktSourceElement;
            KtSourceElement ktSourceElement2;
            FirExpression firExpression;
            Iterator<Object> iterator2;
            block7: {
                Iterable $this$lastIsInstanceOrNull$iv = context.getContainingDeclarations();
                boolean $i$f$lastIsInstanceOrNull = false;
                if ($this$lastIsInstanceOrNull$iv instanceof List) {
                    int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                    if (0 <= n) {
                        do {
                            int i$iv;
                            Iterator<Object> element$iv;
                            if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirProperty)) continue;
                            iterator2 = element$iv;
                            break block7;
                        } while (0 <= n);
                    }
                    iterator2 = null;
                } else {
                    Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                        if (!(element$iv$iv instanceof FirProperty)) continue;
                        iterator2 = (Iterator<Object>)element$iv$iv;
                        break block7;
                    }
                    iterator2 = null;
                }
            }
            FirProperty property = (FirProperty)((Object)iterator2);
            if (property != null && (firExpression = property.getDelegate()) != null && (ktSourceElement2 = firExpression.getSource()) != null && (ktSourceElement = KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) != null) {
                KtSourceElement it = ktSourceElement;
                boolean bl = false;
                return it;
            }
        }
        return $this$delegatedPropertySourceOrThis;
    }
}

