/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeTransformer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmTag;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ&\u0010&\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0'2\u0006\u0010(\u001a\u00020)J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010+\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,\u0012\u0004\u0012\u00020\u001c0'J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020/2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020)J\u0012\u00108\u001a\u00020/2\n\u00109\u001a\u0006\u0012\u0002\b\u00030:J\u0016\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020=2\u0006\u00105\u001a\u000206J\u0016\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u0016\u0010C\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010A\u001a\u00020BJ\u0016\u0010D\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010A\u001a\u00020BJ\u0016\u0010E\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010F\u001a\u00020GJ\u0016\u0010H\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010F\u001a\u00020GJ\u0016\u0010I\u001a\u00020/2\u0006\u0010<\u001a\u00020=2\u0006\u0010J\u001a\u00020KJ\u000e\u0010O\u001a\u00020N2\u0006\u00100\u001a\u000201J\u000e\u0010R\u001a\u00020Q2\u0006\u00100\u001a\u000201J\u0014\u0010S\u001a\b\u0012\u0004\u0012\u0002060\r2\u0006\u0010<\u001a\u00020=J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020B0\r2\u0006\u0010?\u001a\u00020@J\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020B0\r2\u0006\u00100\u001a\u000201J\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020B0\r2\u0006\u00100\u001a\u000201J\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020G0\r2\u0006\u00100\u001a\u000201J\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020G0\r2\u0006\u00100\u001a\u000201J\u0014\u0010Y\u001a\b\u0012\u0004\u0012\u00020G0\r2\u0006\u00100\u001a\u000201J\u0016\u0010Z\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010F\u001a\u00020GJ\u000e\u0010[\u001a\u00020\\2\u0006\u00100\u001a\u000201J\u0014\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u00100\u001a\u000201J\u0016\u0010^\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010_\u001a\u00020\u000eJ\u0014\u0010`\u001a\b\u0012\u0004\u0012\u00020K0\r2\u0006\u0010<\u001a\u00020=J\u0014\u0010a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u00100\u001a\u000201J\u0014\u0010b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010c\u001a\u00020dJ\u0016\u0010e\u001a\u00020/2\u0006\u0010f\u001a\u00020)2\u0006\u0010g\u001a\u00020)J\u000e\u0010h\u001a\u00020/2\u0006\u0010i\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010L\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020N0MX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010P\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020Q0MX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "typeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "scratchMemAddr", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "getScratchMemAddr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "stringPoolSize", "getStringPoolSize", "throwableTagIndex", "getThrowableTagIndex", "()I", "throwableTagIndex$delegate", "Lkotlin/Lazy;", "jsExceptionTagIndex", "getJsExceptionTagIndex", "jsExceptionTagIndex$delegate", "transformType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformFieldType", "transformBoxedType", "transformValueParameterType", "irValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "transformResultType", "transformBlockResultType", "referenceStringLiteralAddressAndId", "Lkotlin/Pair;", "string", "", "referenceConstantArray", "resource", "", "", "generateTypeInfo", "", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "typeInfo", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "registerInitFunction", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "priority", "addExport", "wasmExport", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "defineFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "defineGlobalField", "irField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineGlobalVTable", "defineGlobalClassITable", "defineGcType", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "defineVTableGcType", "defineFunctionType", "wasmFunctionType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "classMetadataCache", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "getClassMetadata", "interfaceMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/InterfaceMetadata;", "getInterfaceMetadata", "referenceFunction", "referenceGlobalField", "referenceGlobalVTable", "referenceGlobalClassITable", "referenceGcType", "referenceVTableGcType", "referenceClassITableGcType", "defineClassITableGcType", "isAlreadyDefinedClassITableGcType", "", "referenceClassITableInterfaceSlot", "defineClassITableInterfaceSlot", "slot", "referenceFunctionType", "referenceTypeId", "getStructFieldRef", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addJsFun", "importName", "jsCode", "addJsModuleImport", "module", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmModuleCodegenContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmModuleCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n381#3,7:200\n381#3,7:207\n360#4,7:214\n360#4,7:221\n*S KotlinDebug\n*F\n+ 1 WasmModuleCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext\n*L\n120#1:200,7\n133#1:207,7\n32#1:214,7\n36#1:221,7\n*E\n"})
public final class WasmModuleCodegenContext {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmCompiledModuleFragment wasmFragment;
    @NotNull
    private final WasmTypeTransformer typeTransformer;
    @NotNull
    private final Lazy throwableTagIndex$delegate;
    @NotNull
    private final Lazy jsExceptionTagIndex$delegate;
    @NotNull
    private final Map<IrClassSymbol, ClassMetadata> classMetadataCache;
    @NotNull
    private final Map<IrClassSymbol, InterfaceMetadata> interfaceMetadataCache;

    public WasmModuleCodegenContext(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmFragment) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFragment, (String)"wasmFragment");
        this.backendContext = backendContext;
        this.wasmFragment = wasmFragment;
        this.typeTransformer = new WasmTypeTransformer(this, this.backendContext.getIrBuiltIns());
        this.throwableTagIndex$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WasmModuleCodegenContext.throwableTagIndex_delegate$lambda$1(this));
        this.jsExceptionTagIndex$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WasmModuleCodegenContext.jsExceptionTagIndex_delegate$lambda$3(this));
        this.classMetadataCache = new LinkedHashMap();
        this.interfaceMetadataCache = new LinkedHashMap();
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmSymbol<Integer> getScratchMemAddr() {
        return this.wasmFragment.getScratchMemAddr();
    }

    @NotNull
    public final WasmSymbol<Integer> getStringPoolSize() {
        return this.wasmFragment.getStringPoolSize();
    }

    public final int getThrowableTagIndex() {
        Lazy lazy = this.throwableTagIndex$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getJsExceptionTagIndex() {
        Lazy lazy = this.jsExceptionTagIndex$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final WasmType transformType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformType_u24lambda_u244 = this.typeTransformer;
        boolean bl = false;
        return $this$transformType_u24lambda_u244.toWasmValueType(irType);
    }

    @NotNull
    public final WasmType transformFieldType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformFieldType_u24lambda_u245 = this.typeTransformer;
        boolean bl = false;
        return $this$transformFieldType_u24lambda_u245.toWasmFieldType(irType);
    }

    @NotNull
    public final WasmType transformBoxedType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformBoxedType_u24lambda_u246 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBoxedType_u24lambda_u246.toBoxedInlineClassType(irType);
    }

    @NotNull
    public final WasmType transformValueParameterType(@NotNull IrValueParameter irValueParameter) {
        Intrinsics.checkNotNullParameter((Object)irValueParameter, (String)"irValueParameter");
        WasmTypeTransformer $this$transformValueParameterType_u24lambda_u247 = this.typeTransformer;
        boolean bl = false;
        return $this$transformValueParameterType_u24lambda_u247.getContext().backendContext.getInlineClassesUtils().shouldValueParameterBeBoxed(irValueParameter) ? $this$transformValueParameterType_u24lambda_u247.toBoxedInlineClassType(irValueParameter.getType()) : $this$transformValueParameterType_u24lambda_u247.toWasmValueType(irValueParameter.getType());
    }

    @Nullable
    public final WasmType transformResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformResultType_u24lambda_u248 = this.typeTransformer;
        boolean bl = false;
        return $this$transformResultType_u24lambda_u248.toWasmResultType(irType);
    }

    @Nullable
    public final WasmType transformBlockResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformBlockResultType_u24lambda_u249 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBlockResultType_u24lambda_u249.toWasmBlockResultType(irType);
    }

    @NotNull
    public final Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> referenceStringLiteralAddressAndId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        WasmSymbol<Integer> address = this.wasmFragment.getStringLiteralAddress().reference(string2);
        WasmSymbol<Integer> id = this.wasmFragment.getStringLiteralPoolId().reference(string2);
        return TuplesKt.to(address, id);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceConstantArray(@NotNull Pair<? extends List<Long>, ? extends WasmType> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        return this.wasmFragment.getConstantArrayDataSegmentId().reference(resource);
    }

    public final void generateTypeInfo(@NotNull IrClassSymbol irClass, @NotNull ConstantDataElement typeInfo) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        this.wasmFragment.getTypeInfo().define(irClass, typeInfo);
    }

    public final void registerInitFunction(@NotNull WasmFunction wasmFunction, @NotNull String priority) {
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        ((Collection)this.wasmFragment.getInitFunctions()).add(new WasmCompiledModuleFragment.FunWithPriority(wasmFunction, priority));
    }

    public final void addExport(@NotNull WasmExport<?> wasmExport) {
        Intrinsics.checkNotNullParameter(wasmExport, (String)"wasmExport");
        ((Collection)this.wasmFragment.getExports()).add(wasmExport);
    }

    public final void defineFunction(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        this.wasmFragment.getFunctions().define(irFunction, wasmFunction);
    }

    public final void defineGlobalField(@NotNull IrFieldSymbol irField, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalFields().define(irField, wasmGlobal);
    }

    public final void defineGlobalVTable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalVTables().define(irClass, wasmGlobal);
    }

    public final void defineGlobalClassITable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalClassITables().define(irClass, wasmGlobal);
    }

    public final void defineGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getGcTypes().define(irClass, wasmType);
    }

    public final void defineVTableGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getVTableGcTypes().define(irClass, wasmType);
    }

    public final void defineFunctionType(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunctionType wasmFunctionType) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunctionType, (String)"wasmFunctionType");
        this.wasmFragment.getFunctionTypes().define(irFunction, wasmFunctionType);
    }

    @NotNull
    public final ClassMetadata getClassMetadata(@NotNull IrClassSymbol irClass) {
        ClassMetadata classMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Map<IrClassSymbol, ClassMetadata> $this$getOrPut$iv = this.classMetadataCache;
        boolean $i$f$getOrPut = false;
        ClassMetadata value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            ClassMetadata classMetadata2;
            IrClass superClass;
            boolean bl = false;
            IrClass irClass2 = superClass = ClassInfoKt.getSuperClass((IrClass)irClass.getOwner(), this.backendContext.getIrBuiltIns());
            if (irClass2 != null) {
                IrClass it = irClass2;
                boolean bl2 = false;
                classMetadata2 = this.getClassMetadata(it.getSymbol());
            } else {
                classMetadata2 = null;
            }
            ClassMetadata superClassMetadata = classMetadata2;
            ClassMetadata answer$iv = new ClassMetadata((IrClass)irClass.getOwner(), superClassMetadata, this.backendContext.getIrBuiltIns(), this.backendContext.getPartialLinkageSupport().isEnabled());
            $this$getOrPut$iv.put(irClass, answer$iv);
            classMetadata = answer$iv;
        } else {
            classMetadata = value$iv;
        }
        return classMetadata;
    }

    @NotNull
    public final InterfaceMetadata getInterfaceMetadata(@NotNull IrClassSymbol irClass) {
        InterfaceMetadata interfaceMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Map<IrClassSymbol, InterfaceMetadata> $this$getOrPut$iv = this.interfaceMetadataCache;
        boolean $i$f$getOrPut = false;
        InterfaceMetadata value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            boolean bl = false;
            InterfaceMetadata answer$iv = new InterfaceMetadata((IrClass)irClass.getOwner(), this.backendContext.getIrBuiltIns());
            $this$getOrPut$iv.put(irClass, answer$iv);
            interfaceMetadata = answer$iv;
        } else {
            interfaceMetadata = value$iv;
        }
        return interfaceMetadata;
    }

    @NotNull
    public final WasmSymbol<WasmFunction> referenceFunction(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.wasmFragment.getFunctions().reference(irFunction);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalField(@NotNull IrFieldSymbol irField) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        return this.wasmFragment.getGlobalFields().reference(irField);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalVTable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getGlobalVTables().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalClassITable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getGlobalClassITables().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getGcTypes().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceVTableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getVTableGcTypes().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceClassITableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getClassITableGcType().reference(irClass);
    }

    public final void defineClassITableGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getClassITableGcType().define(irClass, wasmType);
    }

    public final boolean isAlreadyDefinedClassITableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getClassITableGcType().getDefined().keySet().contains(irClass);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceClassITableInterfaceSlot(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        IrType type2 = IrTypesKt.getDefaultType(irClass);
        if (!(!IrTypePredicatesKt.isNothing(type2))) {
            boolean bl = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.wasmFragment.getClassITableInterfaceSlot().reference(irClass);
    }

    public final void defineClassITableInterfaceSlot(@NotNull IrClassSymbol irClass, int slot) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.wasmFragment.getClassITableInterfaceSlot().define(irClass, slot);
    }

    @NotNull
    public final WasmSymbol<WasmFunctionType> referenceFunctionType(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.wasmFragment.getFunctionTypes().reference(irFunction);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceTypeId(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.wasmFragment.getTypeIds().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        IrClass klass = IrUtilsKt.getParentAsClass(field);
        ClassMetadata metadata = this.getClassMetadata(klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field) + 2;
        return new WasmSymbol<Integer>(fieldId);
    }

    public final void addJsFun(@NotNull String importName, @NotNull String jsCode) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)jsCode, (String)"jsCode");
        ((Collection)this.wasmFragment.getJsFuns()).add(new WasmCompiledModuleFragment.JsCodeSnippet(importName, jsCode));
    }

    public final void addJsModuleImport(@NotNull String module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ((Collection)this.wasmFragment.getJsModuleImports()).add(module2);
    }

    private static final int throwableTagIndex_delegate$lambda$1(WasmModuleCodegenContext this$0) {
        int n;
        block2: {
            List<WasmTag> $this$indexOfFirst$iv = this$0.wasmFragment.getTags();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<WasmTag> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                WasmTag item$iv;
                WasmTag it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getType() == this$0.wasmFragment.getThrowableTagFuncType$backend_wasm()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final int jsExceptionTagIndex_delegate$lambda$3(WasmModuleCodegenContext this$0) {
        int n;
        block2: {
            List<WasmTag> $this$indexOfFirst$iv = this$0.wasmFragment.getTags();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<WasmTag> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                WasmTag item$iv;
                WasmTag it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getType() == this$0.wasmFragment.getJsExceptionTagFuncType$backend_wasm()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }
}

