/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0010\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\f\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\b2\u0006\u0010\u0003\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"asString", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "erase", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "getClassRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "getConstructorRef", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrTypeUtilsKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n*L\n1#1,87:1\n188#2:88\n229#2:90\n229#2:91\n1544#3:89\n*S KotlinDebug\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrTypeUtilsKt\n*L\n39#1:88\n79#1:90\n86#1:91\n53#1:89\n*E\n"})
public final class IrTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asString(@NotNull IrType $this$asString, @NotNull JsIrBackendContext context2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrType irType = $this$asString;
        if (irType instanceof IrErrorType) {
            string2 = "$ErrorType$";
        } else if (irType instanceof IrDynamicType) {
            string2 = "dynamic";
        } else if (irType instanceof IrSimpleType) {
            String string3;
            String string4;
            String string5;
            StringBuilder stringBuilder = new StringBuilder().append(IrTypeUtilsKt.asString(((IrSimpleType)$this$asString).getClassifier(), context2));
            switch (WhenMappings.$EnumSwitchMapping$0[((IrSimpleType)$this$asString).getNullability().ordinal()]) {
                case 1: {
                    string5 = "?";
                    break;
                }
                case 2: {
                    string5 = "";
                    break;
                }
                case 3: {
                    if (((IrSimpleType)$this$asString).getClassifier() instanceof IrTypeParameterSymbol) {
                        string5 = " & Any";
                        break;
                    }
                    string5 = "";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string5);
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)$this$asString).getArguments();
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                void $this$asString_u24lambda_u241;
                List list = (List)$this$ifNotEmpty$iv;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl = false;
                string4 = CollectionsKt.joinToString$default((Iterable)((Iterable)$this$asString_u24lambda_u241), (CharSequence)",", (CharSequence)"<", (CharSequence)">", (int)0, null, arg_0 -> IrTypeUtilsKt.asString$lambda$1$lambda$0(context2, arg_0), (int)24, null);
                stringBuilder2 = stringBuilder3;
            } else {
                string4 = string3 = null;
            }
            if (string4 == null) {
                string3 = "";
            }
            string2 = stringBuilder2.append(string3).toString();
        } else {
            throw new IllegalStateException(("Unexpected kind of IrType: " + $this$asString.getClass().getTypeName()).toString());
        }
        return string2;
    }

    private static final String asString(IrTypeArgument $this$asString, JsIrBackendContext context2) {
        String string2;
        IrTypeArgument irTypeArgument = $this$asString;
        if (irTypeArgument instanceof IrStarProjection) {
            string2 = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            string2 = ((IrTypeProjection)$this$asString).getVariance().getLabel() + (((IrTypeProjection)$this$asString).getVariance() != Variance.INVARIANT ? " " : "") + IrTypeUtilsKt.asString(((IrTypeProjection)$this$asString).getType(), context2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String asString(IrClassifierSymbol $this$asString, JsIrBackendContext context2) {
        String string2;
        IrClassifierSymbol irClassifierSymbol = $this$asString;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            String string3 = ((IrTypeParameter)((IrTypeParameterSymbol)$this$asString).getOwner()).getName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        } else {
            if (irClassifierSymbol instanceof IrScriptSymbol) {
                IrSymbol $this$unexpectedSymbolKind$iv = $this$asString;
                boolean $i$f$unexpectedSymbolKind = false;
                throw new IllegalArgumentException("Unexpected kind of " + IrClassifierSymbol.class.getTypeName() + ": " + $this$unexpectedSymbolKind$iv);
            }
            if (irClassifierSymbol instanceof IrClassSymbol) {
                string2 = context2.getClassToItsId().get(((IrClassSymbol)$this$asString).getOwner());
                if (string2 == null && (string2 = context2.getLocalClassNames().get(((IrClassSymbol)$this$asString).getOwner())) == null) {
                    FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrClassSymbol)$this$asString).getOwner());
                    Intrinsics.checkNotNull((Object)fqName);
                    String string4 = fqName.asString();
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Nullable
    public static final IrClass erase(@NotNull IrType type2) {
        IrClass irClass;
        block4: {
            IrClassifierSymbol classifier;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            while (true) {
                if ((classifier = IrTypesKt.getClassifierOrFail(type2)) instanceof IrClassSymbol) {
                    irClass = (IrClass)((IrClassSymbol)classifier).getOwner();
                    break block4;
                }
                if (!(classifier instanceof IrTypeParameterSymbol)) break;
                type2 = (IrType)CollectionsKt.first(((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes());
            }
            if (classifier instanceof IrScriptSymbol) {
                irClass = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irClass;
    }

    @NotNull
    public static final JsExpression getClassRef(@NotNull IrType $this$getClassRef, @NotNull JsStaticContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getClassRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrSymbolOwner klass = IrTypesKt.getClassifierOrFail($this$getClassRef).getOwner();
        if (klass instanceof IrClass) {
            jsExpression = IrTypeUtilsKt.getClassRef((IrClass)klass, context2);
        } else {
            Intrinsics.checkNotNull((Object)klass, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            JsNameRef jsNameRef = context2.getNameForStaticDeclaration((IrDeclarationWithName)klass).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getClassRef(@NotNull IrClass $this$getClassRef, @NotNull JsStaticContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getClassRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (IrUtilsKt.isEffectivelyExternal($this$getClassRef)) {
            jsExpression = context2.getRefForExternalClass($this$getClassRef);
        } else {
            JsExpression jsExpression2;
            JsNameRef jsNameRef = context2.getNameForClass($this$getClassRef).makeRef();
            boolean condition$iv = context2.isPerFile();
            boolean $i$f$butIf = false;
            if (condition$iv) {
                void $this$butIf$iv;
                void it = $this$butIf$iv;
                boolean bl = false;
                jsExpression2 = new JsInvocation((JsExpression)it, new JsExpression[0]);
            } else {
                jsExpression2 = jsNameRef;
            }
            jsExpression = jsExpression2;
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getConstructorRef(@NotNull IrConstructor $this$getConstructorRef, @NotNull JsStaticContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getConstructorRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsNameRef jsNameRef = context2.getNameForConstructor($this$getConstructorRef).makeRef();
        boolean condition$iv = context2.isPerFile() && !IrUtilsKt.isEffectivelyExternal($this$getConstructorRef);
        boolean $i$f$butIf = false;
        if (condition$iv) {
            void $this$butIf$iv;
            void it = $this$butIf$iv;
            boolean bl = false;
            jsExpression = new JsInvocation((JsExpression)it, new JsExpression[0]);
        } else {
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private static final CharSequence asString$lambda$1$lambda$0(JsIrBackendContext $context, IrTypeArgument it) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IrTypeUtilsKt.asString(it, $context);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

