/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001cH\u0002J\f\u0010 \u001a\u00020\u001f*\u00020!H\u0002J\f\u0010\"\u001a\u00020\u001f*\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\tR\u0018\u0010\u0012\u001a\u00020\u0007*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrepareCollectionsToExportLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "jsNameCtor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getJsNameCtor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "jsNameCtor$delegate", "Lkotlin/Lazy;", "jsExportIgnoreCtor", "getJsExportIgnoreCtor", "jsExportIgnoreCtor$delegate", "jsImplicitExportCtor", "getJsImplicitExportCtor", "jsImplicitExportCtor$delegate", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getPrimaryConstructorSymbol", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "exportedMethodNames", "", "", "exportableSymbols", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "excludeFromJsExport", "", "addJsName", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "markWithJsImplicitExport", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPrepareCollectionsToExportLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareCollectionsToExportLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PrepareCollectionsToExportLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1863#2,2:89\n*S KotlinDebug\n*F\n+ 1 PrepareCollectionsToExportLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PrepareCollectionsToExportLowering\n*L\n60#1:89,2\n*E\n"})
public final class PrepareCollectionsToExportLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Lazy jsNameCtor$delegate;
    @NotNull
    private final Lazy jsExportIgnoreCtor$delegate;
    @NotNull
    private final Lazy jsImplicitExportCtor$delegate;
    @NotNull
    private final Set<String> exportedMethodNames;
    @NotNull
    private final Set<IrClassSymbol> exportableSymbols;

    public PrepareCollectionsToExportLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.jsNameCtor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PrepareCollectionsToExportLowering.jsNameCtor_delegate$lambda$0(this));
        this.jsExportIgnoreCtor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PrepareCollectionsToExportLowering.jsExportIgnoreCtor_delegate$lambda$1(this));
        this.jsImplicitExportCtor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PrepareCollectionsToExportLowering.jsImplicitExportCtor_delegate$lambda$2(this));
        Object[] objectArray = new String[]{"asJsReadonlyArrayView", "asJsArrayView", "asJsReadonlySetView", "asJsSetView", "asJsReadonlyMapView", "asJsMapView"};
        this.exportedMethodNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new IrClassSymbol[]{this.context.getIr().getSymbols().getList(), this.context.getIr().getSymbols().getMutableList(), this.context.getIr().getSymbols().getSet(), this.context.getIr().getSymbols().getMutableSet(), this.context.getIr().getSymbols().getMap(), this.context.getIr().getSymbols().getMutableMap()};
        this.exportableSymbols = SetsKt.setOf((Object[])objectArray);
    }

    private final IrConstructorSymbol getJsNameCtor() {
        Lazy lazy = this.jsNameCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    private final IrConstructorSymbol getJsExportIgnoreCtor() {
        Lazy lazy = this.jsExportIgnoreCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    private final IrConstructorSymbol getJsImplicitExportCtor() {
        Lazy lazy = this.jsImplicitExportCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    private final IrConstructorSymbol getPrimaryConstructorSymbol(IrClassSymbol $this$primaryConstructorSymbol) {
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)$this$primaryConstructorSymbol.getOwner());
        Intrinsics.checkNotNull((Object)irConstructor);
        return irConstructor.getSymbol();
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrClass && this.exportableSymbols.contains(((IrClass)declaration).getSymbol())) {
            this.addJsName((IrDeclarationWithName)declaration);
            this.markWithJsImplicitExport(declaration);
            Iterable $this$forEach$iv = ((IrClass)declaration).getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (it instanceof IrDeclarationWithName && this.exportedMethodNames.contains(((IrDeclarationWithName)it).getName().toString())) continue;
                this.excludeFromJsExport(it);
            }
        }
        return null;
    }

    private final void excludeFromJsExport(IrDeclaration $this$excludeFromJsExport) {
        Object object;
        if ($this$excludeFromJsExport instanceof IrSimpleFunction && (object = ((IrSimpleFunction)$this$excludeFromJsExport).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null) {
            this.excludeFromJsExport((IrDeclaration)object);
        }
        $this$excludeFromJsExport.setAnnotations(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$excludeFromJsExport.getAnnotations(), JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsExportIgnoreCtor(), null, null, null, 14, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void addJsName(IrDeclarationWithName $this$addJsName) {
        void $this$addJsName_u24lambda_u244;
        IrConstructorCall irConstructorCall;
        IrConstructorCall irConstructorCall2 = irConstructorCall = JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsNameCtor(), null, null, null, 14, null);
        List<IrConstructorCall> list = $this$addJsName.getAnnotations();
        IrDeclarationWithName irDeclarationWithName = $this$addJsName;
        boolean bl = false;
        $this$addJsName_u24lambda_u244.putValueArgument(0, IrUtilsKt.toIrConst$default("Kt" + $this$addJsName.getName().asString(), this.context.getIrBuiltIns().getStringType(), 0, 0, 6, null));
        Unit unit = Unit.INSTANCE;
        irDeclarationWithName.setAnnotations(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(list, irConstructorCall));
    }

    /*
     * WARNING - void declaration
     */
    private final void markWithJsImplicitExport(IrDeclaration $this$markWithJsImplicitExport) {
        void $this$markWithJsImplicitExport_u24lambda_u245;
        IrConstructorCall irConstructorCall;
        IrConstructorCall irConstructorCall2 = irConstructorCall = JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsImplicitExportCtor(), null, null, null, 14, null);
        List<IrConstructorCall> list = $this$markWithJsImplicitExport.getAnnotations();
        IrDeclaration irDeclaration2 = $this$markWithJsImplicitExport;
        boolean bl = false;
        $this$markWithJsImplicitExport_u24lambda_u245.putValueArgument(0, IrUtilsKt.toIrConst$default(true, this.context.getIrBuiltIns().getBooleanType(), 0, 0, 6, null));
        Unit unit = Unit.INSTANCE;
        irDeclaration2.setAnnotations(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(list, irConstructorCall));
    }

    private static final IrConstructorSymbol jsNameCtor_delegate$lambda$0(PrepareCollectionsToExportLowering this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getPrimaryConstructorSymbol(this$0.context.getIntrinsics().getJsNameAnnotationSymbol());
    }

    private static final IrConstructorSymbol jsExportIgnoreCtor_delegate$lambda$1(PrepareCollectionsToExportLowering this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getPrimaryConstructorSymbol(this$0.context.getIntrinsics().getJsExportIgnoreAnnotationSymbol());
    }

    private static final IrConstructorSymbol jsImplicitExportCtor_delegate$lambda$2(PrepareCollectionsToExportLowering this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getPrimaryConstructorSymbol(this$0.context.getIntrinsics().getJsImplicitExportAnnotationSymbol());
    }
}

