/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LoweredStatementOrigins;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImplKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImplKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImplKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "stringType", "ReferenceTransformer", "CallableReferenceBuilder", "Companion", "backend.js"})
public final class CallableReferenceLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final IrType nothingType;
    @NotNull
    private final IrType stringType;
    @NotNull
    private static final ReadOnlyProperty<Object, IrDeclarationOriginImpl> LAMBDA_IMPL$delegate = IrDeclarationOriginImpl.Companion.provideDelegate((Object)Companion, org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceLowering$Companion.$$delegatedProperties[0]);
    @NotNull
    private static final ReadOnlyProperty<Object, IrDeclarationOriginImpl> FUNCTION_REFERENCE_IMPL$delegate = IrDeclarationOriginImpl.Companion.provideDelegate((Object)Companion, org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceLowering$Companion.$$delegatedProperties[1]);
    @NotNull
    private static final ReadOnlyProperty<Object, IrDeclarationOriginImpl> GENERATED_MEMBER_IN_CALLABLE_REFERENCE$delegate = IrDeclarationOriginImpl.Companion.provideDelegate((Object)Companion, org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceLowering$Companion.$$delegatedProperties[2]);
    @NotNull
    private static final Name BOUND_RECEIVER_NAME;

    public CallableReferenceLowering(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nothingType = this.context.getIrBuiltIns().getNothingType();
        this.stringType = this.context.getIrBuiltIns().getStringType();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        IrDeclarationParent realContainer = irDeclarationParent;
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ReferenceTransformer(realContainer));
    }

    static {
        Name name2 = Name.identifier("$boundThis");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        BOUND_RECEIVER_NAME = name2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0017\u001a\u00020\u0018*\u00060\u001aj\u0002`\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\f\u0010!\u001a\u00020\u0018*\u00020\u0014H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u0014H\u0002J\f\u0010'\u001a\u00020\u0018*\u00020&H\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020*J\f\u0010+\u001a\u00020,*\u00020#H\u0002J\f\u0010-\u001a\u00020.*\u00020&H\u0002J\f\u0010/\u001a\u00020\u0018*\u00020&H\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#02R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "reflectionTarget", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "isLambda", "", "()Z", "shouldBeCoroutineImpl", "superClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "boundReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "referenceType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "superFunctionInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isKReference", "secondFunctionInterface", "collectNamesForLambda", "", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;)V", "makeContextDependentName", "Lorg/jetbrains/kotlin/name/Name;", "buildReferenceClass", "createReceiverField", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "clazz", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createLambdaInvokeMethod", "getValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "countContextTypeParameters", "", "buildInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "createFunctionReferenceInvokeMethod", "createNameProperty", "build", "Lkotlin/Pair;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nCallableReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,480:1\n50#2,4:481\n289#2:486\n283#2,13:487\n351#2,9:512\n351#2,9:521\n249#2:537\n243#2:538\n237#2,10:539\n345#2,4:563\n127#2:591\n121#2,10:592\n133#2,9:602\n345#2,4:611\n1#3:485\n626#4,12:500\n1187#4,2:549\n1261#4,4:551\n1557#4:555\n1628#4,3:556\n1598#4,3:560\n1601#4:567\n808#4,11:568\n626#4,12:579\n421#5,5:530\n72#6,2:535\n24#7:559\n*S KotlinDebug\n*F\n+ 1 CallableReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder\n*L\n178#1:481,4\n211#1:486\n211#1:487,13\n220#1:512,9\n231#1:521,9\n256#1:537\n256#1:538\n256#1:539,10\n399#1:563,4\n432#1:591\n432#1:592,10\n438#1:602,9\n442#1:611,4\n217#1:500,12\n279#1:549,2\n279#1:551,4\n395#1:555\n395#1:556,3\n398#1:560,3\n398#1:567\n423#1:568,11\n424#1:579,12\n238#1:530,5\n238#1:535,2\n398#1:559\n*E\n"})
    private final class CallableReferenceBuilder {
        @NotNull
        private final IrFunction function;
        @NotNull
        private final IrExpression reference;
        @Nullable
        private final IrFunction reflectionTarget;
        private final boolean shouldBeCoroutineImpl;
        @NotNull
        private final IrType superClass;
        @Nullable
        private IrField boundReceiverField;
        @NotNull
        private final IrSimpleType referenceType;
        @NotNull
        private final IrClass superFunctionInterface;
        private final boolean isKReference;
        @Nullable
        private final IrClass secondFunctionInterface;

        public CallableReferenceBuilder(@NotNull IrFunction function2, @Nullable IrExpression reference2, IrFunction reflectionTarget) {
            IrClass irClass;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            this.function = function2;
            this.reference = reference2;
            this.reflectionTarget = reflectionTarget;
            this.shouldBeCoroutineImpl = this.isLambda() && AdditionalIrUtilsKt.isSuspend(this.function) && !MiscKt.getCompileSuspendAsJsGenerator(CallableReferenceLowering.this.context);
            this.superClass = this.shouldBeCoroutineImpl ? (IrType)IrUtilsKt.getDefaultType((IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().getCoroutineImpl().getOwner()) : CallableReferenceLowering.this.context.getIrBuiltIns().getAnyType();
            IrType irType = this.reference.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            this.referenceType = (IrSimpleType)irType;
            Object object = IrTypesKt.getClassOrNull(this.referenceType);
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                CompilationExceptionKt.compilationException("Expected functional type", this.reference);
                throw null;
            }
            this.superFunctionInterface = object;
            boolean bl = this.isKReference = this.superFunctionInterface.getName().getIdentifier().charAt(0) == 'K';
            if (this.isKReference) {
                int arity = this.referenceType.getArguments().size() - 1;
                irClass = AdditionalIrUtilsKt.isSuspend(this.function) ? (IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().suspendFunctionN(arity).getOwner() : (IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().functionN(arity).getOwner();
            } else {
                irClass = null;
            }
            this.secondFunctionInterface = irClass;
        }

        private final boolean isLambda() {
            return this.reflectionTarget == null;
        }

        private final void collectNamesForLambda(StringBuilder $this$collectNamesForLambda, IrDeclarationWithName d) {
            StringBuilder stringBuilder;
            IrDeclarationParent parent2 = d.getParent();
            if (parent2 instanceof IrPackageFragment) {
                $this$collectNamesForLambda.append(d.getName().asString());
                return;
            }
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            this.collectNamesForLambda($this$collectNamesForLambda, (IrDeclarationWithName)((Object)parent2));
            if (d instanceof IrAnonymousInitializer) {
                return;
            }
            if (CallableReferenceBuilder.collectNamesForLambda$isLambdaFun(d)) {
                $this$collectNamesForLambda.append('$');
                if (d instanceof IrSimpleFunction && ((IrSimpleFunction)d).isSuspend()) {
                    $this$collectNamesForLambda.append('s');
                }
                stringBuilder = $this$collectNamesForLambda.append("lambda");
            } else if (Intrinsics.areEqual((Object)d.getName(), (Object)SpecialNames.NO_NAME_PROVIDED)) {
                stringBuilder = $this$collectNamesForLambda.append("$o");
            } else {
                $this$collectNamesForLambda.append('$');
                stringBuilder = $this$collectNamesForLambda.append(d.getName().asString());
            }
        }

        private final Name makeContextDependentName() {
            StringBuilder sb = new StringBuilder();
            this.collectNamesForLambda(sb, this.function);
            if (!this.isLambda()) {
                sb.append("$ref");
            }
            Name name2 = Name.identifier(sb.toString());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            return name2;
        }

        private final IrClass buildReferenceClass() {
            IrClass irClass;
            IrFactory $this$buildClass$iv = CallableReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl = false;
            IrClassBuilder $this$buildReferenceClass_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$buildReferenceClass_u24lambda_u240, this.reference);
            $this$buildReferenceClass_u24lambda_u240.setVisibility(DescriptorVisibilities.LOCAL);
            $this$buildReferenceClass_u24lambda_u240.setOrigin(this.isKReference || !this.isLambda() ? Companion.getFUNCTION_REFERENCE_IMPL() : Companion.getLAMBDA_IMPL());
            $this$buildReferenceClass_u24lambda_u240.setName(this.makeContextDependentName());
            IrClass $this$buildReferenceClass_u24lambda_u241 = irClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
            boolean bl3 = false;
            Object object = this.secondFunctionInterface;
            Object[] objectArray = new IrType[]{this.superClass, this.referenceType, object != null && (object = ((IrClass)object).getSymbol()) != null ? IrTypesKt.typeWithArguments((IrClassifierSymbol)object, this.referenceType.getArguments()) : null};
            $this$buildReferenceClass_u24lambda_u241.setSuperTypes(CollectionsKt.listOfNotNull((Object[])objectArray));
            IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$buildReferenceClass_u24lambda_u241);
            this.createReceiverField($this$buildReferenceClass_u24lambda_u241);
            return irClass;
        }

        private final void createReceiverField(IrClass $this$createReceiverField) {
            IrExpression boundReceiver;
            IrFunctionReference funRef;
            if (this.isLambda()) {
                return;
            }
            IrExpression irExpression = this.reference;
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            IrFunctionReference $this$createReceiverField_u24lambda_u242 = funRef = (IrFunctionReference)irExpression;
            boolean bl = false;
            IrExpression irExpression2 = $this$createReceiverField_u24lambda_u242.getDispatchReceiver();
            if (irExpression2 == null) {
                irExpression2 = $this$createReceiverField_u24lambda_u242.getExtensionReceiver();
            }
            if ((boundReceiver = irExpression2) != null) {
                this.boundReceiverField = DeclarationBuildersKt.addField$default($this$createReceiverField, Companion.getBOUND_RECEIVER_NAME(), boundReceiver.getType(), null, 4, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor(IrClass clazz) {
            void $this$createConstructor_u24lambda_u2412_u24lambda_u2411;
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            Object object;
            IrValueParameter irValueParameter;
            Object $this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv;
            IrClass $this$addConstructor$iv = clazz;
            boolean $i$f$addConstructor = false;
            Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u243 = $this$addConstructor_u24lambda_u2425$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u243.setOrigin(Companion.getGENERATED_MEMBER_IN_CALLABLE_REFERENCE());
            $this$createConstructor_u24lambda_u243.setReturnType(IrUtilsKt.getDefaultType(clazz));
            $this$createConstructor_u24lambda_u243.setPrimary(true);
            $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            Object object2 = $this$buildConstructor$iv$iv;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            Object $this$createConstructor_u24lambda_u2412 = object2;
            boolean bl5 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.superClass);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            Iterable $this$single$iv = ((IrClass)irClassSymbol.getOwner()).getDeclarations();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl6 = false;
                if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object v1 = single$iv;
            Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
            IrConstructor superConstructor = v1;
            IrField irField = this.boundReceiverField;
            if (irField != null) {
                IrValueParameter irValueParameter2;
                IrField it = irField;
                boolean bl7 = false;
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$createConstructor_u24lambda_u2412;
                boolean $i$f$addValueParameter = false;
                $this$addValueParameter_u24lambda_u2432$iv = new IrValueParameterBuilder();
                boolean bl8 = false;
                $this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245 = $this$addValueParameter_u24lambda_u2432$iv;
                boolean bl9 = false;
                ((IrDeclarationBuilder)$this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245).setName(Companion.getBOUND_RECEIVER_NAME());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245).setType(it.getType());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245).setIndex(0);
                if ($this$addValueParameter_u24lambda_u2432$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2432$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2432$iv, $this$addValueParameter$iv);
                boolean bl10 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
                irValueParameter = irValueParameter2;
            } else {
                irValueParameter = null;
            }
            IrValueParameter boundReceiverParameter = irValueParameter;
            Ref.ObjectRef continuation2 = new Ref.ObjectRef();
            if (this.shouldBeCoroutineImpl) {
                void $this$createConstructor_u24lambda_u2412_u24lambda_u247;
                IrValueParameter superContinuation = (IrValueParameter)CollectionsKt.single(superConstructor.getValueParameters());
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$createConstructor_u24lambda_u2412;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv2 = new IrValueParameterBuilder();
                boolean bl11 = false;
                $this$addValueParameter_u24lambda_u2432$iv = $this$addValueParameter_u24lambda_u2432$iv2;
                object = continuation2;
                boolean bl12 = false;
                $this$createConstructor_u24lambda_u2412_u24lambda_u247.setName(superContinuation.getName());
                $this$createConstructor_u24lambda_u2412_u24lambda_u247.setType(superContinuation.getType());
                $this$createConstructor_u24lambda_u2412_u24lambda_u247.setIndex(boundReceiverParameter == null ? 0 : 1);
                if ($this$addValueParameter_u24lambda_u2432$iv2.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2432$iv2.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                Object valueParameter$iv = $this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2432$iv2, $this$addValueParameter$iv);
                boolean bl13 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
                ((Ref.ObjectRef)object).element = $this$createConstructor_u24lambda_u2412_u24lambda_u246_u24lambda_u245;
            }
            IrBuilderWithScope superContinuation = LowerUtilsKt.createIrBuilder$default(callableReferenceLowering2.context, (IrSymbol)((IrConstructor)$this$createConstructor_u24lambda_u2412).getSymbol(), 0, 0, 6, null);
            int $this$addValueParameter$iv = $this$createConstructor_u24lambda_u2412.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2412.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder bl11 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void bl12 = this_$iv$iv;
            object = $this$createConstructor_u24lambda_u2412;
            boolean bl14 = false;
            IrDelegatingConstructorCall bl13 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2412_u24lambda_u2411, superConstructor);
            void var18_35 = $this$createConstructor_u24lambda_u2412_u24lambda_u2411;
            boolean bl15 = false;
            IrValueParameter irValueParameter3 = (IrValueParameter)continuation2.element;
            if (irValueParameter3 != null) {
                void $this$createConstructor_u24lambda_u2412_u24lambda_u2411_u24lambda_u249;
                IrValueParameter it = irValueParameter3;
                boolean bl16 = false;
                $this$createConstructor_u24lambda_u2412_u24lambda_u2411_u24lambda_u249.putValueArgument(0, this.getValue(it));
            }
            var18_35.unaryPlus(irDelegatingConstructorCall);
            IrValueParameter irValueParameter4 = boundReceiverParameter;
            if (irValueParameter4 != null) {
                IrValueParameter it = irValueParameter4;
                boolean bl17 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2412_u24lambda_u2411;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2412_u24lambda_u2411;
                IrValueParameter irValueParameter5 = clazz.getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter5);
                IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter5);
                IrField irField2 = this.boundReceiverField;
                Intrinsics.checkNotNull((Object)irField2);
                $this$createConstructor_u24lambda_u2412_u24lambda_u2411.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression, irField2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createConstructor_u24lambda_u2412_u24lambda_u2411, it), LoweredStatementOrigins.INSTANCE.getSTATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE()));
            }
            $this$createConstructor_u24lambda_u2412_u24lambda_u2411.unaryPlus(IrInstanceInitializerCallImplKt.IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2412_u24lambda_u2411.getStartOffset(), $this$createConstructor_u24lambda_u2412_u24lambda_u2411.getEndOffset(), clazz.getSymbol(), $this$createConstructor_u24lambda_u2412_u24lambda_u2411.getContext().getIrBuiltIns().getUnitType()));
            ((IrFunction)object).setBody(this_$iv$iv.doBuild());
            return object2;
        }

        private final IrSimpleFunction createInvokeMethod(IrClass clazz) {
            IrSimpleFunction irSimpleFunction;
            Object object;
            IrSimpleFunction irSimpleFunction2 = IrUtilsKt.getInvokeFun(this.superFunctionInterface);
            Intrinsics.checkNotNull((Object)irSimpleFunction2);
            IrSimpleFunction superMethod = irSimpleFunction2;
            IrClass $this$addFunction$iv = clazz;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2413 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$createInvokeMethod_u24lambda_u2413, this.isLambda() ? (IrElement)this.function : (IrElement)this.reference);
            $this$createInvokeMethod_u24lambda_u2413.setName(superMethod.getName());
            $this$createInvokeMethod_u24lambda_u2413.setReturnType(this.function.getReturnType());
            $this$createInvokeMethod_u24lambda_u2413.setSuspend(superMethod.isSuspend());
            $this$createInvokeMethod_u24lambda_u2413.setOperator(superMethod.isOperator());
            Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object $this$createInvokeMethod_u24lambda_u2415 = object = $this$buildFun$iv$iv$iv;
            boolean bl4 = false;
            IrClass irClass = this.secondFunctionInterface;
            if (irClass != null) {
                IrClass it = irClass;
                boolean bl5 = false;
                IrSimpleFunction irSimpleFunction3 = IrUtilsKt.getInvokeFun(it);
                irSimpleFunction = irSimpleFunction3;
                Intrinsics.checkNotNull((Object)irSimpleFunction3);
            } else {
                irSimpleFunction = null;
            }
            IrSimpleFunction secondSuperMethod = irSimpleFunction;
            Object[] objectArray = new IrSimpleFunctionSymbol[2];
            objectArray[0] = superMethod.getSymbol();
            IrSimpleFunction irSimpleFunction4 = secondSuperMethod;
            objectArray[1] = irSimpleFunction4 != null ? irSimpleFunction4.getSymbol() : null;
            ((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2415).setOverriddenSymbols(CollectionsKt.listOfNotNull((Object[])objectArray));
            ((IrFunction)$this$createInvokeMethod_u24lambda_u2415).setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter((IrDeclaration)$this$createInvokeMethod_u24lambda_u2415, clazz.getOrigin(), IrUtilsKt.getDefaultType(clazz), $this$createInvokeMethod_u24lambda_u2415.getStartOffset(), $this$createInvokeMethod_u24lambda_u2415.getEndOffset()));
            if (this.isLambda()) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2415);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2415);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(this.function.getAnnotations());
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.function));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                IrValueParameter param = (IrValueParameter)indexedValue.component2();
                indexedValue = TuplesKt.to((Object)param, (Object)IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, index, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                map.put(indexedValue.getFirst(), indexedValue.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.toList((Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.function, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        @NotNull
        public final IrGetValue getValue(@NotNull IrValueDeclaration d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return IrGetValueImplKt.IrGetValueImpl(-1, -1, d.getType(), d.getSymbol(), JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_INVOKE());
        }

        private final int countContextTypeParameters(IrConstructor $this$countContextTypeParameters) {
            return CallableReferenceBuilder.countContextTypeParameters$countImpl($this$countContextTypeParameters.getParent());
        }

        private final IrFunctionAccessExpression buildInvoke(IrSimpleFunction $this$buildInvoke) {
            int thisValue2;
            int ti;
            IrFunctionReference funRef;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunction callee = this.function;
            IrExpression $this$buildInvoke_u24lambda_u2419 = this.reference;
            boolean bl = false;
            IrFunction irFunction = callee;
            if (irFunction instanceof IrConstructor) {
                irFunctionAccessExpression = new IrConstructorCallImpl(-1, -1, IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(callee)), ((IrConstructor)callee).getSymbol(), this.countContextTypeParameters((IrConstructor)callee), callee.getTypeParameters().size(), callee.getValueParameters().size(), JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_INVOKE(), null, 256, null);
            } else if (irFunction instanceof IrSimpleFunction) {
                irFunctionAccessExpression = new IrCallImpl(-1, -1, callee.getReturnType(), ((IrSimpleFunction)callee).getSymbol(), callee.getTypeParameters().size(), callee.getValueParameters().size(), JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_INVOKE(), null, 128, null);
            } else {
                CompilationExceptionKt.compilationException("unknown function kind", callee);
                throw null;
            }
            IrFunctionAccessExpression irCall = irFunctionAccessExpression;
            IrExpression irExpression = this.reference;
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            IrFunctionReference $this$buildInvoke_u24lambda_u2420 = funRef = (IrFunctionReference)irExpression;
            boolean bl2 = false;
            IrExpression irExpression2 = $this$buildInvoke_u24lambda_u2420.getDispatchReceiver();
            if (irExpression2 == null) {
                irExpression2 = $this$buildInvoke_u24lambda_u2420.getExtensionReceiver();
            }
            boolean boundReceiver = irExpression2 != null;
            IrFunction $this$buildInvoke_u24lambda_u2421 = callee;
            boolean bl3 = false;
            IrValueParameter irValueParameter = $this$buildInvoke_u24lambda_u2421.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = $this$buildInvoke_u24lambda_u2421.getExtensionReceiverParameter();
            }
            boolean hasReceiver = irValueParameter != null;
            irCall.setDispatchReceiver(funRef.getDispatchReceiver());
            irCall.setExtensionReceiver(funRef.getExtensionReceiver());
            int i = 0;
            List<IrValueParameter> valueParameters = $this$buildInvoke.getValueParameters();
            int n = funRef.getTypeArgumentsCount();
            for (ti = 0; ti < n; ++ti) {
                irCall.putTypeArgument(ti, funRef.getTypeArgument(ti));
            }
            if (hasReceiver) {
                if (!boundReceiver) {
                    if (callee.getDispatchReceiverParameter() != null) {
                        ti = i;
                        i = ti + 1;
                        irCall.setDispatchReceiver(this.getValue(valueParameters.get(ti)));
                    }
                    if (callee.getExtensionReceiverParameter() != null) {
                        ti = i;
                        i = ti + 1;
                        irCall.setExtensionReceiver(this.getValue(valueParameters.get(ti)));
                    }
                } else {
                    IrField boundReceiverField = this.boundReceiverField;
                    if (boundReceiverField != null) {
                        IrValueParameter irValueParameter2 = $this$buildInvoke.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter2);
                        IrGetValue thisValue2 = this.getValue(irValueParameter2);
                        IrGetFieldImpl value2 = IrGetFieldImplKt.IrGetFieldImpl$default(-1, -1, boundReceiverField.getSymbol(), boundReceiverField.getType(), thisValue2, JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_INVOKE(), null, 64, null);
                        if (funRef.getDispatchReceiver() != null) {
                            irCall.setDispatchReceiver(value2);
                        }
                        if (funRef.getExtensionReceiver() != null) {
                            irCall.setExtensionReceiver(value2);
                        }
                    }
                    if (callee.getDispatchReceiverParameter() != null && funRef.getDispatchReceiver() == null) {
                        thisValue2 = i;
                        i = thisValue2 + 1;
                        irCall.setDispatchReceiver(this.getValue(valueParameters.get(thisValue2)));
                    }
                    if (callee.getExtensionReceiverParameter() != null && funRef.getExtensionReceiver() == null) {
                        thisValue2 = i;
                        i = thisValue2 + 1;
                        irCall.setExtensionReceiver(this.getValue(valueParameters.get(thisValue2)));
                    }
                }
            }
            int n2 = funRef.getValueArgumentsCount();
            for (thisValue2 = 0; thisValue2 < n2; ++thisValue2) {
                int it = thisValue2;
                boolean bl4 = false;
                IrExpression irExpression3 = funRef.getValueArgument(it);
                if (irExpression3 == null) {
                    int n3 = i;
                    i = n3 + 1;
                    irExpression3 = this.getValue(valueParameters.get(n3));
                }
                irCall.putValueArgument(it, irExpression3);
            }
            if (!(i == valueParameters.size())) {
                boolean bl5 = false;
                String string2 = "Unused parameters are left";
                throw new IllegalStateException(string2.toString());
            }
            return irCall;
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod) {
            void $this$mapIndexedTo$iv$iv;
            void $this$memoryOptimizedMapIndexed$iv;
            Object object;
            void $this$mapTo$iv$iv;
            IrType irType = this.reference.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            Iterable $this$map$iv = ((IrSimpleType)irType).getArguments();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
                object.add(((IrTypeProjection)it).getType());
            }
            List parameterTypes = (List)destination$iv$iv;
            List argumentTypes = CollectionsKt.dropLast((List)parameterTypes, (int)1);
            Collection $i$f$map22 = argumentTypes;
            object = $this$createFunctionReferenceInvokeMethod;
            boolean $i$f$memoryOptimizedMapIndexed = false;
            destination$iv$iv = (Iterable)$this$memoryOptimizedMapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList($this$memoryOptimizedMapIndexed$iv.size());
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void t;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrType irType2 = (IrType)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
                boolean bl2 = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2426_u24lambda_u2425 = $this$buildValueParameter_u24lambda_u2430$iv;
                boolean bl3 = false;
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2426_u24lambda_u2425.setName(Name.identifier("" + 'p' + (int)i));
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2426_u24lambda_u2425.setType((IrType)t);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2426_u24lambda_u2425.setIndex((int)i);
                collection.add(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$this$createFunctionReferenceInvokeMethod).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)$this$createFunctionReferenceInvokeMethod))));
            }
            ((IrFunction)object).setValueParameters(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv2));
            $this$createFunctionReferenceInvokeMethod.setBody(IrFactoryHelpersKt.createBlockBody($this$createFunctionReferenceInvokeMethod.getFactory(), -1, -1, CollectionsKt.listOf((Object)new IrReturnImpl(-1, -1, CallableReferenceLowering.this.nothingType, $this$createFunctionReferenceInvokeMethod.getSymbol(), this.buildInvoke($this$createFunctionReferenceInvokeMethod)))));
        }

        /*
         * WARNING - void declaration
         */
        private final void createNameProperty(IrClass clazz) {
            void $this$createNameProperty_u24lambda_u2430;
            IrSimpleFunction irSimpleFunction;
            void $this$addGetter$iv;
            Object nameProperty;
            void $this$filterIsInstanceTo$iv$iv;
            if (!this.isKReference) {
                return;
            }
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$single$iv = (List)destination$iv$iv;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.NAME)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty superProperty = single$iv;
            IrSimpleFunction irSimpleFunction2 = superProperty.getGetter();
            if (irSimpleFunction2 == null) {
                CompilationExceptionKt.compilationException("Expected getter for KFunction.name property", superProperty);
                throw null;
            }
            IrSimpleFunction supperGetter = irSimpleFunction2;
            IrClass $this$addProperty$iv = clazz;
            boolean $i$f$addProperty22 = false;
            Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv$iv = new IrPropertyBuilder();
            boolean bl = false;
            IrPropertyBuilder $this$createNameProperty_u24lambda_u2428 = $this$buildProperty_u24lambda_u248$iv$iv;
            boolean bl2 = false;
            $this$createNameProperty_u24lambda_u2428.setVisibility(superProperty.getVisibility());
            $this$createNameProperty_u24lambda_u2428.setName(superProperty.getName());
            $this$createNameProperty_u24lambda_u2428.setOrigin(Companion.getGENERATED_MEMBER_IN_CALLABLE_REFERENCE());
            Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u248$iv$iv);
            boolean bl3 = false;
            $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
            property$iv.setParent($this$addProperty$iv);
            Object $i$f$addProperty22 = nameProperty = $this$buildProperty$iv$iv;
            $this$buildProperty$iv$iv = CallableReferenceLowering.this;
            boolean $i$f$addGetter = false;
            IrDeclarationBuilder $this$addGetter_u24lambda_u2411$iv = new IrFunctionBuilder();
            boolean bl4 = false;
            $this$addGetter_u24lambda_u2411$iv.setName(Name.special("<get-" + $this$addGetter$iv.getName() + '>'));
            IrFunctionBuilder $this$createNameProperty_u24lambda_u2429 = $this$addGetter_u24lambda_u2411$iv;
            boolean bl5 = false;
            $this$createNameProperty_u24lambda_u2429.setReturnType(((CallableReferenceLowering)$this$buildProperty$iv$iv).stringType);
            IrSimpleFunction getter$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), $this$addGetter_u24lambda_u2411$iv);
            boolean bl6 = false;
            $this$addGetter$iv.setGetter(getter$iv);
            getter$iv.setCorrespondingPropertySymbol($this$addGetter$iv.getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            IrSimpleFunction getter2 = irSimpleFunction;
            getter2.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(getter2.getOverriddenSymbols(), supperGetter.getSymbol()));
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
            boolean bl7 = false;
            $this$addGetter_u24lambda_u2411$iv = $this$buildValueParameter_u24lambda_u2430$iv;
            IrSimpleFunction irSimpleFunction3 = getter2;
            boolean bl8 = false;
            $this$createNameProperty_u24lambda_u2430.setName(SpecialNames.THIS);
            $this$createNameProperty_u24lambda_u2430.setType(IrUtilsKt.getDefaultType(clazz));
            irSimpleFunction3.setDispatchReceiverParameter(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)getter2).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)getter2))));
            IrFactory irFactory = CallableReferenceLowering.this.context.getIrFactory();
            IrType irType = CallableReferenceLowering.this.nothingType;
            IrReturnTargetSymbol irReturnTargetSymbol = getter2.getSymbol();
            IrType irType2 = CallableReferenceLowering.this.stringType;
            IrFunction irFunction = this.reflectionTarget;
            Intrinsics.checkNotNull((Object)irFunction);
            String string2 = irFunction.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            getter2.setBody(IrFactoryHelpersKt.createBlockBody(irFactory, -1, -1, CollectionsKt.listOf((Object)new IrReturnImpl(-1, -1, irType, irReturnTargetSymbol, IrConstImpl.Companion.string(-1, -1, irType2, string2)))));
            CallableReferenceLowering.this.context.getMapping().getReflectedNameAccessor().set((IrClass)((IrDeclaration)clazz), getter2);
        }

        @NotNull
        public final Pair<IrClass, IrConstructor> build() {
            IrClass clazz = this.buildReferenceClass();
            IrConstructor ctor = this.createConstructor(clazz);
            this.createInvokeMethod(clazz);
            this.createNameProperty(clazz);
            return new Pair((Object)clazz, (Object)ctor);
        }

        private static final boolean collectNamesForLambda$isLambdaFun(IrDeclaration $this$collectNamesForLambda_u24isLambdaFun) {
            return Intrinsics.areEqual((Object)$this$collectNamesForLambda_u24isLambdaFun.getOrigin(), (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA());
        }

        /*
         * WARNING - void declaration
         */
        private static final int countContextTypeParameters$countImpl(IrDeclarationParent container) {
            int n;
            IrDeclarationParent irDeclarationParent = container;
            if (irDeclarationParent instanceof IrClass) {
                void $this$countContextTypeParameters_u24countImpl_u24lambda_u2417;
                IrClass irClass = (IrClass)container;
                int n2 = ((IrClass)container).getTypeParameters().size();
                boolean bl = false;
                int n3 = $this$countContextTypeParameters_u24countImpl_u24lambda_u2417.isInner() ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrClass)container).getParent()) : 0;
                n = n2 + n3;
            } else if (irDeclarationParent instanceof IrFunction) {
                n = ((IrFunction)container).getTypeParameters().size() + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrFunction)container).getParent());
            } else if (irDeclarationParent instanceof IrProperty) {
                IrElement $this$countContextTypeParameters_u24countImpl_u24lambda_u2418 = container;
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2418).getGetter();
                if (irSimpleFunction == null) {
                    irSimpleFunction = ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2418).getSetter();
                }
                Object object = irSimpleFunction;
                n = (irSimpleFunction != null && (object = object.getTypeParameters()) != null ? object.size() : 0) + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrDeclaration)((Object)container)).getParent());
            } else {
                n = irDeclarationParent instanceof IrDeclaration ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrDeclaration)((Object)container)).getParent()) : 0;
            }
            return n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion;", "", "<init>", "()V", "LAMBDA_IMPL", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getLAMBDA_IMPL", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "LAMBDA_IMPL$delegate", "Lkotlin/properties/ReadOnlyProperty;", "FUNCTION_REFERENCE_IMPL", "getFUNCTION_REFERENCE_IMPL", "FUNCTION_REFERENCE_IMPL$delegate", "GENERATED_MEMBER_IN_CALLABLE_REFERENCE", "getGENERATED_MEMBER_IN_CALLABLE_REFERENCE", "GENERATED_MEMBER_IN_CALLABLE_REFERENCE$delegate", "BOUND_RECEIVER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getBOUND_RECEIVER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "backend.js"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getLAMBDA_IMPL() {
            return (IrDeclarationOriginImpl)LAMBDA_IMPL$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @NotNull
        public final IrDeclarationOriginImpl getFUNCTION_REFERENCE_IMPL() {
            return (IrDeclarationOriginImpl)FUNCTION_REFERENCE_IMPL$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        @NotNull
        public final IrDeclarationOriginImpl getGENERATED_MEMBER_IN_CALLABLE_REFERENCE() {
            return (IrDeclarationOriginImpl)GENERATED_MEMBER_IN_CALLABLE_REFERENCE$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        @NotNull
        public final Name getBOUND_RECEIVER_NAME() {
            return BOUND_RECEIVER_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "LAMBDA_IMPL", "getLAMBDA_IMPL()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;"))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "FUNCTION_REFERENCE_IMPL", "getFUNCTION_REFERENCE_IMPL()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;"))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "GENERATED_MEMBER_IN_CALLABLE_REFERENCE", "getGENERATED_MEMBER_IN_CALLABLE_REFERENCE()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;")))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "visitBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "buildFunctionReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildLambdaReference", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nCallableReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$ReferenceTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,480:1\n1#2:481\n*E\n"})
    private final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrDeclarationParent container;

        public ReferenceTransformer(IrDeclarationParent container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.container = container;
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2) {
            Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction function2 = expression2.getFunction();
            Pair<IrClass, IrConstructor> pair = this.buildLambdaReference(function2, expression2);
            IrClass clazz = (IrClass)pair.component1();
            IrConstructor ctor = (IrConstructor)pair.component2();
            clazz.setParent(this.container);
            IrFunctionExpression irFunctionExpression = expression2;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            IrFunctionExpression $this$visitFunctionExpression_u24lambda_u241 = irFunctionExpression;
            boolean bl = false;
            int vpCount = function2.isSuspend() ? 1 : 0;
            Object[] $this$visitFunctionExpression_u24lambda_u241_u24lambda_u240 = objectArray = new IrConstructorCallImpl($this$visitFunctionExpression_u24lambda_u241.getStartOffset(), $this$visitFunctionExpression_u24lambda_u241.getEndOffset(), $this$visitFunctionExpression_u24lambda_u241.getType(), ctor.getSymbol(), 0, 0, vpCount, JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_CREATE(), null, 256, null);
            boolean bl2 = false;
            if (function2.isSuspend()) {
                $this$visitFunctionExpression_u24lambda_u241_u24lambda_u240.putValueArgument(0, IrConstImpl.Companion.constNull($this$visitFunctionExpression_u24lambda_u241_u24lambda_u240.getStartOffset(), $this$visitFunctionExpression_u24lambda_u241_u24lambda_u240.getEndOffset(), callableReferenceLowering2.context.getIrBuiltIns().getNothingNType()));
            }
            Object[] ctorCall = objectArray;
            objectArray = new IrElement[]{clazz, ctorCall};
            return new IrCompositeImpl($this$visitFunctionExpression_u24lambda_u241.getStartOffset(), $this$visitFunctionExpression_u24lambda_u241.getEndOffset(), $this$visitFunctionExpression_u24lambda_u241.getType(), $this$visitFunctionExpression_u24lambda_u241.getOrigin(), CollectionsKt.listOf((Object[])objectArray));
        }

        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Object[] objectArray;
            IrExpression boundReceiver;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            Pair<IrClass, IrConstructor> pair = this.buildFunctionReference(expression2);
            IrClass clazz = (IrClass)pair.component1();
            IrConstructor ctor = (IrConstructor)pair.component2();
            clazz.setParent(this.container);
            IrFunctionReference $this$visitFunctionReference_u24lambda_u245 = expression2;
            boolean bl = false;
            IrFunctionReference $this$visitFunctionReference_u24lambda_u245_u24lambda_u242 = expression2;
            boolean bl2 = false;
            IrExpression irExpression = $this$visitFunctionReference_u24lambda_u245_u24lambda_u242.getDispatchReceiver();
            if (irExpression == null) {
                irExpression = $this$visitFunctionReference_u24lambda_u245_u24lambda_u242.getExtensionReceiver();
            }
            int vpCount = (boundReceiver = irExpression) != null ? 1 : 0;
            Object[] $this$visitFunctionReference_u24lambda_u245_u24lambda_u244 = objectArray = new IrConstructorCallImpl($this$visitFunctionReference_u24lambda_u245.getStartOffset(), $this$visitFunctionReference_u24lambda_u245.getEndOffset(), $this$visitFunctionReference_u24lambda_u245.getType(), ctor.getSymbol(), 0, 0, vpCount, JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_CREATE(), null, 256, null);
            boolean bl3 = false;
            IrExpression irExpression2 = boundReceiver;
            if (irExpression2 != null) {
                IrExpression it = irExpression2;
                boolean bl4 = false;
                $this$visitFunctionReference_u24lambda_u245_u24lambda_u244.putValueArgument(0, it);
            }
            Object[] ctorCall = objectArray;
            objectArray = new IrElement[]{clazz, ctorCall};
            return new IrCompositeImpl($this$visitFunctionReference_u24lambda_u245.getStartOffset(), $this$visitFunctionReference_u24lambda_u245.getEndOffset(), $this$visitFunctionReference_u24lambda_u245.getType(), $this$visitFunctionReference_u24lambda_u245.getOrigin(), CollectionsKt.listOf((Object[])objectArray));
        }

        private final Pair<IrClass, IrConstructor> buildFunctionReference(IrFunctionReference expression2) {
            IrFunction target = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
            Object object = expression2.getReflectionTarget();
            if (object == null || (object = object.getOwner()) == null) {
                object = target;
            }
            Object reflectionTarget = object;
            return new CallableReferenceBuilder(target, expression2, (IrFunction)reflectionTarget).build();
        }

        private final Pair<IrClass, IrConstructor> buildLambdaReference(IrSimpleFunction function2, IrFunctionExpression expression2) {
            return new CallableReferenceBuilder(function2, expression2, null).build();
        }
    }
}

