/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRendererForDiagnostics;
import org.jetbrains.kotlin.fir.renderer.ConeIdShortRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRendererForDebugging;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRendererForReadability;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u00022\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\f\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\f\u001a.\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0012*\u00020\u0012\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\f\u001a\u001f\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\u0010 \u001a\u0012\u0010!\u001a\u00020\u001f*\u00020\u00022\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010!\u001a\u00020\u001f*\u00020\u00022\u0006\u0010$\u001a\u00020%\u001a\n\u0010&\u001a\u00020\u001c*\u00020\u001c\u001a\n\u0010'\u001a\u00020(*\u00020\u0002\u001a\n\u0010)\u001a\u00020(*\u00020\u0002\u001a\n\u0010*\u001a\u00020(*\u00020\u0002\u001a\n\u0010+\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010,\u001a\u00020\u0001*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006-"}, d2={"isNullable", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isMarkedNullable", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/name/ClassId;", "forEachType", "", "action", "Lkotlin/Function1;", "contains", "predicate", "visited", "Lorg/jetbrains/kotlin/utils/SmartSet;", "unwrapLowerBound", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "upperBoundIfFlexible", "lowerBoundIfFlexible", "originalIfDefinitelyNotNullable", "withAlternative", "Lorg/jetbrains/kotlin/fir/types/ConeIntersectionType;", "alternativeType", "mapTypes", "func", "withArguments", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toTypeProjection", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "projectionKind", "Lorg/jetbrains/kotlin/fir/types/ProjectionKind;", "replaceArgumentsWithStarProjections", "renderForDebugging", "", "renderReadable", "renderReadableWithFqNames", "hasError", "hasCapture", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,142:1\n1863#2,2:143\n1755#2,3:147\n1557#2:152\n1628#2,3:153\n13346#3,2:145\n12511#3,2:150\n*S KotlinDebug\n*F\n+ 1 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n*L\n32#1:143,2\n49#1:147,3\n90#1:152\n90#1:153,3\n33#1:145,2\n50#1:150,2\n*E\n"})
public final class ConeTypeUtilsKt {
    public static final boolean isNullable(@NotNull ConeKotlinType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
        return $this$isNullable.getNullability() != ConeNullability.NOT_NULL;
    }

    public static final boolean isMarkedNullable(@NotNull ConeKotlinType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedNullable, (String)"<this>");
        return $this$isMarkedNullable.getNullability() == ConeNullability.NULLABLE;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull ConeKotlinType $this$classId) {
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        Object object = $this$classId instanceof ConeClassLikeType ? (ConeClassLikeType)$this$classId : null;
        return object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null;
    }

    public static final void forEachType(@NotNull ConeKotlinType $this$forEachType, @NotNull Function1<? super ConeKotlinType, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachType, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke((Object)$this$forEachType);
        ConeKotlinType coneKotlinType = $this$forEachType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            ConeTypeUtilsKt.forEachType(((ConeFlexibleType)$this$forEachType).getLowerBound(), action);
            ConeTypeUtilsKt.forEachType(((ConeFlexibleType)$this$forEachType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            ConeTypeUtilsKt.forEachType(((ConeDefinitelyNotNullType)$this$forEachType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                ConeTypeUtilsKt.forEachType(it, action);
            }
        } else {
            ConeTypeProjection[] $this$forEach$iv = $this$forEachType.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!(it instanceof ConeKotlinTypeProjection)) continue;
                ConeTypeUtilsKt.forEachType(((ConeKotlinTypeProjection)it).getType(), action);
            }
        }
    }

    public static final boolean contains(@NotNull ConeKotlinType $this$contains, @NotNull Function1<? super ConeKotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return ConeTypeUtilsKt.contains($this$contains, predicate, SmartSet.Companion.create());
    }

    private static final boolean contains(ConeKotlinType $this$contains, Function1<? super ConeKotlinType, Boolean> predicate, SmartSet<ConeKotlinType> visited2) {
        boolean bl;
        block12: {
            if (visited2.contains($this$contains)) {
                return false;
            }
            if (((Boolean)predicate.invoke((Object)$this$contains)).booleanValue()) {
                return true;
            }
            ((Collection)((Object)visited2)).add($this$contains);
            ConeKotlinType coneKotlinType = $this$contains;
            if (coneKotlinType instanceof ConeFlexibleType) {
                bl = ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getLowerBound(), predicate, visited2) || ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getUpperBound(), predicate, visited2);
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = ConeTypeUtilsKt.contains(((ConeDefinitelyNotNullType)$this$contains).getOriginal(), predicate, visited2);
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$contains).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!ConeTypeUtilsKt.contains(it, predicate, visited2)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            } else {
                ConeTypeProjection[] $this$any$iv = $this$contains.getTypeArguments();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    if (!(it instanceof ConeKotlinTypeProjection && ConeTypeUtilsKt.contains(((ConeKotlinTypeProjection)it).getType(), predicate, visited2))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final ConeSimpleKotlinType unwrapLowerBound(@NotNull ConeKotlinType $this$unwrapLowerBound) {
        ConeSimpleKotlinType coneSimpleKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapLowerBound, (String)"<this>");
        ConeKotlinType coneKotlinType = $this$unwrapLowerBound;
        if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            coneSimpleKotlinType = ConeTypeUtilsKt.unwrapLowerBound(((ConeDefinitelyNotNullType)$this$unwrapLowerBound).getOriginal());
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            coneSimpleKotlinType = ConeTypeUtilsKt.unwrapLowerBound(((ConeFlexibleType)$this$unwrapLowerBound).getLowerBound());
        } else if (coneKotlinType instanceof ConeSimpleKotlinType) {
            coneSimpleKotlinType = (ConeSimpleKotlinType)$this$unwrapLowerBound;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneSimpleKotlinType;
    }

    @NotNull
    public static final ConeSimpleKotlinType upperBoundIfFlexible(@NotNull ConeKotlinType $this$upperBoundIfFlexible) {
        ConeSimpleKotlinType coneSimpleKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$upperBoundIfFlexible, (String)"<this>");
        ConeKotlinType coneKotlinType = $this$upperBoundIfFlexible;
        if (coneKotlinType instanceof ConeSimpleKotlinType) {
            coneSimpleKotlinType = (ConeSimpleKotlinType)$this$upperBoundIfFlexible;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            coneSimpleKotlinType = ((ConeFlexibleType)$this$upperBoundIfFlexible).getUpperBound();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneSimpleKotlinType;
    }

    @NotNull
    public static final ConeSimpleKotlinType lowerBoundIfFlexible(@NotNull ConeKotlinType $this$lowerBoundIfFlexible) {
        ConeSimpleKotlinType coneSimpleKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$lowerBoundIfFlexible, (String)"<this>");
        ConeKotlinType coneKotlinType = $this$lowerBoundIfFlexible;
        if (coneKotlinType instanceof ConeSimpleKotlinType) {
            coneSimpleKotlinType = (ConeSimpleKotlinType)$this$lowerBoundIfFlexible;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            coneSimpleKotlinType = ((ConeFlexibleType)$this$lowerBoundIfFlexible).getLowerBound();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneSimpleKotlinType;
    }

    @NotNull
    public static final ConeSimpleKotlinType originalIfDefinitelyNotNullable(@NotNull ConeSimpleKotlinType $this$originalIfDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$originalIfDefinitelyNotNullable, (String)"<this>");
        return $this$originalIfDefinitelyNotNullable instanceof ConeDefinitelyNotNullType ? ((ConeDefinitelyNotNullType)$this$originalIfDefinitelyNotNullable).getOriginal() : $this$originalIfDefinitelyNotNullable;
    }

    @NotNull
    public static final ConeIntersectionType withAlternative(@NotNull ConeIntersectionType $this$withAlternative, @NotNull ConeKotlinType alternativeType) {
        Intrinsics.checkNotNullParameter((Object)$this$withAlternative, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alternativeType, (String)"alternativeType");
        return new ConeIntersectionType($this$withAlternative.getIntersectedTypes(), alternativeType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeIntersectionType mapTypes(@NotNull ConeIntersectionType $this$mapTypes, @NotNull Function1<? super ConeKotlinType, ? extends ConeKotlinType> func) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$mapTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Iterable $this$map$iv = $this$mapTypes.getIntersectedTypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(func.invoke(item$iv$iv));
        }
        ConeKotlinType coneKotlinType = $this$mapTypes.getAlternativeType();
        ConeKotlinType coneKotlinType2 = coneKotlinType != null ? (ConeKotlinType)func.invoke((Object)coneKotlinType) : null;
        Collection collection = (List)destination$iv$iv;
        return new ConeIntersectionType(collection, coneKotlinType2);
    }

    @NotNull
    public static final ConeClassLikeType withArguments(@NotNull ConeClassLikeType $this$withArguments, @NotNull ConeTypeProjection[] typeArguments) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$withArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeArguments, (String)"typeArguments");
        ConeClassLikeType coneClassLikeType2 = $this$withArguments;
        if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$withArguments).getLookupTag(), typeArguments, ConeTypeUtilsKt.isNullable($this$withArguments), ((ConeClassLikeTypeImpl)$this$withArguments).getAttributes());
        } else if (coneClassLikeType2 instanceof ConeErrorType) {
            coneClassLikeType = $this$withArguments;
        } else {
            throw new IllegalStateException(("Unknown cone type: " + Reflection.getOrCreateKotlinClass($this$withArguments.getClass())).toString());
        }
        return coneClassLikeType;
    }

    @NotNull
    public static final ConeTypeProjection toTypeProjection(@NotNull ConeKotlinType $this$toTypeProjection, @NotNull Variance variance) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeProjection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
        switch (WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
            case 1: {
                coneTypeProjection = $this$toTypeProjection;
                break;
            }
            case 2: {
                coneTypeProjection = new ConeKotlinTypeProjectionIn($this$toTypeProjection);
                break;
            }
            case 3: {
                coneTypeProjection = new ConeKotlinTypeProjectionOut($this$toTypeProjection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneTypeProjection;
    }

    @NotNull
    public static final ConeTypeProjection toTypeProjection(@NotNull ConeKotlinType $this$toTypeProjection, @NotNull ProjectionKind projectionKind) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeProjection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)projectionKind), (String)"projectionKind");
        switch (WhenMappings.$EnumSwitchMapping$1[projectionKind.ordinal()]) {
            case 1: {
                coneTypeProjection = $this$toTypeProjection;
                break;
            }
            case 2: {
                coneTypeProjection = new ConeKotlinTypeProjectionIn($this$toTypeProjection);
                break;
            }
            case 3: {
                coneTypeProjection = new ConeKotlinTypeProjectionOut($this$toTypeProjection);
                break;
            }
            case 4: {
                coneTypeProjection = ConeStarProjection.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneTypeProjection;
    }

    @NotNull
    public static final ConeClassLikeType replaceArgumentsWithStarProjections(@NotNull ConeClassLikeType $this$replaceArgumentsWithStarProjections) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceArgumentsWithStarProjections, (String)"<this>");
        if ($this$replaceArgumentsWithStarProjections.getTypeArguments().length == 0) {
            return $this$replaceArgumentsWithStarProjections;
        }
        int n = 0;
        int n2 = $this$replaceArgumentsWithStarProjections.getTypeArguments().length;
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[n2];
        while (n < n2) {
            int n3 = n++;
            coneStarProjectionArray[n3] = ConeStarProjection.INSTANCE;
        }
        ConeStarProjection[] newArguments2 = coneStarProjectionArray;
        return ConeTypeUtilsKt.withArguments($this$replaceArgumentsWithStarProjections, newArguments2);
    }

    @NotNull
    public static final String renderForDebugging(@NotNull ConeKotlinType $this$renderForDebugging) {
        Intrinsics.checkNotNullParameter((Object)$this$renderForDebugging, (String)"<this>");
        StringBuilder builder = new StringBuilder();
        new ConeTypeRendererForDebugging(builder).render($this$renderForDebugging);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public static final String renderReadable(@NotNull ConeKotlinType $this$renderReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$renderReadable, (String)"<this>");
        StringBuilder builder = new StringBuilder();
        new ConeTypeRendererForReadability(builder, (Function0<? extends ConeIdRenderer>)((Function0)ConeTypeUtilsKt::renderReadable$lambda$4)).render($this$renderReadable);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public static final String renderReadableWithFqNames(@NotNull ConeKotlinType $this$renderReadableWithFqNames) {
        Intrinsics.checkNotNullParameter((Object)$this$renderReadableWithFqNames, (String)"<this>");
        StringBuilder builder = new StringBuilder();
        new ConeTypeRendererForReadability(builder, (Function0<? extends ConeIdRenderer>)((Function0)ConeTypeUtilsKt::renderReadableWithFqNames$lambda$5)).render($this$renderReadableWithFqNames);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static final boolean hasError(@NotNull ConeKotlinType $this$hasError) {
        Intrinsics.checkNotNullParameter((Object)$this$hasError, (String)"<this>");
        return ConeTypeUtilsKt.contains($this$hasError, (Function1<? super ConeKotlinType, Boolean>)((Function1)ConeTypeUtilsKt::hasError$lambda$6));
    }

    public static final boolean hasCapture(@NotNull ConeKotlinType $this$hasCapture) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCapture, (String)"<this>");
        return ConeTypeUtilsKt.contains($this$hasCapture, (Function1<? super ConeKotlinType, Boolean>)((Function1)ConeTypeUtilsKt::hasCapture$lambda$7));
    }

    private static final ConeIdRenderer renderReadable$lambda$4() {
        return new ConeIdShortRenderer();
    }

    private static final ConeIdRenderer renderReadableWithFqNames$lambda$5() {
        return new ConeIdRendererForDiagnostics();
    }

    private static final boolean hasError$lambda$6(ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ConeErrorType;
    }

    private static final boolean hasCapture$lambda$7(ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ConeCapturedType;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

