/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020\b*\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/utils/LibraryUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TITLE_KOTLIN_JAVASCRIPT_STDLIB", "", "META_INF", "getMETA_INF", "()Ljava/lang/String;", "MANIFEST_PATH", "getJarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classesRoots", "", "jarName", "isKotlinJavascriptStdLibrary", "", "library", "Ljava/io/File;", "getManifestFromJar", "Ljava/util/jar/Manifest;", "getManifestFromDirectory", "getManifestFromJarOrDirectory", "getManifestMainAttributesFromJarOrDirectory", "Ljava/util/jar/Attributes;", "checkAttributeValue", "expected", "attributeName", "Ljava/util/jar/Attributes$Name;", "getPropertyOrFail", "Ljava/util/Properties;", "propName", "util"})
@SourceDebugExtension(value={"SMAP\nLibraryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryUtils.kt\norg/jetbrains/kotlin/utils/LibraryUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n288#2,2:124\n*S KotlinDebug\n*F\n+ 1 LibraryUtils.kt\norg/jetbrains/kotlin/utils/LibraryUtils\n*L\n58#1:124,2\n*E\n"})
public final class LibraryUtils {
    @NotNull
    public static final LibraryUtils INSTANCE = new LibraryUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    @NotNull
    private static final String META_INF;
    @NotNull
    private static final String MANIFEST_PATH;

    private LibraryUtils() {
    }

    @NotNull
    public final String getMETA_INF() {
        return META_INF;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getJarFile(@NotNull List<? extends VirtualFile> classesRoots, @NotNull String jarName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(classesRoots, (String)"classesRoots");
            Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
            Iterable $this$firstOrNull$iv = classesRoots;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)jarName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptStdLibrary(@NotNull File library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Attributes.Name name2 = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"IMPLEMENTATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            Closeable closeable = new JarFile(library);
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                boolean bl = false;
                Manifest manifest2 = jarFile.getManifest();
                return manifest2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(File library) {
        if (!library.canRead() || !library.isDirectory()) {
            return null;
        }
        File manifestFile2 = new File(library, MANIFEST_PATH);
        if (!manifestFile2.exists()) {
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(manifestFile2);){
            Manifest manifest2 = new Manifest(inputStream);
            return manifest2;
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(File library) {
        Manifest manifest2 = this.getManifestFromJarOrDirectory(library);
        return manifest2 != null ? manifest2.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(File library, String expected, Attributes.Name attributeName) {
        Attributes attributes2;
        Attributes attributes3 = attributes2 = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value2 = attributes3 != null ? attributes3.getValue(attributeName) : null;
        return value2 != null && Intrinsics.areEqual((Object)value2, (Object)expected);
    }

    private final String getPropertyOrFail(Properties $this$getPropertyOrFail, String propName) {
        String value2 = $this$getPropertyOrFail.getProperty(propName);
        if (value2 == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $this$getPropertyOrFail.list(new PrintStream(bytes));
            LOG.error(propName + " not found.\n " + bytes);
        }
        Intrinsics.checkNotNull((Object)value2);
        return value2;
    }

    static {
        Logger logger = Logger.getInstance(LibraryUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        META_INF = "META-INF/";
        MANIFEST_PATH = META_INF + "MANIFEST.MF";
        String jsStdLib = "";
        InputStream manifestProperties2 = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties2 != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties2);
                jsStdLib = INSTANCE.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
    }
}

