/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J4\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "localVariableResolver", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "resolveLocalVariablesFromDestructuringDeclaration", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "defineLocalVariablesFromDestructuringDeclaration", "", "writableScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "resolveInitializer", "Lorg/jetbrains/kotlin/types/KotlinType;", "entry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "componentIndex", "", "resolveComponentFunctionAndGetType", "componentName", "Lorg/jetbrains/kotlin/name/Name;", "getExpectedTypeForComponent", "frontend"})
@SourceDebugExtension(value={"SMAP\nDestructuringDeclarationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DestructuringDeclarationResolver.kt\norg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1853#2,2:132\n*S KotlinDebug\n*F\n+ 1 DestructuringDeclarationResolver.kt\norg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver\n*L\n74#1:132,2\n*E\n"})
public final class DestructuringDeclarationResolver {
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final LocalVariableResolver localVariableResolver;
    @NotNull
    private final TypeResolver typeResolver;

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkNotNullParameter((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkNotNullParameter((Object)localVariableResolver, (String)"localVariableResolver");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
    }

    @NotNull
    public final List<VariableDescriptor> resolveLocalVariablesFromDestructuringDeclaration(@NotNull LexicalScope scope2, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ArrayList<LocalVariableDescriptor> result2 = new ArrayList<LocalVariableDescriptor>();
        Iterator<KtDestructuringDeclarationEntry> iterator2 = destructuringDeclaration.getEntries().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int componentIndex = n++;
            KtDestructuringDeclarationEntry entry = iterator2.next();
            Intrinsics.checkNotNull((Object)entry);
            KotlinType componentType = this.resolveInitializer(entry, receiver, initializer2, context2, componentIndex);
            KtVariableDeclaration ktVariableDeclaration = entry;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$frontend(scope2, ktVariableDeclaration, componentType, bindingTrace);
            result2.add(variableDescriptor);
        }
        PsiElement psiElement = destructuringDeclaration.getTrailingComma();
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        LanguageVersionSettings languageVersionSettings2 = context2.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings2, (String)"languageVersionSettings");
        TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, languageVersionSettings2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void defineLocalVariablesFromDestructuringDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context2) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)writableScope, (String)"writableScope");
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable iterable = this.resolveLocalVariablesFromDestructuringDeclaration(writableScope, destructuringDeclaration, receiver, initializer2, context2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDescriptor it = (VariableDescriptor)element$iv;
            boolean bl = false;
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context2.trace, it);
            writableScope.addVariableDescriptor(it);
        }
    }

    @NotNull
    public final KotlinType resolveInitializer(@NotNull KtDestructuringDeclarationEntry entry, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context2, int componentIndex) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Name componentName = DataClassDescriptorResolver.INSTANCE.createComponentName(componentIndex + 1);
        return this.resolveComponentFunctionAndGetType(componentName, context2, entry, receiver, initializer2);
    }

    private final KotlinType resolveComponentFunctionAndGetType(Name componentName, ExpressionTypingContext context2, KtDestructuringDeclarationEntry entry, ReceiverValue receiver, KtExpression initializer2) {
        KotlinType kotlinType;
        OverloadResolutionResults<FunctionDescriptor> results;
        if (receiver == null) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        KotlinType expectedType = this.getExpectedTypeForComponent(context2, entry);
        Object Context2 = ((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceContextDependency(...)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
        ResolutionContext resolutionContext = newContext;
        KtExpression ktExpression = entry;
        KtExpression ktExpression2 = initializer2;
        if (ktExpression2 == null) {
            ktExpression2 = entry;
        }
        if (!(results = this.fakeCallResolver.resolveFakeCall(resolutionContext, receiver, componentName, ktExpression, ktExpression2, FakeCallKind.COMPONENT, CollectionsKt.emptyList())).isSuccess()) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        context2.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
        KotlinType functionReturnType = results.getResultingDescriptor().getReturnType();
        if (functionReturnType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(functionReturnType, expectedType)) {
            BindingTrace bindingTrace = context2.trace;
            KtExpression ktExpression3 = initializer2;
            if (ktExpression3 == null) {
                ktExpression3 = entry;
            }
            bindingTrace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)ktExpression3), componentName, functionReturnType, expectedType));
        }
        if ((kotlinType = functionReturnType) == null) {
            kotlinType = DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        return kotlinType;
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context2, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
            return simpleType2;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        return this.typeResolver.resolveType(lexicalScope, entryTypeRef, bindingTrace, true);
    }

    private static final ErrorType resolveComponentFunctionAndGetType$errorType(Name $componentName) {
        String[] stringArray = new String[]{$componentName.toString()};
        return ErrorUtils.createErrorType(ErrorTypeKind.ERROR_TYPE_FOR_DESTRUCTURING_COMPONENT, stringArray);
    }
}

