/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\nJ$\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "", "previousStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Ljava/util/List;)V", "renamings", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "declarations", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "addedDeclarations", "", "applyRenameTo", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "target", "replaceName", "", "name", "replacement", "newVar", "value", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "source", "js.translator"})
@SourceDebugExtension(value={"SMAP\nNamingContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingContext.kt\norg/jetbrains/kotlin/js/inline/context/NamingContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class NamingContext {
    @NotNull
    private final List<JsStatement> previousStatements;
    @NotNull
    private final Map<JsName, JsNameRef> renamings;
    @NotNull
    private final List<JsVars> declarations;
    private boolean addedDeclarations;

    public NamingContext(@NotNull List<JsStatement> previousStatements) {
        Intrinsics.checkNotNullParameter(previousStatements, (String)"previousStatements");
        this.previousStatements = previousStatements;
        this.renamings = new LinkedHashMap();
        this.declarations = new ArrayList();
    }

    @NotNull
    public final JsNode applyRenameTo(@NotNull JsNode target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.addedDeclarations) {
            this.previousStatements.addAll((Collection<JsStatement>)this.declarations);
            this.addedDeclarations = true;
        }
        return RewriteUtilsKt.replaceNames(target, this.renamings);
    }

    public final void replaceName(@NotNull JsName name2, @NotNull JsNameRef replacement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        boolean bl2 = bl = !this.renamings.containsKey(name2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = name2 + " has been renamed already";
            throw new AssertionError((Object)string2);
        }
        this.renamings.put(name2, replacement);
    }

    public final void newVar(@NotNull JsName name2, @Nullable JsExpression value2, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        JsVars jsVars = JsAstUtils.newVar(name2, value2);
        Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"newVar(...)");
        JsVars vars = jsVars;
        MetadataProperties.setSynthetic(vars, true);
        vars.setSource(source);
        this.declarations.add(vars);
    }

    public static /* synthetic */ void newVar$default(NamingContext namingContext, JsName jsName, JsExpression jsExpression, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            jsExpression = null;
        }
        namingContext.newVar(jsName, jsExpression, object);
    }
}

