/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrSetValueImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "<init>", "(IILorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;)V", "getStartOffset", "()I", "getEndOffset", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "setSymbol", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;)V", "getValue", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "setValue", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "setOrigin", "(Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;)V", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrSetValueImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrSetValueImpl.kt\norg/jetbrains/kotlin/ir/expressions/impl/IrSetValueImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class IrSetValueImpl
extends IrSetValue {
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private IrType type;
    @NotNull
    private IrValueSymbol symbol;
    @NotNull
    private IrExpression value;
    @Nullable
    private IrStatementOrigin origin;

    public IrSetValueImpl(int startOffset, int endOffset, @NotNull IrType type2, @NotNull IrValueSymbol symbol2, @NotNull IrExpression value2, @Nullable IrStatementOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type2;
        this.symbol = symbol2;
        this.value = value2;
        this.origin = origin;
        if (this.getSymbol().isBound()) {
            boolean bl = this.getSymbol().getOwner().isAssignable();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Only assignable IrValues can be set";
                throw new AssertionError((Object)string2);
            }
        }
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    @NotNull
    public IrType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<set-?>");
        this.type = irType;
    }

    @Override
    @NotNull
    public IrValueSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(@NotNull IrValueSymbol irValueSymbol) {
        Intrinsics.checkNotNullParameter((Object)irValueSymbol, (String)"<set-?>");
        this.symbol = irValueSymbol;
    }

    @Override
    @NotNull
    public IrExpression getValue() {
        return this.value;
    }

    @Override
    public void setValue(@NotNull IrExpression irExpression) {
        Intrinsics.checkNotNullParameter((Object)irExpression, (String)"<set-?>");
        this.value = irExpression;
    }

    @Override
    @Nullable
    public IrStatementOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(@Nullable IrStatementOrigin irStatementOrigin) {
        this.origin = irStatementOrigin;
    }
}

