/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "", "file", "Ljava/io/File;", "length", "", "hash", "", "<init>", "(Ljava/io/File;J[B)V", "getFile", "()Ljava/io/File;", "getLength", "()J", "getHash", "()[B", "equals", "", "other", "hashCode", "", "toString", "", "incremental-compilation-impl"})
public final class FileSnapshot {
    @NotNull
    private final File file;
    private final long length;
    @NotNull
    private final byte[] hash;

    public FileSnapshot(@NotNull File file2, long length, @NotNull byte[] hash) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this.file = file2;
        this.length = length;
        this.hash = hash;
        boolean bl2 = bl = !this.file.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final long getLength() {
        return this.length;
    }

    @NotNull
    public final byte[] getHash() {
        return this.hash;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(other.getClass(), this.getClass())) {
            return false;
        }
        FileSnapshot cfr_ignored_0 = (FileSnapshot)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)((FileSnapshot)other).file)) {
            return false;
        }
        if (this.length != ((FileSnapshot)other).length) {
            return false;
        }
        return Arrays.equals(this.hash, ((FileSnapshot)other).hash);
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = 31 * result2 + Long.hashCode(this.length);
        result2 = 31 * result2 + Arrays.hashCode(this.hash);
        return result2;
    }

    @NotNull
    public String toString() {
        return "FileSnapshot(file=" + this.file + ", length=" + this.length + ", hash=" + Arrays.toString(this.hash) + ')';
    }
}

