/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideCheckerKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J0\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020!H\u0014J$\u0010\"\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020$H\u0016J\u001e\u0010#\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020$2\u0006\u0010%\u001a\u00020\tJ\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020'H\u0016J\u001e\u0010&\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020'2\u0006\u0010%\u001a\u00020\tJ,\u0010(\u001a\u00020\t*\u00020\u00002\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractOverrideChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "isEqualTypes", "", "candidateType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "baseType", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "candidateTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "baseTypeRef", "maybeEqualErrorTypes", "ref1", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "ref2", "isEqualBound", "overrideBound", "baseBound", "overrideTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "baseTypeParameter", "isCompatibleTypeParameters", "overrideCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "baseDeclaration", "buildTypeParametersSubstitutorIfCompatible", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isEqualReceiverTypes", "isOverriddenFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "ignoreVisibility", "isOverriddenProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "commonCallableChecks", "providers"})
@SourceDebugExtension(value={"SMAP\nFirStandardOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStandardOverrideChecker.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,160:1\n1724#2,3:161\n1745#2,3:164\n1745#2,3:167\n1724#2,3:170\n1745#2,3:173\n1724#2,3:177\n1724#2,3:181\n46#3:176\n21#3:180\n*S KotlinDebug\n*F\n+ 1 FirStandardOverrideChecker.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker\n*L\n41#1:161,3\n61#1:164,3\n68#1:167,3\n80#1:170,3\n92#1:173,3\n118#1:177,3\n155#1:181,3\n112#1:176\n145#1:180\n*E\n"})
public final class FirStandardOverrideChecker
extends FirAbstractOverrideChecker {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ConeInferenceContext context;

    public FirStandardOverrideChecker(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.context = TypeComponentsKt.getTypeContext(this.session);
    }

    private final boolean isEqualTypes(ConeKotlinType candidateType, ConeKotlinType baseType2, ConeSubstitutor substitutor2) {
        ConeKotlinType substitutedCandidateType = substitutor2.substituteOrSelf(candidateType);
        ConeKotlinType substitutedBaseType = substitutor2.substituteOrSelf(baseType2);
        return AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, this.context, substitutedCandidateType, substitutedBaseType, false, 8, null);
    }

    public final boolean isEqualTypes(@NotNull FirTypeRef candidateTypeRef, @NotNull FirTypeRef baseTypeRef, @NotNull ConeSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)candidateTypeRef, (String)"candidateTypeRef");
        Intrinsics.checkNotNullParameter((Object)baseTypeRef, (String)"baseTypeRef");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        PhaseUtilsKt.ensureResolvedTypeDeclaration(candidateTypeRef, this.session, FirResolvePhase.TYPES);
        PhaseUtilsKt.ensureResolvedTypeDeclaration(baseTypeRef, this.session, FirResolvePhase.TYPES);
        if (candidateTypeRef instanceof FirErrorTypeRef && baseTypeRef instanceof FirErrorTypeRef) {
            return this.maybeEqualErrorTypes((FirErrorTypeRef)candidateTypeRef, (FirErrorTypeRef)baseTypeRef);
        }
        return this.isEqualTypes(FirTypeUtilsKt.getConeType(candidateTypeRef), FirTypeUtilsKt.getConeType(baseTypeRef), substitutor2);
    }

    private final boolean maybeEqualErrorTypes(FirErrorTypeRef ref1, FirErrorTypeRef ref2) {
        boolean bl;
        block6: {
            FirTypeRef firTypeRef = ref1.getDelegatedTypeRef();
            FirUserTypeRef firUserTypeRef = firTypeRef instanceof FirUserTypeRef ? (FirUserTypeRef)firTypeRef : null;
            if (firUserTypeRef == null) {
                return false;
            }
            FirUserTypeRef delegated1 = firUserTypeRef;
            FirTypeRef firTypeRef2 = ref2.getDelegatedTypeRef();
            FirUserTypeRef firUserTypeRef2 = firTypeRef2 instanceof FirUserTypeRef ? (FirUserTypeRef)firTypeRef2 : null;
            if (firUserTypeRef2 == null) {
                return false;
            }
            FirUserTypeRef delegated2 = firUserTypeRef2;
            if (delegated1.getQualifier().size() != delegated2.getQualifier().size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)delegated1.getQualifier(), (Iterable)delegated2.getQualifier());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirQualifierPart l = (FirQualifierPart)pair.component1();
                    FirQualifierPart r = (FirQualifierPart)pair.component2();
                    if (Intrinsics.areEqual((Object)l.getName(), (Object)r.getName())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEqualBound(FirTypeRef overrideBound, FirTypeRef baseBound, FirTypeParameter overrideTypeParameter, FirTypeParameter baseTypeParameter, ConeSubstitutor substitutor2) {
        Object element$iv;
        FirResolvedTypeRef bound2;
        ConeKotlinType substitutedBaseType;
        ConeKotlinType substitutedOverrideType = substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(overrideBound));
        if (AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, this.context, substitutedOverrideType, substitutedBaseType = substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(baseBound)), false, 8, null)) {
            return true;
        }
        Iterable $this$any$iv = overrideTypeParameter.getSymbol().getResolvedBounds();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            bound2 = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
        } while (!this.isEqualTypes(FirTypeUtilsKt.getConeType(bound2), substitutedBaseType, substitutor2));
        boolean bl = true;
        if (!bl) return false;
        $this$any$iv = baseTypeParameter.getSymbol().getResolvedBounds();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            bound2 = (FirResolvedTypeRef)element$iv;
            boolean bl2 = false;
        } while (!this.isEqualTypes(FirTypeUtilsKt.getConeType(bound2), substitutedOverrideType, substitutor2));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCompatibleTypeParameters(FirTypeParameterRef overrideCandidate, FirTypeParameterRef baseDeclaration, ConeSubstitutor substitutor2) {
        boolean bl;
        block6: {
            void $this$all$iv;
            if (Intrinsics.areEqual((Object)overrideCandidate.getSymbol(), (Object)baseDeclaration.getSymbol())) {
                return true;
            }
            if (!(overrideCandidate instanceof FirTypeParameter) || !(baseDeclaration instanceof FirTypeParameter)) {
                return false;
            }
            if (((FirTypeParameter)overrideCandidate).getBounds().size() != ((FirTypeParameter)baseDeclaration).getBounds().size()) {
                return false;
            }
            Iterable iterable = CollectionsKt.zip((Iterable)((FirTypeParameter)overrideCandidate).getSymbol().getResolvedBounds(), (Iterable)((FirTypeParameter)baseDeclaration).getSymbol().getResolvedBounds());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirResolvedTypeRef bBound;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirResolvedTypeRef aBound = (FirResolvedTypeRef)pair.component1();
                    if (this.isEqualBound(aBound, bBound = (FirResolvedTypeRef)pair.component2(), (FirTypeParameter)overrideCandidate, (FirTypeParameter)baseDeclaration, substitutor2)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    protected ConeSubstitutor buildTypeParametersSubstitutorIfCompatible(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirCallableDeclaration baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(overrideCandidate, FirResolvePhase.TYPES);
        FirLazyDeclarationResolverKt.lazyResolveToPhase(baseDeclaration, FirResolvePhase.TYPES);
        ConeSubstitutor coneSubstitutor = FirAbstractOverrideCheckerKt.buildSubstitutorForOverridesCheck(overrideCandidate, baseDeclaration, this.session);
        if (coneSubstitutor == null) {
            return null;
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        if (!((Collection)overrideCandidate.getTypeParameters()).isEmpty()) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = CollectionsKt.zip((Iterable)overrideCandidate.getTypeParameters(), (Iterable)baseDeclaration.getTypeParameters());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterRef base;
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        FirTypeParameterRef override = (FirTypeParameterRef)pair.component1();
                        if (!(!this.isCompatibleTypeParameters(override, base = (FirTypeParameterRef)pair.component2(), substitutor2))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
        }
        return substitutor2;
    }

    private final boolean isEqualReceiverTypes(FirTypeRef candidateTypeRef, FirTypeRef baseTypeRef, ConeSubstitutor substitutor2) {
        return candidateTypeRef != null && baseTypeRef != null ? this.isEqualTypes(candidateTypeRef, baseTypeRef, substitutor2) : candidateTypeRef == null && baseTypeRef == null;
    }

    @Override
    public boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        return this.isOverriddenFunction(overrideCandidate, baseDeclaration, false);
    }

    public final boolean isOverriddenFunction(@NotNull FirSimpleFunction overrideCandidate, @NotNull FirSimpleFunction baseDeclaration, boolean ignoreVisibility) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
            Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
            if (overrideCandidate.getValueParameters().size() != baseDeclaration.getValueParameters().size()) {
                return false;
            }
            FirMemberDeclaration $this$isSuspend$iv = overrideCandidate;
            boolean $i$f$isSuspend = false;
            boolean bl2 = $this$isSuspend$iv.getStatus().isSuspend();
            $this$isSuspend$iv = baseDeclaration;
            $i$f$isSuspend = false;
            if (bl2 != $this$isSuspend$iv.getStatus().isSuspend()) {
                return false;
            }
            ConeSubstitutor coneSubstitutor = this.buildTypeParametersSubstitutorIfCompatible(overrideCandidate, baseDeclaration);
            if (coneSubstitutor == null) {
                return false;
            }
            ConeSubstitutor substitutor2 = coneSubstitutor;
            if (!this.commonCallableChecks(this, overrideCandidate, baseDeclaration, substitutor2, ignoreVisibility)) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)overrideCandidate.getValueParameters(), (Iterable)baseDeclaration.getValueParameters());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl3 = false;
                    FirValueParameter memberParam = (FirValueParameter)pair.component1();
                    FirValueParameter selfParam = (FirValueParameter)pair.component2();
                    if (this.isEqualTypes(memberParam.getReturnTypeRef(), selfParam.getReturnTypeRef(), substitutor2)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        return this.isOverriddenProperty(overrideCandidate, baseDeclaration, false);
    }

    public final boolean isOverriddenProperty(@NotNull FirCallableDeclaration overrideCandidate, @NotNull FirProperty baseDeclaration, boolean ignoreVisibility) {
        Intrinsics.checkNotNullParameter((Object)overrideCandidate, (String)"overrideCandidate");
        Intrinsics.checkNotNullParameter((Object)baseDeclaration, (String)"baseDeclaration");
        if (!(overrideCandidate instanceof FirProperty)) {
            return false;
        }
        ConeSubstitutor coneSubstitutor = this.buildTypeParametersSubstitutorIfCompatible(overrideCandidate, baseDeclaration);
        if (coneSubstitutor == null) {
            return false;
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        return this.commonCallableChecks(this, overrideCandidate, baseDeclaration, substitutor2, ignoreVisibility);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean commonCallableChecks(FirStandardOverrideChecker $this$commonCallableChecks, FirCallableDeclaration overrideCandidate, FirCallableDeclaration baseDeclaration, ConeSubstitutor substitutor2, boolean ignoreVisibility) {
        FirContextReceiver selfParam;
        FirContextReceiver memberParam;
        if (!ignoreVisibility) {
            FirMemberDeclaration $this$visibility$iv = baseDeclaration;
            boolean $i$f$getVisibility = false;
            if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                return false;
            }
        }
        if (overrideCandidate.getContextReceivers().size() != baseDeclaration.getContextReceivers().size()) {
            return false;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(overrideCandidate, FirResolvePhase.TYPES);
        FirLazyDeclarationResolverKt.lazyResolveToPhase(baseDeclaration, FirResolvePhase.TYPES);
        FirReceiverParameter firReceiverParameter = overrideCandidate.getReceiverParameter();
        FirReceiverParameter firReceiverParameter2 = baseDeclaration.getReceiverParameter();
        if (!$this$commonCallableChecks.isEqualReceiverTypes(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, firReceiverParameter2 != null ? firReceiverParameter2.getTypeRef() : null, substitutor2)) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)overrideCandidate.getContextReceivers(), (Iterable)baseDeclaration.getContextReceivers());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            memberParam = (FirContextReceiver)pair.component1();
            selfParam = (FirContextReceiver)pair.component2();
        } while ($this$commonCallableChecks.isEqualTypes(memberParam.getTypeRef(), selfParam.getTypeRef(), substitutor2));
        return false;
    }
}

