/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.descriptors;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.descriptors.FirPackageViewDescriptor;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0001CB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00110\u001eH\u0016J#\u0010,\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0016\u00a2\u0006\u0002\u00100J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u001fH\u0016J\u001e\u0010;\u001a\u0002042\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020>\u0018\u00010=H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u00101\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00108\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "shouldSeeInternalsOf", "", "targetModule", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPackage", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getSubPackagesOf", "", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "allDependencyModules", "", "getAllDependencyModules", "()Ljava/util/List;", "setAllDependencyModules", "(Ljava/util/List;)V", "expectedByModules", "getExpectedByModules", "allExpectedByModules", "", "getAllExpectedByModules", "()Ljava/util/Set;", "getCapability", "T", "capability", "Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "(Lorg/jetbrains/kotlin/descriptors/ModuleCapability;)Ljava/lang/Object;", "isValid", "()Z", "assertValid", "", "getOriginal", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getName", "stableName", "getStableName", "()Lorg/jetbrains/kotlin/name/Name;", "acceptVoid", "visitor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "Ljava/lang/Void;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getAnnotations", "()Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Companion", "fir2ir"})
public final class FirModuleDescriptor
implements ModuleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private List<? extends ModuleDescriptor> allDependencyModules;

    private FirModuleDescriptor(FirSession session2, FirModuleData moduleData, KotlinBuiltIns builtIns2) {
        this.session = session2;
        this.moduleData = moduleData;
        this.builtIns = builtIns2;
        this.allDependencyModules = CollectionsKt.emptyList();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirModuleData getModuleData() {
        return this.moduleData;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @Override
    public boolean shouldSeeInternalsOf(@NotNull ModuleDescriptor targetModule) {
        Intrinsics.checkNotNullParameter((Object)targetModule, (String)"targetModule");
        if (!(targetModule instanceof FirModuleDescriptor)) {
            return false;
        }
        FirModuleData firModuleData = ((FirModuleDescriptor)targetModule).moduleData;
        return Intrinsics.areEqual((Object)firModuleData, (Object)this.moduleData) || this.moduleData.getFriendDependencies().contains(firModuleData) || this.moduleData.getDependsOnDependencies().contains(firModuleData);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.moduleData.getPlatform();
    }

    @Override
    @NotNull
    public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
        if (symbolProvider.getPackage(fqName2) != null) {
            return new FirPackageViewDescriptor(fqName2, this);
        }
        throw new IllegalStateException(("Module " + this.moduleData + " doesn't contain package " + fqName2).toString());
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getAllDependencyModules() {
        return this.allDependencyModules;
    }

    public void setAllDependencyModules(@NotNull List<? extends ModuleDescriptor> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.allDependencyModules = list2;
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getExpectedByModules() {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @NotNull
    public Set<ModuleDescriptor> getAllExpectedByModules() {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull ModuleCapability<T> capability) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void assertValid() {
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.moduleData.getName();
    }

    @Override
    @NotNull
    public Name getStableName() {
        return this.getName();
    }

    @Override
    public void acceptVoid(@Nullable DeclarationDescriptorVisitor<Void, Void> visitor2) {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    @Override
    @Nullable
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return ModuleDescriptor.DefaultImpls.accept(this, visitor2, data2);
    }

    public /* synthetic */ FirModuleDescriptor(FirSession session2, FirModuleData moduleData, KotlinBuiltIns builtIns2, DefaultConstructorMarker $constructor_marker) {
        this(session2, moduleData, builtIns2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor$Companion;", "", "<init>", "()V", "createSourceModuleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "createDependencyModuleDescriptor", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirModuleDescriptor createSourceModuleDescriptor(@NotNull FirSession session2, @NotNull KotlinBuiltIns builtIns2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
            if (!(session2.getKind() == FirSession.Kind.Source)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return new FirModuleDescriptor(session2, FirModuleDataKt.getModuleData(session2), builtIns2, null);
        }

        @NotNull
        public final FirModuleDescriptor createDependencyModuleDescriptor(@NotNull FirModuleData moduleData, @NotNull KotlinBuiltIns builtIns2) {
            Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
            Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
            return new FirModuleDescriptor(moduleData.getSession(), moduleData, builtIns2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

