/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsPackageDirectiveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsPackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker\n+ 2 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n42#2,7:41\n64#2:48\n96#2,6:49\n66#2:55\n102#2:56\n49#2:57\n50#2:63\n105#2,5:64\n67#2:69\n110#2,2:72\n113#2:75\n69#2:76\n51#2,2:77\n80#2:79\n96#2,6:80\n82#2:86\n102#2:87\n53#2:95\n105#2,5:96\n83#2:101\n110#2,4:102\n85#2:106\n54#2:107\n584#3,5:58\n590#3,7:88\n229#4:70\n1853#5:71\n1854#5:74\n*S KotlinDebug\n*F\n+ 1 FirJsPackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker\n*L\n27#1:41,7\n27#1:48\n27#1:49,6\n27#1:55\n27#1:56\n27#1:57\n27#1:63\n27#1:64,5\n27#1:69\n27#1:72,2\n27#1:75\n27#1:76\n27#1:77,2\n27#1:79\n27#1:80,6\n27#1:86\n27#1:87\n27#1:95\n27#1:96,5\n27#1:101\n27#1:102,4\n27#1:106\n27#1:107\n27#1:58,5\n27#1:88,7\n27#1:70\n27#1:71\n27#1:74\n*E\n"})
public final class FirJsPackageDirectiveChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirJsPackageDirectiveChecker INSTANCE = new FirJsPackageDirectiveChecker();

    private FirJsPackageDirectiveChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (UtilsKt.getPackageFqName(declaration).isRoot()) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        KtSourceElement ktSourceElement = declaration.getPackageDirective().getSource();
        if (ktSourceElement != null) {
            void $this$forEachChildOfType_u24default$iv;
            KtSourceElement ktSourceElement2 = ktSourceElement;
            Set types$iv = SetsKt.setOf((Object)KtNodeTypes.REFERENCE_EXPRESSION);
            int depth$iv = -1;
            boolean reverse$iv = false;
            boolean $i$f$forEachChildOfType = false;
            void var9_9 = $this$forEachChildOfType_u24default$iv;
            if (var9_9 instanceof KtPsiSourceElement) {
                PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
                boolean $i$f$forEachChildOfType2 = false;
                boolean $i$f$forEachChildOfType3 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$this$forEachChildOfType$iv$iv, (Object)0)};
                List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    PsiElement it$iv$iv;
                    pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = pairArray.component1();
                    int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                        Set set = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                        if (set.contains(iElementType)) {
                            KtPsiSourceElement ktPsiSourceElement;
                            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                            boolean bl2 = false;
                            PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                            KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                            boolean $i$f$toKtPsiSourceElement = false;
                            KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                                ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            KtSourceElement it = ktPsiSourceElement;
                            boolean bl3 = false;
                            String name2 = String.valueOf(KtSourceElementKt.getText(it));
                            if (!Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name2 + " contains illegal characters"), (DiagnosticContext)context2, null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (PsiElement)element$iv$iv$iv;
                    boolean bl = false;
                    List list2 = SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren(it$iv$iv));
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf22 = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl4 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                    while ($i$f$butIf22.hasNext()) {
                        Object element$iv$iv$iv$iv;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                        boolean bl5 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                    }
                }
            } else if (var9_9 instanceof KtLightSourceElement) {
                LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
                FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                boolean $i$f$forEachChildOfType4 = false;
                boolean $i$f$forEachChildOfType5 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$this$forEachChildOfType$iv$iv, (Object)0)};
                List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    LighterASTNode it$iv$iv;
                    pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = pairArray.component1();
                    int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        LighterASTNode lighterASTNode2 = (LighterASTNode)element$iv$iv$iv;
                        Set set = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getTokenType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
                        if (set.contains(iElementType)) {
                            void $this$toKtLightSourceElement_u24default$iv$iv;
                            LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                            boolean bl6 = false;
                            LighterASTNode kind$iv$iv = it$iv;
                            FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                            KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                            int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                            int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                            boolean $i$f$toKtLightSourceElement = false;
                            KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                            boolean bl7 = false;
                            String name3 = String.valueOf(KtSourceElementKt.getText(it));
                            if (!Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name3), (Object)name3)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name3 + " contains illegal characters"), (DiagnosticContext)context2, null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                    boolean bl = false;
                    List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl8 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv$iv$iv2;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                        boolean bl9 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

