/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.RequireKotlinDeprecationInfo;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J?\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u0019J*\u0010\u001a\u001a\u00020\u0011*\u00020\u001b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\rH\u0002JC\u0010\u001c\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001fJ6\u0010 \u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010\"\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010#\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010%\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(*\u00020)2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "<init>", "()V", "filteredSourceKinds", "", "Lorg/jetbrains/kotlin/KtFakeSourceElementKind;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isDelegatedPropertySelfAccess", "", "referencedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportApiStatusIfNeeded", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "reportApiStatusIfNeeded$checkers", "isTypealiasExpansionOf", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "reportApiStatus", "isTypealiasExpansion", "deprecationInfo", "reportApiStatus$checkers", "reportVersionRequirementDeprecation", "Lorg/jetbrains/kotlin/fir/declarations/RequireKotlinDeprecationInfo;", "reportDeprecation", "reportApiNotAvailable", "Lorg/jetbrains/kotlin/fir/declarations/FutureApiDeprecationInfo;", "getWorstDeprecation", "symbol", "classSymbolItIsCalledThrough", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class FirDeprecationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirDeprecationChecker INSTANCE = new FirDeprecationChecker();
    @NotNull
    private static final Set<KtFakeSourceElementKind> filteredSourceKinds;

    private FirDeprecationChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        if (CollectionsKt.contains((Iterable)filteredSourceKinds, (Object)(ktSourceElement != null ? ktSourceElement.getKind() : null))) {
            return;
        }
        if (expression2 instanceof FirAnnotation) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression2, context2)) {
            return;
        }
        FirReference firReference = FirExpressionUtilKt.getCalleeReference(expression2);
        if (firReference == null) {
            return;
        }
        FirReference calleeReference = firReference;
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(calleeReference);
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference resolvedReference = firResolvedNamedReference;
        FirBasedSymbol<?> referencedSymbol = resolvedReference.getResolvedSymbol();
        if (this.isDelegatedPropertySelfAccess(expression2, context2, referencedSymbol)) {
            return;
        }
        KtSourceElement ktSourceElement2 = resolvedReference.getSource();
        if (ktSourceElement2 == null) {
            ktSourceElement2 = source = expression2.getSource();
        }
        if (expression2 instanceof FirDelegatedConstructorCall) {
            DeprecationInfo deprecationInfo = DeprecationUtilsKt.getDeprecation(referencedSymbol, context2.getSession(), expression2);
            if (deprecationInfo == null) {
                return;
            }
            DeprecationInfo constructorOnlyDeprecation = deprecationInfo;
            FirClassLikeDeclaration firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(((FirDelegatedConstructorCall)expression2).getConstructedTypeRef(), context2.getSession());
            boolean isTypealiasExpansion = (firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null) instanceof FirTypeAliasSymbol;
            this.reportApiStatus$checkers(source, referencedSymbol, isTypealiasExpansion, constructorOnlyDeprecation, reporter, context2);
        } else {
            this.reportApiStatusIfNeeded$checkers(source, referencedSymbol, context2, reporter, expression2);
        }
    }

    private final boolean isDelegatedPropertySelfAccess(FirStatement $this$isDelegatedPropertySelfAccess, CheckerContext context2, FirBasedSymbol<?> referencedSymbol) {
        KtSourceElement ktSourceElement = $this$isDelegatedPropertySelfAccess.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            return false;
        }
        List<FirDeclaration> containers = context2.getContainingDeclarations();
        int size = containers.size();
        Object fir = referencedSymbol.getFir();
        return Intrinsics.areEqual((Object)CollectionsKt.getOrNull(containers, (int)(size - 1)), fir) || Intrinsics.areEqual((Object)CollectionsKt.getOrNull(containers, (int)(size - 2)), fir);
    }

    public final void reportApiStatusIfNeeded$checkers(@Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable FirElement callSite) {
        Intrinsics.checkNotNullParameter(referencedSymbol, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        DeprecationInfo deprecationInfo = this.getWorstDeprecation(callSite, referencedSymbol, context2);
        if (deprecationInfo == null) {
            return;
        }
        DeprecationInfo deprecation = deprecationInfo;
        boolean isTypealiasExpansion = this.isTypealiasExpansionOf(deprecation, referencedSymbol, callSite, context2);
        this.reportApiStatus$checkers(source, referencedSymbol, isTypealiasExpansion, deprecation, reporter, context2);
    }

    public static /* synthetic */ void reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker firDeprecationChecker, KtSourceElement ktSourceElement, FirBasedSymbol firBasedSymbol, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirElement firElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            firElement = null;
        }
        firDeprecationChecker.reportApiStatusIfNeeded$checkers(ktSourceElement, firBasedSymbol, checkerContext, diagnosticReporter, firElement);
    }

    private final boolean isTypealiasExpansionOf(DeprecationInfo $this$isTypealiasExpansionOf, FirBasedSymbol<?> referencedSymbol, FirElement callSite, CheckerContext context2) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = referencedSymbol;
        if (firBasedSymbol instanceof FirConstructorSymbol) {
            FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)referencedSymbol);
            if (firTypeAliasSymbol != null) {
                FirTypeAliasSymbol it = firTypeAliasSymbol;
                boolean bl2 = false;
                bl = INSTANCE.isTypealiasExpansionOf($this$isTypealiasExpansionOf, it, callSite, context2);
            } else {
                bl = false;
            }
        } else if (!(firBasedSymbol instanceof FirTypeAliasSymbol)) {
            bl = false;
        } else {
            DeprecationInfo it = DeprecationUtilsKt.getOwnDeprecation(referencedSymbol, context2.getSession(), callSite);
            boolean bl3 = false;
            bl = it == null || it.compareTo($this$isTypealiasExpansionOf) < 0;
        }
        return bl;
    }

    public final void reportApiStatus$checkers(@Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol, boolean isTypealiasExpansion, @NotNull DeprecationInfo deprecationInfo, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(referencedSymbol, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)deprecationInfo, (String)"deprecationInfo");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeprecationInfo deprecationInfo2 = deprecationInfo;
        if (deprecationInfo2 instanceof FutureApiDeprecationInfo) {
            this.reportApiNotAvailable(source, (FutureApiDeprecationInfo)deprecationInfo, reporter, context2);
        } else if (deprecationInfo2 instanceof RequireKotlinDeprecationInfo) {
            this.reportVersionRequirementDeprecation(source, referencedSymbol, (RequireKotlinDeprecationInfo)deprecationInfo, reporter, context2);
        } else {
            this.reportDeprecation(source, referencedSymbol, isTypealiasExpansion, deprecationInfo, reporter, context2);
        }
    }

    private final void reportVersionRequirementDeprecation(KtSourceElement source, FirBasedSymbol<?> referencedSymbol, RequireKotlinDeprecationInfo deprecationInfo, DiagnosticReporter reporter, CheckerContext context2) {
        String string2;
        KtDiagnosticFactory4<FirBasedSymbol<?>, VersionRequirement.Version, String, String> diagnostic = WhenMappings.$EnumSwitchMapping$0[deprecationInfo.getDeprecationLevel().ordinal()] == 1 ? FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION() : FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION_ERROR();
        LanguageVersionSettings languageVersionSettings2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        switch (WhenMappings.$EnumSwitchMapping$1[deprecationInfo.getVersionRequirement().getKind().ordinal()]) {
            case 1: {
                string2 = KotlinCompilerVersion.VERSION;
                break;
            }
            case 2: {
                string2 = languageVersionSettings2.getLanguageVersion().getVersionString();
                break;
            }
            case 3: {
                string2 = languageVersionSettings2.getApiVersion().getVersionString();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String currentVersionString = string2;
        AbstractKtSourceElement abstractKtSourceElement = source;
        VersionRequirement.Version version2 = deprecationInfo.getVersionRequirement().getVersion();
        Intrinsics.checkNotNull((Object)currentVersionString);
        String string3 = deprecationInfo.getMessage();
        if (string3 == null) {
            string3 = "";
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, diagnostic, referencedSymbol, (Object)version2, (Object)currentVersionString, (Object)string3, (DiagnosticContext)context2, null, 128, null);
    }

    private final void reportDeprecation(KtSourceElement source, FirBasedSymbol<?> referencedSymbol, boolean isTypealiasExpansion, DeprecationInfo deprecationInfo, DiagnosticReporter reporter, CheckerContext context2) {
        if (!isTypealiasExpansion) {
            KtDiagnosticFactory2<FirBasedSymbol<?>, String> ktDiagnosticFactory2;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo.getDeprecationLevel().ordinal()]) {
                case 2: 
                case 3: {
                    ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION_ERROR();
                    break;
                }
                case 1: {
                    ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory2;
            AbstractKtSourceElement abstractKtSourceElement = source;
            String string2 = deprecationInfo.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, diagnostic, referencedSymbol, (Object)string2, (DiagnosticContext)context2, null, 32, null);
        } else {
            KtDiagnosticFactory3<FirBasedSymbol<?>, FirBasedSymbol<?>, String> ktDiagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo.getDeprecationLevel().ordinal()]) {
                case 2: 
                case 3: {
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION_ERROR();
                    break;
                }
                case 1: {
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtDiagnosticFactory3<FirBasedSymbol<?>, FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement = source;
            String string3 = deprecationInfo.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, diagnostic, referencedSymbol, referencedSymbol, (Object)string3, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final void reportApiNotAvailable(KtSourceElement source, FutureApiDeprecationInfo deprecationInfo, DiagnosticReporter reporter, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getAPI_NOT_AVAILABLE(), (Object)deprecationInfo.getSinceVersion(), (Object)context2.getLanguageVersionSettings().getApiVersion(), (DiagnosticContext)context2, null, 32, null);
    }

    private final DeprecationInfo getWorstDeprecation(FirElement callSite, FirBasedSymbol<?> symbol2, CheckerContext context2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Object[] objectArray = new DeprecationInfo[2];
        FirConstructorSymbol firConstructorSymbol2 = symbol2 instanceof FirConstructorSymbol ? (FirConstructorSymbol)symbol2 : null;
        objectArray[0] = firConstructorSymbol2 != null && (firClassLikeSymbol = this.classSymbolItIsCalledThrough(firConstructorSymbol2, context2)) != null ? DeprecationUtilsKt.getDeprecation((FirBasedSymbol)firClassLikeSymbol, context2.getSession(), callSite) : null;
        objectArray[1] = DeprecationUtilsKt.getDeprecation(symbol2, context2.getSession(), callSite);
        List deprecationInfos = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (DeprecationInfo)CollectionsKt.maxOrNull((Iterable)deprecationInfos);
    }

    private final FirClassLikeSymbol<?> classSymbolItIsCalledThrough(FirConstructorSymbol $this$classSymbolItIsCalledThrough, CheckerContext context2) {
        FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor($this$classSymbolItIsCalledThrough);
        return firTypeAliasSymbol != null ? (FirClassLikeSymbol)firTypeAliasSymbol : (FirClassLikeSymbol)FirHelpersKt.toRegularClassSymbol($this$classSymbolItIsCalledThrough.getResolvedReturnTypeRef(), context2.getSession());
    }

    static {
        Object[] objectArray = new KtFakeSourceElementKind[]{KtFakeSourceElementKind.PropertyFromParameter.INSTANCE, KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE};
        filteredSourceKinds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            try {
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

