/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies$DOT_BY_QUALIFIED$1$mark$lambda$1$;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u00a0\u0001\u00a1\u0001\u00a2\u0001\u00a3\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206H\u0007\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0007J\u000e\u0010}\u001a\u0004\u0018\u00010b*\u00020~H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020E0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020O0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020V0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020^0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\\0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020G0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010g\u001a\b\u0012\u0004\u0012\u00020h0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010k\u001a\b\u0012\u0004\u0012\u00020l0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020n0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020n0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020q0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020s0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010t\u001a\b\u0012\u0004\u0012\u00020u0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020Z0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010xR\u0017\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bz\u0010xR\u0017\u0010{\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010xR\u0018\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0080\u0001\u0010xR\u0019\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0082\u0001\u0010xR\u0017\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0001\u0010xR\u0019\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010xR\u0019\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0001\u0010xR\u0019\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008b\u0001\u0010xR\u0019\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020b0\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0001\u0010xR\u0019\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010xR\u001a\u0010\u0090\u0001\u001a\t\u0012\u0005\u0012\u00030\u0091\u00010\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0092\u0001\u0010xR\u0019\u0010\u0093\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0094\u0001\u0010xR\u0019\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u00020b0\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0096\u0001\u0010xR\u0019\u0010\u0097\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0098\u0001\u0010xR\u0019\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009a\u0001\u0010xR\u0019\u0010\u009b\u0001\u001a\b\u0012\u0004\u0012\u00020\\0\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009c\u0001\u0010xR\u0018\u0010\u009d\u0001\u001a\t\u0012\u0005\u0012\u00030\u009e\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u009f\u0001\u001a\b\u0012\u0004\u0012\u00020b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a4\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "<init>", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lcom/intellij/psi/PsiElement;", "SUPERTYPES_LIST", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "propertyKindTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getPropertyKindTokens", "()Lcom/intellij/psi/tree/TokenSet;", "classKindTokens", "getClassKindTokens", "DECLARATION_START_TO_NAME", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_NAME_ONLY", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "OPEN_MODIFIER", "OVERRIDE_MODIFIER", "PRIVATE_MODIFIER", "LATEINIT_MODIFIER", "VARIANCE_MODIFIER", "CONST_MODIFIER", "FUN_MODIFIER", "SUSPEND_MODIFIER", "DATA_MODIFIER", "OPERATOR_MODIFIER", "INFIX_MODIFIER", "ENUM_MODIFIER", "TAILREC_MODIFIER", "EXTERNAL_MODIFIER", "EXPECT_ACTUAL_MODIFIER", "OBJECT_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "FIELD_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtBackingField;", "PROPERTY_DELEGATE", "Lorg/jetbrains/kotlin/psi/KtProperty;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "projectionPosition", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "SAFE_ACCESS", "VISIBILITY_MODIFIER", "MODALITY_MODIFIER", "INLINE_OR_VALUE_MODIFIER", "INNER_MODIFIER", "INLINE_PARAMETER_MODIFIER", "INLINE_FUN_MODIFIER", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETERS_WITH_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtFunction;", "PARAMETER_VARARG_MODIFIER", "NAME_OF_NAMED_ARGUMENT", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "CALL_ELEMENT", "CALL_ELEMENT_WITH_DOT", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "VAL_OR_VAR_NODE", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "IF_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "SPECIAL_CONSTRUCT_TOKEN", "Lorg/jetbrains/kotlin/psi/KtExpression;", "REDUNDANT_NULLABLE", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "QUESTION_MARK_BY_TYPE", "CALL_EXPRESSION", "VALUE_ARGUMENTS", "Lorg/jetbrains/kotlin/psi/KtElement;", "VALUE_ARGUMENTS_LIST", "FUNCTION_PARAMETERS", "CUT_CHAR_QUOTES", "LONG_LITERAL_SUFFIX", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "COMPANION_OBJECT", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "RECEIVER", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "OPERATOR", "getOPERATOR", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "getReferencedTypeExpression", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "NAME_IDENTIFIER", "getNAME_IDENTIFIER", "SPREAD_OPERATOR", "getSPREAD_OPERATOR", "FUN_INTERFACE", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "PROPERTY_INITIALIZER", "getPROPERTY_INITIALIZER", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "ANNOTATION_USE_SITE", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getANNOTATION_USE_SITE", "IMPORT_LAST_NAME", "getIMPORT_LAST_NAME", "LABEL", "getLABEL", "COMMAS", "getCOMMAS", "NON_FINAL_MODIFIER_OR_NAME", "getNON_FINAL_MODIFIER_OR_NAME", "DELEGATED_SUPERTYPE_BY_KEYWORD", "getDELEGATED_SUPERTYPE_BY_KEYWORD", "TYPEALIAS_TYPE_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "SUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS_DIAGNOSTIC", "DeclarationHeader", "ModifierSetBasedPositioningStrategy", "InlineFunPositioningStrategy", "FindReferencePositioningStrategy", "frontend.common-psi"})
public final class PositioningStrategies {
    @NotNull
    public static final PositioningStrategies INSTANCE = new PositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy<PsiElement>(){

        public List<TextRange> mark(PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            if (psiElement instanceof KtObjectLiteralExpression) {
                KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"getObjectDeclaration(...)");
                KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
                PsiElement psiElement2 = objectDeclaration.getObjectKeyword();
                Intrinsics.checkNotNull((Object)psiElement2);
                PsiElement objectKeyword = psiElement2;
                KtSuperTypeList ktSuperTypeList = objectDeclaration.getSuperTypeList();
                if (ktSuperTypeList == null) {
                    return PositioningStrategyKt.markElement(objectKeyword);
                }
                KtSuperTypeList delegationSpecifierList = ktSuperTypeList;
                return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
            }
            if (psiElement instanceof KtObjectDeclaration) {
                PsiElement psiElement3 = ((KtObjectDeclaration)element).getObjectKeyword();
                Intrinsics.checkNotNull((Object)psiElement3);
                PsiElement psiElement4 = ((KtObjectDeclaration)element).getNameIdentifier();
                if (psiElement4 == null) {
                    PsiElement psiElement5 = ((KtObjectDeclaration)element).getObjectKeyword();
                    psiElement4 = psiElement5;
                    Intrinsics.checkNotNull((Object)psiElement5);
                }
                return PositioningStrategyKt.markRange(psiElement3, psiElement4);
            }
            if (psiElement instanceof KtConstructorDelegationCall) {
                return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark(element);
            }
            return super.mark(element);
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SUPERTYPES_LIST = new PositioningStrategy<PsiElement>(){

        public List<TextRange> mark(PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtClassOrObject ktClassOrObject = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
            if (ktClassOrObject == null) {
                return PositioningStrategyKt.markElement(element);
            }
            List<KtSuperTypeListEntry> supertypes2 = ktClassOrObject.getSuperTypeListEntries();
            return supertypes2.isEmpty() ? PositioningStrategyKt.markElement(element) : PositioningStrategyKt.markRange(supertypes2.get(0), (PsiElement)CollectionsKt.last(supertypes2));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

        public List<TextRange> mark(KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return PositioningStrategyKt.markElement(this.getElementToMark(element));
        }

        public boolean isValid(KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
        }

        private final PsiElement getElementToMark(KtDeclaration declaration) {
            KtDeclaration ktDeclaration = declaration;
            Pair pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair((Object)((KtCallableDeclaration)declaration).getTypeReference(), (Object)((KtCallableDeclaration)declaration).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair((Object)((KtPropertyAccessor)declaration).getReturnTypeReference(), (Object)((KtPropertyAccessor)declaration).getNamePlaceholder()) : new Pair(null, null));
            KtTypeReference returnTypeRef = (KtTypeReference)pair.component1();
            PsiElement nameIdentifierOrPlaceholder = (PsiElement)pair.component2();
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration;
        }
    };
    @NotNull
    private static final TokenSet propertyKindTokens;
    @NotNull
    private static final TokenSet classKindTokens;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_START_TO_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME_ONLY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> LATEINIT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> CONST_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> SUSPEND_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> DATA_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPERATOR_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INFIX_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ENUM_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> TAILREC_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> EXTERNAL_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> EXPECT_ACTUAL_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> OBJECT_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBackingField> FIELD_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtProperty> PROPERTY_DELEGATE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SAFE_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> MODALITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_OR_VALUE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INNER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_PARAMETER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> PARAMETERS_WITH_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtValueArgument> NAME_OF_NAMED_ARGUMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtQualifiedExpression> CALL_ELEMENT_WITH_DOT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtIfExpression> IF_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> REDUNDANT_NULLABLE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> QUESTION_MARK_BY_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS_LIST;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtCallableDeclaration> RECEIVER;
    @NotNull
    private static final PositioningStrategy<KtExpression> OPERATOR;
    @NotNull
    private static final PositioningStrategy<PsiElement> DOT_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> NAME_IDENTIFIER;
    @NotNull
    private static final PositioningStrategy<PsiElement> SPREAD_OPERATOR;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> FUN_INTERFACE;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> REIFIED_MODIFIER;
    @NotNull
    private static final PositioningStrategy<KtNamedDeclaration> PROPERTY_INITIALIZER;
    @NotNull
    private static final PositioningStrategy<KtElement> WHOLE_ELEMENT;
    @NotNull
    private static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_LIST;
    @NotNull
    private static final PositioningStrategy<KtAnnotationEntry> ANNOTATION_USE_SITE;
    @NotNull
    private static final PositioningStrategy<PsiElement> IMPORT_LAST_NAME;
    @NotNull
    private static final PositioningStrategy<KtElement> LABEL;
    @NotNull
    private static final PositioningStrategy<PsiElement> COMMAS;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> NON_FINAL_MODIFIER_OR_NAME;
    @NotNull
    private static final PositioningStrategy<KtTypeReference> DELEGATED_SUPERTYPE_BY_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeAlias> TYPEALIAS_TYPE_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> SUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS_DIAGNOSTIC;

    private PositioningStrategies() {
    }

    @NotNull
    public final TokenSet getPropertyKindTokens() {
        return propertyKindTokens;
    }

    @NotNull
    public final TokenSet getClassKindTokens() {
        return classKindTokens;
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;
            {
                this.$tokens = $tokens;
            }

            public List<TextRange> mark(KtModifierListOwner element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtModifierList ktModifierList = element.getModifierList();
                if (ktModifierList == null) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                KtModifierList modifierList2 = ktModifierList;
                for (KtModifierKeywordToken token : this.$tokens) {
                    PsiElement modifier = modifierList2.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> projectionPosition() {
        return new PositioningStrategy<KtModifierListOwner>(){

            public List<TextRange> mark(KtModifierListOwner element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeProjection && ((KtTypeProjection)element).getProjectionKind() == KtProjectionKind.STAR) {
                    return PositioningStrategyKt.markElement(element);
                }
                KtModifierList $this$sure$iv = element.getModifierList();
                boolean $i$f$sure = false;
                KtModifierList ktModifierList = $this$sure$iv;
                if (ktModifierList == null) {
                    boolean bl = false;
                    String string2 = "No modifier list, but modifier has been found by the analyzer";
                    throw new AssertionError((Object)string2);
                }
                KtModifierList modifierList2 = ktModifierList;
                PsiElement psiElement = modifierList2.getModifier(KtTokens.IN_KEYWORD);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                psiElement = modifierList2.getModifier(KtTokens.OUT_KEYWORD);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                throw new IllegalStateException("None of the modifiers is found: in, out");
            }
        };
    }

    @NotNull
    public final PositioningStrategy<KtExpression> getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    private final KtElement getReferencedTypeExpression(KtTypeElement $this$getReferencedTypeExpression) {
        KtElement ktElement;
        KtTypeElement ktTypeElement = $this$getReferencedTypeExpression;
        if (ktTypeElement instanceof KtUserType) {
            ktElement = ((KtUserType)$this$getReferencedTypeExpression).getReferenceExpression();
        } else if (ktTypeElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement2 = ((KtNullableType)$this$getReferencedTypeExpression).getInnerType();
            ktElement = ktTypeElement2 != null ? this.getReferencedTypeExpression(ktTypeElement2) : null;
        } else {
            ktElement = null;
        }
        return ktElement;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getNAME_IDENTIFIER() {
        return NAME_IDENTIFIER;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSPREAD_OPERATOR() {
        return SPREAD_OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtNamedDeclaration> getPROPERTY_INITIALIZER() {
        return PROPERTY_INITIALIZER;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    @NotNull
    public final PositioningStrategy<KtAnnotationEntry> getANNOTATION_USE_SITE() {
        return ANNOTATION_USE_SITE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getIMPORT_LAST_NAME() {
        return IMPORT_LAST_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getLABEL() {
        return LABEL;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCOMMAS() {
        return COMMAS;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getNON_FINAL_MODIFIER_OR_NAME() {
        return NON_FINAL_MODIFIER_OR_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtTypeReference> getDELEGATED_SUPERTYPE_BY_KEYWORD() {
        return DELEGATED_SUPERTYPE_BY_KEYWORD;
    }

    public static final /* synthetic */ KtElement access$getReferencedTypeExpression(PositioningStrategies $this, KtTypeElement $receiver) {
        return $this.getReferencedTypeExpression($receiver);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        propertyKindTokens = tokenSet;
        iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet2 = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        classKindTokens = tokenSet2;
        DECLARATION_START_TO_NAME = new DeclarationHeader<KtDeclaration>(){

            private final PsiElement firstNonCommentNonAnnotationLeaf(PsiElement $this$firstNonCommentNonAnnotationLeaf) {
                PsiElement leaf;
                PsiElement psiElement = $this$firstNonCommentNonAnnotationLeaf.getFirstChild();
                if (psiElement == null) {
                    return $this$firstNonCommentNonAnnotationLeaf;
                }
                PsiElement child = psiElement;
                while (true) {
                    if (child instanceof PsiComment || child instanceof PsiWhiteSpace || child instanceof KtAnnotationEntry) {
                        child = child.getNextSibling();
                        continue;
                    }
                    if (child == null) {
                        return null;
                    }
                    leaf = this.firstNonCommentNonAnnotationLeaf(child);
                    if (leaf != null) break;
                    child = child.getNextSibling();
                }
                return leaf;
            }

            public List<TextRange> mark(KtDeclaration element) {
                List<TextRange> list2;
                PsiElement nameIdentifier;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = this.firstNonCommentNonAnnotationLeaf(element);
                if (psiElement == null) {
                    psiElement = element;
                }
                PsiElement startElement = psiElement;
                KtNamedDeclaration ktNamedDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
                PsiElement psiElement2 = nameIdentifier = ktNamedDeclaration != null ? ktNamedDeclaration.getNameIdentifier() : null;
                if (nameIdentifier != null) {
                    list2 = PositioningStrategyKt.markRange(startElement, nameIdentifier);
                } else {
                    KtDeclaration ktDeclaration = element;
                    if (ktDeclaration instanceof KtConstructor) {
                        PsiElement psiElement3 = ((KtConstructor)element).getConstructorKeyword();
                        if (psiElement3 == null) {
                            psiElement3 = element;
                        }
                        list2 = PositioningStrategyKt.markRange(startElement, psiElement3);
                    } else if (ktDeclaration instanceof KtObjectDeclaration) {
                        PsiElement psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                        if (psiElement4 == null) {
                            psiElement4 = element;
                        }
                        list2 = PositioningStrategyKt.markRange(startElement, psiElement4);
                    } else {
                        list2 = PositioningStrategies.DEFAULT.mark(element);
                    }
                }
                return list2;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            public List<TextRange> mark(KtNamedDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        PsiElement psiElement = ((KtClassOrObject)element).getModifierList();
                        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                            ASTNode aSTNode = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create(iElementTypeArray));
                            psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                            if (psiElement == null) {
                                psiElement = element;
                            }
                        }
                        PsiElement startElement = psiElement;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_NAME_ONLY = new DeclarationHeader<KtNamedDeclaration>(){

            public List<TextRange> mark(KtNamedDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            public List<TextRange> mark(KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                        if (ktParameterList != null) {
                            psiElement2 = ktParameterList;
                        } else {
                            return PositioningStrategyKt.markElement(element);
                        }
                    }
                    PsiElement begin = psiElement2;
                    KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                    if (ktParameterList != null) {
                        psiElement = ktParameterList;
                    } else {
                        psiElement = ((KtConstructor)element).getConstructorKeyword();
                        if (psiElement == null) {
                            return PositioningStrategyKt.markElement(element);
                        }
                    }
                    PsiElement end = psiElement;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    KtElement ktElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtFunction)element).getTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        KtParameterList ktParameterList = ((KtFunction)element).getValueParameterList();
                        if (ktParameterList != null) {
                            psiElement = ktParameterList;
                        } else {
                            psiElement = ((KtFunction)element).getNameIdentifier();
                            if (psiElement == null) {
                                psiElement = endOfSignatureElement = (PsiElement)element;
                            }
                        }
                    }
                    if (element instanceof KtFunctionLiteral) {
                        NavigatablePsiElement navigatablePsiElement;
                        KtTypeReference ktTypeReference2 = ((KtFunctionLiteral)element).getReceiverTypeReference();
                        if (ktTypeReference2 != null) {
                            navigatablePsiElement = ktTypeReference2;
                        } else {
                            KtParameterList ktParameterList = ((KtFunctionLiteral)element).getValueParameterList();
                            navigatablePsiElement = ktParameterList != null ? (NavigatablePsiElement)ktParameterList : (NavigatablePsiElement)element;
                        }
                        ktElement = (KtElement)navigatablePsiElement;
                    } else {
                        ktElement = element;
                    }
                    KtElement startElement = ktElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        psiElement = ((KtProperty)element).getNameIdentifier();
                        if (psiElement == null) {
                            psiElement = element;
                        }
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        psiElement = ((KtPropertyAccessor)element).getRightParenthesis();
                        if (psiElement == null) {
                            PsiElement psiElement3 = ((KtPropertyAccessor)element).getNamePlaceholder();
                            psiElement = psiElement3;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getNamePlaceholder(...)");
                        }
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement psiElement = ((KtClass)element).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement;
                    KtParameterList ktParameterList = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(nameAsDeclaration);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    return PositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element);
                }
                if (ktDeclaration instanceof KtClassInitializer) {
                    TextRange textRange = ((KtClassInitializer)element).getInitKeyword().getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    return PositioningStrategyKt.markRange(textRange);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element) : PositioningStrategies.DEFAULT.mark(element);
            }

            public boolean isValid(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element) : PositioningStrategies.DEFAULT.isValid(element);
            }
        };
        NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT = new PositioningStrategy<KtDeclaration>(){

            public List<TextRange> mark(KtDeclaration element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClassOrObject) {
                    psiElement = ((KtClassOrObject)element).getDeclarationKeyword();
                    if (psiElement == null && (psiElement = ((KtClassOrObject)element).getNameIdentifier()) == null) {
                        psiElement = element;
                    }
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    psiElement = ((KtNamedFunction)element).getModifierList();
                    if ((psiElement == null || (psiElement = ((KtModifierList)psiElement).getModifier(KtTokens.INLINE_KEYWORD)) == null) && (psiElement = ((KtNamedFunction)element).getFunKeyword()) == null) {
                        psiElement = element;
                    }
                } else {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            public List<TextRange> mark(KtDeclaration element) {
                KtTypeParameterList ktTypeParameterList;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeParameterListOwner && (ktTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(ktTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
            }
        };
        IElementType[] iElementTypeArray2 = new IElementType[]{KtTokens.ABSTRACT_KEYWORD};
        ABSTRACT_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.OPEN_KEYWORD};
        OPEN_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.OVERRIDE_KEYWORD};
        OVERRIDE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.PRIVATE_KEYWORD};
        PRIVATE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.LATEINIT_KEYWORD};
        LATEINIT_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        VARIANCE_MODIFIER = PositioningStrategies.projectionPosition();
        iElementTypeArray2 = new IElementType[]{KtTokens.CONST_KEYWORD};
        CONST_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.FUN_KEYWORD};
        FUN_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.SUSPEND_KEYWORD};
        SUSPEND_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.DATA_KEYWORD};
        DATA_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.OPERATOR_KEYWORD};
        OPERATOR_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.INFIX_KEYWORD};
        INFIX_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.ENUM_KEYWORD};
        ENUM_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.TAILREC_KEYWORD};
        TAILREC_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.EXTERNAL_KEYWORD};
        EXTERNAL_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.EXPECT_KEYWORD, KtTokens.ACTUAL_KEYWORD};
        EXPECT_ACTUAL_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        OBJECT_KEYWORD = new PositioningStrategy<KtObjectDeclaration>(){

            public List<TextRange> mark(KtObjectDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getObjectKeyword();
                if (psiElement == null) {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        FIELD_KEYWORD = new DeclarationHeader<KtBackingField>(){

            public List<TextRange> mark(KtBackingField element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getFieldKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFieldKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PROPERTY_DELEGATE = new DeclarationHeader<KtProperty>(){

            public List<TextRange> mark(KtProperty element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtPropertyDelegate delegate2 = element.getDelegate();
                return delegate2 != null ? PositioningStrategyKt.markElement(delegate2) : PositioningStrategies.DEFAULT.mark(element);
            }
        };
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtNamedDeclaration) {
                    psiElement = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    Intrinsics.checkNotNull((Object)ktPackageDirective);
                    psiElement = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                PsiElement psiElement3 = nameIdentifier;
                if (psiElement3 == null) {
                    psiElement3 = element;
                }
                return PositioningStrategyKt.markElement(psiElement3);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            public List<TextRange> mark(KtReferenceExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtArrayAccessExpression) {
                    List<TextRange> list2 = ((KtArrayAccessExpression)element).getBracketRanges();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getBracketRanges(...)");
                    List<TextRange> ranges2 = list2;
                    if (!ranges2.isEmpty()) {
                        return ranges2;
                    }
                }
                return CollectionsKt.listOf((Object)element.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            public List<TextRange> mark(KtArrayAccessExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtContainerNode ktContainerNode = element.getIndicesNode();
                Intrinsics.checkNotNullExpressionValue((Object)ktContainerNode, (String)"getIndicesNode(...)");
                return PositioningStrategyKt.markElement(ktContainerNode);
            }
        };
        SAFE_ACCESS = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                UserDataHolder userDataHolder = element.getNode().findChildByType(KtTokens.SAFE_ACCESS);
                if (userDataHolder == null || (userDataHolder = userDataHolder.getPsi()) == null) {
                    userDataHolder = element;
                }
                return PositioningStrategyKt.markElement((PsiElement)userDataHolder);
            }
        };
        TokenSet tokenSet3 = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedPositioningStrategy(tokenSet3);
        TokenSet tokenSet4 = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedPositioningStrategy(tokenSet4);
        iElementTypeArray2 = new IElementType[]{KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD};
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.INNER_KEYWORD};
        INNER_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[]{KtTokens.NOINLINE_KEYWORD, KtTokens.CROSSINLINE_KEYWORD};
        INLINE_PARAMETER_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        INLINE_FUN_MODIFIER = new InlineFunPositioningStrategy();
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            public List<TextRange> mark(KtTypeProjection element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getProjectionToken();
                Intrinsics.checkNotNull((Object)psiElement);
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            public List<TextRange> mark(KtParameter element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getDefaultValue();
                Intrinsics.checkNotNull((Object)ktExpression);
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETERS_WITH_DEFAULT_VALUE = new PositioningStrategy<KtFunction>(){

            /*
             * WARNING - void declaration
             */
            public List<TextRange> mark(KtFunction element) {
                List<TextRange> list2;
                List<E> list3;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                List<KtParameter> list4 = element.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"getValueParameters(...)");
                Iterable $this$filter$iv = list4;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtParameter p0 = (KtParameter)element$iv$iv;
                    boolean bl = false;
                    if (!p0.hasDefaultValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List<E> p0 = list3 = (List<E>)destination$iv$iv;
                boolean bl = false;
                List<E> list5 = !((Collection)p0).isEmpty() ? list3 : null;
                if (list5 != null) {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = list5;
                    boolean $i$f$flatMap = false;
                    destination$iv$iv = $this$flatMap$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                        KtParameter it = (KtParameter)element$iv$iv;
                        boolean bl2 = false;
                        ASTNode aSTNode = it.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                        Iterable list$iv$iv = PositioningStrategyKt.markNode(aSTNode);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    list2 = (List<TextRange>)destination$iv$iv2;
                } else {
                    KtParameterList ktParameterList = element.getValueParameterList();
                    if (ktParameterList != null) {
                        KtParameterList it = ktParameterList;
                        boolean bl3 = false;
                        ASTNode aSTNode = it.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                        list2 = PositioningStrategyKt.markNode(aSTNode);
                    } else {
                        List<TextRange> list6;
                        PsiElement psiElement = element.getNameIdentifier();
                        if (psiElement != null) {
                            PsiElement it = psiElement;
                            boolean bl4 = false;
                            ASTNode aSTNode = it.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                            list6 = PositioningStrategyKt.markNode(aSTNode);
                        } else {
                            list6 = list2 = null;
                        }
                        if (list6 == null) {
                            ASTNode aSTNode = element.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                            list2 = PositioningStrategyKt.markNode(aSTNode);
                        }
                    }
                }
                return list2;
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            public List<TextRange> mark(KtParameter element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtModifierList ktModifierList = element.getModifierList();
                Intrinsics.checkNotNull((Object)ktModifierList);
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement varargModifier = psiElement;
                ASTNode aSTNode = varargModifier.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new PositioningStrategy<KtValueArgument>(){

            public List<TextRange> mark(KtValueArgument element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtValueArgumentName ktValueArgumentName = element.getArgumentName();
                return PositioningStrategyKt.markElement(ktValueArgumentName != null ? (KtElementImplStub)ktValueArgumentName : (KtElementImplStub)element);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement ktElement = element instanceof KtCallElement ? (KtCallElement)element : null;
                return PositioningStrategyKt.markElement(ktElement != null && (ktElement = ktElement.getCalleeExpression()) != null ? (PsiElement)ktElement : element);
            }
        };
        CALL_ELEMENT_WITH_DOT = new PositioningStrategy<KtQualifiedExpression>(){

            public List<TextRange> mark(KtQualifiedExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                List<TextRange> callElementRanges = PositioningStrategies.INSTANCE.getSELECTOR_BY_QUALIFIED().mark(element);
                if (callElementRanges.size() != 1) {
                    return callElementRanges;
                }
                TextRange callElementRange = (TextRange)CollectionsKt.first(callElementRanges);
                List<TextRange> dotRanges = PositioningStrategies.SAFE_ACCESS.mark(element);
                if (dotRanges.size() != 1) {
                    return dotRanges;
                }
                TextRange dotRange = (TextRange)CollectionsKt.first(dotRanges);
                return CollectionsKt.listOf((Object)new TextRange(dotRange.getStartOffset(), callElementRange.getEndOffset()));
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            public List<TextRange> mark(KtDeclarationWithBody element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(KtDeclarationWithBody element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!super.isValid((PsiElement)element)) return false;
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                if (ktBlockExpression == null) return false;
                TextRange textRange = ktBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtDeclaration>(){

            public List<TextRange> mark(KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtParameter) {
                    PsiElement psiElement = ((KtParameter)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getValOrVarKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
                    PsiElement psiElement = ((KtDestructuringDeclaration)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else {
                    throw new IllegalStateException(("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element)).toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            public List<TextRange> mark(KtWhenEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getElseKeyword();
                Intrinsics.checkNotNull((Object)psiElement);
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            public List<TextRange> mark(KtWhenExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getWhenKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        IF_EXPRESSION = new PositioningStrategy<KtIfExpression>(){

            public List<TextRange> mark(KtIfExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getIfKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            public List<TextRange> mark(KtWhenConditionInRange element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                return PositioningStrategyKt.markElement(ktOperationReferenceExpression);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            public List<TextRange> mark(KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement = ((KtWhenExpression)element).getWhenKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getWhenKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement = ((KtIfExpression)element).getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getIfKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtOperationExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                    list2 = PositioningStrategyKt.markElement(ktSimpleNameExpression);
                } else {
                    throw new IllegalStateException(("Expression is not an if, when or operation expression: " + PsiUtilsKt.getElementTextWithContext(element)).toString());
                }
                return list2;
            }
        };
        REDUNDANT_NULLABLE = new PositioningStrategy<KtTypeReference>(){

            public List<TextRange> mark(KtTypeReference element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeElement typeElement = element.getTypeElement();
                ASTNode question = null;
                ASTNode prevQuestion = null;
                ASTNode lastQuestion = null;
                while (typeElement instanceof KtNullableType) {
                    prevQuestion = question;
                    question = ((KtNullableType)typeElement).getQuestionMarkNode();
                    if (lastQuestion == null) {
                        lastQuestion = question;
                    }
                    typeElement = ((KtNullableType)typeElement).getInnerType();
                }
                if (lastQuestion != null) {
                    ASTNode aSTNode = prevQuestion;
                    if (aSTNode == null) {
                        aSTNode = lastQuestion;
                    }
                    PsiElement psiElement = aSTNode.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                    PsiElement psiElement2 = lastQuestion.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsi(...)");
                    return PositioningStrategyKt.markRange(psiElement, psiElement2);
                }
                return super.mark((PsiElement)element);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            public List<TextRange> mark(KtNullableType element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getQuestionMarkNode(...)");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        QUESTION_MARK_BY_TYPE = new PositioningStrategy<KtTypeReference>(){

            public List<TextRange> mark(KtTypeReference element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeElement typeElement = element.getTypeElement();
                if (typeElement instanceof KtNullableType) {
                    ASTNode aSTNode = ((KtNullableType)typeElement).getQuestionMarkNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getQuestionMarkNode(...)");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return super.mark((PsiElement)element);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression) {
                    KtElement ktElement;
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    if (ktTypeArgumentList != null) {
                        ktElement = ktTypeArgumentList;
                    } else {
                        KtExpression ktExpression = ((KtCallExpression)element).getCalleeExpression();
                        ktElement = ktExpression != null ? (KtElement)ktExpression : (KtElement)element;
                    }
                    return PositioningStrategyKt.markRange(element, ktElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            public List<TextRange> mark(KtElement element) {
                List<TextRange> list2;
                boolean $i$f$getChildOfType;
                PsiElement $this$getChildOfType$iv;
                KtValueArgumentList ktValueArgumentList;
                KtElement qualifiedAccess;
                KtElement ktElement;
                KtElement left;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken())) {
                    left = ((KtBinaryExpression)element).getLeft();
                    boolean bl = false;
                    PsiElement psiElement = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations(left);
                    if (psiElement != null) {
                        PsiElement it = psiElement;
                        boolean bl2 = false;
                        return PositioningStrategyKt.markElement(it);
                    }
                }
                if ((left = element) instanceof KtQualifiedExpression) {
                    KtExpression ktExpression = ((KtQualifiedExpression)element).getSelectorExpression();
                    if (ktExpression == null) {
                        ktExpression = (KtExpression)element;
                    }
                    ktElement = ktExpression;
                } else if (left instanceof KtClassOrObject) {
                    KtSuperTypeList ktSuperTypeList = ((KtClassOrObject)element).getSuperTypeList();
                    ktElement = ktSuperTypeList != null ? (KtElementImplStub)ktSuperTypeList : (KtElementImplStub)element;
                } else {
                    ktElement = qualifiedAccess = element;
                }
                if ((ktValueArgumentList = qualifiedAccess instanceof KtValueArgumentList ? (KtValueArgumentList)qualifiedAccess : null) == null) {
                    $this$getChildOfType$iv = qualifiedAccess;
                    $i$f$getChildOfType = false;
                    ktValueArgumentList = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtValueArgumentList.class);
                }
                KtValueArgumentList argumentList2 = ktValueArgumentList;
                if (argumentList2 != null) {
                    Object object;
                    PsiElement rightParenthesis;
                    block18: {
                        PsiElement psiElement = argumentList2.getRightParenthesis();
                        if (psiElement == null) {
                            return PositioningStrategyKt.markElement(qualifiedAccess);
                        }
                        rightParenthesis = psiElement;
                        PsiElement[] psiElementArray = argumentList2.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                        Object[] objectArray = psiElementArray;
                        int n = objectArray.length + -1;
                        if (0 <= n) {
                            do {
                                int n2 = n--;
                                Object object2 = objectArray[n2];
                                PsiElement it = (PsiElement)object2;
                                boolean bl = false;
                                if (!(it instanceof KtValueArgument)) continue;
                                object = object2;
                                break block18;
                            } while (0 <= n);
                        }
                        object = null;
                    }
                    PsiElement lastArgument = (PsiElement)object;
                    if (lastArgument != null) {
                        list2 = PositioningStrategyKt.markRange(lastArgument, rightParenthesis);
                    } else {
                        PsiElement leftParenthesis = argumentList2.getLeftParenthesis();
                        PsiElement psiElement = leftParenthesis;
                        if (psiElement == null) {
                            psiElement = qualifiedAccess;
                        }
                        list2 = PositioningStrategyKt.markRange(psiElement, rightParenthesis);
                    }
                } else if (qualifiedAccess instanceof KtCallExpression) {
                    $this$getChildOfType$iv = qualifiedAccess;
                    $i$f$getChildOfType = false;
                    KtNameReferenceExpression ktNameReferenceExpression = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtNameReferenceExpression.class);
                    list2 = PositioningStrategyKt.markElement(ktNameReferenceExpression != null ? (NavigatablePsiElement)ktNameReferenceExpression : (NavigatablePsiElement)qualifiedAccess);
                } else {
                    list2 = PositioningStrategyKt.markElement(qualifiedAccess);
                }
                return list2;
            }
        };
        VALUE_ARGUMENTS_LIST = new PositioningStrategy<KtElement>(){

            public List<TextRange> mark(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement $this$getChildOfType$iv = element;
                boolean $i$f$getChildOfType = false;
                KtValueArgumentList ktValueArgumentList = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtValueArgumentList.class);
                return PositioningStrategyKt.markElement(ktValueArgumentList != null ? (KtElement)ktValueArgumentList : element);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            public List<TextRange> mark(KtFunction element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            public List<TextRange> mark(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element).getNode().getElementType(), (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = ((KtConstantExpression)element).getTextRange();
                    return CollectionsKt.listOf((Object)TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            public List<TextRange> mark(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element).getNode().getElementType(), (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    return CollectionsKt.listOf((Object)TextRange.create(endOffset - 1, endOffset));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            public List<TextRange> mark(KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtSimpleNameExpression ktSimpleNameExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                return PositioningStrategyKt.markRange(ktSimpleNameExpression, element);
            }
        };
        iElementTypeArray2 = new IElementType[]{KtTokens.COMPANION_KEYWORD};
        COMPANION_OBJECT = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element;
                if (psiElement instanceof KtSecondaryConstructor) {
                    KtParameterList ktParameterList = ((KtSecondaryConstructor)element).getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement2 = ((KtSecondaryConstructor)element).getConstructorKeyword();
                    PsiElement psiElement3 = valueParameterList.getLastChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getLastChild(...)");
                    list2 = PositioningStrategyKt.markRange(psiElement2, psiElement3);
                } else if (psiElement instanceof KtConstructorDelegationCall) {
                    if (((KtConstructorDelegationCall)element).isImplicit()) {
                        PsiElement $this$getStrictParentOfType$iv = element;
                        boolean $i$f$getStrictParentOfType = false;
                        KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtSecondaryConstructor.class, true);
                        Intrinsics.checkNotNull((Object)ktSecondaryConstructor);
                        KtSecondaryConstructor constructor2 = ktSecondaryConstructor;
                        KtParameterList ktParameterList = constructor2.getValueParameterList();
                        if (ktParameterList == null) {
                            return PositioningStrategyKt.markElement(constructor2);
                        }
                        KtParameterList valueParameterList = ktParameterList;
                        PsiElement psiElement4 = constructor2.getConstructorKeyword();
                        PsiElement psiElement5 = valueParameterList.getLastChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getLastChild(...)");
                        return PositioningStrategyKt.markRange(psiElement4, psiElement5);
                    }
                    KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                    list2 = PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression != null ? (KtElementImpl)ktConstructorDelegationReferenceExpression : (KtElementImpl)element);
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            public List<TextRange> mark(KtEnumEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                List<KtSuperTypeListEntry> list2 = element.getSuperTypeListEntries();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getSuperTypeListEntries(...)");
                List<KtSuperTypeListEntry> specifiers = list2;
                return PositioningStrategyKt.markElement(specifiers.isEmpty() ? (KtElementImplStub)element : (KtElementImplStub)specifiers.get(0));
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            public List<TextRange> mark(KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression);
                int n = PsiUtilsKt.getStartOffset(ktExpression);
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                return CollectionsKt.listOf((Object)new TextRange(n, PsiUtilsKt.getEndOffset(ktOperationReferenceExpression)));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            public List<TextRange> mark(KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                return CollectionsKt.listOf((Object)new TextRange(PsiUtilsKt.getStartOffset(ktOperationReferenceExpression), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            public List<TextRange> mark(KtImportDirective element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement ktElement = element.getAlias();
                if (ktElement != null && (psiElement = ktElement.getNameIdentifier()) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                ktElement = element.getImportedReference();
                if (ktElement != null) {
                    KtElement it = ktElement;
                    boolean bl = false;
                    if (it instanceof KtQualifiedExpression) {
                        KtExpression ktExpression = ((KtQualifiedExpression)it).getSelectorExpression();
                        if (ktExpression != null) {
                            KtExpression it2 = ktExpression;
                            boolean bl2 = false;
                            return PositioningStrategyKt.markElement(it2);
                        }
                    }
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            public List<TextRange> mark(KtReturnExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement labeledExpression = element.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange(element, labeledExpression);
                }
                PsiElement psiElement = element.getReturnKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getReturnKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        RECEIVER = new DeclarationHeader<KtCallableDeclaration>(){

            public List<TextRange> mark(KtCallableDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeReference ktTypeReference = element.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference it = ktTypeReference;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        OPERATOR = new PositioningStrategy<KtExpression>(){

            public List<TextRange> mark(KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtBinaryExpression) {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                    list2 = this.mark(ktOperationReferenceExpression);
                } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                    list2 = this.mark(ktSimpleNameExpression);
                } else if (ktExpression instanceof KtUnaryExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtUnaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                    list2 = this.mark(ktSimpleNameExpression);
                } else {
                    list2 = super.mark((PsiElement)element);
                }
                return list2;
            }
        };
        DOT_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken())) {
                    KtExpression ktExpression = ((KtBinaryExpression)element).getLeft();
                    if (ktExpression != null) {
                        KtExpression left = ktExpression;
                        boolean bl = false;
                        PsiElement $this$findDescendantOfType_u24default$iv = left;
                        Function1 predicate$iv = DOT_BY_QUALIFIED$1$mark$lambda$1$$inlined$findDescendantOfType$default$1.INSTANCE;
                        boolean $i$f$findDescendantOfType = false;
                        PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv);
                        Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                        $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(PsiElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                if (element instanceof KtDotQualifiedExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                    this.$result.element = element;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                            }
                        });
                        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)result$iv$iv.element);
                        if (ktDotQualifiedExpression != null) {
                            KtDotQualifiedExpression it = ktDotQualifiedExpression;
                            boolean bl2 = false;
                            return this.mark(it);
                        }
                    }
                }
                if (element instanceof KtDotQualifiedExpression) {
                    PsiElement psiElement = ((KtDotQualifiedExpression)element).getOperationTokenNode().getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                    return this.mark(psiElement);
                }
                return PositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(element);
            }
        };
        SELECTOR_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                PsiElement psiElement;
                KtExpression selectorExpression;
                KtElement ktElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken()) && (ktElement = ((KtBinaryExpression)element).getLeft()) != null) {
                    KtElement it = ktElement;
                    boolean bl = false;
                    return this.mark(it);
                }
                if (element instanceof KtQualifiedExpression && (selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression()) instanceof KtElement) {
                    return this.mark(selectorExpression);
                }
                if (element instanceof KtImportDirective) {
                    ktElement = ((KtImportDirective)element).getAlias();
                    if (ktElement != null && (psiElement = ((KtImportAlias)ktElement).getNameIdentifier()) != null) {
                        PsiElement it = psiElement;
                        boolean bl = false;
                        return this.mark(it);
                    }
                    ktElement = ((KtImportDirective)element).getImportedReference();
                    if (ktElement != null) {
                        KtElement it = ktElement;
                        boolean bl = false;
                        return this.mark(it);
                    }
                }
                if (element instanceof KtTypeReference && (ktElement = ((KtTypeReference)element).getTypeElement()) != null && (psiElement = PositioningStrategies.access$getReferencedTypeExpression(PositioningStrategies.INSTANCE, (KtTypeElement)ktElement)) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return this.mark(it);
                }
                return super.mark(element);
            }
        };
        NAME_IDENTIFIER = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiNameIdentifierOwner) {
                    PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                    if (nameIdentifier != null) {
                        return super.mark(nameIdentifier);
                    }
                } else {
                    PsiElement nameIdentifier;
                    if (element instanceof KtLabelReferenceExpression) {
                        return super.mark(((KtLabelReferenceExpression)element).getReferencedNameElement());
                    }
                    if (element instanceof KtPackageDirective && (nameIdentifier = ((KtPackageDirective)element).getNameIdentifier()) != null) {
                        return super.mark(nameIdentifier);
                    }
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        SPREAD_OPERATOR = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                UserDataHolder userDataHolder = element instanceof KtValueArgument ? (KtValueArgument)element : null;
                if (userDataHolder == null || (userDataHolder = ((KtValueArgument)userDataHolder).getSpreadElement()) == null || (userDataHolder = ((LeafPsiElement)userDataHolder).getNode()) == null || (userDataHolder = userDataHolder.getPsi()) == null) {
                    userDataHolder = element;
                }
                return super.mark(userDataHolder);
            }
        };
        FUN_INTERFACE = new PositioningStrategy<KtDeclaration>(){

            public List<TextRange> mark(KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClass) {
                    list2 = PositioningStrategies.FUN_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getValOrVarKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    KtTypeParameterList typeParameterList = ((KtNamedFunction)element).getTypeParameterList();
                    KtTypeParameterList ktTypeParameterList = typeParameterList;
                    if (ktTypeParameterList != null) {
                        list2 = PositioningStrategyKt.markElement(ktTypeParameterList);
                    } else if (((KtNamedFunction)element).hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                        list2 = PositioningStrategies.SUSPEND_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                    } else {
                        PsiElement psiElement = ((KtNamedFunction)element).getFunKeyword();
                        if (psiElement == null) {
                            psiElement = element;
                        }
                        list2 = PositioningStrategyKt.markElement(psiElement);
                    }
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        iElementTypeArray2 = new IElementType[]{KtTokens.REIFIED_KEYWORD};
        REIFIED_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        PROPERTY_INITIALIZER = new PositioningStrategy<KtNamedDeclaration>(){

            public List<TextRange> mark(KtNamedDeclaration element) {
                KtElement ktElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtNamedDeclaration ktNamedDeclaration = element;
                if (ktNamedDeclaration instanceof KtProperty) {
                    KtExpression ktExpression = ((KtProperty)element).getInitializer();
                    if (ktExpression == null) {
                        ktExpression = element;
                    }
                    ktElement = ktExpression;
                } else if (ktNamedDeclaration instanceof KtParameter) {
                    KtExpression ktExpression = ((KtParameter)element).getDefaultValue();
                    if (ktExpression != null) {
                        ktElement = ktExpression;
                    } else {
                        KtTypeReference ktTypeReference = ((KtParameter)element).getTypeReference();
                        ktElement = ktTypeReference != null ? (KtElement)ktTypeReference : (KtElement)element;
                    }
                } else {
                    ktElement = element;
                }
                return PositioningStrategyKt.markElement(ktElement);
            }
        };
        WHOLE_ELEMENT = new PositioningStrategy<KtElement>(){};
        TYPE_PARAMETERS_LIST = new PositioningStrategy<KtDeclaration>(){

            public List<TextRange> mark(KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeParameterListOwner) {
                    KtTypeParameterList ktTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList();
                    return PositioningStrategyKt.markElement(ktTypeParameterList != null ? (KtElement)ktTypeParameterList : (KtElement)element);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        ANNOTATION_USE_SITE = new PositioningStrategy<KtAnnotationEntry>(){

            public List<TextRange> mark(KtAnnotationEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = element.getUseSiteTarget();
                return PositioningStrategyKt.markElement(ktAnnotationUseSiteTarget != null ? (KtElementImplStub)ktAnnotationUseSiteTarget : (KtElementImplStub)element);
            }
        };
        IMPORT_LAST_NAME = new PositioningStrategy<PsiElement>(){

            public boolean isValid(PsiElement element) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof PsiErrorElement) {
                        return false;
                    }
                    PsiElement[] psiElementArray = element.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    Object[] $this$any$iv = psiElementArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!(!this.isValid(it))) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return !bl;
            }

            public List<TextRange> mark(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtImportDirective) {
                    KtExpression ktExpression;
                    KtExpression importedReference = ((KtImportDirective)element).getImportedReference();
                    if (importedReference instanceof KtDotQualifiedExpression && (ktExpression = ((KtDotQualifiedExpression)importedReference).getSelectorExpression()) != null) {
                        KtExpression it = ktExpression;
                        boolean bl = false;
                        return super.mark((PsiElement)it);
                    }
                    KtExpression ktExpression2 = ((KtImportDirective)element).getImportedReference();
                    return super.mark((PsiElement)(ktExpression2 != null ? (KtElement)ktExpression2 : (KtElement)element));
                }
                return super.mark(element);
            }
        };
        LABEL = new PositioningStrategy<KtElement>(){

            public List<TextRange> mark(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElementImpl ktElementImpl = element instanceof KtExpressionWithLabel ? (KtExpressionWithLabel)element : null;
                return super.mark((PsiElement)(ktElementImpl != null && (ktElementImpl = ktElementImpl.getLabelQualifier()) != null ? (KtElement)ktElementImpl : element));
            }
        };
        COMMAS = new PositioningStrategy<PsiElement>(){

            public List<TextRange> mark(PsiElement element) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                List $this$mark_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                Iterator<PsiElement> iterator2 = PsiUtilsKt.getAllChildren(element).iterator();
                while (iterator2.hasNext()) {
                    PsiElement child = iterator2.next();
                    if (!Intrinsics.areEqual((Object)child.getNode().getElementType(), (Object)KtTokens.COMMA)) continue;
                    $this$mark_u24lambda_u240.add(PositioningStrategyKt.markSingleElement(child));
                }
                return CollectionsKt.build((List)list2);
            }

            public boolean isValid(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return true;
            }
        };
        iElementTypeArray2 = new IElementType[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.SEALED_KEYWORD};
        NON_FINAL_MODIFIER_OR_NAME = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        DELEGATED_SUPERTYPE_BY_KEYWORD = new PositioningStrategy<KtTypeReference>(){

            public List<TextRange> mark(KtTypeReference element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getParent();
                KtDelegatedSuperTypeEntry ktDelegatedSuperTypeEntry = psiElement instanceof KtDelegatedSuperTypeEntry ? (KtDelegatedSuperTypeEntry)psiElement : null;
                if (ktDelegatedSuperTypeEntry == null) {
                    return super.mark((PsiElement)element);
                }
                KtDelegatedSuperTypeEntry parent2 = ktDelegatedSuperTypeEntry;
                PsiElement psiElement2 = parent2.getByKeywordNode().getPsi();
                if (psiElement2 == null) {
                    psiElement2 = element;
                }
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        TYPEALIAS_TYPE_REFERENCE = new PositioningStrategy<KtTypeAlias>(){

            public List<TextRange> mark(KtTypeAlias element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeReference ktTypeReference = element.getTypeReference();
                return PositioningStrategyKt.markElement(ktTypeReference != null ? (KtModifierListOwnerStub)ktTypeReference : (KtModifierListOwnerStub)element);
            }
        };
        SUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS_DIAGNOSTIC = new PositioningStrategy<KtElement>(){

            public List<TextRange> mark(KtElement element) {
                KtElement ktElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement ktElement2 = element;
                if (ktElement2 instanceof KtEnumEntry) {
                    KtInitializerList ktInitializerList = ((KtEnumEntry)element).getInitializerList();
                    ktElement = ktInitializerList != null ? (KtElementImplStub)ktInitializerList : (KtElementImplStub)element;
                } else if (ktElement2 instanceof KtTypeReference) {
                    PsiElement psiElement = ((KtTypeReference)element).getParent();
                    KtConstructorCalleeExpression ktConstructorCalleeExpression = psiElement instanceof KtConstructorCalleeExpression ? (KtConstructorCalleeExpression)psiElement : null;
                    PsiElement psiElement2 = ktConstructorCalleeExpression != null ? ktConstructorCalleeExpression.getParent() : null;
                    KtSuperTypeCallEntry superTypeCallEntry = psiElement2 instanceof KtSuperTypeCallEntry ? (KtSuperTypeCallEntry)psiElement2 : null;
                    KtElementImplStub ktElementImplStub = superTypeCallEntry;
                    ktElement = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueArgumentList()) != null ? (KtElementImplStub)ktElementImplStub : (KtElementImplStub)element;
                } else {
                    ktElement = element;
                }
                KtElement elementToMark = ktElement;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "<init>", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "frontend.common-psi"})
    public static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lcom/intellij/psi/PsiElement;", "locateReferencedName", "", "<init>", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "frontend.common-psi"})
    @SourceDebugExtension(value={"SMAP\nPositioningStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1114:1\n1#2:1115\n*E\n"})
    public static final class FindReferencePositioningStrategy
    extends PositioningStrategy<PsiElement> {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            PsiElement result2;
            PsiElement psiElement;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)element).getOperationToken(), (Object)KtTokens.EQ) && (ktExpression = ((KtBinaryExpression)element).getLeft()) != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                return this.mark(it);
            }
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof KtQualifiedExpression) {
                KtExpression ktExpression2;
                KtExpression selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression();
                if (selectorExpression instanceof KtCallExpression) {
                    ktExpression2 = ((KtCallExpression)selectorExpression).getCalleeExpression();
                    if (ktExpression2 == null) {
                        ktExpression2 = selectorExpression;
                    }
                } else {
                    ktExpression2 = selectorExpression instanceof KtReferenceExpression ? selectorExpression : (KtExpression)element;
                }
                psiElement = ktExpression2;
            } else if (psiElement2 instanceof KtCallableReferenceExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtCallableReferenceExpression)element).getCallableReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
                psiElement = ktSimpleNameExpression;
            } else if (psiElement2 instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element).getCalleeExpression();
                if (ktExpression3 == null) {
                    ktExpression3 = (KtExpression)element;
                }
                psiElement = ktExpression3;
            } else if (psiElement2 instanceof KtConstructorDelegationCall) {
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                psiElement = ktConstructorDelegationReferenceExpression != null ? (KtElementImpl)ktConstructorDelegationReferenceExpression : (KtElementImpl)element;
            } else if (psiElement2 instanceof KtSuperTypeCallEntry) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ((KtSuperTypeCallEntry)element).getCalleeExpression();
                Intrinsics.checkNotNullExpressionValue((Object)ktConstructorCalleeExpression, (String)"getCalleeExpression(...)");
                psiElement = ktConstructorCalleeExpression;
            } else if (psiElement2 instanceof KtOperationExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                psiElement = ktSimpleNameExpression;
            } else if (psiElement2 instanceof KtWhenConditionInRange) {
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                psiElement = ktOperationReferenceExpression;
            } else if (psiElement2 instanceof KtAnnotationEntry) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ((KtAnnotationEntry)element).getCalleeExpression();
                psiElement = ktConstructorCalleeExpression != null ? (KtElementImplStub)ktConstructorCalleeExpression : (KtElementImplStub)element;
            } else if (psiElement2 instanceof KtTypeReference) {
                KtTypeElement ktTypeElement = ((KtTypeReference)element).getTypeElement();
                KtTypeElement ktTypeElement2 = ktTypeElement instanceof KtNullableType ? (KtNullableType)ktTypeElement : null;
                psiElement = ktTypeElement2 != null && (ktTypeElement2 = ktTypeElement2.getInnerType()) != null ? (KtElement)ktTypeElement2 : (KtElement)element;
            } else if (psiElement2 instanceof KtImportDirective) {
                KtExpression ktExpression4 = ((KtImportDirective)element).getImportedReference();
                psiElement = ktExpression4 != null ? (KtElement)ktExpression4 : (KtElement)element;
            } else {
                psiElement = result2 = element;
            }
            while (this.locateReferencedName && result2 instanceof KtParenthesizedExpression) {
                KtExpression ktExpression5 = ((KtParenthesizedExpression)result2).getExpression();
                if (ktExpression5 == null) break;
                result2 = ktExpression5;
            }
            return super.mark(result2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$InlineFunPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "<init>", "()V", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "frontend.common-psi"})
    private static final class InlineFunPositioningStrategy
    extends ModifierSetBasedPositioningStrategy {
        public InlineFunPositioningStrategy() {
            IElementType[] iElementTypeArray = new IElementType[]{KtTokens.INLINE_KEYWORD};
            super(iElementTypeArray);
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof KtProperty) {
                List<TextRange> list2 = this.markModifier(((KtProperty)element).getGetter());
                if (list2 == null && (list2 = this.markModifier(((KtProperty)element).getSetter())) == null) {
                    list2 = super.mark(element);
                }
                return list2;
            }
            return super.mark(element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierSet", "Lcom/intellij/psi/tree/TokenSet;", "<init>", "(Lcom/intellij/psi/tree/TokenSet;)V", "tokens", "", "Lcom/intellij/psi/tree/IElementType;", "([Lcom/intellij/psi/tree/IElementType;)V", "markModifier", "", "Lcom/intellij/openapi/util/TextRange;", "element", "mark", "frontend.common-psi"})
    @SourceDebugExtension(value={"SMAP\nPositioningStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1114:1\n11365#2,9:1115\n13291#2:1124\n13292#2:1126\n11374#2:1127\n1#3:1125\n1#3:1128\n*S KotlinDebug\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy\n*L\n445#1:1115,9\n445#1:1124\n445#1:1126\n445#1:1127\n445#1:1125\n*E\n"})
    private static class ModifierSetBasedPositioningStrategy
    extends PositioningStrategy<KtModifierListOwner> {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedPositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter((Object)modifierSet, (String)"modifierSet");
            this.modifierSet = modifierSet;
        }

        public ModifierSetBasedPositioningStrategy(IElementType ... tokens) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            TokenSet tokenSet = TokenSet.create(Arrays.copyOf(tokens, tokens.length));
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
            this(tokenSet);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        protected final List<TextRange> markModifier(@Nullable KtModifierListOwner element) {
            v0 = this.modifierSet.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getTypes(...)");
            $this$mapNotNull$iv = v0;
            $i$f$mapNotNull = false;
            var4_5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var10_12 = ((void)$this$forEach$iv$iv$iv).length;
            for (var9_11 = 0; var9_11 < var10_12; ++var9_11) {
                element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var9_11];
                $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                it = (IElementType)element$iv$iv;
                $i$a$-mapNotNull-PositioningStrategies$ModifierSetBasedPositioningStrategy$markModifier$1 = false;
                v1 = element;
                if (v1 == null || (v1 = v1.getModifierList()) == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                if ((v1 = v1.getModifier((KtModifierKeywordToken)it)) != null) {
                    v2 = v1.getTextRange();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if (v2 == null) continue;
                it$iv$iv = v2;
                $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            it = var2_2 = (List<E>)destination$iv$iv;
            $i$a$-takeIf-PositioningStrategies$ModifierSetBasedPositioningStrategy$markModifier$2 = false;
            return !((Collection)it).isEmpty() != false ? var2_2 : null;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element) {
            PsiElement psiElement;
            PsiElement nameIdentifier;
            List<TextRange> result2;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List<TextRange> list2 = result2 = this.markModifier(element);
            if (list2 != null) {
                return list2;
            }
            if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                return PositioningStrategyKt.markElement(nameIdentifier);
            }
            KtModifierListOwner ktModifierListOwner = element;
            if (ktModifierListOwner instanceof KtObjectDeclaration) {
                PsiElement psiElement2 = ((KtObjectDeclaration)element).getObjectKeyword();
                psiElement = psiElement2;
                Intrinsics.checkNotNull((Object)psiElement2);
            } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                PsiElement psiElement3 = ((KtPropertyAccessor)element).getNamePlaceholder();
                psiElement = psiElement3;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getNamePlaceholder(...)");
            } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                psiElement = element;
            } else {
                throw new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + '\'');
            }
            PsiElement elementToMark = psiElement;
            return PositioningStrategyKt.markElement(elementToMark);
        }
    }
}

