/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.javac;

import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.javac.JavacWrapperKotlinResolver;
import org.jetbrains.kotlin.javac.resolve.MockKotlinField;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/javac/JavacWrapperKotlinResolverImpl;", "Lorg/jetbrains/kotlin/javac/JavacWrapperKotlinResolver;", "lightClassGenerationSupport", "Lorg/jetbrains/kotlin/asJava/LightClassGenerationSupport;", "<init>", "(Lorg/jetbrains/kotlin/asJava/LightClassGenerationSupport;)V", "supersCache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveSupertypes", "classOrObject", "findField", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "name", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "cli-base"})
@SourceDebugExtension(value={"SMAP\nJavacWrapperKotlinResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavacWrapperKotlinResolverImpl.kt\norg/jetbrains/kotlin/cli/jvm/javac/JavacWrapperKotlinResolverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1601#2,9:64\n1853#2:73\n1854#2:75\n1610#2:76\n1#3:74\n1#3:77\n*S KotlinDebug\n*F\n+ 1 JavacWrapperKotlinResolverImpl.kt\norg/jetbrains/kotlin/cli/jvm/javac/JavacWrapperKotlinResolverImpl\n*L\n45#1:64,9\n45#1:73\n45#1:75\n45#1:76\n45#1:74\n*E\n"})
public final class JavacWrapperKotlinResolverImpl
implements JavacWrapperKotlinResolver {
    @NotNull
    private final LightClassGenerationSupport lightClassGenerationSupport;
    @NotNull
    private final HashMap<KtClassOrObject, List<ClassId>> supersCache;

    public JavacWrapperKotlinResolverImpl(@NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        Intrinsics.checkNotNullParameter((Object)lightClassGenerationSupport, (String)"lightClassGenerationSupport");
        this.lightClassGenerationSupport = lightClassGenerationSupport;
        this.supersCache = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassId> resolveSupertypes(@NotNull KtClassOrObject classOrObject) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        List<ClassId> cachedItem = this.supersCache.get(classOrObject);
        if (cachedItem != null) {
            return cachedItem;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)this.lightClassGenerationSupport.analyze(classOrObject).get(BindingContext.CLASS, classOrObject);
        if (classDescriptor2 == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        Collection<KotlinType> collection = classDescriptor3.getDefaultType().getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
        Iterable iterable = collection;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl2 = false;
            ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor4 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if ((classDescriptor4 != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor4) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List classIds = (List)destination$iv$iv;
        ((Map)this.supersCache).put(classOrObject, classIds);
        return classIds;
    }

    @Override
    @Nullable
    public JavaField findField(@NotNull KtClassOrObject classOrObject, @NotNull String name2) {
        MockKotlinField mockKotlinField;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(classOrObject);
            if (ktLightClass == null) {
                return null;
            }
            KtLightClass lightClass = ktLightClass;
            PsiField[] psiFieldArray = lightClass.getAllFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getAllFields(...)");
            for (Object object2 : (Object[])psiFieldArray) {
                PsiField it = (PsiField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        PsiField psiField2 = (PsiField)object;
        if (psiField2 != null) {
            PsiField p0 = psiField2;
            boolean bl = false;
            mockKotlinField = new MockKotlinField(p0);
        } else {
            mockKotlinField = null;
        }
        return mockKotlinField;
    }

    @Override
    @Nullable
    public JavaField findField(@Nullable KtFile ktFile, @NotNull String name2) {
        MockKotlinField mockKotlinField;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            NavigatablePsiElement navigatablePsiElement = ktFile;
            if (navigatablePsiElement == null || (navigatablePsiElement = LightClassUtilsKt.findFacadeClass((KtFile)navigatablePsiElement)) == null) {
                return null;
            }
            NavigatablePsiElement lightClass = navigatablePsiElement;
            PsiField[] psiFieldArray = lightClass.getAllFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getAllFields(...)");
            for (Object object2 : (Object[])psiFieldArray) {
                PsiField it = (PsiField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        PsiField psiField2 = (PsiField)object;
        if (psiField2 != null) {
            PsiField p0 = psiField2;
            boolean bl = false;
            mockKotlinField = new MockKotlinField(p0);
        } else {
            mockKotlinField = null;
        }
        return mockKotlinField;
    }
}

