/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.resolve.jvm.JvmCompilerDeserializationConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/jvm/JvmCompilerDeserializationConfiguration;", "getDeserializationConfiguration", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmCompilerDeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "addRoots", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli-base"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final JvmCompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
        this.deserializationConfiguration = new JvmCompilerDeserializationConfiguration(languageVersionSettings2);
        this.loadedModules = new SmartList();
    }

    @Override
    @NotNull
    public JvmCompilerDeserializationConfiguration getDeserializationConfiguration() {
        return this.deserializationConfiguration;
    }

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        for (JavaRoot javaRoot : roots2) {
            VirtualFile metaInf;
            VirtualFile root2 = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root2) || root2.findChild("META-INF") == null) continue;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])metaInf.getChildren());
            while (iterator2.hasNext()) {
                VirtualFile moduleFile = (VirtualFile)iterator2.next();
                String string2 = moduleFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)"kotlin_module", (boolean)false, (int)2, null)) continue;
                Function0 function0 = (Function0)new Function0<byte[]>(moduleFile){
                    final /* synthetic */ VirtualFile $moduleFile;
                    {
                        this.$moduleFile = $moduleFile;
                        super(0);
                    }

                    public final byte[] invoke() {
                        byte[] byArray = this.$moduleFile.contentsToByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
                        return byArray;
                    }
                };
                String string3 = moduleFile.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                String string4 = moduleFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                ModuleMapping moduleMapping = JvmPackagePartProviderKt.tryLoadModuleMapping((Function0<byte[]>)function0, string3, string4, this.getDeserializationConfiguration(), messageCollector);
                if (moduleMapping == null) continue;
                ModuleMapping it = moduleMapping;
                boolean bl = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list2 = this.getLoadedModules();
                String string5 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getNameWithoutExtension(...)");
                list2.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root2, it, string5));
            }
        }
    }
}

