/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower.indy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.MfvcNodeKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArgumentsBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.indy.MetafactoryArgumentsResult;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionWithLateBinding;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.overrides.FakeOverrideBuilderStrategyKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0002OPB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0017\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\n*\u00020\u0018H\u0002J2\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\nH\u0002J(\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\f\u0010&\u001a\u00020\n*\u00020\u0014H\u0002J \u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J4\u0010)\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u00100\u001a\u00020,*\u00020,2\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u00107\u001a\u00020\n*\u0004\u0018\u00010%H\u0002J\u000e\u00108\u001a\u00020\n*\u0004\u0018\u00010%H\u0002J\u001a\u00109\u001a\u0004\u0018\u00010!2\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010%2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u0010H\u0002J\u0010\u0010?\u001a\u00020\u00182\u0006\u0010#\u001a\u00020@H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010%2\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0002J\u001a\u0010B\u001a\u0004\u0018\u00010!2\u0006\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020!H\u0002J\u001e\u0010E\u001a\u0004\u0018\u00010%2\b\u0010F\u001a\u0004\u0018\u00010%2\b\u0010G\u001a\u0004\u0018\u00010%H\u0002J\f\u0010H\u001a\u00020\n*\u00020IH\u0002J\f\u0010J\u001a\u00020\n*\u00020IH\u0002J(\u0010K\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010L\u001a\u00020\u00142\b\b\u0002\u0010M\u001a\u00020\n2\b\b\u0002\u0010N\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "crossinlineLambdas", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Ljava/util/Set;)V", "isJavaSamConversionWithEqualsHashCode", "", "getLambdaMetafactoryArguments", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/MetafactoryArgumentsResult;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "plainLambda", "isConstructorRequiringAccessor", "implFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "javaIoSerializableFqn", "Lorg/jetbrains/kotlin/name/FqName;", "isInheritedFromSerializable", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "requiresDelegationToDefaultImpls", "getLambdaMetafactoryArgsOrNullInner", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArguments;", "samMethod", "shouldBeSerializable", "checkMethodSignatureCompliance", "fakeInstanceMethod", "constraints", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$SignatureAdaptationConstraints;", "checkTypeCompliesWithConstraint", "irType", "constraint", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "isAdaptable", "adaptLambdaSignature", "", "validateMethodParameters", "implParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "methodParameters", "remapExtensionLambda", "lambda", "copy", "parent", "newIndex", "", "newName", "Lorg/jetbrains/kotlin/name/Name;", "adaptFakeInstanceMethodSignature", "requiresInstanceMethodBoxing", "requiresImplLambdaBoxing", "computeSignatureAdaptationConstraints", "adapteeFun", "expectedFun", "computeParameterTypeAdaptationConstraint", "adapteeType", "expectedType", "getErasedClassForSignatureAdaptation", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "computeReturnTypeAdaptationConstraint", "joinSignatureAdaptationConstraints", "sig1", "sig2", "composeTypeAdaptationConstraints", "t1", "t2", "isInlineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "isCrossinlineLambda", "collectValueParameters", "irFun", "withDispatchReceiver", "withExtensionReceiver", "TypeAdaptationConstraint", "SignatureAdaptationConstraints", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nLambdaMetafactoryArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LambdaMetafactoryArguments.kt\norg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,708:1\n1745#2,3:709\n1745#2,3:714\n1745#2,3:717\n817#2:720\n845#2,2:721\n1618#2,3:727\n1618#2,3:730\n1247#3,2:712\n50#4,4:723\n345#4,4:733\n*S KotlinDebug\n*F\n+ 1 LambdaMetafactoryArguments.kt\norg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder\n*L\n129#1:709,3\n195#1:714,3\n227#1:717,3\n255#1:720\n255#1:721,2\n448#1:727,3\n460#1:730,3\n187#1:712,2\n260#1:723,4\n483#1:733,4\n*E\n"})
public final class LambdaMetafactoryArgumentsBuilder {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Set<IrSimpleFunction> crossinlineLambdas;
    private final boolean isJavaSamConversionWithEqualsHashCode;
    @NotNull
    private final FqName javaIoSerializableFqn;

    public LambdaMetafactoryArgumentsBuilder(@NotNull JvmBackendContext context2, @NotNull Set<? extends IrSimpleFunction> crossinlineLambdas) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(crossinlineLambdas, (String)"crossinlineLambdas");
        this.context = context2;
        this.crossinlineLambdas = crossinlineLambdas;
        this.isJavaSamConversionWithEqualsHashCode = this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
        FqName fqName2 = new FqName("java.io").child(Name.identifier("Serializable"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        this.javaIoSerializableFqn = fqName2;
    }

    @NotNull
    public final MetafactoryArgumentsResult getLambdaMetafactoryArguments(@NotNull IrFunctionReference reference2, @NotNull IrType samType, boolean plainLambda) {
        boolean bl;
        Object element$iv;
        Iterator iterator2;
        boolean $i$f$any;
        Object $this$any$iv;
        IrFunction implFun;
        IrSimpleFunction samMethod;
        boolean functionHazard;
        boolean shouldBeSerializable;
        boolean inliningHazard;
        boolean abiHazard;
        boolean semanticsHazard;
        block32: {
            IrDeclarationParent implFunParent;
            boolean bl2;
            block31: {
                Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
                IrClass irClass = IrTypesKt.getClass(samType);
                if (irClass == null) {
                    throw new AssertionError((Object)("SAM type is not a class: " + RenderIrElementKt.render$default(samType, null, 1, null)));
                }
                IrClass samClass = irClass;
                semanticsHazard = false;
                abiHazard = false;
                inliningHazard = false;
                shouldBeSerializable = false;
                functionHazard = false;
                if (!(IrUtilsKt.isLambda(reference2.getOrigin()) || IrUtilsKt.isFromJava(samClass) && !this.isJavaSamConversionWithEqualsHashCode)) {
                    semanticsHazard = true;
                }
                if (this.isInheritedFromSerializable(samClass)) {
                    shouldBeSerializable = true;
                }
                IrSimpleFunction irSimpleFunction = JvmIrUtilsKt.getSingleAbstractMethod(samClass);
                if (irSimpleFunction == null) {
                    throw new AssertionError((Object)("SAM class has no single abstract method: " + RenderIrElementKt.render$default(samClass, null, 1, null)));
                }
                samMethod = irSimpleFunction;
                if (samMethod.isSuspend()) {
                    abiHazard = true;
                }
                if (this.requiresDelegationToDefaultImpls(samClass)) {
                    abiHazard = true;
                }
                implFun = ((IrFunctionSymbol)reference2.getSymbol()).getOwner();
                Iterable $this$any$iv2 = implFun.getTypeParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        IrTypeParameter it = (IrTypeParameter)element$iv2;
                        boolean bl3 = false;
                        if (!it.isReified()) continue;
                        bl2 = true;
                        break block31;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                functionHazard = true;
            }
            if (this.context.getGetIntrinsic().invoke((Object)implFun.getSymbol()) != null) {
                functionHazard = true;
            }
            if (implFun.isInline()) {
                functionHazard = true;
            }
            if (this.isConstructorRequiringAccessor(implFun)) {
                functionHazard = true;
            }
            if (implFun instanceof IrSimpleFunction) {
                IrClass baseFunClass;
                IrSimpleFunction baseFun = JvmIrUtilsKt.findSuperDeclaration((IrSimpleFunction)implFun, false, this.context.getConfig().getJvmDefaultMode());
                IrDeclarationParent irDeclarationParent = baseFun.getParent();
                IrClass irClass = baseFunClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (baseFunClass != null && Intrinsics.areEqual((Object)baseFunClass.getVisibility(), (Object)JavaDescriptorVisibilities.PACKAGE_VISIBILITY)) {
                    functionHazard = true;
                }
            }
            if ((implFunParent = implFun.getParent()) instanceof IrClass && Intrinsics.areEqual((Object)((IrClass)implFunParent).getOrigin(), (Object)IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS())) {
                functionHazard = true;
            }
            if (IrUtilsKt.isLambda(reference2.getOrigin()) && !((Collection)implFun.getAnnotations()).isEmpty()) {
                abiHazard = true;
            }
            if (plainLambda) {
                int parametersCount = implFun.getValueParameters().size();
                if (implFun.getExtensionReceiverParameter() != null) {
                    ++parametersCount;
                }
                if (parametersCount >= 23) {
                    abiHazard = true;
                }
            }
            $this$any$iv = IrUtilsKt.getParents(implFun);
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                IrDeclarationParent it = (IrDeclarationParent)element$iv;
                boolean bl4 = false;
                if (!(this.isInlineFunction(it) || this.isCrossinlineLambda(it))) continue;
                bl = true;
                break block32;
            }
            bl = false;
        }
        if (bl) {
            inliningHazard = true;
        }
        if (samType instanceof IrSimpleType) {
            boolean bl5;
            block33: {
                $this$any$iv = ((IrSimpleType)samType).getArguments();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        IrTypeArgument it = (IrTypeArgument)element$iv;
                        boolean bl6 = false;
                        if (!(it instanceof IrStarProjection || it instanceof IrTypeProjection && ((IrTypeProjection)it).getVariance() != Variance.INVARIANT)) continue;
                        bl5 = true;
                        break block33;
                    }
                    bl5 = false;
                }
            }
            if (bl5) {
                abiHazard = true;
            }
        }
        if (semanticsHazard) {
            return MetafactoryArgumentsResult.Failure.LambdaMetafactorySemanticsHazard.INSTANCE;
        }
        if (abiHazard) {
            return MetafactoryArgumentsResult.Failure.LambdaMetafactoryAbiHazard.INSTANCE;
        }
        if (inliningHazard) {
            return MetafactoryArgumentsResult.Failure.InliningHazard.INSTANCE;
        }
        if (functionHazard) {
            return MetafactoryArgumentsResult.Failure.FunctionHazard.INSTANCE;
        }
        LambdaMetafactoryArguments lambdaMetafactoryArguments = this.getLambdaMetafactoryArgsOrNullInner(reference2, samMethod, samType, implFun, shouldBeSerializable);
        return lambdaMetafactoryArguments != null ? (MetafactoryArgumentsResult)lambdaMetafactoryArguments : (MetafactoryArgumentsResult)MetafactoryArgumentsResult.Failure.FunctionHazard.INSTANCE;
    }

    private final boolean isConstructorRequiringAccessor(IrFunction implFun) {
        if (!(implFun instanceof IrConstructor)) {
            return false;
        }
        DescriptorVisibility visibility2 = ((IrConstructor)implFun).getVisibility();
        return Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PROTECTED) || DescriptorVisibilities.isPrivate(visibility2);
    }

    private final boolean isInheritedFromSerializable(IrClass $this$isInheritedFromSerializable) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.getAllSuperclasses($this$isInheritedFromSerializable);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrClass it = (IrClass)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(it), (Object)this.javaIoSerializableFqn)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean requiresDelegationToDefaultImpls(IrClass $this$requiresDelegationToDefaultImpls) {
        Sequence functionsAndAccessors2 = SequencesKt.plus((Sequence)SequencesKt.plus(IrUtilsKt.getFunctions($this$requiresDelegationToDefaultImpls), (Sequence)SequencesKt.mapNotNull(IrUtilsKt.getProperties($this$requiresDelegationToDefaultImpls), (Function1)requiresDelegationToDefaultImpls.functionsAndAccessors.1.INSTANCE)), (Sequence)SequencesKt.mapNotNull(IrUtilsKt.getProperties($this$requiresDelegationToDefaultImpls), (Function1)requiresDelegationToDefaultImpls.functionsAndAccessors.2.INSTANCE));
        for (IrSimpleFunction irMemberFun : functionsAndAccessors2) {
            IrSimpleFunction irImplFun;
            IrSimpleFunction irSimpleFunction;
            if (irMemberFun.getModality() == Modality.ABSTRACT) continue;
            if (irMemberFun.isFakeOverride()) {
                irSimpleFunction = InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation(irMemberFun, this.context.getConfig().getJvmDefaultMode());
                if (irSimpleFunction == null) {
                    continue;
                }
            } else {
                irSimpleFunction = irMemberFun;
            }
            if (Intrinsics.areEqual((Object)(irImplFun = irSimpleFunction).getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || JvmIrUtilsKt.isCompiledToJvmDefault(irImplFun, this.context.getConfig().getJvmDefaultMode())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final LambdaMetafactoryArguments getLambdaMetafactoryArgsOrNullInner(IrFunctionReference reference2, IrSimpleFunction samMethod, IrType samType, IrFunction implFun, boolean shouldBeSerializable) {
        IrFunctionReference newReference;
        IrFunctionReference irFunctionReference;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = IrUtilsKt.allOverridden$default(samMethod, false, 1, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (it.isFakeOverride()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonFakeOverriddenFuns = (List)destination$iv$iv;
        List relevantOverriddenFuns = samMethod.isFakeOverride() ? nonFakeOverriddenFuns : kotlin.collections.CollectionsKt.plus((Collection)nonFakeOverriddenFuns, (Object)samMethod);
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u245 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u245.setName(Name.special("<fake>"));
        IrClass fakeClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        fakeClass.setParent(this.context.getIr().getSymbols().getKotlinJvmInternalInvokeDynamicPackage());
        IrOverridableMember irOverridableMember = FakeOverrideBuilderStrategyKt.buildFakeOverrideMember$default(samType, samMethod, fakeClass, null, null, 24, null);
        Intrinsics.checkNotNull((Object)irOverridableMember, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        IrSimpleFunction fakeInstanceMethod = (IrSimpleFunction)irOverridableMember;
        ((IrFunctionWithLateBinding)fakeInstanceMethod).acquireSymbol(new IrSimpleFunctionSymbolImpl(null, 1, null));
        ((IrFunctionWithLateBinding)fakeInstanceMethod).setOverriddenSymbols(kotlin.collections.CollectionsKt.listOf((Object)samMethod.getSymbol()));
        LambdaMetafactoryArgumentsBuilder $this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u246 = this;
        boolean bl3 = false;
        SignatureAdaptationConstraints result2 = new SignatureAdaptationConstraints(MapsKt.emptyMap(), null);
        for (IrSimpleFunction overriddenFun : relevantOverriddenFuns) {
            SignatureAdaptationConstraints constraintsFromOverridden;
            if ($this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u246.computeSignatureAdaptationConstraints(fakeInstanceMethod, overriddenFun) == null) {
                return null;
            }
            if ($this$getLambdaMetafactoryArgsOrNullInner_u24lambda_u246.joinSignatureAdaptationConstraints(result2, constraintsFromOverridden) != null) continue;
            return null;
        }
        SignatureAdaptationConstraints signatureAdaptationConstraints = result2;
        if (signatureAdaptationConstraints.hasConflicts()) {
            return null;
        }
        this.adaptFakeInstanceMethodSignature(fakeInstanceMethod, signatureAdaptationConstraints);
        if (this.isAdaptable(implFun)) {
            Intrinsics.checkNotNull((Object)implFun, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            this.adaptLambdaSignature((IrSimpleFunction)implFun, fakeInstanceMethod, signatureAdaptationConstraints);
        } else if (!this.checkMethodSignatureCompliance(implFun, fakeInstanceMethod, signatureAdaptationConstraints, reference2)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)implFun.getOrigin(), (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA()) || AdditionalIrUtilsKt.isAnonymousFunction(implFun)) {
            Intrinsics.checkNotNull((Object)implFun, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            irFunctionReference = this.remapExtensionLambda((IrSimpleFunction)implFun, reference2);
        } else {
            irFunctionReference = newReference = reference2;
        }
        if (samMethod.isFakeOverride() && nonFakeOverriddenFuns.size() == 1) {
            return new LambdaMetafactoryArguments((IrSimpleFunction)kotlin.collections.CollectionsKt.single((List)nonFakeOverriddenFuns), fakeInstanceMethod, newReference, kotlin.collections.CollectionsKt.emptyList(), shouldBeSerializable);
        }
        return new LambdaMetafactoryArguments(samMethod, fakeInstanceMethod, newReference, nonFakeOverriddenFuns, shouldBeSerializable);
    }

    private final boolean checkMethodSignatureCompliance(IrFunction implFun, IrSimpleFunction fakeInstanceMethod, SignatureAdaptationConstraints constraints, IrFunctionReference reference2) {
        List<IrValueParameter> implParameters = this.collectValueParameters(implFun, reference2.getDispatchReceiver() == null, reference2.getExtensionReceiver() == null);
        List methodParameters = LambdaMetafactoryArgumentsBuilder.collectValueParameters$default(this, fakeInstanceMethod, false, false, 6, null);
        this.validateMethodParameters(implParameters, methodParameters, implFun, fakeInstanceMethod);
        for (Pair pair : kotlin.collections.CollectionsKt.zip((Iterable)implParameters, (Iterable)methodParameters)) {
            IrValueParameter implParameter = (IrValueParameter)pair.component1();
            IrValueParameter methodParameter = (IrValueParameter)pair.component2();
            TypeAdaptationConstraint constraint2 = constraints.getValueParameters().get(methodParameter);
            if (this.checkTypeCompliesWithConstraint(implParameter.getType(), constraint2)) continue;
            return false;
        }
        if (!this.checkTypeCompliesWithConstraint(implFun.getReturnType(), constraints.getReturnType())) {
            return false;
        }
        return !IrTypePredicatesKt.isUnit(implFun.getReturnType()) || IrTypePredicatesKt.isUnit(fakeInstanceMethod.getReturnType());
    }

    private final boolean checkTypeCompliesWithConstraint(IrType irType, TypeAdaptationConstraint constraint2) {
        boolean bl;
        TypeAdaptationConstraint typeAdaptationConstraint = constraint2;
        switch (typeAdaptationConstraint == null ? -1 : WhenMappings.$EnumSwitchMapping$0[typeAdaptationConstraint.ordinal()]) {
            case -1: {
                bl = true;
                break;
            }
            case 1: {
                bl = IrTypeUtilsKt.isNullable(irType);
                break;
            }
            case 2: {
                if (!IrTypeUtilsKt.isNullable(irType)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (IrTypePredicatesKt.getPrimitiveType(irType) != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isAdaptable(IrFunction $this$isAdaptable) {
        IrDeclarationOrigin irDeclarationOrigin = $this$isAdaptable.getOrigin();
        return Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA()) || Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)JvmLoweredDeclarationOrigin.INSTANCE.getPROXY_FUN_FOR_METAFACTORY()) || Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_PROXY_FUN_FOR_METAFACTORY()) ? true : (Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION()) ? AdditionalIrUtilsKt.isAnonymousFunction($this$isAdaptable) : false);
    }

    private final void adaptLambdaSignature(IrSimpleFunction implFun, IrSimpleFunction fakeInstanceMethod, SignatureAdaptationConstraints constraints) {
        if (!this.isAdaptable(implFun)) {
            throw new AssertionError((Object)("Function origin should be adaptable: " + DumpIrTreeKt.dump$default(implFun, null, 1, null)));
        }
        List implParameters = LambdaMetafactoryArgumentsBuilder.collectValueParameters$default(this, implFun, false, false, 6, null);
        List methodParameters = LambdaMetafactoryArgumentsBuilder.collectValueParameters$default(this, fakeInstanceMethod, false, false, 6, null);
        this.validateMethodParameters(implParameters, methodParameters, implFun, fakeInstanceMethod);
        for (Pair pair : kotlin.collections.CollectionsKt.zip((Iterable)implParameters, (Iterable)methodParameters)) {
            IrValueParameter implParameter = (IrValueParameter)pair.component1();
            IrValueParameter methodParameter = (IrValueParameter)pair.component2();
            TypeAdaptationConstraint parameterConstraint = constraints.getValueParameters().get(methodParameter);
            if (!this.requiresImplLambdaBoxing(parameterConstraint)) continue;
            implParameter.setType(IrTypesKt.makeNullable(implParameter.getType()));
        }
        if (this.requiresImplLambdaBoxing(constraints.getReturnType()) || IrTypePredicatesKt.isUnit(implFun.getReturnType()) && !IrTypePredicatesKt.isUnit(fakeInstanceMethod.getReturnType())) {
            implFun.setReturnType(IrTypesKt.makeNullable(implFun.getReturnType()));
        }
    }

    private final void validateMethodParameters(List<? extends IrValueParameter> implParameters, List<? extends IrValueParameter> methodParameters, IrFunction implFun, IrSimpleFunction fakeInstanceMethod) {
        if (implParameters.size() != methodParameters.size()) {
            throw new AssertionError((Object)("Mismatching lambda and instance method parameters:\nimplFun: " + RenderIrElementKt.render$default(implFun, null, 1, null) + "\n  (" + implParameters.size() + " parameters)\ninstance method: " + RenderIrElementKt.render$default(fakeInstanceMethod, null, 1, null) + "\n  (" + methodParameters.size() + " parameters)"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunctionReference remapExtensionLambda(IrSimpleFunction lambda2, IrFunctionReference reference2) {
        void it;
        IrValueParameter it2;
        IrValueParameter oldParameter;
        IrValueParameter irValueParameter;
        Collection<IrValueParameter> collection;
        IrValueParameter irValueParameter2 = lambda2.getExtensionReceiverParameter();
        if (irValueParameter2 == null) {
            return reference2;
        }
        IrValueParameter oldExtensionReceiver = irValueParameter2;
        ArrayList<IrValueParameter> newValueParameters = new ArrayList<IrValueParameter>();
        HashMap oldToNew = new HashMap();
        int newParameterIndex = 0;
        Iterable $this$mapTo$iv322 = kotlin.collections.CollectionsKt.take((Iterable)lambda2.getValueParameters(), (int)lambda2.getContextReceiverParametersCount());
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv322) {
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv;
            collection = newValueParameters;
            boolean bl = false;
            int n = newParameterIndex;
            newParameterIndex = n + 1;
            it2 = irValueParameter = LambdaMetafactoryArgumentsBuilder.copy$default(this, oldParameter, lambda2, n, null, 4, null);
            boolean bl2 = false;
            ((Map)oldToNew).put(oldParameter, it2);
            collection.add(irValueParameter);
        }
        int $this$mapTo$iv322 = newParameterIndex;
        newParameterIndex = $this$mapTo$iv322 + 1;
        Object $this$mapTo$iv322 = this.copy(oldExtensionReceiver, lambda2, $this$mapTo$iv322, oldExtensionReceiver.getName());
        IrValueParameter $i$f$mapTo22 = $this$mapTo$iv322;
        collection = newValueParameters;
        boolean bl = false;
        ((Map)oldToNew).put(oldExtensionReceiver, it);
        ((ArrayList)collection).add((IrValueParameter)$this$mapTo$iv322);
        $this$mapTo$iv322 = kotlin.collections.CollectionsKt.drop((Iterable)lambda2.getValueParameters(), (int)lambda2.getContextReceiverParametersCount());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv322.iterator();
        while (iterator2.hasNext()) {
            Object item$iv;
            item$iv = iterator2.next();
            oldParameter = (IrValueParameter)item$iv;
            collection = newValueParameters;
            boolean bl3 = false;
            int n = newParameterIndex;
            newParameterIndex = n + 1;
            it2 = irValueParameter = LambdaMetafactoryArgumentsBuilder.copy$default(this, oldParameter, lambda2, n, null, 4, null);
            boolean bl4 = false;
            ((Map)oldToNew).put(oldParameter, it2);
            collection.add(irValueParameter);
        }
        IrBody irBody = lambda2.getBody();
        if (irBody != null) {
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, new VariableRemapper(oldToNew));
        }
        lambda2.setExtensionReceiverParameter(null);
        lambda2.setValueParameters((List<? extends IrValueParameter>)newValueParameters);
        return new IrFunctionReferenceImpl(reference2.getStartOffset(), reference2.getEndOffset(), reference2.getType(), lambda2.getSymbol(), 0, newValueParameters.size(), null, reference2.getOrigin());
    }

    private final IrValueParameter copy(IrValueParameter $this$copy, IrSimpleFunction parent2, int newIndex, Name newName2) {
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$copy_u24lambda_u2412 = $this$buildValueParameter_u24lambda_u2430$iv;
        boolean bl2 = false;
        $this$copy_u24lambda_u2412.updateFrom($this$copy);
        $this$copy_u24lambda_u2412.setIndex(newIndex);
        $this$copy_u24lambda_u2412.setName(newName2);
        return DeclarationBuildersKt.buildValueParameter(((IrDeclaration)parent2).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)parent2)));
    }

    static /* synthetic */ IrValueParameter copy$default(LambdaMetafactoryArgumentsBuilder lambdaMetafactoryArgumentsBuilder, IrValueParameter irValueParameter, IrSimpleFunction irSimpleFunction, int n, Name name2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            name2 = irValueParameter.getName();
        }
        return lambdaMetafactoryArgumentsBuilder.copy(irValueParameter, irSimpleFunction, n, name2);
    }

    private final void adaptFakeInstanceMethodSignature(IrSimpleFunction fakeInstanceMethod, SignatureAdaptationConstraints constraints) {
        for (Map.Entry<IrValueParameter, TypeAdaptationConstraint> entry : constraints.getValueParameters().entrySet()) {
            IrValueParameter valueParameter2 = entry.getKey();
            TypeAdaptationConstraint constraint2 = entry.getValue();
            if (!Intrinsics.areEqual((Object)valueParameter2.getParent(), (Object)fakeInstanceMethod)) {
                throw new AssertionError((Object)("Unexpected value parameter: " + RenderIrElementKt.render$default(valueParameter2, null, 1, null) + "; fakeInstanceMethod:\n" + DumpIrTreeKt.dump$default(fakeInstanceMethod, null, 1, null)));
            }
            if (!this.requiresInstanceMethodBoxing(constraint2)) continue;
            valueParameter2.setType(IrTypesKt.makeNullable(valueParameter2.getType()));
        }
        if (this.requiresInstanceMethodBoxing(constraints.getReturnType())) {
            fakeInstanceMethod.setReturnType(IrTypesKt.makeNullable(fakeInstanceMethod.getReturnType()));
        }
    }

    private final boolean requiresInstanceMethodBoxing(TypeAdaptationConstraint $this$requiresInstanceMethodBoxing) {
        return $this$requiresInstanceMethodBoxing == TypeAdaptationConstraint.FORCE_BOXING || $this$requiresInstanceMethodBoxing == TypeAdaptationConstraint.BOX_PRIMITIVE;
    }

    private final boolean requiresImplLambdaBoxing(TypeAdaptationConstraint $this$requiresImplLambdaBoxing) {
        return $this$requiresImplLambdaBoxing == TypeAdaptationConstraint.FORCE_BOXING;
    }

    private final SignatureAdaptationConstraints computeSignatureAdaptationConstraints(IrSimpleFunction adapteeFun, IrSimpleFunction expectedFun) {
        TypeAdaptationConstraint returnTypeConstraint = this.computeReturnTypeAdaptationConstraint(adapteeFun, expectedFun);
        if (returnTypeConstraint == TypeAdaptationConstraint.CONFLICT) {
            return null;
        }
        HashMap valueParameterConstraints = new HashMap();
        List adapteeParameters = LambdaMetafactoryArgumentsBuilder.collectValueParameters$default(this, adapteeFun, false, false, 6, null);
        List expectedParameters = LambdaMetafactoryArgumentsBuilder.collectValueParameters$default(this, expectedFun, false, false, 6, null);
        if (adapteeParameters.size() != expectedParameters.size()) {
            throw new AssertionError((Object)("Mismatching value parameters:\nadaptee: " + RenderIrElementKt.render$default(adapteeFun, null, 1, null) + "\n  " + adapteeParameters.size() + " value parameters;\nexpected: " + RenderIrElementKt.render$default(expectedFun, null, 1, null) + "\n  " + expectedParameters.size() + " value parameters."));
        }
        for (Pair pair : kotlin.collections.CollectionsKt.zip((Iterable)adapteeParameters, (Iterable)expectedParameters)) {
            TypeAdaptationConstraint parameterConstraint;
            IrValueParameter adapteeParameter = (IrValueParameter)pair.component1();
            IrValueParameter expectedParameter = (IrValueParameter)pair.component2();
            if (this.computeParameterTypeAdaptationConstraint(adapteeParameter.getType(), expectedParameter.getType()) == null) continue;
            if (parameterConstraint == TypeAdaptationConstraint.CONFLICT) {
                return null;
            }
            ((Map)valueParameterConstraints).put(adapteeParameter, parameterConstraint);
        }
        return new SignatureAdaptationConstraints(valueParameterConstraints.isEmpty() ? MapsKt.emptyMap() : (Map)valueParameterConstraints, returnTypeConstraint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final TypeAdaptationConstraint computeParameterTypeAdaptationConstraint(IrType adapteeType, IrType expectedType) {
        TypeAdaptationConstraint typeAdaptationConstraint;
        if (!(adapteeType instanceof IrSimpleType)) {
            throw new AssertionError((Object)("Simple type expected: " + RenderIrElementKt.render$default(adapteeType, null, 1, null)));
        }
        if (!(expectedType instanceof IrSimpleType)) {
            throw new AssertionError((Object)("Simple type expected: " + RenderIrElementKt.render$default(expectedType, null, 1, null)));
        }
        if (IrTypePredicatesKt.isNothing(adapteeType)) return TypeAdaptationConstraint.CONFLICT;
        if (IrTypePredicatesKt.isNullableNothing(adapteeType)) {
            return TypeAdaptationConstraint.CONFLICT;
        }
        if (IrTypePredicatesKt.isPrimitiveType$default(adapteeType, false, 1, null)) {
            TypeAdaptationConstraint typeAdaptationConstraint2;
            if (IrTypePredicatesKt.isPrimitiveType$default(expectedType, false, 1, null)) {
                IrAnnotationContainer irAnnotationContainer = expectedType;
                FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
                if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
                    typeAdaptationConstraint2 = TypeAdaptationConstraint.KEEP_UNBOXED;
                    return typeAdaptationConstraint2;
                }
            }
            typeAdaptationConstraint2 = TypeAdaptationConstraint.BOX_PRIMITIVE;
            return typeAdaptationConstraint2;
        }
        IrClass erasedAdapteeClass = this.getErasedClassForSignatureAdaptation((IrSimpleType)adapteeType);
        if (!IrDeclarationsKt.isSingleFieldValueClass(erasedAdapteeClass)) {
            if (!MfvcNodeKt.needsMfvcFlattening(adapteeType)) return null;
            return TypeAdaptationConstraint.CONFLICT;
        }
        IrSimpleType underlyingAdapteeType = InlineClassesKt.getInlineClassUnderlyingType(erasedAdapteeClass);
        if (!IrTypeUtilsKt.isNullable(underlyingAdapteeType) && !IrTypePredicatesKt.isPrimitiveType$default(underlyingAdapteeType, false, 1, null)) {
            return TypeAdaptationConstraint.CONFLICT;
        }
        IrClass erasedExpectedClass = this.getErasedClassForSignatureAdaptation((IrSimpleType)expectedType);
        if (IrDeclarationsKt.isSingleFieldValueClass(erasedExpectedClass)) {
            typeAdaptationConstraint = TypeAdaptationConstraint.CONFLICT;
            return typeAdaptationConstraint;
        }
        typeAdaptationConstraint = TypeAdaptationConstraint.FORCE_BOXING;
        return typeAdaptationConstraint;
    }

    private final IrClass getErasedClassForSignatureAdaptation(IrSimpleType irType) {
        IrClass irClass;
        IrSymbolOwner classifier2 = irType.getClassifier().getOwner();
        if (classifier2 instanceof IrTypeParameter) {
            irClass = JvmIrTypeUtilsKt.getErasedUpperBound((IrTypeParameter)classifier2);
        } else if (classifier2 instanceof IrClass) {
            irClass = (IrClass)classifier2;
        } else {
            throw new AssertionError((Object)("Unexpected classifier: " + RenderIrElementKt.render$default(classifier2, null, 1, null)));
        }
        return irClass;
    }

    private final TypeAdaptationConstraint computeReturnTypeAdaptationConstraint(IrSimpleFunction adapteeFun, IrSimpleFunction expectedFun) {
        IrType adapteeReturnType = adapteeFun.getReturnType();
        if (IrTypePredicatesKt.isUnit(adapteeReturnType)) {
            return IrTypePredicatesKt.isUnit(expectedFun.getReturnType()) ? TypeAdaptationConstraint.KEEP_UNBOXED : TypeAdaptationConstraint.FORCE_BOXING;
        }
        IrType expectedReturnType = expectedFun.getReturnType();
        return this.computeParameterTypeAdaptationConstraint(adapteeReturnType, expectedReturnType);
    }

    private final SignatureAdaptationConstraints joinSignatureAdaptationConstraints(SignatureAdaptationConstraints sig1, SignatureAdaptationConstraints sig2) {
        Map map;
        TypeAdaptationConstraint newReturnTypeConstraint = this.composeTypeAdaptationConstraints(sig1.getReturnType(), sig2.getReturnType());
        if (newReturnTypeConstraint == TypeAdaptationConstraint.CONFLICT) {
            return null;
        }
        if (sig1.getValueParameters().isEmpty()) {
            map = sig2.getValueParameters();
        } else if (sig2.getValueParameters().isEmpty()) {
            map = sig1.getValueParameters();
        } else {
            HashMap<IrValueParameter, TypeAdaptationConstraint> joined2 = new HashMap<IrValueParameter, TypeAdaptationConstraint>();
            joined2.putAll(sig1.getValueParameters());
            for (Map.Entry<IrValueParameter, TypeAdaptationConstraint> entry : sig2.getValueParameters().entrySet()) {
                TypeAdaptationConstraint tx;
                IrValueParameter vp2 = entry.getKey();
                TypeAdaptationConstraint t2 = entry.getValue();
                if (this.composeTypeAdaptationConstraints((TypeAdaptationConstraint)((Object)joined2.get(vp2)), t2) == null) continue;
                if (tx == TypeAdaptationConstraint.CONFLICT) {
                    return null;
                }
                ((Map)joined2).put(vp2, tx);
            }
            map = joined2;
        }
        Map newValueParameterConstraints = map;
        return new SignatureAdaptationConstraints(newValueParameterConstraints, newReturnTypeConstraint);
    }

    private final TypeAdaptationConstraint composeTypeAdaptationConstraints(TypeAdaptationConstraint t1, TypeAdaptationConstraint t2) {
        return t1 == null ? t2 : (t2 == null ? t1 : (t1 == t2 ? t1 : TypeAdaptationConstraint.CONFLICT));
    }

    private final boolean isInlineFunction(IrDeclarationParent $this$isInlineFunction) {
        return $this$isInlineFunction instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isInlineFunction).isInline() && !Intrinsics.areEqual((Object)((IrSimpleFunction)$this$isInlineFunction).getOrigin(), (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA());
    }

    private final boolean isCrossinlineLambda(IrDeclarationParent $this$isCrossinlineLambda) {
        return $this$isCrossinlineLambda instanceof IrSimpleFunction && this.crossinlineLambdas.contains($this$isCrossinlineLambda);
    }

    @NotNull
    public final List<IrValueParameter> collectValueParameters(@NotNull IrFunction irFun, boolean withDispatchReceiver2, boolean withExtensionReceiver) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)irFun, (String)"irFun");
        if (!(withDispatchReceiver2 && irFun.getDispatchReceiverParameter() != null || withExtensionReceiver && irFun.getExtensionReceiverParameter() != null)) {
            return irFun.getValueParameters();
        }
        ArrayList $this$collectValueParameters_u24lambda_u2413 = arrayList = new ArrayList();
        boolean bl = false;
        if (withDispatchReceiver2) {
            CollectionsKt.addIfNotNull($this$collectValueParameters_u24lambda_u2413, irFun.getDispatchReceiverParameter());
        }
        if (withExtensionReceiver) {
            CollectionsKt.addIfNotNull($this$collectValueParameters_u24lambda_u2413, irFun.getExtensionReceiverParameter());
        }
        $this$collectValueParameters_u24lambda_u2413.addAll(irFun.getValueParameters());
        return arrayList;
    }

    public static /* synthetic */ List collectValueParameters$default(LambdaMetafactoryArgumentsBuilder lambdaMetafactoryArgumentsBuilder, IrFunction irFunction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return lambdaMetafactoryArgumentsBuilder.collectValueParameters(irFunction, bl, bl2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$SignatureAdaptationConstraints;", "", "valueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "returnType", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;)V", "getValueParameters", "()Ljava/util/Map;", "getReturnType", "()Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "hasConflicts", "", "backend.jvm.lower"})
    private static final class SignatureAdaptationConstraints {
        @NotNull
        private final Map<IrValueParameter, TypeAdaptationConstraint> valueParameters;
        @Nullable
        private final TypeAdaptationConstraint returnType;

        public SignatureAdaptationConstraints(@NotNull Map<IrValueParameter, ? extends TypeAdaptationConstraint> valueParameters2, @Nullable TypeAdaptationConstraint returnType2) {
            Intrinsics.checkNotNullParameter(valueParameters2, (String)"valueParameters");
            this.valueParameters = valueParameters2;
            this.returnType = returnType2;
        }

        @NotNull
        public final Map<IrValueParameter, TypeAdaptationConstraint> getValueParameters() {
            return this.valueParameters;
        }

        @Nullable
        public final TypeAdaptationConstraint getReturnType() {
            return this.returnType;
        }

        public final boolean hasConflicts() {
            return this.returnType == TypeAdaptationConstraint.CONFLICT || this.valueParameters.values().contains((Object)TypeAdaptationConstraint.CONFLICT);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArgumentsBuilder$TypeAdaptationConstraint;", "", "<init>", "(Ljava/lang/String;I)V", "FORCE_BOXING", "BOX_PRIMITIVE", "KEEP_UNBOXED", "CONFLICT", "backend.jvm.lower"})
    private static final class TypeAdaptationConstraint
    extends Enum<TypeAdaptationConstraint> {
        public static final /* enum */ TypeAdaptationConstraint FORCE_BOXING = new TypeAdaptationConstraint();
        public static final /* enum */ TypeAdaptationConstraint BOX_PRIMITIVE = new TypeAdaptationConstraint();
        public static final /* enum */ TypeAdaptationConstraint KEEP_UNBOXED = new TypeAdaptationConstraint();
        public static final /* enum */ TypeAdaptationConstraint CONFLICT = new TypeAdaptationConstraint();
        private static final /* synthetic */ TypeAdaptationConstraint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TypeAdaptationConstraint[] values() {
            return (TypeAdaptationConstraint[])$VALUES.clone();
        }

        public static TypeAdaptationConstraint valueOf(String value2) {
            return Enum.valueOf(TypeAdaptationConstraint.class, value2);
        }

        @NotNull
        public static EnumEntries<TypeAdaptationConstraint> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeAdaptationConstraintArray = new TypeAdaptationConstraint[]{TypeAdaptationConstraint.FORCE_BOXING, TypeAdaptationConstraint.BOX_PRIMITIVE, TypeAdaptationConstraint.KEEP_UNBOXED, TypeAdaptationConstraint.CONFLICT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeAdaptationConstraint.values().length];
            try {
                nArray[TypeAdaptationConstraint.FORCE_BOXING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeAdaptationConstraint.KEEP_UNBOXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeAdaptationConstraint.BOX_PRIMITIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeAdaptationConstraint.CONFLICT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

