/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmReflectSymbols;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020(H\u0016J\u0014\u0010-\u001a\u00020 *\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u001c\u00101\u001a\u00020 *\u00020.2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0002J\u0014\u00105\u001a\u00020 *\u00020.2\u0006\u00106\u001a\u00020 H\u0002J$\u00107\u001a\u00020 *\u00020.2\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020 H\u0002J\u001c\u0010;\u001a\u00020 *\u00020.2\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020 H\u0002J\u001c\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020?H\u0002J\"\u0010A\u001a\u00020 *\u00020.2\u0006\u0010B\u001a\u0002002\f\u0010C\u001a\b\u0012\u0004\u0012\u00020 0DH\u0002J*\u0010E\u001a\u00020 *\u00020.2\u0006\u00102\u001a\u00020 2\u0006\u0010F\u001a\u0002042\f\u0010G\u001a\b\u0012\u0004\u0012\u0002000DH\u0002J\u0014\u0010H\u001a\u00020 *\u00020.2\u0006\u0010I\u001a\u00020 H\u0002J*\u0010J\u001a\u00020 *\u00020.2\u0006\u0010I\u001a\u00020 2\u0006\u00109\u001a\u00020 2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020 0DH\u0002J\"\u0010L\u001a\u00020 *\u00020.2\u0006\u00102\u001a\u00020 2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002000DH\u0002J\u0014\u0010M\u001a\u00020 *\u00020.2\u0006\u0010N\u001a\u00020 H\u0002J\"\u0010O\u001a\u00020 *\u00020.2\u0006\u0010N\u001a\u00020 2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020 0DH\u0002JN\u0010P\u001a\u00020 2\u0006\u00102\u001a\u0002002\u0006\u0010F\u001a\u0002042\f\u0010G\u001a\b\u0012\u0004\u0012\u0002000D2\b\u00109\u001a\u0004\u0018\u00010 2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020 0D2\u0006\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020\u0015H\u0002J\u0012\u0010S\u001a\b\u0012\u0004\u0012\u00020 0D*\u00020TH\u0002J\u0012\u0010U\u001a\b\u0012\u0004\u0012\u0002000D*\u00020TH\u0002J\u0010\u0010P\u001a\u00020 2\u0006\u0010V\u001a\u00020\u0019H\u0002J\u0010\u0010W\u001a\u00020 2\u0006\u0010V\u001a\u00020\u0019H\u0002J\u0010\u0010X\u001a\u00020 2\u0006\u0010V\u001a\u00020&H\u0002J2\u0010Y\u001a\u00020 2\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u0010Z\u001a\u0002002\b\u0010[\u001a\u0004\u0018\u00010 2\u0006\u0010R\u001a\u00020\u0015H\u0002J\u0010\u0010Y\u001a\u00020 2\u0006\u0010\\\u001a\u00020\"H\u0002J:\u0010]\u001a\u00020 2\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u0010:\u001a\u00020 2\u0006\u0010^\u001a\u0002002\b\u0010[\u001a\u0004\u0018\u00010 2\u0006\u0010R\u001a\u00020\u0015H\u0002J\u0010\u0010]\u001a\u00020 2\u0006\u0010_\u001a\u00020$H\u0002J\u0010\u0010`\u001a\u00020\u00142\u0006\u0010a\u001a\u00020bH\u0002J\u001e\u0010c\u001a\u0010\u0012\u0004\u0012\u000200\u0012\u0006\u0012\u0004\u0018\u00010 0d2\u0006\u0010V\u001a\u00020\u0019H\u0002J\u0010\u0010e\u001a\u00020 2\u0006\u0010V\u001a\u00020\u0019H\u0002J\u0010\u0010f\u001a\u00020 2\u0006\u0010V\u001a\u00020\u0019H\u0002J\u0010\u0010g\u001a\u00020 2\u0006\u0010_\u001a\u00020$H\u0002J\u0018\u0010h\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010i\u001a\u00020\u001aH\u0002J\u0010\u0010j\u001a\u00020 2\u0006\u0010V\u001a\u00020(H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "getInlineScopeResolver", "()Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "setInlineScopeResolver", "(Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isAccessible", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "withSuper", "callsOnCompanionObjects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getCallsOnCompanionObjects", "()Ljava/util/Map;", "recordCompanionObjectAsDispatchReceiver", "expression", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "reflectSymbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmReflectSymbols;", "javaClassObject", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "klass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getDeclaredField", "declaringClass", "fieldName", "", "fieldSetAccessible", "field", "fieldSet", "fieldObject", "receiver", "value", "fieldGet", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "irVararg", "elementType", "values", "", "getDeclaredMethod", "methodName", "parameterTypes", "methodSetAccessible", "method", "methodInvoke", "arguments", "getDeclaredConstructor", "constructorSetAccessible", "constructor", "constructorNewInstance", "generateReflectiveMethodInvocation", "returnType", "symbol", "getValueArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "valueParameterTypes", "call", "generateReflectiveStaticCall", "generateReflectiveConstructorInvocation", "generateReflectiveFieldGet", "fieldType", "instance", "getField", "generateReflectiveFieldSet", "type", "setField", "shouldUseAccessor", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "fieldLocationAndReceiver", "Lkotlin/Pair;", "generateReflectiveAccessForGetter", "generateReflectiveAccessForSetter", "generateThrowIllegalAccessException", "generateInvokeSpecialForCall", "superQualifier", "generateReflectiveAccessForCompanion", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nReflectiveAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectiveAccess.kt\norg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n*L\n1#1,565:1\n1547#2:566\n1618#2,3:567\n1547#2:570\n1618#2,3:571\n1547#2:589\n1618#2,3:590\n1547#2:593\n1618#2,3:594\n388#3,13:574\n388#3,13:598\n388#3,13:613\n388#3,13:628\n388#3,13:643\n98#4,2:587\n98#4,2:611\n98#4,2:626\n98#4,2:641\n98#4,2:656\n1#5:597\n1#5:659\n20#6:658\n*S KotlinDebug\n*F\n+ 1 ReflectiveAccess.kt\norg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering\n*L\n235#1:566\n235#1:567,3\n261#1:570\n261#1:571,3\n306#1:589\n306#1:590,3\n309#1:593\n309#1:594,3\n290#1:574,13\n355#1:598,13\n377#1:613,13\n410#1:628,13\n515#1:643,13\n290#1:587,2\n355#1:611,2\n377#1:626,2\n410#1:641,2\n515#1:656,2\n546#1:659\n546#1:658\n*E\n"})
public final class ReflectiveAccessLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    public IrInlineScopeResolver inlineScopeResolver;
    @NotNull
    private final Map<IrCall, IrClassSymbol> callsOnCompanionObjects;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final JvmReflectSymbols reflectSymbols;

    public ReflectiveAccessLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.callsOnCompanionObjects = new LinkedHashMap();
        this.symbols = this.context.getIr().getSymbols();
        this.reflectSymbols = this.symbols.getJavaLangReflectSymbols();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrInlineScopeResolver getInlineScopeResolver() {
        IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
        if (irInlineScopeResolver != null) {
            return irInlineScopeResolver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inlineScopeResolver");
        return null;
    }

    public final void setInlineScopeResolver(@NotNull IrInlineScopeResolver irInlineScopeResolver) {
        Intrinsics.checkNotNullParameter((Object)irInlineScopeResolver, (String)"<set-?>");
        this.inlineScopeResolver = irInlineScopeResolver;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setInlineScopeResolver(IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context));
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    private final boolean isAccessible(IrSymbol $this$isAccessible, boolean withSuper) {
        return SyntheticAccessorLowering.Companion.isAccessible($this$isAccessible, this.context, this.getCurrentScope(), this.getInlineScopeResolver(), withSuper, null, true);
    }

    static /* synthetic */ boolean isAccessible$default(ReflectiveAccessLowering reflectiveAccessLowering2, IrSymbol irSymbol2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return reflectiveAccessLowering2.isAccessible(irSymbol2, bl);
    }

    @NotNull
    public final Map<IrCall, IrClassSymbol> getCallsOnCompanionObjects() {
        return this.callsOnCompanionObjects;
    }

    private final void recordCompanionObjectAsDispatchReceiver(IrCall expression2) {
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrGetField irGetField = irExpression instanceof IrGetField ? (IrGetField)irExpression : null;
        if (irGetField == null) {
            return;
        }
        IrGetField dispatchReceiver = irGetField;
        IrType irType = ((IrField)dispatchReceiver.getSymbol().getOwner()).getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return;
        }
        IrSimpleType dispatchReceiverType = irSimpleType;
        IrClassSymbol klass = IrTypesKt.getClassOrNull(dispatchReceiverType);
        if (klass != null && ((IrClass)klass.getOwner()).isCompanion()) {
            this.callsOnCompanionObjects.put(expression2, klass);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        boolean isAccessToProperty;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.recordCompanionObjectAsDispatchReceiver(expression2);
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrClassSymbol superQualifier = expression2.getSuperQualifierSymbol();
        IrSimpleFunctionSymbol callee = expression2.getSymbol();
        if (this.isAccessible(callee, superQualifier != null)) {
            return expression2;
        }
        boolean bl = isAccessToProperty = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol() != null;
        if (isAccessToProperty && Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getGET_PROPERTY())) {
            irExpression = this.generateReflectiveAccessForGetter(expression2);
            return irExpression;
        }
        if (isAccessToProperty) {
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            boolean bl2 = irStatementOrigin != null ? IrStatementOriginKt.isAssignmentOperator(irStatementOrigin) : false;
            if (bl2) {
                irExpression = this.generateReflectiveAccessForSetter(expression2);
                return irExpression;
            }
        }
        if (expression2.getDispatchReceiver() == null && expression2.getExtensionReceiver() == null) {
            irExpression = this.generateReflectiveStaticCall(expression2);
            return irExpression;
        }
        if (superQualifier != null) {
            irExpression = this.generateInvokeSpecialForCall(expression2, superQualifier);
            return irExpression;
        }
        irExpression = this.generateReflectiveMethodInvocation(expression2);
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFieldSymbol field2 = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, field2, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveFieldGet(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFieldSymbol field2 = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, field2, false, 1, null) ? (IrExpression)expression2 : (((object = ((IrField)field2.getOwner()).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : false) || IrUtilsKt.isFromJava((IrDeclaration)field2.getOwner()) && ((IrField)field2.getOwner()).isFinal() ? this.generateThrowIllegalAccessException(expression2) : this.generateReflectiveFieldSet(expression2));
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrConstructorSymbol callee = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveConstructorInvocation(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrClassSymbol callee = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveAccessForCompanion(expression2);
    }

    private final IrExpression javaClassObject(IrBuilderWithScope $this$javaClassObject, IrType klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$javaClassObject_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall($this$javaClassObject, this.symbols.getKClassJavaPropertyGetter());
        boolean bl = false;
        $this$javaClassObject_u24lambda_u240.setExtensionReceiver(new IrClassReferenceImpl($this$javaClassObject_u24lambda_u240.getStartOffset(), $this$javaClassObject_u24lambda_u240.getEndOffset(), IrTypesKt.getStarProjectedType($this$javaClassObject.getContext().getIrBuiltIns().getKClassClass()), $this$javaClassObject.getContext().getIrBuiltIns().getKClassClass(), klass));
        return irFunctionAccessExpression;
    }

    private final IrExpression getDeclaredField(IrBuilderWithScope $this$getDeclaredField, IrExpression declaringClass, String fieldName) {
        IrCall irCall;
        IrCall $this$getDeclaredField_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall($this$getDeclaredField, this.reflectSymbols.getGetDeclaredField());
        boolean bl = false;
        $this$getDeclaredField_u24lambda_u241.setDispatchReceiver(declaringClass);
        $this$getDeclaredField_u24lambda_u241.putValueArgument(0, ExpressionHelpersKt.irString($this$getDeclaredField, fieldName));
        return irCall;
    }

    private final IrExpression fieldSetAccessible(IrBuilderWithScope $this$fieldSetAccessible, IrExpression field2) {
        IrCall irCall;
        IrCall $this$fieldSetAccessible_u24lambda_u242 = irCall = ExpressionHelpersKt.irCall($this$fieldSetAccessible, this.reflectSymbols.getJavaLangReflectFieldSetAccessible());
        boolean bl = false;
        $this$fieldSetAccessible_u24lambda_u242.setDispatchReceiver(field2);
        $this$fieldSetAccessible_u24lambda_u242.putValueArgument(0, ExpressionHelpersKt.irTrue($this$fieldSetAccessible));
        return irCall;
    }

    private final IrExpression fieldSet(IrBuilderWithScope $this$fieldSet, IrExpression fieldObject, IrExpression receiver, IrExpression value2) {
        IrCall irCall;
        IrCall $this$fieldSet_u24lambda_u243 = irCall = ExpressionHelpersKt.irCall($this$fieldSet, this.reflectSymbols.getJavaLangReflectFieldSet());
        boolean bl = false;
        $this$fieldSet_u24lambda_u243.setDispatchReceiver(fieldObject);
        $this$fieldSet_u24lambda_u243.putValueArgument(0, receiver);
        $this$fieldSet_u24lambda_u243.putValueArgument(1, value2);
        return irCall;
    }

    private final IrExpression fieldGet(IrBuilderWithScope $this$fieldGet, IrExpression fieldObject, IrExpression receiver) {
        IrCall irCall;
        IrCall $this$fieldGet_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall($this$fieldGet, this.reflectSymbols.getJavaLangReflectFieldGet());
        boolean bl = false;
        $this$fieldGet_u24lambda_u244.setDispatchReceiver(fieldObject);
        $this$fieldGet_u24lambda_u244.putValueArgument(0, receiver);
        return irCall;
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(ReflectiveAccessLowering reflectiveAccessLowering2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return reflectiveAccessLowering2.createBuilder(n, n2);
    }

    private final IrExpression irVararg(IrBuilderWithScope $this$irVararg, IrType elementType, List<? extends IrExpression> values2) {
        Object object = new IrType[]{elementType};
        Object $this$irVararg_u24lambda_u245 = object = new IrArrayBuilder(ReflectiveAccessLowering.createBuilder$default(this, 0, 0, 3, null), IrTypesKt.typeWith((IrClassifierSymbol)$this$irVararg.getContext().getIrBuiltIns().getArrayClass(), (IrType[])object));
        boolean bl = false;
        for (IrExpression irExpression : values2) {
            ((IrArrayBuilder)$this$irVararg_u24lambda_u245).unaryPlus(irExpression);
        }
        return ((IrArrayBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredMethod(IrBuilderWithScope $this$getDeclaredMethod, IrExpression declaringClass, String methodName, List<? extends IrType> parameterTypes2) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredMethod_u24lambda_u247 = irCall = ExpressionHelpersKt.irCall($this$getDeclaredMethod, this.reflectSymbols.getGetDeclaredMethod());
        boolean bl = false;
        $this$getDeclaredMethod_u24lambda_u247.setDispatchReceiver(declaringClass);
        $this$getDeclaredMethod_u24lambda_u247.putValueArgument(0, ExpressionHelpersKt.irString($this$getDeclaredMethod, methodName));
        Iterable iterable = parameterTypes2;
        IrType irType = IrTypesKt.getDefaultType(this.symbols.getJavaLangClass());
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredMethod;
        ReflectiveAccessLowering reflectiveAccessLowering2 = this;
        int n = 1;
        IrCall irCall2 = $this$getDeclaredMethod_u24lambda_u247;
        boolean $i$f$map = false;
        void var15_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType irType2 = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.javaClassObject($this$getDeclaredMethod, (IrType)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, reflectiveAccessLowering2.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return irCall;
    }

    private final IrExpression methodSetAccessible(IrBuilderWithScope $this$methodSetAccessible, IrExpression method) {
        IrCall irCall;
        IrCall $this$methodSetAccessible_u24lambda_u248 = irCall = ExpressionHelpersKt.irCall($this$methodSetAccessible, this.reflectSymbols.getJavaLangReflectMethodSetAccessible());
        boolean bl = false;
        $this$methodSetAccessible_u24lambda_u248.setDispatchReceiver(method);
        $this$methodSetAccessible_u24lambda_u248.putValueArgument(0, ExpressionHelpersKt.irTrue($this$methodSetAccessible));
        return irCall;
    }

    private final IrExpression methodInvoke(IrBuilderWithScope $this$methodInvoke, IrExpression method, IrExpression receiver, List<? extends IrExpression> arguments2) {
        IrCall irCall;
        IrCall $this$methodInvoke_u24lambda_u249 = irCall = ExpressionHelpersKt.irCall($this$methodInvoke, this.reflectSymbols.getJavaLangReflectMethodInvoke());
        boolean bl = false;
        $this$methodInvoke_u24lambda_u249.setDispatchReceiver(method);
        $this$methodInvoke_u24lambda_u249.putValueArgument(0, receiver);
        $this$methodInvoke_u24lambda_u249.putValueArgument(1, this.irVararg($this$methodInvoke, $this$methodInvoke.getContext().getIrBuiltIns().getAnyNType(), arguments2));
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredConstructor(IrBuilderWithScope $this$getDeclaredConstructor, IrExpression declaringClass, List<? extends IrType> parameterTypes2) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredConstructor_u24lambda_u2411 = irCall = ExpressionHelpersKt.irCall($this$getDeclaredConstructor, this.reflectSymbols.getGetDeclaredConstructor());
        boolean bl = false;
        $this$getDeclaredConstructor_u24lambda_u2411.setDispatchReceiver(declaringClass);
        Iterable iterable = parameterTypes2;
        IrType irType = IrTypesKt.getDefaultType(this.symbols.getJavaLangClass());
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredConstructor;
        ReflectiveAccessLowering reflectiveAccessLowering2 = this;
        int n = 0;
        IrCall irCall2 = $this$getDeclaredConstructor_u24lambda_u2411;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType irType2 = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.javaClassObject($this$getDeclaredConstructor, (IrType)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, reflectiveAccessLowering2.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return irCall;
    }

    private final IrExpression constructorSetAccessible(IrBuilderWithScope $this$constructorSetAccessible, IrExpression constructor2) {
        IrCall irCall;
        IrCall $this$constructorSetAccessible_u24lambda_u2412 = irCall = ExpressionHelpersKt.irCall($this$constructorSetAccessible, this.reflectSymbols.getJavaLangReflectConstructorSetAccessible());
        boolean bl = false;
        $this$constructorSetAccessible_u24lambda_u2412.setDispatchReceiver(constructor2);
        $this$constructorSetAccessible_u24lambda_u2412.putValueArgument(0, ExpressionHelpersKt.irTrue($this$constructorSetAccessible));
        return irCall;
    }

    private final IrExpression constructorNewInstance(IrBuilderWithScope $this$constructorNewInstance, IrExpression constructor2, List<? extends IrExpression> arguments2) {
        IrCall irCall;
        IrCall $this$constructorNewInstance_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall($this$constructorNewInstance, this.reflectSymbols.getJavaLangReflectConstructorNewInstance());
        boolean bl = false;
        $this$constructorNewInstance_u24lambda_u2413.setDispatchReceiver(constructor2);
        $this$constructorNewInstance_u24lambda_u2413.putValueArgument(0, this.irVararg($this$constructorNewInstance, $this$constructorNewInstance.getContext().getIrBuiltIns().getAnyNType(), arguments2));
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveMethodInvocation(IrType declaringClass, String methodName, List<? extends IrType> parameterTypes2, IrExpression receiver, List<? extends IrExpression> arguments2, IrType returnType2, IrSymbol symbol2) {
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, returnType2, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveMethodInvocation_u24lambda_u2414 = this_$iv$iv;
        boolean bl = false;
        IrVariable methodVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveMethodInvocation_u24lambda_u2414, this.getDeclaredMethod((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, declaringClass), methodName, parameterTypes2), "method", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectMethod()), 12, null);
        $this$generateReflectiveMethodInvocation_u24lambda_u2414.unaryPlus(this.methodSetAccessible((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, methodVar)));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414;
        IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, methodVar);
        IrExpression irExpression2 = receiver;
        if (irExpression2 == null) {
            irExpression2 = ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414);
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2414.unaryPlus(this.methodInvoke(irBuilderWithScope, irExpression, irExpression2, arguments2));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrExpression> getValueArguments(IrFunctionAccessExpression $this$getValueArguments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$getValueArguments.getValueArgumentsCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrExpression irExpression = $this$getValueArguments.getValueArgument((int)it);
            Intrinsics.checkNotNull((Object)irExpression);
            collection.add(irExpression);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrType> valueParameterTypes(IrFunctionAccessExpression $this$valueParameterTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((IrFunctionSymbol)$this$valueParameterTypes.getSymbol()).getOwner().getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    private final IrExpression generateReflectiveMethodInvocation(IrCall call2) {
        List parameterTypes2 = new ArrayList();
        List arguments2 = new ArrayList();
        if (call2.getExtensionReceiver() != null) {
            IrElementBase it;
            IrValueParameter irValueParameter = ((IrSimpleFunction)call2.getSymbol().getOwner()).getExtensionReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl = false;
                parameterTypes2.add(it.getType());
            }
            IrExpression irExpression = call2.getExtensionReceiver();
            if (irExpression != null) {
                it = irExpression;
                boolean bl = false;
                arguments2.add(it);
            }
        } else if (call2.getDispatchReceiver() != null && Intrinsics.areEqual((Object)((IrSimpleFunction)call2.getSymbol().getOwner()).getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
            IrElementBase it;
            IrValueParameter irValueParameter = ((IrSimpleFunction)call2.getSymbol().getOwner()).getDispatchReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl = false;
                parameterTypes2.add(it.getType());
            }
            IrExpression irExpression = call2.getDispatchReceiver();
            if (irExpression != null) {
                it = irExpression;
                boolean bl = false;
                arguments2.add(it);
            }
        }
        parameterTypes2.addAll((Collection)this.valueParameterTypes(call2));
        arguments2.addAll((Collection)this.getValueArguments(call2));
        Object object = call2.getSuperQualifierSymbol();
        if (object == null || (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) == null) {
            object = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)call2.getSymbol().getOwner())));
        }
        String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.generateReflectiveMethodInvocation((IrType)object, string2, parameterTypes2, call2.getDispatchReceiver(), arguments2, call2.getType(), call2.getSymbol());
    }

    private final IrExpression generateReflectiveStaticCall(IrCall call2) {
        boolean bl;
        boolean bl2 = bl = call2.getDispatchReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Assumed-to-be static call with a dispatch receiver";
            throw new AssertionError((Object)string2);
        }
        IrType irType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)call2.getSymbol().getOwner()));
        String string3 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        return this.generateReflectiveMethodInvocation(irType, string3, this.valueParameterTypes(call2), null, this.getValueArguments(call2), call2.getType(), call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveConstructorInvocation(IrConstructorCall call2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, call2.getSymbol(), 0, 0, 6, null);
        IrType resultType$iv = call2.getType();
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveConstructorInvocation_u24lambda_u2422 = this_$iv$iv;
        boolean bl = false;
        IrVariable constructorVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, this.getDeclaredConstructor((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)call2.getSymbol().getOwner()))), this.valueParameterTypes(call2)), "constructor", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectConstructor()), 12, null);
        $this$generateReflectiveConstructorInvocation_u24lambda_u2422.unaryPlus(this.constructorSetAccessible((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, constructorVar)));
        $this$generateReflectiveConstructorInvocation_u24lambda_u2422.unaryPlus(this.constructorNewInstance((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, constructorVar), this.getValueArguments(call2)));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldGet(IrType declaringClass, String fieldName, IrType fieldType, IrExpression instance2, IrSymbol symbol2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, fieldType, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldGet_u24lambda_u2423 = this_$iv$iv;
        boolean bl = false;
        IrVariable classVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2423, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, declaringClass), "klass", false, null, this.symbols.getKClassJavaPropertyGetter().getReturnType(), 12, null);
        IrVariable fieldVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2423, this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, classVar), fieldName), "field", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectField()), 12, null);
        $this$generateReflectiveFieldGet_u24lambda_u2423.unaryPlus(this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, fieldVar)));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423;
        IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, fieldVar);
        IrExpression irExpression2 = instance2;
        if (irExpression2 == null) {
            irExpression2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, classVar);
        }
        $this$generateReflectiveFieldGet_u24lambda_u2423.unaryPlus(this.fieldGet(irBuilderWithScope2, irExpression, irExpression2));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldGet(IrGetField getField) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)getField.getSymbol().getOwner());
        Intrinsics.checkNotNull((Object)irClass);
        IrType irType = IrUtilsKt.getDefaultType(irClass);
        String string2 = ((IrField)getField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.generateReflectiveFieldGet(irType, string2, getField.getType(), getField.getReceiver(), getField.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldSet(IrType declaringClass, String fieldName, IrExpression value2, IrType type2, IrExpression instance2, IrSymbol symbol2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, type2, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldSet_u24lambda_u2424 = this_$iv$iv;
        boolean bl = false;
        IrVariable fieldVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$generateReflectiveFieldSet_u24lambda_u2424, this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, declaringClass), fieldName), "field", false, null, IrTypesKt.getDefaultType(this.reflectSymbols.getJavaLangReflectField()), 12, null);
        $this$generateReflectiveFieldSet_u24lambda_u2424.unaryPlus(this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, fieldVar)));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424;
        IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, fieldVar);
        IrExpression irExpression2 = instance2;
        if (irExpression2 == null) {
            irExpression2 = ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424);
        }
        $this$generateReflectiveFieldSet_u24lambda_u2424.unaryPlus(this.fieldSet(irBuilderWithScope2, irExpression, irExpression2, value2));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldSet(IrSetField setField) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)setField.getSymbol().getOwner());
        Intrinsics.checkNotNull((Object)irClass);
        IrType irType = IrUtilsKt.getDefaultType(irClass);
        String string2 = ((IrField)setField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.generateReflectiveFieldSet(irType, string2, setField.getValue(), setField.getType(), setField.getReceiver(), setField.getSymbol());
    }

    private final boolean shouldUseAccessor(IrSimpleFunction accessor) {
        JvmGeneratorExtensions jvmGeneratorExtensions = this.context.getGeneratorExtensions();
        Intrinsics.checkNotNull((Object)jvmGeneratorExtensions, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.StubGeneratorExtensions");
        return ((StubGeneratorExtensions)((Object)jvmGeneratorExtensions)).isAccessorWithExplicitImplementation(accessor);
    }

    private final Pair<IrType, IrExpression> fieldLocationAndReceiver(IrCall call2) {
        IrClassSymbol irClassSymbol = this.callsOnCompanionObjects.get(call2);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            IrClass parentAsClass = IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner());
            if (!JvmIrUtilsKt.isJvmInterface(parentAsClass)) {
                return TuplesKt.to((Object)IrUtilsKt.getDefaultType(parentAsClass), null);
            }
        }
        IrExpression irExpression = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        IrType irType = irExpression.getType();
        IrExpression irExpression2 = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression2);
        return TuplesKt.to((Object)irType, (Object)irExpression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForGetter(IrCall call2) {
        IrProperty property;
        IrSimpleFunction getter2;
        block2: {
            Object object;
            String string2;
            IrType irType;
            ReflectiveAccessLowering reflectiveAccessLowering2;
            block4: {
                block3: {
                    void it;
                    getter2 = (IrSimpleFunction)call2.getSymbol().getOwner();
                    IrPropertySymbol irPropertySymbol = getter2.getCorrespondingPropertySymbol();
                    Intrinsics.checkNotNull((Object)irPropertySymbol);
                    property = (IrProperty)irPropertySymbol.getOwner();
                    if (!this.shouldUseAccessor(getter2)) break block2;
                    reflectiveAccessLowering2 = this;
                    irType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(getter2));
                    String string3 = property.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                    string2 = JvmAbi.getterName(string3);
                    object = getter2.getExtensionReceiverParameter();
                    if (object == null) break block3;
                    IrValueParameter irValueParameter = object;
                    String string4 = string2;
                    IrType irType2 = irType;
                    ReflectiveAccessLowering reflectiveAccessLowering3 = reflectiveAccessLowering2;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)it.getType());
                    reflectiveAccessLowering2 = reflectiveAccessLowering3;
                    irType = irType2;
                    string2 = string4;
                    List list3 = list2;
                    object = list3;
                    if (list3 != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            return reflectiveAccessLowering2.generateReflectiveMethodInvocation(irType, string2, (List<? extends IrType>)object, call2.getDispatchReceiver(), CollectionsKt.listOfNotNull((Object)call2.getExtensionReceiver()), getter2.getReturnType(), call2.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call2);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression instance2 = (IrExpression)pair.component2();
        String string5 = property.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"asString(...)");
        return this.generateReflectiveFieldGet(fieldLocation, string5, getter2.getReturnType(), instance2, call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForSetter(IrCall call2) {
        IrSimpleFunction setter2 = (IrSimpleFunction)call2.getSymbol().getOwner();
        IrPropertySymbol irPropertySymbol = setter2.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrProperty property = (IrProperty)irPropertySymbol.getOwner();
        if (this.shouldUseAccessor(setter2)) {
            void $this$generateReflectiveAccessForSetter_u24lambda_u2430;
            List $this$generateReflectiveAccessForSetter_u24lambda_u2428;
            IrElementBase it;
            List list2;
            IrType irType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(setter2));
            String string2 = property.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            List list3 = list2 = (List)new ArrayList();
            String string3 = JvmAbi.setterName(string2);
            IrType irType2 = irType;
            ReflectiveAccessLowering reflectiveAccessLowering2 = this;
            boolean bl = false;
            IrValueParameter irValueParameter = setter2.getExtensionReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl2 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2428.add(it.getType());
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2428.addAll((Collection)this.valueParameterTypes(call2));
            Object object = Unit.INSTANCE;
            List list4 = list2;
            $this$generateReflectiveAccessForSetter_u24lambda_u2428 = list2 = (List)new ArrayList();
            IrExpression irExpression = call2.getDispatchReceiver();
            object = list4;
            boolean bl3 = false;
            IrExpression irExpression2 = call2.getExtensionReceiver();
            if (irExpression2 != null) {
                it = irExpression2;
                boolean bl4 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2430.add(it);
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2430.addAll((Collection)this.getValueArguments(call2));
            Unit unit2 = Unit.INSTANCE;
            return reflectiveAccessLowering2.generateReflectiveMethodInvocation(irType2, string3, (List<? extends IrType>)object, irExpression, list2, setter2.getReturnType(), call2.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call2);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression receiver = (IrExpression)pair.component2();
        String string4 = property.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
        IrExpression irExpression = call2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        return this.generateReflectiveFieldSet(fieldLocation, string4, irExpression, call2.getType(), receiver, call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateThrowIllegalAccessException(IrSetField setField) {
        void $this$generateThrowIllegalAccessException_u24lambda_u2432_u24lambda_u2431;
        IrCall irCall;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, setField.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateThrowIllegalAccessException_u24lambda_u2432 = this_$iv$iv;
        boolean bl = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2432, this.symbols.getThrowIllegalAccessException());
        void var14_14 = $this$generateThrowIllegalAccessException_u24lambda_u2432;
        boolean bl2 = false;
        $this$generateThrowIllegalAccessException_u24lambda_u2432_u24lambda_u2431.putValueArgument(0, ExpressionHelpersKt.irString((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2432, "Can not set final field"));
        var14_14.unaryPlus(irCall);
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateInvokeSpecialForCall(IrCall expression2, IrClassSymbol superQualifier) {
        void $this$irArray$iv;
        IrArrayBuilder irArrayBuilder;
        IrCall irCall;
        JvmMethodSignature jvmSignature = this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric((IrFunction)expression2.getSymbol().getOwner());
        IrClass owner = (IrClass)superQualifier.getOwner();
        JvmIrBuilder builder2 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, expression2.getSymbol(), 0, 0, 6, null);
        IrCall $this$generateInvokeSpecialForCall_u24lambda_u2435 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder2, this.symbols.getJvmDebuggerInvokeSpecialIntrinsic());
        boolean bl = false;
        $this$generateInvokeSpecialForCall_u24lambda_u2435.setDispatchReceiver(expression2.getDispatchReceiver());
        $this$generateInvokeSpecialForCall_u24lambda_u2435.setType(((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType());
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(0, ExpressionHelpersKt.irString(builder2, "" + AdditionalIrUtilsKt.getPackageFqName(owner) + '/' + owner.getName()));
        IrBuilderWithScope irBuilderWithScope = builder2;
        String string2 = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(1, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        IrBuilderWithScope irBuilderWithScope2 = builder2;
        String string3 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDescriptor(...)");
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(2, ExpressionHelpersKt.irString(irBuilderWithScope2, string3));
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(3, ExpressionHelpersKt.irFalse(builder2));
        IrBuiltIns $this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434 = this.context.getIrBuiltIns();
        boolean bl2 = false;
        JvmIrBuilder jvmIrBuilder = builder2;
        IrType[] irTypeArray = new IrType[]{$this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434.getAnyNType()};
        IrType arrayType$iv = IrTypesKt.typeWith((IrClassifierSymbol)$this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434.getArrayClass(), irTypeArray);
        boolean $i$f$irArray = false;
        IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
        boolean bl3 = false;
        IrArrayBuilder $this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433 = $this$irArray_u24lambda_u240$iv;
        boolean bl4 = false;
        int n = expression2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression irExpression = expression2.getValueArgument(i);
            Intrinsics.checkNotNull((Object)irExpression);
            $this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433.add(irExpression);
        }
        IrExpression args = irArrayBuilder.build();
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(4, args);
        return irCall;
    }

    private final IrExpression generateReflectiveAccessForCompanion(IrGetObjectValue call2) {
        return this.generateReflectiveFieldGet(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)call2.getSymbol().getOwner())), "Companion", call2.getType(), null, call2.getSymbol());
    }
}

