/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016J\f\u0010\"\u001a\u00020 *\u00020\bH\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\fJ\u001d\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u0002\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020 H\u0082\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001f\u001a\u00020 *\u00020\u00188\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "inlineCallSites", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver$CallSite;", "inlineFunctionCallSites", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitInlineLambda", "", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "scope", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "data", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "isPrivateInline", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isCoroutineIntrinsic", "findContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "approximateToPackage", "CallSite", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nIrInlineReferenceLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n76#1:169\n76#1:170\n76#1:178\n372#2,7:171\n372#2,7:179\n1547#3:186\n1618#3,3:187\n1724#3,3:191\n1#4:190\n*S KotlinDebug\n*F\n+ 1 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver\n*L\n50#1:169\n58#1:170\n67#1:178\n59#1:171,7\n68#1:179,7\n125#1:186\n125#1:187,3\n128#1:191,3\n*E\n"})
public final class IrInlineScopeResolver
extends IrInlineReferenceLocator {
    @NotNull
    private final Map<IrFunction, CallSite> inlineCallSites;
    @NotNull
    private final Map<IrFunction, Set<IrElement>> inlineFunctionCallSites;

    public IrInlineScopeResolver(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.inlineCallSites = new LinkedHashMap();
        this.inlineFunctionCallSites = new LinkedHashMap();
    }

    @Override
    public void visitInlineLambda(@NotNull IrFunctionReference argument2, @NotNull IrFunction callee, @NotNull IrValueParameter parameter2, @NotNull IrDeclaration scope2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.inlineCallSites.put(((IrFunctionSymbol)argument2.getSymbol()).getOwner(), new CallSite(scope2, parameter2.isCrossinline() && !this.isCoroutineIntrinsic(callee)));
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrDeclaration data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrInlineScopeResolver irInlineScopeResolver = this;
        IrSimpleFunction $this$isPrivateInline$iv = declaration;
        boolean $i$f$isPrivateInline = false;
        if ($this$isPrivateInline$iv.isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility())) {
            this.inlineFunctionCallSites.putIfAbsent(declaration, new LinkedHashSet());
        }
        super.visitSimpleFunction(declaration, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrInlineScopeResolver irInlineScopeResolver = this;
        IrSimpleFunction $this$isPrivateInline$iv = callee;
        boolean $i$f$isPrivateInline = false;
        if ($this$isPrivateInline$iv.isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility()) && data2 != null) {
            Set set;
            Map<IrFunction, Set<IrElement>> $this$getOrPut$iv = this.inlineFunctionCallSites;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(callee);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(callee, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            TypeIntrinsics.asMutableSet(set).add(data2);
        }
        super.visitCall(expression2, data2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclaration data2) {
        IrDeclaration callee;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2 instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)expression2) && (callee = IrInlineUtilsKt.getInlineDeclaration((IrInlinedFunctionBlock)expression2)) instanceof IrSimpleFunction) {
            IrInlineScopeResolver irInlineScopeResolver = this;
            Object $this$isPrivateInline$iv = (IrSimpleFunction)callee;
            boolean $i$f$isPrivateInline = false;
            if (((IrFunction)$this$isPrivateInline$iv).isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility()) && data2 != null) {
                Object object;
                void $this$getOrPut$iv;
                $this$isPrivateInline$iv = this.inlineFunctionCallSites;
                IrDeclaration key$iv = callee;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TypeIntrinsics.asMutableSet(object).add(data2);
            }
        }
        super.visitBlock(expression2, data2);
    }

    private final boolean isCoroutineIntrinsic(IrFunction $this$isCoroutineIntrinsic) {
        return Intrinsics.areEqual((Object)$this$isCoroutineIntrinsic.getName().asString(), (Object)"suspendCoroutine") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment($this$isCoroutineIntrinsic).getPackageFqName(), (Object)new FqName("kotlin.coroutines")) || Intrinsics.areEqual((Object)$this$isCoroutineIntrinsic.getName().asString(), (Object)"suspendCoroutineUninterceptedOrReturn") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment($this$isCoroutineIntrinsic).getPackageFqName(), (Object)new FqName("kotlin.coroutines.intrinsics"));
    }

    @Nullable
    public final IrDeclarationContainer findContainer(@NotNull IrElement scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return this.findContainer(scope2, false);
    }

    /*
     * WARNING - void declaration
     */
    private final IrDeclarationContainer findContainer(IrElement context2, boolean approximateToPackage) {
        IrDeclarationContainer irDeclarationContainer;
        block15: {
            Object object;
            Object object2 = this;
            IrElement irElement = context2;
            boolean bl = approximateToPackage;
            while (true) {
                boolean bl2;
                IrElement irElement2;
                CallSite callSite = ((IrInlineScopeResolver)object2).inlineCallSites.get(irElement);
                if (callSite != null) {
                    object = object2;
                    irElement2 = callSite.getParent();
                    bl2 = bl || callSite.getApproximateToPackage();
                    object2 = object;
                    irElement = irElement2;
                    bl = bl2;
                    continue;
                }
                if (irElement instanceof IrFunction && ((IrFunction)irElement).isInline()) {
                    CallSite callSite2;
                    Set<IrElement> callSites;
                    if (((IrInlineScopeResolver)object2).inlineFunctionCallSites.get(irElement) == null) {
                        return null;
                    }
                    ((IrInlineScopeResolver)object2).inlineCallSites.put((IrFunction)irElement, new CallSite(null, false));
                    if (callSites.isEmpty()) {
                        callSite2 = new CallSite(((IrFunction)irElement).getParent(), false);
                    } else if (callSites.size() == 1) {
                        callSite2 = new CallSite((IrElement)CollectionsKt.single((Iterable)callSites), false);
                    } else {
                        IrDeclarationContainer single2;
                        boolean bl3;
                        Object object3;
                        block14: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = callSites;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                IrElement irElement3 = (IrElement)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl4 = false;
                                IrDeclarationContainer irDeclarationContainer2 = ((IrInlineScopeResolver)object2).findContainer((IrElement)it, false);
                                if (irDeclarationContainer2 == null) {
                                    return null;
                                }
                                collection.add(irDeclarationContainer2);
                            }
                            List results = (List)destination$iv$iv;
                            object3 = CollectionsKt.first((List)results);
                            IrDeclarationContainer it = (IrDeclarationContainer)object3;
                            boolean bl5 = false;
                            Iterable $this$all$iv = results;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl3 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    IrDeclarationContainer other = (IrDeclarationContainer)element$iv;
                                    boolean bl6 = false;
                                    if (it == other) continue;
                                    bl3 = false;
                                    break block14;
                                }
                                bl3 = true;
                            }
                        }
                        IrDeclarationContainer irDeclarationContainer3 = single2 = (IrDeclarationContainer)(bl3 ? object3 : null);
                        callSite2 = new CallSite(irDeclarationContainer3 != null ? (IrDeclarationParent)irDeclarationContainer3 : ((IrFunction)irElement).getParent(), single2 == null);
                    }
                    CallSite commonCallSite = callSite2;
                    ((IrInlineScopeResolver)object2).inlineCallSites.put((IrFunction)irElement, commonCallSite);
                    IrInlineScopeResolver irInlineScopeResolver = (IrInlineScopeResolver)object2;
                    IrElement irElement4 = commonCallSite.getParent();
                    boolean bl7 = bl || commonCallSite.getApproximateToPackage();
                    object2 = irInlineScopeResolver;
                    irElement = irElement4;
                    bl = bl7;
                    continue;
                }
                if (irElement instanceof IrClass && !bl) {
                    irDeclarationContainer = (IrDeclarationContainer)irElement;
                    break block15;
                }
                if (!(irElement instanceof IrDeclaration)) break;
                object = object2;
                irElement2 = ((IrDeclaration)irElement).getParent();
                bl2 = bl;
                object2 = object;
                irElement = irElement2;
                bl = bl2;
            }
            object = irElement;
            irDeclarationContainer = object instanceof IrPackageFragment ? (IrPackageFragment)object : null;
        }
        return irDeclarationContainer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver$CallSite;", "", "parent", "Lorg/jetbrains/kotlin/ir/IrElement;", "approximateToPackage", "", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Z)V", "getParent", "()Lorg/jetbrains/kotlin/ir/IrElement;", "getApproximateToPackage", "()Z", "backend.jvm"})
    private static final class CallSite {
        @Nullable
        private final IrElement parent;
        private final boolean approximateToPackage;

        public CallSite(@Nullable IrElement parent2, boolean approximateToPackage) {
            this.parent = parent2;
            this.approximateToPackage = approximateToPackage;
        }

        @Nullable
        public final IrElement getParent() {
            return this.parent;
        }

        public final boolean getApproximateToPackage() {
            return this.approximateToPackage;
        }
    }
}

