/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "classFinder", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "jvmMetadataVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "<init>", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;Lcom/intellij/openapi/diagnostic/Logger;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;)V", "getClassFinder", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "findClassData", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "decompiler-to-file-stubs"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;
    @NotNull
    private final JvmMetadataVersion jvmMetadataVersion;

    public DirectoryBasedDataFinder(@NotNull DirectoryBasedClassFinder classFinder, @NotNull Logger log2, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classFinder, (String)"classFinder");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        this.classFinder = classFinder;
        this.log = log2;
        this.jvmMetadataVersion = jvmMetadataVersion;
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.classFinder, classId, this.jvmMetadataVersion);
        if (kotlinJvmBinaryClass2 == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass2;
        KotlinClassHeader classHeader = binaryClass.getClassHeader();
        String[] data2 = classHeader.getData();
        if (data2 == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        String[] strings2 = classHeader.getStrings();
        if (strings2 == null) {
            this.log.error("String table not found in class " + binaryClass.getClassId());
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(data2, strings2);
        JvmNameResolver nameResolver2 = (JvmNameResolver)pair.component1();
        ProtoBuf.Class classProto = (ProtoBuf.Class)pair.component2();
        return new ClassData(nameResolver2, classProto, classHeader.getMetadataVersion(), new KotlinJvmBinarySourceElement(binaryClass, null, false, null, 14, null));
    }
}

