/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Comment;
import com.google.gwt.dev.js.rhino.TokenStream;

public class Node
implements Cloneable {
    int type;
    Node next;
    private Node first;
    private Node last;
    private CodePosition position;
    private Comment commentBefore;
    private Comment commentAfter;
    private int operation;

    public Node(int nodeType) {
        this.type = nodeType;
    }

    public Node(int nodeType, Node child, CodePosition position) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
        this.position = position;
    }

    public Node(int nodeType, Node child, int operation, CodePosition position) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
        this.operation = operation;
        this.position = position;
    }

    public Node(int nodeType, Node left, Node right, CodePosition position) {
        this(nodeType, left, right, -1, position);
    }

    public Node(int nodeType, Node left, Node right, int operation, CodePosition position) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = right;
        right.next = null;
        this.operation = operation;
        this.position = position;
    }

    public Node(int nodeType, Node left, Node mid, Node right, CodePosition position) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = right;
        right.next = null;
        this.position = position;
    }

    public Node(int nodeType, Node left, Node mid, Node mid2, Node right, CodePosition position) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = mid2;
        mid2.next = right;
        right.next = null;
        this.position = position;
    }

    public Node(int nodeType, CodePosition position) {
        this.type = nodeType;
        this.position = position;
    }

    public Node(int nodeType, int operation, CodePosition position) {
        this.type = nodeType;
        this.operation = operation;
        this.position = position;
    }

    public static Node newIntNumber(double number, CodePosition position) {
        return new NumberNode(148, number, position);
    }

    public static Node newNumber(double number, CodePosition position) {
        return new NumberNode(45, number, position);
    }

    public static Node newString(String str, CodePosition position) {
        return new StringNode(46, str, position);
    }

    public static Node newString(int type2, String str, CodePosition position) {
        return new StringNode(type2, str, position);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getLastSibling() {
        Node n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public void addChildToBack(Node child) {
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToBack(Node children2) {
        if (this.last != null) {
            this.last.next = children2;
        }
        this.last = children2.getLastSibling();
        if (this.first == null) {
            this.first = children2;
        }
    }

    public Comment getCommentsBeforeNode() {
        return this.commentBefore;
    }

    public Comment getCommentsAfterNode() {
        return this.commentAfter;
    }

    public void setCommentsBeforeNode(Comment comment) {
        if (comment == null) {
            return;
        }
        this.commentBefore = comment;
    }

    public void setCommentsAfterNode(Comment comment) {
        if (comment == null) {
            return;
        }
        this.commentAfter = comment;
    }

    public int getOperation() {
        return this.operation;
    }

    public CodePosition getPosition() {
        return this.position;
    }

    public void setPosition(CodePosition position) {
        this.position = position;
    }

    public double getDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public String getString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(TokenStream.tokenToName(this.type));
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else {
            switch (this.type) {
                case 137: {
                    sb.append(' ');
                    sb.append(this.hashCode());
                    break;
                }
                case 148: {
                    sb.append(' ');
                    sb.append((int)this.getDouble());
                    break;
                }
                case 45: {
                    sb.append(' ');
                    sb.append(this.getDouble());
                    break;
                }
                case 110: {
                    sb.append(' ');
                    sb.append(this.first.getString());
                }
            }
        }
        if (this.operation != -1) {
            sb.append(' ');
            sb.append(this.operation);
        }
        return sb.toString();
    }

    private static class StringNode
    extends Node {
        private String str;

        StringNode(int type2, String str, CodePosition position) {
            super(type2, position);
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        @Override
        public String getString() {
            return this.str;
        }
    }

    private static class NumberNode
    extends Node {
        private double number;

        NumberNode(int type2, double number, CodePosition position) {
            super(type2, position);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }
    }
}

