/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Joiner {
    private final String separator;

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    public static Joiner on(char separator) {
        return new Joiner(String.valueOf(separator));
    }

    private Joiner(String separator) {
        this.separator = Preconditions.checkNotNull(separator);
    }

    private Joiner(Joiner prototype) {
        this.separator = prototype.separator;
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A appendable, Iterable<? extends @Nullable Object> parts2) throws IOException {
        return this.appendTo(appendable, parts2.iterator());
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A appendable, Iterator<? extends @Nullable Object> parts2) throws IOException {
        Preconditions.checkNotNull(appendable);
        if (parts2.hasNext()) {
            appendable.append(this.toString(parts2.next()));
            while (parts2.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts2.next()));
            }
        }
        return appendable;
    }

    @CanIgnoreReturnValue
    public final <A extends Appendable> A appendTo(A appendable, @Nullable Object[] parts2) throws IOException {
        return this.appendTo(appendable, Arrays.asList(parts2));
    }

    @CanIgnoreReturnValue
    public final <A extends Appendable> A appendTo(A appendable, Object first, Object second, Object ... rest) throws IOException {
        return this.appendTo(appendable, Joiner.iterable(first, second, rest));
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder2, Iterable<? extends @Nullable Object> parts2) {
        return this.appendTo(builder2, parts2.iterator());
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder2, Iterator<? extends @Nullable Object> parts2) {
        try {
            this.appendTo((Appendable)builder2, parts2);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder2;
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder2, @Nullable Object[] parts2) {
        return this.appendTo(builder2, (Iterable<? extends Object>)Arrays.asList(parts2));
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder2, Object first, Object second, Object ... rest) {
        return this.appendTo(builder2, Joiner.iterable(first, second, rest));
    }

    public final String join(Iterable<? extends @Nullable Object> parts2) {
        return this.join(parts2.iterator());
    }

    public final String join(Iterator<? extends @Nullable Object> parts2) {
        return this.appendTo(new StringBuilder(), parts2).toString();
    }

    public final String join(@Nullable Object[] parts2) {
        return this.join(Arrays.asList(parts2));
    }

    public final String join(Object first, Object second, Object ... rest) {
        return this.join(Joiner.iterable(first, second, rest));
    }

    public Joiner useForNull(final String nullText) {
        Preconditions.checkNotNull(nullText);
        return new Joiner(this){

            @Override
            CharSequence toString(Object part2) {
                return part2 == null ? nullText : Joiner.this.toString(part2);
            }

            @Override
            public Joiner useForNull(String nullText2) {
                throw new UnsupportedOperationException("already specified useForNull");
            }

            @Override
            public Joiner skipNulls() {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    public Joiner skipNulls() {
        return new Joiner(this){

            @Override
            public <A extends Appendable> A appendTo(A appendable, Iterator<? extends @Nullable Object> parts2) throws IOException {
                Object part2;
                Preconditions.checkNotNull(appendable, "appendable");
                Preconditions.checkNotNull(parts2, "parts");
                while (parts2.hasNext()) {
                    part2 = parts2.next();
                    if (part2 == null) continue;
                    appendable.append(Joiner.this.toString(part2));
                    break;
                }
                while (parts2.hasNext()) {
                    part2 = parts2.next();
                    if (part2 == null) continue;
                    appendable.append(Joiner.this.separator);
                    appendable.append(Joiner.this.toString(part2));
                }
                return appendable;
            }

            @Override
            public Joiner useForNull(String nullText) {
                throw new UnsupportedOperationException("already specified skipNulls");
            }

            @Override
            public MapJoiner withKeyValueSeparator(String kvs) {
                throw new UnsupportedOperationException("can't use .skipNulls() with maps");
            }
        };
    }

    public MapJoiner withKeyValueSeparator(char keyValueSeparator) {
        return this.withKeyValueSeparator(String.valueOf(keyValueSeparator));
    }

    public MapJoiner withKeyValueSeparator(String keyValueSeparator) {
        return new MapJoiner(this, keyValueSeparator);
    }

    CharSequence toString(Object part2) {
        Objects.requireNonNull(part2);
        return part2 instanceof CharSequence ? (CharSequence)part2 : part2.toString();
    }

    private static Iterable<@Nullable Object> iterable(final Object first, final Object second, final @Nullable Object[] rest) {
        Preconditions.checkNotNull(rest);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return rest.length + 2;
            }

            @Override
            public Object get(int index2) {
                switch (index2) {
                    case 0: {
                        return first;
                    }
                    case 1: {
                        return second;
                    }
                }
                return rest[index2 - 2];
            }
        };
    }

    public static final class MapJoiner {
        private final Joiner joiner;
        private final String keyValueSeparator;

        private MapJoiner(Joiner joiner, String keyValueSeparator) {
            this.joiner = joiner;
            this.keyValueSeparator = Preconditions.checkNotNull(keyValueSeparator);
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A appendable, Map<?, ?> map) throws IOException {
            return this.appendTo(appendable, map.entrySet());
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder builder2, Map<?, ?> map) {
            return this.appendTo(builder2, (Iterable<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A appendable, Iterable<? extends Map.Entry<?, ?>> entries) throws IOException {
            return this.appendTo(appendable, entries.iterator());
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A appendable, Iterator<? extends Map.Entry<?, ?>> parts2) throws IOException {
            Preconditions.checkNotNull(appendable);
            if (parts2.hasNext()) {
                Map.Entry<?, ?> entry = parts2.next();
                appendable.append(this.joiner.toString(entry.getKey()));
                appendable.append(this.keyValueSeparator);
                appendable.append(this.joiner.toString(entry.getValue()));
                while (parts2.hasNext()) {
                    appendable.append(this.joiner.separator);
                    Map.Entry<?, ?> e = parts2.next();
                    appendable.append(this.joiner.toString(e.getKey()));
                    appendable.append(this.keyValueSeparator);
                    appendable.append(this.joiner.toString(e.getValue()));
                }
            }
            return appendable;
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder builder2, Iterable<? extends Map.Entry<?, ?>> entries) {
            return this.appendTo(builder2, entries.iterator());
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder builder2, Iterator<? extends Map.Entry<?, ?>> entries) {
            try {
                this.appendTo((Appendable)builder2, entries);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
            return builder2;
        }

        public String join(Map<?, ?> map) {
            return this.join(map.entrySet());
        }

        public String join(Iterable<? extends Map.Entry<?, ?>> entries) {
            return this.join(entries.iterator());
        }

        public String join(Iterator<? extends Map.Entry<?, ?>> entries) {
            return this.appendTo(new StringBuilder(), entries).toString();
        }

        public MapJoiner useForNull(String nullText) {
            return new MapJoiner(this.joiner.useForNull(nullText), this.keyValueSeparator);
        }
    }
}

