/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface EventWatcher {
    @NotNull
    public static final InstanceHolder ourInstance = new InstanceHolder();

    public static boolean isEnabled() {
        return ourInstance.myIsEnabled;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application application;
        if (!EventWatcher.isEnabled()) {
            return null;
        }
        EventWatcher result2 = ourInstance.myInstance;
        if (result2 == null && (application = ApplicationManager.getApplication()) != null && !application.isDisposed() && LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred()) {
            result2 = application.getService(EventWatcher.class);
            ourInstance.myInstance = result2;
        }
        return result2;
    }

    public void runnableStarted(@NotNull Runnable var1, long var2);

    public void runnableFinished(@NotNull Runnable var1, long var2);

    public static final class InstanceHolder {
        @Nullable
        private EventWatcher myInstance = null;
        private final boolean myIsEnabled = Boolean.getBoolean("idea.event.queue.dispatch.listen");

        private InstanceHolder() {
        }
    }
}

