/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/translate/general/ModuleWrapperTranslation;", "", "()V", "addModuleValidation", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "currentModuleId", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "makePlainInvocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleId", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "importedModules", "", "makePlainModuleRef", "wrapAmd", "wrapCommonJs", "wrapIfNecessary", "kind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "wrapPlain", "wrapUmd", "js.translator"})
@SourceDebugExtension(value={"SMAP\nModuleWrapperTranslation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleWrapperTranslation.kt\norg/jetbrains/kotlin/js/translate/general/ModuleWrapperTranslation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1549#2:174\n1620#2,3:175\n1549#2:178\n1620#2,3:179\n1549#2:182\n1620#2,3:183\n*S KotlinDebug\n*F\n+ 1 ModuleWrapperTranslation.kt\norg/jetbrains/kotlin/js/translate/general/ModuleWrapperTranslation\n*L\n87#1:174\n87#1:175,3\n104#1:178\n104#1:179,3\n150#1:182\n150#1:183,3\n*E\n"})
public final class ModuleWrapperTranslation {
    @NotNull
    public static final ModuleWrapperTranslation INSTANCE = new ModuleWrapperTranslation();

    private ModuleWrapperTranslation() {
    }

    @JvmStatic
    @NotNull
    public static final List<JsStatement> wrapIfNecessary(@NotNull String moduleId, @NotNull JsExpression function2, @NotNull List<JsImportedModule> importedModules, @NotNull JsProgram program, @NotNull ModuleKind kind) {
        List<JsStatement> list2;
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(importedModules, (String)"importedModules");
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                list2 = INSTANCE.wrapAmd(function2, importedModules, program);
                break;
            }
            case 2: {
                list2 = INSTANCE.wrapCommonJs(function2, importedModules, program);
                break;
            }
            case 3: {
                list2 = INSTANCE.wrapUmd(moduleId, function2, importedModules, program);
                break;
            }
            case 4: {
                list2 = INSTANCE.wrapPlain(moduleId, function2, importedModules, program);
                break;
            }
            case 5: {
                throw new IllegalStateException("ES modules are not supported in legacy wrapper".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<JsStatement> wrapUmd(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsExpression[] jsExpressionArray;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("define");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        JsName jsName2 = scope2.declareName("exports");
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"scope.declareName(\"exports\")");
        JsName exportsName = jsName2;
        JsBlock adapterBody = new JsBlock();
        JsFunction adapter = new JsFunction((JsScope)program.getScope(), adapterBody, "Adapter");
        JsName jsName3 = adapter.getScope().declareName("root");
        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"adapter.scope.declareName(\"root\")");
        JsName rootName = jsName3;
        JsName jsName4 = adapter.getScope().declareName("factory");
        Intrinsics.checkNotNullExpressionValue((Object)jsName4, (String)"adapter.scope.declareName(\"factory\")");
        JsName factoryName = jsName4;
        List<JsParameter> list2 = adapter.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"adapter.parameters");
        Collection collection = list2;
        collection.add(new JsParameter(rootName));
        List<JsParameter> list3 = adapter.getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"adapter.parameters");
        collection = list3;
        collection.add(new JsParameter(factoryName));
        JsBinaryOperation jsBinaryOperation = JsAstUtils.and(JsAstUtils.typeOfIs(defineName.makeRef(), new JsStringLiteral("function")), new JsNameRef("amd", (JsExpression)defineName.makeRef()));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"and(JsAstUtils.typeOfIs(\u2026\", defineName.makeRef()))");
        JsBinaryOperation amdTest = jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.typeOfIs(exportsName.makeRef(), new JsStringLiteral("object"));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation2, (String)"typeOfIs(exportsName.mak\u2026sStringLiteral(\"object\"))");
        JsBinaryOperation commonJsTest = jsBinaryOperation2;
        JsNameRef jsNameRef = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"factoryName.makeRef()");
        JsBlock amdBody = new JsBlock(this.wrapAmd(jsNameRef, importedModules, program));
        JsNameRef jsNameRef2 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"factoryName.makeRef()");
        JsBlock commonJsBody = new JsBlock(this.wrapCommonJs(jsNameRef2, importedModules, program));
        JsNameRef jsNameRef3 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef3, (String)"factoryName.makeRef()");
        JsInvocation plainInvocation = this.makePlainInvocation(moduleId, jsNameRef3, importedModules, program);
        JsExpression lhs = Namer.requiresEscaping(moduleId) ? (JsExpression)new JsArrayAccess(rootName.makeRef(), new JsStringLiteral(moduleId)) : (JsExpression)new JsNameRef(scope2.declareName(moduleId), (JsExpression)rootName.makeRef());
        JsBlock plainBlock = new JsBlock();
        for (JsImportedModule importedModule : importedModules) {
            List<JsStatement> list4 = plainBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"plainBlock.statements");
            jsExpressionArray = (JsExpression[])list4;
            jsExpressionArray.add(this.addModuleValidation(moduleId, program, importedModule));
        }
        List<JsStatement> list5 = plainBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"plainBlock.statements");
        Collection collection2 = list5;
        collection2.add(JsAstUtils.assignment(lhs, plainInvocation).makeStmt());
        JsIf jsIf = JsAstUtils.newJsIf(amdTest, amdBody, JsAstUtils.newJsIf(commonJsTest, commonJsBody, plainBlock));
        Intrinsics.checkNotNullExpressionValue((Object)jsIf, (String)"newJsIf(amdTest, amdBody\u2026ommonJsBody, plainBlock))");
        JsIf selector = jsIf;
        List<JsStatement> list6 = adapterBody.getStatements();
        Intrinsics.checkNotNullExpressionValue(list6, (String)"adapterBody.statements");
        ((Collection)list6).add(selector);
        jsExpressionArray = new JsExpression[]{new JsThisRef(), function2};
        JsStatement jsStatement = new JsInvocation((JsExpression)adapter, jsExpressionArray).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"JsInvocation(adapter, Js\u2026f(), function).makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapAmd(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        Collection<JsStringLiteral> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("define");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        Object[] objectArray = new JsExpression[2];
        Iterable iterable = importedModules;
        Collection collection2 = CollectionsKt.listOf((Object)new JsStringLiteral("exports"));
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JsStringLiteral(it.getExternalName()));
        }
        collection = (List)destination$iv$iv;
        List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        objectArray2[n] = new JsArrayLiteral(list2);
        objectArray[1] = function2;
        List invocationArgs = CollectionsKt.listOf((Object[])objectArray);
        JsInvocation invocation = new JsInvocation((JsExpression)defineName.makeRef(), invocationArgs);
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"invocation.makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapCommonJs(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("module");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"scope.declareName(\"module\")");
        JsName moduleName = jsName;
        JsName jsName2 = scope2.declareName("require");
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"scope.declareName(\"require\")");
        JsName requireName = jsName2;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsStringLiteral(it.getExternalName())};
            collection.add(new JsInvocation((JsExpression)requireName.makeRef(), jsExpressionArray));
        }
        List invocationArgs = (List)destination$iv$iv;
        JsInvocation invocation = new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new JsNameRef("exports", (JsExpression)moduleName.makeRef())), (Iterable)invocationArgs));
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"invocation.makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    private final List<JsStatement> wrapPlain(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsInvocation invocation = this.makePlainInvocation(moduleId, function2, importedModules, program);
        List statements2 = new ArrayList();
        for (JsImportedModule importedModule : importedModules) {
            ((Collection)statements2).add(this.addModuleValidation(moduleId, program, importedModule));
        }
        ((Collection)statements2).add(Namer.requiresEscaping(moduleId) ? JsAstUtils.assignment(this.makePlainModuleRef(moduleId, program), invocation).makeStmt() : (JsStatement)JsAstUtils.newVar(program.getRootScope().declareName(moduleId), invocation));
        return statements2;
    }

    private final JsStatement addModuleValidation(String currentModuleId, JsProgram program, JsImportedModule module2) {
        JsExpression moduleRef = this.makePlainModuleRef(module2, program);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"typeOfIs(moduleRef, JsStringLiteral(\"undefined\"))");
        JsBinaryOperation moduleExistsCond = jsBinaryOperation;
        JsStringLiteral moduleNotFoundMessage = new JsStringLiteral("Error loading module '" + currentModuleId + "'. Its dependency '" + module2.getExternalName() + "' was not found. Please, check whether '" + module2.getExternalName() + "' is loaded prior to '" + currentModuleId + "'.");
        JsThrow moduleNotFoundThrow = new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf((Object)moduleNotFoundMessage)));
        return new JsIf(moduleExistsCond, new JsBlock((JsStatement)moduleNotFoundThrow));
    }

    /*
     * WARNING - void declaration
     */
    private final JsInvocation makePlainInvocation(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.makePlainModuleRef((JsImportedModule)it, program));
        }
        List invocationArgs = (List)destination$iv$iv;
        JsExpression moduleRef = this.makePlainModuleRef(moduleId, program);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"typeOfIs(moduleRef, JsStringLiteral(\"undefined\"))");
        JsBinaryOperation testModuleDefined = jsBinaryOperation;
        JsConditional selfArg = new JsConditional(testModuleDefined, new JsObjectLiteral(false), moduleRef.deepCopy());
        return new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)selfArg), (Iterable)invocationArgs));
    }

    private final JsExpression makePlainModuleRef(JsImportedModule module2, JsProgram program) {
        JsExpression jsExpression = module2.getPlainReference();
        if (jsExpression == null) {
            jsExpression = this.makePlainModuleRef(module2.getExternalName(), program);
        }
        return jsExpression;
    }

    private final JsExpression makePlainModuleRef(String moduleId, JsProgram program) {
        JsExpression jsExpression;
        if (Namer.requiresEscaping(moduleId)) {
            jsExpression = new JsArrayAccess(new JsThisRef(), new JsStringLiteral(moduleId));
        } else {
            JsNameRef jsNameRef = program.getScope().declareName(moduleId).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"{\n            program.sc\u2026leId).makeRef()\n        }");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleKind.values().length];
            try {
                nArray[ModuleKind.AMD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.COMMON_JS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.UMD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.PLAIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.ES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

