/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.SuspendFunctionAsSupertypeChecker$check$;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SuspendFunctionAsSupertypeChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SuspendFunctionAsSupertypeChecker
implements DeclarationChecker {
    @NotNull
    public static final SuspendFunctionAsSupertypeChecker INSTANCE = new SuspendFunctionAsSupertypeChecker();

    private SuspendFunctionAsSupertypeChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        block11: {
            FunctionClassDescriptor it;
            boolean bl2;
            List functionalSupertypes;
            block10: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendFunctionAsSupertype)) {
                    return;
                }
                if (!(descriptor2 instanceof ClassDescriptor)) {
                    return;
                }
                Sequence<ClassifierDescriptor> $this$filterIsInstance$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, (Function1)check$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                functionalSupertypes = SequencesKt.toList((Sequence)sequence2);
                Iterable $this$none$iv = functionalSupertypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (FunctionClassDescriptor)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = it.getFunctionKind() == FunctionClassKind.SuspendFunction || it.getFunctionKind() == FunctionClassKind.KSuspendFunction;
                        if (!bl4) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return;
            }
            Iterable $this$any$iv = functionalSupertypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FunctionClassDescriptor)element$iv;
                    boolean bl5 = false;
                    boolean bl6 = it.getFunctionKind() == FunctionClassKind.Function || it.getFunctionKind() == FunctionClassKind.KFunction;
                    if (!bl6) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            KtElementImplStub ktElementImplStub = declaration instanceof KtClassOrObject ? (KtClassOrObject)declaration : null;
            KtElement reportOn = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getSuperTypeList()) != null ? (KtElement)ktElementImplStub : (KtElement)declaration;
            context.getTrace().report(Errors.MIXING_SUSPEND_AND_NON_SUSPEND_SUPERTYPES.on(reportOn));
        }
    }
}

